/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.array.ArrayGuards;
import org.jruby.truffle.core.array.ArrayHelpers;
import org.jruby.truffle.core.array.ArrayStrategy;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.objects.AllocateObjectNode;
import org.jruby.truffle.language.objects.AllocateObjectNodeGen;

@ImportStatic(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array", type=RubyNode.class), @NodeChild(value="index", type=RubyNode.class), @NodeChild(value="length", type=RubyNode.class)})
public abstract class ArrayReadSliceNormalizedNode
extends RubyNode {
    @Node.Child
    private AllocateObjectNode allocateObjectNode;

    public ArrayReadSliceNormalizedNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.allocateObjectNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
    }

    public abstract DynamicObject executeReadSlice(DynamicObject var1, int var2, int var3);

    @Specialization(guards={"!indexInBounds(array, index)"})
    public DynamicObject readIndexOutOfBounds(DynamicObject array, int index, int length) {
        return this.nil();
    }

    @Specialization(guards={"!lengthPositive(length)"})
    public DynamicObject readNegativeLength(DynamicObject array, int index, int length) {
        return this.nil();
    }

    @Specialization(guards={"indexInBounds(array, index)", "lengthPositive(length)", "isNullArray(array)"})
    public DynamicObject readNull(DynamicObject array, int index, int length) {
        return this.createArrayOfSameClass(array, null, 0);
    }

    @Specialization(guards={"indexInBounds(array, index)", "lengthPositive(length)", "endInBounds(array, index, length)", "strategy.matches(array)"}, limit="ARRAY_STRATEGIES")
    public DynamicObject readInBounds(DynamicObject array, int index, int length, @Cached(value="of(array)") ArrayStrategy strategy) {
        Object store = strategy.newMirror(array).extractRange(index, index + length).getArray();
        return this.createArrayOfSameClass(array, store, length);
    }

    @Specialization(guards={"indexInBounds(array, index)", "lengthPositive(length)", "!endInBounds(array, index, length)", "strategy.matches(array)"}, limit="ARRAY_STRATEGIES")
    public DynamicObject readOutOfBounds(DynamicObject array, int index, int length, @Cached(value="of(array)") ArrayStrategy strategy) {
        int end = ArrayHelpers.getSize(array);
        Object store = strategy.newMirror(array).extractRange(index, end).getArray();
        return this.createArrayOfSameClass(array, store, end - index);
    }

    protected DynamicObject createArrayOfSameClass(DynamicObject array, Object store, int size) {
        return this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(array), store, size);
    }

    protected static boolean indexInBounds(DynamicObject array, int index) {
        return index >= 0 && index <= ArrayHelpers.getSize(array);
    }

    protected static boolean lengthPositive(int length) {
        return length >= 0;
    }

    protected static boolean endInBounds(DynamicObject array, int index, int length) {
        return index + length <= ArrayHelpers.getSize(array);
    }
}

