/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.dsl.internal.SuppressFBWarnings;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.CoreMethodNode;
import org.jruby.truffle.core.array.ArrayBuilderNode;
import org.jruby.truffle.core.array.ArrayGuards;
import org.jruby.truffle.core.array.ArrayNodes;
import org.jruby.truffle.core.array.ArrayStrategy;
import org.jruby.truffle.core.array.ArrayWriteNormalizedNode;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.string.StringCachingGuards;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyTypes;
import org.jruby.truffle.language.RubyTypesGen;
import org.jruby.truffle.language.SnippetNode;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;

@GeneratedBy(value=ArrayNodes.class)
public final class ArrayNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(AllocateNodeFactory.getInstance(), AddNodeFactory.getInstance(), MulNodeFactory.getInstance(), IndexNodeFactory.getInstance(), IndexSetNodeFactory.getInstance(), AtNodeFactory.getInstance(), ClearNodeFactory.getInstance(), CompactNodeFactory.getInstance(), CompactBangNodeFactory.getInstance(), ConcatNodeFactory.getInstance(), DeleteNodeFactory.getInstance(), DeleteAtNodeFactory.getInstance(), EachNodeFactory.getInstance(), EachWithIndexNodeFactory.getInstance(), FillNodeFactory.getInstance(), IncludeNodeFactory.getInstance(), InitializeNodeFactory.getInstance(), InitializeCopyNodeFactory.getInstance(), InjectNodeFactory.getInstance(), MapNodeFactory.getInstance(), MapInPlaceNodeFactory.getInstance(), MaxNodeFactory.getInstance(), MaxBlockNodeFactory.getInstance(), MinNodeFactory.getInstance(), MinBlockNodeFactory.getInstance(), PackNodeFactory.getInstance(), PopNodeFactory.getInstance(), LeftShiftNodeFactory.getInstance(), PushNodeFactory.getInstance(), RejectNodeFactory.getInstance(), DeleteIfNodeFactory.getInstance(), RejectInPlaceNodeFactory.getInstance(), ReplaceNodeFactory.getInstance(), SelectNodeFactory.getInstance(), ShiftNodeFactory.getInstance(), SizeNodeFactory.getInstance(), SortNodeFactory.getInstance(), ZipNodeFactory.getInstance());
    }

    @GeneratedBy(value=ArrayNodes.ZipNode.class)
    public static final class ZipNodeFactory
    extends NodeFactoryBase<ArrayNodes.ZipNode> {
        private static ZipNodeFactory zipNodeFactoryInstance;

        private ZipNodeFactory() {
            super(ArrayNodes.ZipNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyNode[].class}});
        }

        public ArrayNodes.ZipNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ZipNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.ZipNode> getInstance() {
            if (zipNodeFactoryInstance == null) {
                zipNodeFactoryInstance = new ZipNodeFactory();
            }
            return zipNodeFactoryInstance;
        }

        public static ArrayNodes.ZipNode create(RubyNode[] arguments) {
            return new ZipNodeGen(arguments);
        }

        @GeneratedBy(value=ArrayNodes.ZipNode.class)
        @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
        public static final class ZipNodeGen
        extends ArrayNodes.ZipNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @Node.Child
            private RubyNode arguments3_;
            @Node.Child
            private BaseNode_ specialization_;

            private ZipNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.arguments3_ = arguments != null && 3 < arguments.length ? arguments[3] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="zipBlock(VirtualFrame, DynamicObject, DynamicObject, Object[], DynamicObject)", value=ArrayNodes.ZipNode.class)
            private static final class ZipBlockNode_
            extends BaseNode_ {
                ZipBlockNode_(ZipNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof Object[] && arguments3Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        Object[] arguments2Value_ = (Object[])arguments2Value;
                        DynamicObject arguments3Value_ = (DynamicObject)arguments3Value;
                        return this.root.zipBlock(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(ZipNodeGen root) {
                    return new ZipBlockNode_(root);
                }
            }

            @GeneratedBy(methodName="zipObjectObjectNotArray(VirtualFrame, DynamicObject, DynamicObject, Object[], NotProvided)", value=ArrayNodes.ZipNode.class)
            private static final class ZipObjectObjectNotArrayNode_
            extends BaseNode_ {
                ZipObjectObjectNotArrayNode_(ZipNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof Object[] && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        Object[] arguments2Value_ = (Object[])arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (!RubyGuards.isRubyArray(arguments1Value_)) {
                            return this.root.zipObjectObjectNotArray(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(ZipNodeGen root) {
                    return new ZipObjectObjectNotArrayNode_(root);
                }
            }

            @GeneratedBy(methodName="zipObjectObjectNotSingleObject(VirtualFrame, DynamicObject, DynamicObject, Object[], NotProvided)", value=ArrayNodes.ZipNode.class)
            private static final class ZipObjectObjectNotSingleObjectNode_
            extends BaseNode_ {
                ZipObjectObjectNotSingleObjectNode_(ZipNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof Object[] && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        Object[] arguments2Value_ = (Object[])arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (RubyGuards.isRubyArray(arguments1Value_) && ArrayNodes.ZipNode.fallback(arguments0Value_, arguments1Value_, arguments2Value_)) {
                            return this.root.zipObjectObjectNotSingleObject(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(ZipNodeGen root) {
                    return new ZipObjectObjectNotSingleObjectNode_(root);
                }
            }

            @GeneratedBy(methodName="zipObjectIntegerFixnum(DynamicObject, DynamicObject, Object[], NotProvided, ArrayStrategy, ArrayStrategy, ArrayStrategy, ConditionProfile)", value=ArrayNodes.ZipNode.class)
            private static final class ZipObjectIntegerFixnumNode_
            extends BaseNode_ {
                private final ArrayStrategy aStrategy;
                private final ArrayStrategy bStrategy;
                private final ArrayStrategy generalized;
                private final ConditionProfile bNotSmallerProfile;

                ZipObjectIntegerFixnumNode_(ZipNodeGen root, ArrayStrategy aStrategy, ArrayStrategy bStrategy, ArrayStrategy generalized, ConditionProfile bNotSmallerProfile) {
                    super(root, 1);
                    this.aStrategy = aStrategy;
                    this.bStrategy = bStrategy;
                    this.generalized = generalized;
                    this.bNotSmallerProfile = bNotSmallerProfile;
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof Object[] && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        Object[] arguments2Value_ = (Object[])arguments2Value;
                        if (RubyGuards.isRubyArray(arguments1Value_) && this.aStrategy.matches(arguments0Value_) && this.bStrategy.matches(arguments1Value_) && arguments2Value_.length == 0) {
                            return true;
                        }
                    }
                    return false;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof Object[] && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        Object[] arguments2Value_ = (Object[])arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (RubyGuards.isRubyArray(arguments1Value_) && this.aStrategy.matches(arguments0Value_) && this.bStrategy.matches(arguments1Value_) && arguments2Value_.length == 0) {
                            return this.root.zipObjectIntegerFixnum(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_, this.aStrategy, this.bStrategy, this.generalized, this.bNotSmallerProfile);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(ZipNodeGen root, ArrayStrategy aStrategy, ArrayStrategy bStrategy, ArrayStrategy generalized, ConditionProfile bNotSmallerProfile) {
                    return new ZipObjectIntegerFixnumNode_(root, aStrategy, bStrategy, generalized, bNotSmallerProfile);
                }
            }

            @GeneratedBy(value=ArrayNodes.ZipNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ZipNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(ZipNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.ZipNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ZipNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(ZipNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.ZipNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ZipNodeGen root;

                BaseNode_(ZipNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (ZipNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_, this.root.arguments3_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4, Object var5);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    Object arguments3Value_ = this.root.arguments3_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof Object[]) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        Object[] arguments2Value_ = (Object[])arguments2Value;
                        if (arguments3Value instanceof NotProvided) {
                            ConditionProfile bNotSmallerProfile1;
                            ArrayStrategy generalized1;
                            BaseNode_ s;
                            ArrayStrategy aStrategy1 = ArrayStrategy.of(arguments0Value_);
                            ArrayStrategy bStrategy1 = ArrayStrategy.of(arguments1Value_);
                            if (RubyGuards.isRubyArray(arguments1Value_) && aStrategy1.matches(arguments0Value_) && bStrategy1.matches(arguments1Value_) && arguments2Value_.length == 0 && this.countSame(s = ZipObjectIntegerFixnumNode_.create(this.root, aStrategy1, bStrategy1, generalized1 = aStrategy1.generalize(bStrategy1), bNotSmallerProfile1 = ConditionProfile.createBinaryProfile())) < 25) {
                                return s;
                            }
                            if (RubyGuards.isRubyArray(arguments1Value_) && ArrayNodes.ZipNode.fallback(arguments0Value_, arguments1Value_, arguments2Value_)) {
                                return ZipObjectObjectNotSingleObjectNode_.create(this.root);
                            }
                            if (!RubyGuards.isRubyArray(arguments1Value_)) {
                                return ZipObjectObjectNotArrayNode_.create(this.root);
                            }
                        }
                        if (arguments3Value instanceof DynamicObject) {
                            return ZipBlockNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.SortNode.class)
    public static final class SortNodeFactory
    extends NodeFactoryBase<ArrayNodes.SortNode> {
        private static SortNodeFactory sortNodeFactoryInstance;

        private SortNodeFactory() {
            super(ArrayNodes.SortNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.SortNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SortNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.SortNode> getInstance() {
            if (sortNodeFactoryInstance == null) {
                sortNodeFactoryInstance = new SortNodeFactory();
            }
            return sortNodeFactoryInstance;
        }

        public static ArrayNodes.SortNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SortNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.SortNode.class)
        public static final class SortNodeGen
        extends ArrayNodes.SortNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private SortNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="sortWithBlock(VirtualFrame, DynamicObject, DynamicObject, SnippetNode)", value=ArrayNodes.SortNode.class)
            private static final class SortWithBlockNode_
            extends BaseNode_ {
                @Node.Child
                private SnippetNode snippet;

                SortWithBlockNode_(SortNodeGen root, SnippetNode snippet) {
                    super(root, 4);
                    this.snippet = snippet;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (!ArrayGuards.isNullArray(arguments0Value_)) {
                            return this.root.sortWithBlock(frameValue, arguments0Value_, arguments1Value_, this.snippet);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SortNodeGen root, SnippetNode snippet) {
                    return new SortWithBlockNode_(root, snippet);
                }
            }

            @GeneratedBy(methodName="sortLargeArray(VirtualFrame, DynamicObject, NotProvided, SnippetNode)", value=ArrayNodes.SortNode.class)
            private static final class SortLargeArrayNode_
            extends BaseNode_ {
                @Node.Child
                private SnippetNode snippetNode;

                SortLargeArrayNode_(SortNodeGen root, SnippetNode snippetNode) {
                    super(root, 3);
                    this.snippetNode = snippetNode;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        if (!ArrayGuards.isNullArray(arguments0Value_) && !this.root.isSmall(arguments0Value_)) {
                            return this.root.sortLargeArray(frameValue, arguments0Value_, arguments1Value_, this.snippetNode);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SortNodeGen root, SnippetNode snippetNode) {
                    return new SortLargeArrayNode_(root, snippetNode);
                }
            }

            @GeneratedBy(methodName="sortVeryShort(VirtualFrame, DynamicObject, NotProvided, ArrayStrategy)", value=ArrayNodes.SortNode.class)
            private static final class SortVeryShortNode_
            extends BaseNode_ {
                private final ArrayStrategy strategy;

                SortVeryShortNode_(SortNodeGen root, ArrayStrategy strategy) {
                    super(root, 2);
                    this.strategy = strategy;
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    return arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided && !ArrayGuards.isNullArray(arguments0Value_ = (DynamicObject)arguments0Value) && this.root.isSmall(arguments0Value_) && this.strategy.matches(arguments0Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        if (!ArrayGuards.isNullArray(arguments0Value_) && this.root.isSmall(arguments0Value_) && this.strategy.matches(arguments0Value_)) {
                            return this.root.sortVeryShort(frameValue, arguments0Value_, arguments1Value_, this.strategy);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SortNodeGen root, ArrayStrategy strategy) {
                    return new SortVeryShortNode_(root, strategy);
                }
            }

            @GeneratedBy(methodName="sortNull(DynamicObject, Object)", value=ArrayNodes.SortNode.class)
            private static final class SortNullNode_
            extends BaseNode_ {
                SortNullNode_(SortNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && ArrayGuards.isNullArray(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.sortNull(arguments0Value_, arguments1Value);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SortNodeGen root) {
                    return new SortNullNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.SortNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SortNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SortNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.SortNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SortNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SortNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.SortNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected SortNodeGen root;

                BaseNode_(SortNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (SortNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (ArrayGuards.isNullArray(arguments0Value_)) {
                            return SortNullNode_.create(this.root);
                        }
                        if (arguments1Value instanceof NotProvided) {
                            BaseNode_ s;
                            ArrayStrategy strategy2 = ArrayStrategy.of(arguments0Value_);
                            if (!ArrayGuards.isNullArray(arguments0Value_) && this.root.isSmall(arguments0Value_) && strategy2.matches(arguments0Value_) && this.countSame(s = SortVeryShortNode_.create(this.root, strategy2)) < 25) {
                                return s;
                            }
                            if (!ArrayGuards.isNullArray(arguments0Value_) && !this.root.isSmall(arguments0Value_)) {
                                SnippetNode snippetNode3 = new SnippetNode();
                                return SortLargeArrayNode_.create(this.root, snippetNode3);
                            }
                        }
                        if (arguments1Value instanceof DynamicObject && !ArrayGuards.isNullArray(arguments0Value_)) {
                            SnippetNode snippet4 = new SnippetNode();
                            return SortWithBlockNode_.create(this.root, snippet4);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.SizeNode.class)
    public static final class SizeNodeFactory
    extends NodeFactoryBase<ArrayNodes.SizeNode> {
        private static SizeNodeFactory sizeNodeFactoryInstance;

        private SizeNodeFactory() {
            super(ArrayNodes.SizeNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyNode[].class}});
        }

        public ArrayNodes.SizeNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return SizeNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.SizeNode> getInstance() {
            if (sizeNodeFactoryInstance == null) {
                sizeNodeFactoryInstance = new SizeNodeFactory();
            }
            return sizeNodeFactoryInstance;
        }

        public static ArrayNodes.SizeNode create(RubyNode[] arguments) {
            return new SizeNodeGen(arguments);
        }

        @GeneratedBy(value=ArrayNodes.SizeNode.class)
        public static final class SizeNodeGen
        extends ArrayNodes.SizeNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private SizeNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeInteger(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeInteger(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.size(arguments0Value_);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.ShiftNode.class)
    public static final class ShiftNodeFactory
    extends NodeFactoryBase<ArrayNodes.ShiftNode> {
        private static ShiftNodeFactory shiftNodeFactoryInstance;

        private ShiftNodeFactory() {
            super(ArrayNodes.ShiftNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyNode.class, RubyNode.class}});
        }

        public ArrayNodes.ShiftNode createNode(Object ... arguments) {
            if (arguments.length == 2 && (arguments[0] == null || arguments[0] instanceof RubyNode) && (arguments[1] == null || arguments[1] instanceof RubyNode)) {
                return ShiftNodeFactory.create((RubyNode)((Object)arguments[0]), (RubyNode)((Object)arguments[1]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.ShiftNode> getInstance() {
            if (shiftNodeFactoryInstance == null) {
                shiftNodeFactoryInstance = new ShiftNodeFactory();
            }
            return shiftNodeFactoryInstance;
        }

        public static ArrayNodes.ShiftNode create(RubyNode array, RubyNode n) {
            return new ShiftNodeGen(array, n);
        }

        @GeneratedBy(value=ArrayNodes.ShiftNode.class)
        @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
        public static final class ShiftNodeGen
        extends ArrayNodes.ShiftNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode array_;
            @Node.Child
            private RubyNode n_;
            @CompilerDirectives.CompilationFinal
            private Class<?> nType_;
            @Node.Child
            private BaseNode_ specialization_;

            private ShiftNodeGen(RubyNode array, RubyNode n) {
                this.array_ = array;
                this.n_ = n;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object executeShift(VirtualFrame frameValue, DynamicObject arrayValue, Object nValue) {
                return this.specialization_.execute1(frameValue, arrayValue, nValue);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute0(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="shiftNToInt(VirtualFrame, DynamicObject, Object)", value=ArrayNodes.ShiftNode.class)
            private static final class ShiftNToIntNode_
            extends BaseNode_ {
                ShiftNToIntNode_(ShiftNodeGen root) {
                    super(root, 7);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arrayValue, Object nValue) {
                    if (RubyGuards.wasProvided(nValue) && !RubyGuards.isInteger(nValue) && !RubyGuards.isLong(nValue)) {
                        return this.root.shiftNToInt(frameValue, arrayValue, nValue);
                    }
                    return this.getNext().execute1(frameValue, arrayValue, nValue);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arrayValue, Object nValue) {
                    if (arrayValue instanceof DynamicObject) {
                        DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                        if (RubyGuards.wasProvided(nValue) && !RubyGuards.isInteger(nValue) && !RubyGuards.isLong(nValue)) {
                            return this.root.shiftNToInt(frameValue, arrayValue_, nValue);
                        }
                    }
                    return this.getNext().execute_(frameValue, arrayValue, nValue);
                }

                static BaseNode_ create(ShiftNodeGen root) {
                    return new ShiftNToIntNode_(root);
                }
            }

            @GeneratedBy(methodName="shiftMany(DynamicObject, int, ArrayStrategy, ConditionProfile)", value=ArrayNodes.ShiftNode.class)
            private static final class ShiftManyNode_
            extends BaseNode_ {
                private final ArrayStrategy strategy;
                private final ConditionProfile minProfile;
                private final Class<?> nImplicitType;

                ShiftManyNode_(ShiftNodeGen root, Object nValue, ArrayStrategy strategy, ConditionProfile minProfile) {
                    super(root, 6);
                    this.nImplicitType = RubyTypesGen.getImplicitIntegerClass(nValue);
                    this.strategy = strategy;
                    this.minProfile = minProfile;
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.nImplicitType == ((ShiftManyNode_)other).nImplicitType;
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arrayValue, Object nValue) {
                    if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(nValue, this.nImplicitType)) {
                        DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                        int nValue_ = RubyTypesGen.asImplicitInteger(nValue, this.nImplicitType);
                        if (nValue_ > 0 && this.strategy.matches(arrayValue_) && !ArrayGuards.isEmptyArray(arrayValue_)) {
                            return true;
                        }
                    }
                    return false;
                }

                @Override
                public Object execute0(VirtualFrame frameValue) {
                    int nValue_;
                    DynamicObject arrayValue_;
                    try {
                        arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object nValue = this.executeN_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), nValue);
                    }
                    try {
                        if (this.nImplicitType == Integer.TYPE) {
                            nValue_ = this.root.n_.executeInteger(frameValue);
                        } else {
                            Object nValue__ = this.executeN_((Frame)frameValue);
                            nValue_ = RubyTypesGen.expectImplicitInteger(nValue__, this.nImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arrayValue_, ex.getResult());
                    }
                    if (nValue_ > 0 && this.strategy.matches(arrayValue_) && !ArrayGuards.isEmptyArray(arrayValue_)) {
                        return this.root.shiftMany(arrayValue_, nValue_, this.strategy, this.minProfile);
                    }
                    return this.getNext().execute_(frameValue, arrayValue_, nValue_);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arrayValue, Object nValue) {
                    int nValue_;
                    if (RubyTypesGen.isImplicitInteger(nValue, this.nImplicitType) && (nValue_ = RubyTypesGen.asImplicitInteger(nValue, this.nImplicitType)) > 0 && this.strategy.matches(arrayValue) && !ArrayGuards.isEmptyArray(arrayValue)) {
                        return this.root.shiftMany(arrayValue, nValue_, this.strategy, this.minProfile);
                    }
                    return this.getNext().execute1(frameValue, arrayValue, nValue);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arrayValue, Object nValue) {
                    if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(nValue, this.nImplicitType)) {
                        DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                        int nValue_ = RubyTypesGen.asImplicitInteger(nValue, this.nImplicitType);
                        if (nValue_ > 0 && this.strategy.matches(arrayValue_) && !ArrayGuards.isEmptyArray(arrayValue_)) {
                            return this.root.shiftMany(arrayValue_, nValue_, this.strategy, this.minProfile);
                        }
                    }
                    return this.getNext().execute_(frameValue, arrayValue, nValue);
                }

                static BaseNode_ create(ShiftNodeGen root, Object nValue, ArrayStrategy strategy, ConditionProfile minProfile) {
                    return new ShiftManyNode_(root, nValue, strategy, minProfile);
                }
            }

            @GeneratedBy(methodName="shiftManyEmpty(DynamicObject, int)", value=ArrayNodes.ShiftNode.class)
            private static final class ShiftManyEmptyNode_
            extends BaseNode_ {
                private final Class<?> nImplicitType;

                ShiftManyEmptyNode_(ShiftNodeGen root, Object nValue) {
                    super(root, 5);
                    this.nImplicitType = RubyTypesGen.getImplicitIntegerClass(nValue);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.nImplicitType == ((ShiftManyEmptyNode_)other).nImplicitType;
                }

                @Override
                public Object execute0(VirtualFrame frameValue) {
                    int nValue_;
                    DynamicObject arrayValue_;
                    try {
                        arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object nValue = this.executeN_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), nValue);
                    }
                    try {
                        if (this.nImplicitType == Integer.TYPE) {
                            nValue_ = this.root.n_.executeInteger(frameValue);
                        } else {
                            Object nValue__ = this.executeN_((Frame)frameValue);
                            nValue_ = RubyTypesGen.expectImplicitInteger(nValue__, this.nImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arrayValue_, ex.getResult());
                    }
                    if (nValue_ > 0 && ArrayGuards.isEmptyArray(arrayValue_)) {
                        return this.root.shiftManyEmpty(arrayValue_, nValue_);
                    }
                    return this.getNext().execute_(frameValue, arrayValue_, nValue_);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arrayValue, Object nValue) {
                    int nValue_;
                    if (RubyTypesGen.isImplicitInteger(nValue, this.nImplicitType) && (nValue_ = RubyTypesGen.asImplicitInteger(nValue, this.nImplicitType)) > 0 && ArrayGuards.isEmptyArray(arrayValue)) {
                        return this.root.shiftManyEmpty(arrayValue, nValue_);
                    }
                    return this.getNext().execute1(frameValue, arrayValue, nValue);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arrayValue, Object nValue) {
                    if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(nValue, this.nImplicitType)) {
                        DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                        int nValue_ = RubyTypesGen.asImplicitInteger(nValue, this.nImplicitType);
                        if (nValue_ > 0 && ArrayGuards.isEmptyArray(arrayValue_)) {
                            return this.root.shiftManyEmpty(arrayValue_, nValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arrayValue, nValue);
                }

                static BaseNode_ create(ShiftNodeGen root, Object nValue) {
                    return new ShiftManyEmptyNode_(root, nValue);
                }
            }

            @GeneratedBy(methodName="shiftZero(DynamicObject, int)", value=ArrayNodes.ShiftNode.class)
            private static final class ShiftZeroNode_
            extends BaseNode_ {
                private final Class<?> nImplicitType;

                ShiftZeroNode_(ShiftNodeGen root, Object nValue) {
                    super(root, 4);
                    this.nImplicitType = RubyTypesGen.getImplicitIntegerClass(nValue);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.nImplicitType == ((ShiftZeroNode_)other).nImplicitType;
                }

                @Override
                public Object execute0(VirtualFrame frameValue) {
                    int nValue_;
                    DynamicObject arrayValue_;
                    try {
                        arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object nValue = this.executeN_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), nValue);
                    }
                    try {
                        if (this.nImplicitType == Integer.TYPE) {
                            nValue_ = this.root.n_.executeInteger(frameValue);
                        } else {
                            Object nValue__ = this.executeN_((Frame)frameValue);
                            nValue_ = RubyTypesGen.expectImplicitInteger(nValue__, this.nImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arrayValue_, ex.getResult());
                    }
                    if (nValue_ == 0) {
                        return this.root.shiftZero(arrayValue_, nValue_);
                    }
                    return this.getNext().execute_(frameValue, arrayValue_, nValue_);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arrayValue, Object nValue) {
                    int nValue_;
                    if (RubyTypesGen.isImplicitInteger(nValue, this.nImplicitType) && (nValue_ = RubyTypesGen.asImplicitInteger(nValue, this.nImplicitType)) == 0) {
                        return this.root.shiftZero(arrayValue, nValue_);
                    }
                    return this.getNext().execute1(frameValue, arrayValue, nValue);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arrayValue, Object nValue) {
                    if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(nValue, this.nImplicitType)) {
                        DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                        int nValue_ = RubyTypesGen.asImplicitInteger(nValue, this.nImplicitType);
                        if (nValue_ == 0) {
                            return this.root.shiftZero(arrayValue_, nValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arrayValue, nValue);
                }

                static BaseNode_ create(ShiftNodeGen root, Object nValue) {
                    return new ShiftZeroNode_(root, nValue);
                }
            }

            @GeneratedBy(methodName="shiftNegative(DynamicObject, int)", value=ArrayNodes.ShiftNode.class)
            private static final class ShiftNegativeNode_
            extends BaseNode_ {
                private final Class<?> nImplicitType;

                ShiftNegativeNode_(ShiftNodeGen root, Object nValue) {
                    super(root, 3);
                    this.nImplicitType = RubyTypesGen.getImplicitIntegerClass(nValue);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.nImplicitType == ((ShiftNegativeNode_)other).nImplicitType;
                }

                @Override
                public Object execute0(VirtualFrame frameValue) {
                    int nValue_;
                    DynamicObject arrayValue_;
                    try {
                        arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object nValue = this.executeN_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), nValue);
                    }
                    try {
                        if (this.nImplicitType == Integer.TYPE) {
                            nValue_ = this.root.n_.executeInteger(frameValue);
                        } else {
                            Object nValue__ = this.executeN_((Frame)frameValue);
                            nValue_ = RubyTypesGen.expectImplicitInteger(nValue__, this.nImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arrayValue_, ex.getResult());
                    }
                    if (nValue_ < 0) {
                        return this.root.shiftNegative(arrayValue_, nValue_);
                    }
                    return this.getNext().execute_(frameValue, arrayValue_, nValue_);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arrayValue, Object nValue) {
                    int nValue_;
                    if (RubyTypesGen.isImplicitInteger(nValue, this.nImplicitType) && (nValue_ = RubyTypesGen.asImplicitInteger(nValue, this.nImplicitType)) < 0) {
                        return this.root.shiftNegative(arrayValue, nValue_);
                    }
                    return this.getNext().execute1(frameValue, arrayValue, nValue);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arrayValue, Object nValue) {
                    if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(nValue, this.nImplicitType)) {
                        DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                        int nValue_ = RubyTypesGen.asImplicitInteger(nValue, this.nImplicitType);
                        if (nValue_ < 0) {
                            return this.root.shiftNegative(arrayValue_, nValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arrayValue, nValue);
                }

                static BaseNode_ create(ShiftNodeGen root, Object nValue) {
                    return new ShiftNegativeNode_(root, nValue);
                }
            }

            @GeneratedBy(methodName="shiftOther(DynamicObject, NotProvided, ArrayStrategy)", value=ArrayNodes.ShiftNode.class)
            private static final class ShiftOtherNode_
            extends BaseNode_ {
                private final ArrayStrategy strategy;

                ShiftOtherNode_(ShiftNodeGen root, ArrayStrategy strategy) {
                    super(root, 2);
                    this.strategy = strategy;
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arrayValue, Object nValue) {
                    DynamicObject arrayValue_;
                    return arrayValue instanceof DynamicObject && nValue instanceof NotProvided && this.strategy.matches(arrayValue_ = (DynamicObject)arrayValue) && !ArrayGuards.isEmptyArray(arrayValue_);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arrayValue, Object nValue) {
                    if (nValue instanceof NotProvided) {
                        NotProvided nValue_ = (NotProvided)nValue;
                        if (this.strategy.matches(arrayValue) && !ArrayGuards.isEmptyArray(arrayValue)) {
                            return this.root.shiftOther(arrayValue, nValue_, this.strategy);
                        }
                    }
                    return this.getNext().execute1(frameValue, arrayValue, nValue);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arrayValue, Object nValue) {
                    if (arrayValue instanceof DynamicObject && nValue instanceof NotProvided) {
                        DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                        NotProvided nValue_ = (NotProvided)nValue;
                        if (this.strategy.matches(arrayValue_) && !ArrayGuards.isEmptyArray(arrayValue_)) {
                            return this.root.shiftOther(arrayValue_, nValue_, this.strategy);
                        }
                    }
                    return this.getNext().execute_(frameValue, arrayValue, nValue);
                }

                static BaseNode_ create(ShiftNodeGen root, ArrayStrategy strategy) {
                    return new ShiftOtherNode_(root, strategy);
                }
            }

            @GeneratedBy(methodName="shiftEmpty(DynamicObject, NotProvided)", value=ArrayNodes.ShiftNode.class)
            private static final class ShiftEmptyNode_
            extends BaseNode_ {
                ShiftEmptyNode_(ShiftNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arrayValue, Object nValue) {
                    if (nValue instanceof NotProvided) {
                        NotProvided nValue_ = (NotProvided)nValue;
                        if (ArrayGuards.isEmptyArray(arrayValue)) {
                            return this.root.shiftEmpty(arrayValue, nValue_);
                        }
                    }
                    return this.getNext().execute1(frameValue, arrayValue, nValue);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arrayValue, Object nValue) {
                    if (arrayValue instanceof DynamicObject && nValue instanceof NotProvided) {
                        DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                        NotProvided nValue_ = (NotProvided)nValue;
                        if (ArrayGuards.isEmptyArray(arrayValue_)) {
                            return this.root.shiftEmpty(arrayValue_, nValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arrayValue, nValue);
                }

                static BaseNode_ create(ShiftNodeGen root) {
                    return new ShiftEmptyNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.ShiftNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ShiftNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arrayValue, Object nValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arrayValue, nValue));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arrayValue, Object nValue) {
                    return this.getNext().execute_(frameValue, arrayValue, nValue);
                }

                static BaseNode_ create(ShiftNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.ShiftNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ShiftNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arrayValue, Object nValue) {
                    return this.uninitialized((Frame)frameValue, arrayValue, nValue);
                }

                static BaseNode_ create(ShiftNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.ShiftNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ShiftNodeGen root;

                BaseNode_(ShiftNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (ShiftNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.array_, this.root.n_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arrayValue, Object nValue) {
                    return this.execute_((VirtualFrame)frameValue, arrayValue, nValue);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute1(VirtualFrame frameValue, DynamicObject arrayValue, Object nValue) {
                    return this.execute_(frameValue, arrayValue, nValue);
                }

                public Object execute0(VirtualFrame frameValue) {
                    Object arrayValue_ = this.root.array_.execute(frameValue);
                    Object nValue_ = this.executeN_((Frame)frameValue);
                    return this.execute_(frameValue, arrayValue_, nValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute0(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arrayValue, Object nValue) {
                    if (arrayValue instanceof DynamicObject) {
                        DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                        if (nValue instanceof NotProvided) {
                            BaseNode_ s;
                            if (ArrayGuards.isEmptyArray(arrayValue_)) {
                                return ShiftEmptyNode_.create(this.root);
                            }
                            ArrayStrategy strategy2 = ArrayStrategy.of(arrayValue_);
                            if (strategy2.matches(arrayValue_) && !ArrayGuards.isEmptyArray(arrayValue_) && this.countSame(s = ShiftOtherNode_.create(this.root, strategy2)) < 25) {
                                return s;
                            }
                        }
                        if (RubyTypesGen.isImplicitInteger(nValue)) {
                            ConditionProfile minProfile6;
                            BaseNode_ s;
                            int nValue_ = RubyTypesGen.asImplicitInteger(nValue);
                            if (nValue_ < 0) {
                                return ShiftNegativeNode_.create(this.root, nValue);
                            }
                            if (nValue_ == 0) {
                                return ShiftZeroNode_.create(this.root, nValue);
                            }
                            if (nValue_ > 0 && ArrayGuards.isEmptyArray(arrayValue_)) {
                                return ShiftManyEmptyNode_.create(this.root, nValue);
                            }
                            ArrayStrategy strategy6 = ArrayStrategy.of(arrayValue_);
                            if (nValue_ > 0 && strategy6.matches(arrayValue_) && !ArrayGuards.isEmptyArray(arrayValue_) && this.countSame(s = ShiftManyNode_.create(this.root, nValue, strategy6, minProfile6 = ConditionProfile.createBinaryProfile())) < 25) {
                                return s;
                            }
                        }
                        if (RubyGuards.wasProvided(nValue) && !RubyGuards.isInteger(nValue) && !RubyGuards.isLong(nValue)) {
                            return ShiftNToIntNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeN_(Frame frameValue) {
                    Object object;
                    Class nType_ = this.root.nType_;
                    if (nType_ == Integer.TYPE) {
                        return this.root.n_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (nType_ != null) return this.root.n_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.n_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.nType_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.nType_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.nType_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.SelectNode.class)
    public static final class SelectNodeFactory
    extends NodeFactoryBase<ArrayNodes.SelectNode> {
        private static SelectNodeFactory selectNodeFactoryInstance;

        private SelectNodeFactory() {
            super(ArrayNodes.SelectNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyNode[].class}});
        }

        public ArrayNodes.SelectNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return SelectNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.SelectNode> getInstance() {
            if (selectNodeFactoryInstance == null) {
                selectNodeFactoryInstance = new SelectNodeFactory();
            }
            return selectNodeFactoryInstance;
        }

        public static ArrayNodes.SelectNode create(RubyNode[] arguments) {
            return new SelectNodeGen(arguments);
        }

        @GeneratedBy(value=ArrayNodes.SelectNode.class)
        public static final class SelectNodeGen
        extends ArrayNodes.SelectNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private SelectNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="selectOther(VirtualFrame, DynamicObject, DynamicObject, ArrayStrategy, ArrayBuilderNode)", value=ArrayNodes.SelectNode.class)
            private static final class SelectOtherNode_
            extends BaseNode_ {
                private final ArrayStrategy strategy;
                @Node.Child
                private ArrayBuilderNode arrayBuilder;

                SelectOtherNode_(SelectNodeGen root, ArrayStrategy strategy, ArrayBuilderNode arrayBuilder) {
                    super(root, 2);
                    this.strategy = strategy;
                    this.arrayBuilder = arrayBuilder;
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    return arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && this.strategy.matches(arguments0Value_ = (DynamicObject)arguments0Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (this.strategy.matches(arguments0Value_)) {
                            return this.root.selectOther(frameValue, arguments0Value_, arguments1Value_, this.strategy, this.arrayBuilder);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SelectNodeGen root, ArrayStrategy strategy, ArrayBuilderNode arrayBuilder) {
                    return new SelectOtherNode_(root, strategy, arrayBuilder);
                }
            }

            @GeneratedBy(methodName="selectNull(DynamicObject, DynamicObject)", value=ArrayNodes.SelectNode.class)
            private static final class SelectNullNode_
            extends BaseNode_ {
                SelectNullNode_(SelectNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isNullArray(arguments0Value_)) {
                            return this.root.selectNull(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SelectNodeGen root) {
                    return new SelectNullNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.SelectNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SelectNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SelectNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.SelectNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SelectNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SelectNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.SelectNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected SelectNodeGen root;

                BaseNode_(SelectNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (SelectNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        ArrayBuilderNode arrayBuilder2;
                        BaseNode_ s;
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (ArrayGuards.isNullArray(arguments0Value_)) {
                            return SelectNullNode_.create(this.root);
                        }
                        ArrayStrategy strategy2 = ArrayStrategy.of(arguments0Value_);
                        if (strategy2.matches(arguments0Value_) && this.countSame(s = SelectOtherNode_.create(this.root, strategy2, arrayBuilder2 = ArrayBuilderNode.create(this.root.getContext()))) < 25) {
                            return s;
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.ReplaceNode.class)
    public static final class ReplaceNodeFactory
    extends NodeFactoryBase<ArrayNodes.ReplaceNode> {
        private static ReplaceNodeFactory replaceNodeFactoryInstance;

        private ReplaceNodeFactory() {
            super(ArrayNodes.ReplaceNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyNode.class, RubyNode.class}});
        }

        public ArrayNodes.ReplaceNode createNode(Object ... arguments) {
            if (arguments.length == 2 && (arguments[0] == null || arguments[0] instanceof RubyNode) && (arguments[1] == null || arguments[1] instanceof RubyNode)) {
                return ReplaceNodeFactory.create((RubyNode)((Object)arguments[0]), (RubyNode)((Object)arguments[1]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.ReplaceNode> getInstance() {
            if (replaceNodeFactoryInstance == null) {
                replaceNodeFactoryInstance = new ReplaceNodeFactory();
            }
            return replaceNodeFactoryInstance;
        }

        public static ArrayNodes.ReplaceNode create(RubyNode array, RubyNode other) {
            return new ReplaceNodeGen(array, other);
        }

        @GeneratedBy(value=ArrayNodes.ReplaceNode.class)
        public static final class ReplaceNodeGen
        extends ArrayNodes.ReplaceNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode array_;
            @Node.Child
            private RubyNode other_;
            @Node.Child
            private BaseNode_ specialization_;

            private ReplaceNodeGen(RubyNode array, RubyNode other) {
                this.array_ = array;
                this.other_ = this.coerceOtherToAry(other);
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public DynamicObject executeReplace(DynamicObject arrayValue, DynamicObject otherValue) {
                return this.specialization_.executeDynamicObject1(arrayValue, otherValue);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="replace(DynamicObject, DynamicObject, ArrayStrategy)", value=ArrayNodes.ReplaceNode.class)
            private static final class Replace1Node_
            extends BaseNode_ {
                private final ArrayStrategy strategy;

                Replace1Node_(ReplaceNodeGen root, ArrayStrategy strategy) {
                    super(root, 2);
                    this.strategy = strategy;
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arrayValue, Object otherValue) {
                    DynamicObject otherValue_;
                    return arrayValue instanceof DynamicObject && otherValue instanceof DynamicObject && this.strategy.matches(otherValue_ = (DynamicObject)otherValue);
                }

                @Override
                public DynamicObject executeDynamicObject1(DynamicObject arrayValue, DynamicObject otherValue) {
                    if (this.strategy.matches(otherValue)) {
                        return this.root.replace(arrayValue, otherValue, this.strategy);
                    }
                    return this.getNext().executeDynamicObject1(arrayValue, otherValue);
                }

                @Override
                public DynamicObject executeDynamicObject_(Object arrayValue, Object otherValue) {
                    if (arrayValue instanceof DynamicObject && otherValue instanceof DynamicObject) {
                        DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                        DynamicObject otherValue_ = (DynamicObject)otherValue;
                        if (this.strategy.matches(otherValue_)) {
                            return this.root.replace(arrayValue_, otherValue_, this.strategy);
                        }
                    }
                    return this.getNext().executeDynamicObject_(arrayValue, otherValue);
                }

                static BaseNode_ create(ReplaceNodeGen root, ArrayStrategy strategy) {
                    return new Replace1Node_(root, strategy);
                }
            }

            @GeneratedBy(methodName="replace(DynamicObject, DynamicObject)", value=ArrayNodes.ReplaceNode.class)
            private static final class Replace0Node_
            extends BaseNode_ {
                Replace0Node_(ReplaceNodeGen root) {
                    super(root, 1);
                }

                @Override
                public DynamicObject executeDynamicObject1(DynamicObject arrayValue, DynamicObject otherValue) {
                    if (ArrayGuards.isNullArray(otherValue)) {
                        return this.root.replace(arrayValue, otherValue);
                    }
                    return this.getNext().executeDynamicObject1(arrayValue, otherValue);
                }

                @Override
                public DynamicObject executeDynamicObject_(Object arrayValue, Object otherValue) {
                    if (arrayValue instanceof DynamicObject && otherValue instanceof DynamicObject) {
                        DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                        DynamicObject otherValue_ = (DynamicObject)otherValue;
                        if (ArrayGuards.isNullArray(otherValue_)) {
                            return this.root.replace(arrayValue_, otherValue_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(arrayValue, otherValue);
                }

                static BaseNode_ create(ReplaceNodeGen root) {
                    return new Replace0Node_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.ReplaceNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ReplaceNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arrayValue, Object otherValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arrayValue, otherValue));
                }

                @Override
                public DynamicObject executeDynamicObject_(Object arrayValue, Object otherValue) {
                    return this.getNext().executeDynamicObject_(arrayValue, otherValue);
                }

                static BaseNode_ create(ReplaceNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.ReplaceNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ReplaceNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(Object arrayValue, Object otherValue) {
                    return (DynamicObject)this.uninitialized(null, arrayValue, otherValue);
                }

                static BaseNode_ create(ReplaceNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.ReplaceNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ReplaceNodeGen root;

                BaseNode_(ReplaceNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (ReplaceNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.array_, this.root.other_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arrayValue, Object otherValue) {
                    return this.executeDynamicObject_(arrayValue, otherValue);
                }

                public abstract DynamicObject executeDynamicObject_(Object var1, Object var2);

                public DynamicObject executeDynamicObject1(DynamicObject arrayValue, DynamicObject otherValue) {
                    return this.executeDynamicObject_(arrayValue, otherValue);
                }

                public Object execute(VirtualFrame frameValue) {
                    Object arrayValue_ = this.root.array_.execute(frameValue);
                    Object otherValue_ = this.root.other_.execute(frameValue);
                    return this.executeDynamicObject_(arrayValue_, otherValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arrayValue, Object otherValue) {
                    if (arrayValue instanceof DynamicObject && otherValue instanceof DynamicObject) {
                        BaseNode_ s;
                        DynamicObject otherValue_ = (DynamicObject)otherValue;
                        if (ArrayGuards.isNullArray(otherValue_)) {
                            return Replace0Node_.create(this.root);
                        }
                        ArrayStrategy strategy2 = ArrayStrategy.of(otherValue_);
                        if (strategy2.matches(otherValue_) && this.countSame(s = Replace1Node_.create(this.root, strategy2)) < 25) {
                            return s;
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.RejectInPlaceNode.class)
    public static final class RejectInPlaceNodeFactory
    extends NodeFactoryBase<ArrayNodes.RejectInPlaceNode> {
        private static RejectInPlaceNodeFactory rejectInPlaceNodeFactoryInstance;

        private RejectInPlaceNodeFactory() {
            super(ArrayNodes.RejectInPlaceNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyNode[].class}});
        }

        public ArrayNodes.RejectInPlaceNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return RejectInPlaceNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.RejectInPlaceNode> getInstance() {
            if (rejectInPlaceNodeFactoryInstance == null) {
                rejectInPlaceNodeFactoryInstance = new RejectInPlaceNodeFactory();
            }
            return rejectInPlaceNodeFactoryInstance;
        }

        public static ArrayNodes.RejectInPlaceNode create(RubyNode[] arguments) {
            return new RejectInPlaceNodeGen(arguments);
        }

        @GeneratedBy(value=ArrayNodes.RejectInPlaceNode.class)
        public static final class RejectInPlaceNodeGen
        extends ArrayNodes.RejectInPlaceNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private RejectInPlaceNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object executeRejectInPlace(VirtualFrame frameValue, DynamicObject arguments0Value, DynamicObject arguments1Value) {
                return this.specialization_.execute1(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute0(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="rejectInPlaceOther(VirtualFrame, DynamicObject, DynamicObject, ArrayStrategy)", value=ArrayNodes.RejectInPlaceNode.class)
            private static final class RejectInPlaceOtherNode_
            extends BaseNode_ {
                private final ArrayStrategy strategy;

                RejectInPlaceOtherNode_(RejectInPlaceNodeGen root, ArrayStrategy strategy) {
                    super(root, 2);
                    this.strategy = strategy;
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    return arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && this.strategy.matches(arguments0Value_ = (DynamicObject)arguments0Value);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, DynamicObject arguments1Value) {
                    if (this.strategy.matches(arguments0Value)) {
                        return this.root.rejectInPlaceOther(frameValue, arguments0Value, arguments1Value, this.strategy);
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (this.strategy.matches(arguments0Value_)) {
                            return this.root.rejectInPlaceOther(frameValue, arguments0Value_, arguments1Value_, this.strategy);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(RejectInPlaceNodeGen root, ArrayStrategy strategy) {
                    return new RejectInPlaceOtherNode_(root, strategy);
                }
            }

            @GeneratedBy(methodName="rejectInPlaceNull(DynamicObject, DynamicObject)", value=ArrayNodes.RejectInPlaceNode.class)
            private static final class RejectInPlaceNullNode_
            extends BaseNode_ {
                RejectInPlaceNullNode_(RejectInPlaceNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, DynamicObject arguments1Value) {
                    if (ArrayGuards.isNullArray(arguments0Value)) {
                        return this.root.rejectInPlaceNull(arguments0Value, arguments1Value);
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isNullArray(arguments0Value_)) {
                            return this.root.rejectInPlaceNull(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(RejectInPlaceNodeGen root) {
                    return new RejectInPlaceNullNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.RejectInPlaceNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(RejectInPlaceNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(RejectInPlaceNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.RejectInPlaceNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(RejectInPlaceNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(RejectInPlaceNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.RejectInPlaceNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected RejectInPlaceNodeGen root;

                BaseNode_(RejectInPlaceNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (RejectInPlaceNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, DynamicObject arguments1Value) {
                    return this.execute_(frameValue, arguments0Value, arguments1Value);
                }

                public Object execute0(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute0(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        BaseNode_ s;
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (ArrayGuards.isNullArray(arguments0Value_)) {
                            return RejectInPlaceNullNode_.create(this.root);
                        }
                        ArrayStrategy strategy2 = ArrayStrategy.of(arguments0Value_);
                        if (strategy2.matches(arguments0Value_) && this.countSame(s = RejectInPlaceOtherNode_.create(this.root, strategy2)) < 25) {
                            return s;
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.DeleteIfNode.class)
    public static final class DeleteIfNodeFactory
    extends NodeFactoryBase<ArrayNodes.DeleteIfNode> {
        private static DeleteIfNodeFactory deleteIfNodeFactoryInstance;

        private DeleteIfNodeFactory() {
            super(ArrayNodes.DeleteIfNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyNode[].class}});
        }

        public ArrayNodes.DeleteIfNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return DeleteIfNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.DeleteIfNode> getInstance() {
            if (deleteIfNodeFactoryInstance == null) {
                deleteIfNodeFactoryInstance = new DeleteIfNodeFactory();
            }
            return deleteIfNodeFactoryInstance;
        }

        public static ArrayNodes.DeleteIfNode create(RubyNode[] arguments) {
            return new DeleteIfNodeGen(arguments);
        }

        @GeneratedBy(value=ArrayNodes.DeleteIfNode.class)
        public static final class DeleteIfNodeGen
        extends ArrayNodes.DeleteIfNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private DeleteIfNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="deleteIf(VirtualFrame, DynamicObject, DynamicObject, RejectInPlaceNode)", value=ArrayNodes.DeleteIfNode.class)
            private static final class DeleteIfNode_
            extends BaseNode_ {
                @Node.Child
                private ArrayNodes.RejectInPlaceNode rejectInPlaceNode;

                DeleteIfNode_(DeleteIfNodeGen root, ArrayNodes.RejectInPlaceNode rejectInPlaceNode) {
                    super(root, 1);
                    this.rejectInPlaceNode = rejectInPlaceNode;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        return this.root.deleteIf(frameValue, arguments0Value_, arguments1Value_, this.rejectInPlaceNode);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DeleteIfNodeGen root, ArrayNodes.RejectInPlaceNode rejectInPlaceNode) {
                    return new DeleteIfNode_(root, rejectInPlaceNode);
                }
            }

            @GeneratedBy(value=ArrayNodes.DeleteIfNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(DeleteIfNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DeleteIfNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.DeleteIfNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected DeleteIfNodeGen root;

                BaseNode_(DeleteIfNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (DeleteIfNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        ArrayNodes.RejectInPlaceNode rejectInPlaceNode1 = this.root.createRejectInPlaceNode();
                        return DeleteIfNode_.create(this.root, rejectInPlaceNode1);
                    }
                    return null;
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.RejectNode.class)
    public static final class RejectNodeFactory
    extends NodeFactoryBase<ArrayNodes.RejectNode> {
        private static RejectNodeFactory rejectNodeFactoryInstance;

        private RejectNodeFactory() {
            super(ArrayNodes.RejectNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyNode[].class}});
        }

        public ArrayNodes.RejectNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return RejectNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.RejectNode> getInstance() {
            if (rejectNodeFactoryInstance == null) {
                rejectNodeFactoryInstance = new RejectNodeFactory();
            }
            return rejectNodeFactoryInstance;
        }

        public static ArrayNodes.RejectNode create(RubyNode[] arguments) {
            return new RejectNodeGen(arguments);
        }

        @GeneratedBy(value=ArrayNodes.RejectNode.class)
        public static final class RejectNodeGen
        extends ArrayNodes.RejectNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private RejectNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="rejectOther(VirtualFrame, DynamicObject, DynamicObject, ArrayStrategy, ArrayBuilderNode)", value=ArrayNodes.RejectNode.class)
            private static final class RejectOtherNode_
            extends BaseNode_ {
                private final ArrayStrategy strategy;
                @Node.Child
                private ArrayBuilderNode arrayBuilder;

                RejectOtherNode_(RejectNodeGen root, ArrayStrategy strategy, ArrayBuilderNode arrayBuilder) {
                    super(root, 2);
                    this.strategy = strategy;
                    this.arrayBuilder = arrayBuilder;
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    return arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && this.strategy.matches(arguments0Value_ = (DynamicObject)arguments0Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (this.strategy.matches(arguments0Value_)) {
                            return this.root.rejectOther(frameValue, arguments0Value_, arguments1Value_, this.strategy, this.arrayBuilder);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(RejectNodeGen root, ArrayStrategy strategy, ArrayBuilderNode arrayBuilder) {
                    return new RejectOtherNode_(root, strategy, arrayBuilder);
                }
            }

            @GeneratedBy(methodName="rejectNull(DynamicObject, DynamicObject)", value=ArrayNodes.RejectNode.class)
            private static final class RejectNullNode_
            extends BaseNode_ {
                RejectNullNode_(RejectNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isNullArray(arguments0Value_)) {
                            return this.root.rejectNull(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(RejectNodeGen root) {
                    return new RejectNullNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.RejectNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(RejectNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(RejectNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.RejectNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(RejectNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(RejectNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.RejectNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected RejectNodeGen root;

                BaseNode_(RejectNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (RejectNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        ArrayBuilderNode arrayBuilder2;
                        BaseNode_ s;
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (ArrayGuards.isNullArray(arguments0Value_)) {
                            return RejectNullNode_.create(this.root);
                        }
                        ArrayStrategy strategy2 = ArrayStrategy.of(arguments0Value_);
                        if (strategy2.matches(arguments0Value_) && this.countSame(s = RejectOtherNode_.create(this.root, strategy2, arrayBuilder2 = ArrayBuilderNode.create(this.root.getContext()))) < 25) {
                            return s;
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.PushNode.class)
    public static final class PushNodeFactory
    extends NodeFactoryBase<ArrayNodes.PushNode> {
        private static PushNodeFactory pushNodeFactoryInstance;

        private PushNodeFactory() {
            super(ArrayNodes.PushNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.PushNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PushNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.PushNode> getInstance() {
            if (pushNodeFactoryInstance == null) {
                pushNodeFactoryInstance = new PushNodeFactory();
            }
            return pushNodeFactoryInstance;
        }

        public static ArrayNodes.PushNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new PushNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.PushNode.class)
        @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
        public static final class PushNodeGen
        extends ArrayNodes.PushNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @Node.Child
            private BaseNode_ specialization_;

            private PushNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="pushMany(VirtualFrame, DynamicObject, Object, Object[])", value=ArrayNodes.PushNode.class)
            private static final class PushManyNode_
            extends BaseNode_ {
                PushManyNode_(PushNodeGen root) {
                    super(root, 3);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof Object[]) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        Object[] arguments2Value_ = (Object[])arguments2Value;
                        if (arguments2Value_.length > 0 && RubyGuards.wasProvided(arguments1Value)) {
                            return this.root.pushMany(frameValue, arguments0Value_, arguments1Value, arguments2Value_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(PushNodeGen root) {
                    return new PushManyNode_(root);
                }
            }

            @GeneratedBy(methodName="pushOne(DynamicObject, Object, Object[])", value=ArrayNodes.PushNode.class)
            private static final class PushOneNode_
            extends BaseNode_ {
                PushOneNode_(PushNodeGen root) {
                    super(root, 2);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof Object[]) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        Object[] arguments2Value_ = (Object[])arguments2Value;
                        if (arguments2Value_.length == 0 && RubyGuards.wasProvided(arguments1Value)) {
                            return this.root.pushOne(arguments0Value_, arguments1Value, arguments2Value_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(PushNodeGen root) {
                    return new PushOneNode_(root);
                }
            }

            @GeneratedBy(methodName="pushZero(DynamicObject, NotProvided, Object[])", value=ArrayNodes.PushNode.class)
            private static final class PushZeroNode_
            extends BaseNode_ {
                PushZeroNode_(PushNodeGen root) {
                    super(root, 1);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided && arguments2Value instanceof Object[]) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        Object[] arguments2Value_ = (Object[])arguments2Value;
                        if (arguments2Value_.length == 0) {
                            return this.root.pushZero(arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(PushNodeGen root) {
                    return new PushZeroNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.PushNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(PushNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(PushNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.PushNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(PushNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(PushNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.PushNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected PushNodeGen root;

                BaseNode_(PushNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (PushNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof Object[]) {
                        Object[] arguments2Value_ = (Object[])arguments2Value;
                        if (arguments1Value instanceof NotProvided && arguments2Value_.length == 0) {
                            return PushZeroNode_.create(this.root);
                        }
                        if (arguments2Value_.length == 0 && RubyGuards.wasProvided(arguments1Value)) {
                            return PushOneNode_.create(this.root);
                        }
                        if (arguments2Value_.length > 0 && RubyGuards.wasProvided(arguments1Value)) {
                            return PushManyNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.LeftShiftNode.class)
    public static final class LeftShiftNodeFactory
    extends NodeFactoryBase<ArrayNodes.LeftShiftNode> {
        private static LeftShiftNodeFactory leftShiftNodeFactoryInstance;

        private LeftShiftNodeFactory() {
            super(ArrayNodes.LeftShiftNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.LeftShiftNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LeftShiftNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.LeftShiftNode> getInstance() {
            if (leftShiftNodeFactoryInstance == null) {
                leftShiftNodeFactoryInstance = new LeftShiftNodeFactory();
            }
            return leftShiftNodeFactoryInstance;
        }

        public static ArrayNodes.LeftShiftNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new LeftShiftNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.LeftShiftNode.class)
        public static final class LeftShiftNodeGen
        extends ArrayNodes.LeftShiftNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private LeftShiftNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                return this.leftShift(arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.PopNode.class)
    public static final class PopNodeFactory
    extends NodeFactoryBase<ArrayNodes.PopNode> {
        private static PopNodeFactory popNodeFactoryInstance;

        private PopNodeFactory() {
            super(ArrayNodes.PopNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyNode[].class}});
        }

        public ArrayNodes.PopNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return PopNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.PopNode> getInstance() {
            if (popNodeFactoryInstance == null) {
                popNodeFactoryInstance = new PopNodeFactory();
            }
            return popNodeFactoryInstance;
        }

        public static ArrayNodes.PopNode create(RubyNode[] arguments) {
            return new PopNodeGen(arguments);
        }

        @GeneratedBy(value=ArrayNodes.PopNode.class)
        @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
        public static final class PopNodeGen
        extends ArrayNodes.PopNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private PopNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object executePop(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value) {
                return this.specialization_.execute1(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute0(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="popNToInt(VirtualFrame, DynamicObject, Object)", value=ArrayNodes.PopNode.class)
            private static final class PopNToIntNode_
            extends BaseNode_ {
                PopNToIntNode_(PopNodeGen root) {
                    super(root, 6);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value) {
                    if (RubyGuards.wasProvided(arguments1Value) && !RubyGuards.isInteger(arguments1Value) && !RubyGuards.isLong(arguments1Value)) {
                        return this.root.popNToInt(frameValue, arguments0Value, arguments1Value);
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (RubyGuards.wasProvided(arguments1Value) && !RubyGuards.isInteger(arguments1Value) && !RubyGuards.isLong(arguments1Value)) {
                            return this.root.popNToInt(frameValue, arguments0Value_, arguments1Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PopNodeGen root) {
                    return new PopNToIntNode_(root);
                }
            }

            @GeneratedBy(methodName="popNotEmpty(DynamicObject, int, ArrayStrategy, ConditionProfile)", value=ArrayNodes.PopNode.class)
            private static final class PopNotEmptyNode_
            extends BaseNode_ {
                private final ArrayStrategy strategy;
                private final ConditionProfile minProfile;
                private final Class<?> arguments1ImplicitType;

                PopNotEmptyNode_(PopNodeGen root, Object arguments1Value, ArrayStrategy strategy, ConditionProfile minProfile) {
                    super(root, 5);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                    this.strategy = strategy;
                    this.minProfile = minProfile;
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((PopNotEmptyNode_)other).arguments1ImplicitType;
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        if (arguments1Value_ > 0 && !ArrayGuards.isEmptyArray(arguments0Value_) && this.strategy.matches(arguments0Value_)) {
                            return true;
                        }
                    }
                    return false;
                }

                @Override
                public Object execute0(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (arguments1Value_ > 0 && !ArrayGuards.isEmptyArray(arguments0Value_) && this.strategy.matches(arguments0Value_)) {
                        return this.root.popNotEmpty(arguments0Value_, arguments1Value_, this.strategy, this.minProfile);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value) {
                    int arguments1Value_;
                    if (RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && (arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType)) > 0 && !ArrayGuards.isEmptyArray(arguments0Value) && this.strategy.matches(arguments0Value)) {
                        return this.root.popNotEmpty(arguments0Value, arguments1Value_, this.strategy, this.minProfile);
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        if (arguments1Value_ > 0 && !ArrayGuards.isEmptyArray(arguments0Value_) && this.strategy.matches(arguments0Value_)) {
                            return this.root.popNotEmpty(arguments0Value_, arguments1Value_, this.strategy, this.minProfile);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PopNodeGen root, Object arguments1Value, ArrayStrategy strategy, ConditionProfile minProfile) {
                    return new PopNotEmptyNode_(root, arguments1Value, strategy, minProfile);
                }
            }

            @GeneratedBy(methodName="popZeroNotEmpty(DynamicObject, int)", value=ArrayNodes.PopNode.class)
            private static final class PopZeroNotEmptyNode_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                PopZeroNotEmptyNode_(PopNodeGen root, Object arguments1Value) {
                    super(root, 4);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((PopZeroNotEmptyNode_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute0(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (arguments1Value_ == 0 && !ArrayGuards.isEmptyArray(arguments0Value_)) {
                        return this.root.popZeroNotEmpty(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value) {
                    int arguments1Value_;
                    if (RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && (arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType)) == 0 && !ArrayGuards.isEmptyArray(arguments0Value)) {
                        return this.root.popZeroNotEmpty(arguments0Value, arguments1Value_);
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        if (arguments1Value_ == 0 && !ArrayGuards.isEmptyArray(arguments0Value_)) {
                            return this.root.popZeroNotEmpty(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PopNodeGen root, Object arguments1Value) {
                    return new PopZeroNotEmptyNode_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="popEmpty(VirtualFrame, DynamicObject, int)", value=ArrayNodes.PopNode.class)
            private static final class PopEmptyNode_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                PopEmptyNode_(PopNodeGen root, Object arguments1Value) {
                    super(root, 3);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((PopEmptyNode_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute0(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (arguments1Value_ >= 0 && ArrayGuards.isEmptyArray(arguments0Value_)) {
                        return this.root.popEmpty(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value) {
                    int arguments1Value_;
                    if (RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && (arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType)) >= 0 && ArrayGuards.isEmptyArray(arguments0Value)) {
                        return this.root.popEmpty(frameValue, arguments0Value, arguments1Value_);
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        if (arguments1Value_ >= 0 && ArrayGuards.isEmptyArray(arguments0Value_)) {
                            return this.root.popEmpty(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PopNodeGen root, Object arguments1Value) {
                    return new PopEmptyNode_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="popNNegative(VirtualFrame, DynamicObject, int)", value=ArrayNodes.PopNode.class)
            private static final class PopNNegativeNode_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                PopNNegativeNode_(PopNodeGen root, Object arguments1Value) {
                    super(root, 2);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((PopNNegativeNode_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute0(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (arguments1Value_ < 0) {
                        return this.root.popNNegative(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value) {
                    int arguments1Value_;
                    if (RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && (arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType)) < 0) {
                        return this.root.popNNegative(frameValue, arguments0Value, arguments1Value_);
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        if (arguments1Value_ < 0) {
                            return this.root.popNNegative(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PopNodeGen root, Object arguments1Value) {
                    return new PopNNegativeNode_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="pop(DynamicObject, NotProvided)", value=ArrayNodes.PopNode.class)
            private static final class PopNode_
            extends BaseNode_ {
                PopNode_(PopNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value) {
                    if (arguments1Value instanceof NotProvided) {
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        return this.root.pop(arguments0Value, arguments1Value_);
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        return this.root.pop(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PopNodeGen root) {
                    return new PopNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.PopNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(PopNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PopNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.PopNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(PopNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PopNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.PopNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected PopNodeGen root;

                BaseNode_(PopNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (PopNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value) {
                    return this.execute_(frameValue, arguments0Value, arguments1Value);
                }

                public Object execute0(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute0(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (arguments1Value instanceof NotProvided) {
                            return PopNode_.create(this.root);
                        }
                        if (RubyTypesGen.isImplicitInteger(arguments1Value)) {
                            ConditionProfile minProfile5;
                            BaseNode_ s;
                            int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value);
                            if (arguments1Value_ < 0) {
                                return PopNNegativeNode_.create(this.root, arguments1Value);
                            }
                            if (arguments1Value_ >= 0 && ArrayGuards.isEmptyArray(arguments0Value_)) {
                                return PopEmptyNode_.create(this.root, arguments1Value);
                            }
                            if (arguments1Value_ == 0 && !ArrayGuards.isEmptyArray(arguments0Value_)) {
                                return PopZeroNotEmptyNode_.create(this.root, arguments1Value);
                            }
                            ArrayStrategy strategy5 = ArrayStrategy.of(arguments0Value_);
                            if (arguments1Value_ > 0 && !ArrayGuards.isEmptyArray(arguments0Value_) && strategy5.matches(arguments0Value_) && this.countSame(s = PopNotEmptyNode_.create(this.root, arguments1Value, strategy5, minProfile5 = ConditionProfile.createBinaryProfile())) < 25) {
                                return s;
                            }
                        }
                        if (RubyGuards.wasProvided(arguments1Value) && !RubyGuards.isInteger(arguments1Value) && !RubyGuards.isLong(arguments1Value)) {
                            return PopNToIntNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.PackNode.class)
    public static final class PackNodeFactory
    extends NodeFactoryBase<ArrayNodes.PackNode> {
        private static PackNodeFactory packNodeFactoryInstance;

        private PackNodeFactory() {
            super(ArrayNodes.PackNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyNode[].class}});
        }

        public ArrayNodes.PackNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return PackNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.PackNode> getInstance() {
            if (packNodeFactoryInstance == null) {
                packNodeFactoryInstance = new PackNodeFactory();
            }
            return packNodeFactoryInstance;
        }

        public static ArrayNodes.PackNode create(RubyNode[] arguments) {
            return new PackNodeGen(arguments);
        }

        @GeneratedBy(value=ArrayNodes.PackNode.class)
        public static final class PackNodeGen
        extends ArrayNodes.PackNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean excludePackCached_;
            @Node.Child
            private BaseNode_ specialization_;

            private PackNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="pack(VirtualFrame, DynamicObject, Object, SnippetNode)", value=ArrayNodes.PackNode.class)
            private static final class PackNode_
            extends BaseNode_ {
                @Node.Child
                private SnippetNode snippetNode;

                PackNode_(PackNodeGen root, SnippetNode snippetNode) {
                    super(root, 3);
                    this.snippetNode = snippetNode;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (!(RubyGuards.isRubyString(arguments1Value) || RubyGuards.isBoolean(arguments1Value) || RubyGuards.isInteger(arguments1Value) || RubyGuards.isLong(arguments1Value) || this.root.isNil(arguments1Value))) {
                            return this.root.pack(frameValue, arguments0Value_, arguments1Value, this.snippetNode);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PackNodeGen root, SnippetNode snippetNode) {
                    return new PackNode_(root, snippetNode);
                }
            }

            @GeneratedBy(methodName="packUncached(VirtualFrame, DynamicObject, DynamicObject, IndirectCallNode)", value=ArrayNodes.PackNode.class)
            private static final class PackUncachedNode_
            extends BaseNode_ {
                @Node.Child
                private IndirectCallNode callPackNode;

                PackUncachedNode_(PackNodeGen root, IndirectCallNode callPackNode) {
                    super(root, 2);
                    this.callPackNode = callPackNode;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments1Value_)) {
                            return this.root.packUncached(frameValue, arguments0Value_, arguments1Value_, this.callPackNode);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PackNodeGen root, IndirectCallNode callPackNode) {
                    return new PackUncachedNode_(root, callPackNode);
                }
            }

            @GeneratedBy(methodName="packCached(VirtualFrame, DynamicObject, DynamicObject, Rope, int, DirectCallNode)", value=ArrayNodes.PackNode.class)
            private static final class PackCachedNode_
            extends BaseNode_ {
                private final Rope cachedFormat;
                private final int cachedFormatLength;
                @Node.Child
                private DirectCallNode callPackNode;

                PackCachedNode_(PackNodeGen root, Rope cachedFormat, int cachedFormatLength, DirectCallNode callPackNode) {
                    super(root, 1);
                    this.cachedFormat = cachedFormat;
                    this.cachedFormatLength = cachedFormatLength;
                    this.callPackNode = callPackNode;
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (newNode.getClass() == PackUncachedNode_.class) {
                        this.removeSame("Contained by packUncached(VirtualFrame, DynamicObject, DynamicObject, IndirectCallNode)");
                    }
                    return super.merge(newNode, frameValue, arguments0Value, arguments1Value);
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments1Value_;
                    return arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && RubyGuards.isRubyString(arguments1Value_ = (DynamicObject)arguments1Value) && StringCachingGuards.ropesEqual(arguments1Value_, this.cachedFormat);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments1Value_) && StringCachingGuards.ropesEqual(arguments1Value_, this.cachedFormat)) {
                            return this.root.packCached(frameValue, arguments0Value_, arguments1Value_, this.cachedFormat, this.cachedFormatLength, this.callPackNode);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PackNodeGen root, Rope cachedFormat, int cachedFormatLength, DirectCallNode callPackNode) {
                    return new PackCachedNode_(root, cachedFormat, cachedFormatLength, callPackNode);
                }
            }

            @GeneratedBy(value=ArrayNodes.PackNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(PackNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PackNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.PackNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(PackNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(PackNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.PackNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected PackNodeGen root;

                BaseNode_(PackNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (PackNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        if (arguments1Value instanceof DynamicObject) {
                            DirectCallNode callPackNode1;
                            int cachedFormatLength1;
                            BaseNode_ s;
                            DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                            Rope cachedFormat1 = StringCachingGuards.privatizeRope(arguments1Value_);
                            if (RubyGuards.isRubyString(arguments1Value_) && StringCachingGuards.ropesEqual(arguments1Value_, cachedFormat1) && !this.root.excludePackCached_ && this.countSame(s = PackCachedNode_.create(this.root, cachedFormat1, cachedFormatLength1 = StringCachingGuards.ropeLength(cachedFormat1), callPackNode1 = DirectCallNode.create((CallTarget)this.root.compileFormat(arguments1Value_)))) < this.root.getCacheLimit()) {
                                return s;
                            }
                            if (RubyGuards.isRubyString(arguments1Value_)) {
                                IndirectCallNode callPackNode2 = IndirectCallNode.create();
                                this.root.excludePackCached_ = true;
                                return PackUncachedNode_.create(this.root, callPackNode2);
                            }
                        }
                        if (!(RubyGuards.isRubyString(arguments1Value) || RubyGuards.isBoolean(arguments1Value) || RubyGuards.isInteger(arguments1Value) || RubyGuards.isLong(arguments1Value) || this.root.isNil(arguments1Value))) {
                            SnippetNode snippetNode3 = new SnippetNode();
                            return PackNode_.create(this.root, snippetNode3);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.MinBlockNode.class)
    public static final class MinBlockNodeFactory
    extends NodeFactoryBase<ArrayNodes.MinBlockNode> {
        private static MinBlockNodeFactory minBlockNodeFactoryInstance;

        private MinBlockNodeFactory() {
            super(ArrayNodes.MinBlockNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.MinBlockNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MinBlockNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.MinBlockNode> getInstance() {
            if (minBlockNodeFactoryInstance == null) {
                minBlockNodeFactoryInstance = new MinBlockNodeFactory();
            }
            return minBlockNodeFactoryInstance;
        }

        public static ArrayNodes.MinBlockNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new MinBlockNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.MinBlockNode.class)
        public static final class MinBlockNodeGen
        extends ArrayNodes.MinBlockNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;

            private MinBlockNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                return this.min(frameValue, arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.MinNode.class)
    public static final class MinNodeFactory
    extends NodeFactoryBase<ArrayNodes.MinNode> {
        private static MinNodeFactory minNodeFactoryInstance;

        private MinNodeFactory() {
            super(ArrayNodes.MinNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.MinNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MinNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.MinNode> getInstance() {
            if (minNodeFactoryInstance == null) {
                minNodeFactoryInstance = new MinNodeFactory();
            }
            return minNodeFactoryInstance;
        }

        public static ArrayNodes.MinNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new MinNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.MinNode.class)
        public static final class MinNodeGen
        extends ArrayNodes.MinNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private MinNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="min(VirtualFrame, DynamicObject, DynamicObject, SnippetNode)", value=ArrayNodes.MinNode.class)
            private static final class Min1Node_
            extends BaseNode_ {
                @Node.Child
                private SnippetNode snippetNode;

                Min1Node_(MinNodeGen root, SnippetNode snippetNode) {
                    super(root, 2);
                    this.snippetNode = snippetNode;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        return this.root.min(frameValue, arguments0Value_, arguments1Value_, this.snippetNode);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MinNodeGen root, SnippetNode snippetNode) {
                    return new Min1Node_(root, snippetNode);
                }
            }

            @GeneratedBy(methodName="min(VirtualFrame, DynamicObject, NotProvided)", value=ArrayNodes.MinNode.class)
            private static final class Min0Node_
            extends BaseNode_ {
                Min0Node_(MinNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        return this.root.min(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MinNodeGen root) {
                    return new Min0Node_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.MinNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(MinNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MinNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.MinNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(MinNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MinNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.MinNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected MinNodeGen root;

                BaseNode_(MinNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (MinNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        if (arguments1Value instanceof NotProvided) {
                            return Min0Node_.create(this.root);
                        }
                        if (arguments1Value instanceof DynamicObject) {
                            SnippetNode snippetNode2 = new SnippetNode();
                            return Min1Node_.create(this.root, snippetNode2);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.MaxBlockNode.class)
    public static final class MaxBlockNodeFactory
    extends NodeFactoryBase<ArrayNodes.MaxBlockNode> {
        private static MaxBlockNodeFactory maxBlockNodeFactoryInstance;

        private MaxBlockNodeFactory() {
            super(ArrayNodes.MaxBlockNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.MaxBlockNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MaxBlockNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.MaxBlockNode> getInstance() {
            if (maxBlockNodeFactoryInstance == null) {
                maxBlockNodeFactoryInstance = new MaxBlockNodeFactory();
            }
            return maxBlockNodeFactoryInstance;
        }

        public static ArrayNodes.MaxBlockNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new MaxBlockNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.MaxBlockNode.class)
        public static final class MaxBlockNodeGen
        extends ArrayNodes.MaxBlockNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;

            private MaxBlockNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                return this.max(frameValue, arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.MaxNode.class)
    public static final class MaxNodeFactory
    extends NodeFactoryBase<ArrayNodes.MaxNode> {
        private static MaxNodeFactory maxNodeFactoryInstance;

        private MaxNodeFactory() {
            super(ArrayNodes.MaxNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.MaxNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MaxNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.MaxNode> getInstance() {
            if (maxNodeFactoryInstance == null) {
                maxNodeFactoryInstance = new MaxNodeFactory();
            }
            return maxNodeFactoryInstance;
        }

        public static ArrayNodes.MaxNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new MaxNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.MaxNode.class)
        public static final class MaxNodeGen
        extends ArrayNodes.MaxNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private MaxNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="max(VirtualFrame, DynamicObject, DynamicObject, CallDispatchHeadNode)", value=ArrayNodes.MaxNode.class)
            private static final class Max1Node_
            extends BaseNode_ {
                @Node.Child
                private CallDispatchHeadNode callNode;

                Max1Node_(MaxNodeGen root, CallDispatchHeadNode callNode) {
                    super(root, 2);
                    this.callNode = callNode;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        return this.root.max(frameValue, arguments0Value_, arguments1Value_, this.callNode);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MaxNodeGen root, CallDispatchHeadNode callNode) {
                    return new Max1Node_(root, callNode);
                }
            }

            @GeneratedBy(methodName="max(VirtualFrame, DynamicObject, NotProvided)", value=ArrayNodes.MaxNode.class)
            private static final class Max0Node_
            extends BaseNode_ {
                Max0Node_(MaxNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        return this.root.max(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MaxNodeGen root) {
                    return new Max0Node_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.MaxNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(MaxNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MaxNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.MaxNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(MaxNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MaxNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.MaxNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected MaxNodeGen root;

                BaseNode_(MaxNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (MaxNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        if (arguments1Value instanceof NotProvided) {
                            return Max0Node_.create(this.root);
                        }
                        if (arguments1Value instanceof DynamicObject) {
                            CallDispatchHeadNode callNode2 = CallDispatchHeadNode.createMethodCall();
                            return Max1Node_.create(this.root, callNode2);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.MapInPlaceNode.class)
    public static final class MapInPlaceNodeFactory
    extends NodeFactoryBase<ArrayNodes.MapInPlaceNode> {
        private static MapInPlaceNodeFactory mapInPlaceNodeFactoryInstance;

        private MapInPlaceNodeFactory() {
            super(ArrayNodes.MapInPlaceNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyNode[].class}});
        }

        public ArrayNodes.MapInPlaceNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return MapInPlaceNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.MapInPlaceNode> getInstance() {
            if (mapInPlaceNodeFactoryInstance == null) {
                mapInPlaceNodeFactoryInstance = new MapInPlaceNodeFactory();
            }
            return mapInPlaceNodeFactoryInstance;
        }

        public static ArrayNodes.MapInPlaceNode create(RubyNode[] arguments) {
            return new MapInPlaceNodeGen(arguments);
        }

        @GeneratedBy(value=ArrayNodes.MapInPlaceNode.class)
        public static final class MapInPlaceNodeGen
        extends ArrayNodes.MapInPlaceNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private MapInPlaceNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="map(VirtualFrame, DynamicObject, DynamicObject, ArrayStrategy, ArrayWriteNormalizedNode)", value=ArrayNodes.MapInPlaceNode.class)
            private static final class MapNode_
            extends BaseNode_ {
                private final ArrayStrategy strategy;
                @Node.Child
                private ArrayWriteNormalizedNode writeNode;

                MapNode_(MapInPlaceNodeGen root, ArrayStrategy strategy, ArrayWriteNormalizedNode writeNode) {
                    super(root, 2);
                    this.strategy = strategy;
                    this.writeNode = writeNode;
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    return arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && this.strategy.matches(arguments0Value_ = (DynamicObject)arguments0Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (this.strategy.matches(arguments0Value_)) {
                            return this.root.map(frameValue, arguments0Value_, arguments1Value_, this.strategy, this.writeNode);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MapInPlaceNodeGen root, ArrayStrategy strategy, ArrayWriteNormalizedNode writeNode) {
                    return new MapNode_(root, strategy, writeNode);
                }
            }

            @GeneratedBy(methodName="mapInPlaceNull(DynamicObject, DynamicObject)", value=ArrayNodes.MapInPlaceNode.class)
            private static final class MapInPlaceNullNode_
            extends BaseNode_ {
                MapInPlaceNullNode_(MapInPlaceNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isNullArray(arguments0Value_)) {
                            return this.root.mapInPlaceNull(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MapInPlaceNodeGen root) {
                    return new MapInPlaceNullNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.MapInPlaceNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(MapInPlaceNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MapInPlaceNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.MapInPlaceNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(MapInPlaceNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MapInPlaceNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.MapInPlaceNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected MapInPlaceNodeGen root;

                BaseNode_(MapInPlaceNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (MapInPlaceNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        ArrayWriteNormalizedNode writeNode2;
                        BaseNode_ s;
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (ArrayGuards.isNullArray(arguments0Value_)) {
                            return MapInPlaceNullNode_.create(this.root);
                        }
                        ArrayStrategy strategy2 = ArrayStrategy.of(arguments0Value_);
                        if (strategy2.matches(arguments0Value_) && this.countSame(s = MapNode_.create(this.root, strategy2, writeNode2 = this.root.createWriteNode())) < 25) {
                            return s;
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.MapNode.class)
    public static final class MapNodeFactory
    extends NodeFactoryBase<ArrayNodes.MapNode> {
        private static MapNodeFactory mapNodeFactoryInstance;

        private MapNodeFactory() {
            super(ArrayNodes.MapNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyNode[].class}});
        }

        public ArrayNodes.MapNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return MapNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.MapNode> getInstance() {
            if (mapNodeFactoryInstance == null) {
                mapNodeFactoryInstance = new MapNodeFactory();
            }
            return mapNodeFactoryInstance;
        }

        public static ArrayNodes.MapNode create(RubyNode[] arguments) {
            return new MapNodeGen(arguments);
        }

        @GeneratedBy(value=ArrayNodes.MapNode.class)
        public static final class MapNodeGen
        extends ArrayNodes.MapNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private MapNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="map(VirtualFrame, DynamicObject, DynamicObject, ArrayStrategy, ArrayBuilderNode)", value=ArrayNodes.MapNode.class)
            private static final class MapNode_
            extends BaseNode_ {
                private final ArrayStrategy strategy;
                @Node.Child
                private ArrayBuilderNode arrayBuilder;

                MapNode_(MapNodeGen root, ArrayStrategy strategy, ArrayBuilderNode arrayBuilder) {
                    super(root, 2);
                    this.strategy = strategy;
                    this.arrayBuilder = arrayBuilder;
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    return arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && this.strategy.matches(arguments0Value_ = (DynamicObject)arguments0Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (this.strategy.matches(arguments0Value_)) {
                            return this.root.map(frameValue, arguments0Value_, arguments1Value_, this.strategy, this.arrayBuilder);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MapNodeGen root, ArrayStrategy strategy, ArrayBuilderNode arrayBuilder) {
                    return new MapNode_(root, strategy, arrayBuilder);
                }
            }

            @GeneratedBy(methodName="mapNull(DynamicObject, DynamicObject)", value=ArrayNodes.MapNode.class)
            private static final class MapNullNode_
            extends BaseNode_ {
                MapNullNode_(MapNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isNullArray(arguments0Value_)) {
                            return this.root.mapNull(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MapNodeGen root) {
                    return new MapNullNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.MapNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(MapNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MapNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.MapNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(MapNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MapNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.MapNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected MapNodeGen root;

                BaseNode_(MapNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (MapNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        ArrayBuilderNode arrayBuilder2;
                        BaseNode_ s;
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (ArrayGuards.isNullArray(arguments0Value_)) {
                            return MapNullNode_.create(this.root);
                        }
                        ArrayStrategy strategy2 = ArrayStrategy.of(arguments0Value_);
                        if (strategy2.matches(arguments0Value_) && this.countSame(s = MapNode_.create(this.root, strategy2, arrayBuilder2 = ArrayBuilderNode.create(this.root.getContext()))) < 25) {
                            return s;
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.InjectNode.class)
    public static final class InjectNodeFactory
    extends NodeFactoryBase<ArrayNodes.InjectNode> {
        private static InjectNodeFactory injectNodeFactoryInstance;

        private InjectNodeFactory() {
            super(ArrayNodes.InjectNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.InjectNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InjectNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.InjectNode> getInstance() {
            if (injectNodeFactoryInstance == null) {
                injectNodeFactoryInstance = new InjectNodeFactory();
            }
            return injectNodeFactoryInstance;
        }

        public static ArrayNodes.InjectNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new InjectNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.InjectNode.class)
        public static final class InjectNodeGen
        extends ArrayNodes.InjectNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @Node.Child
            private RubyNode arguments3_;
            @Node.Child
            private BaseNode_ specialization_;

            private InjectNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.arguments3_ = arguments != null && 3 < arguments.length ? arguments[3] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="injectSymbolNoInitial(VirtualFrame, DynamicObject, DynamicObject, NotProvided, NotProvided, ArrayStrategy)", value=ArrayNodes.InjectNode.class)
            private static final class InjectSymbolNoInitialNode_
            extends BaseNode_ {
                private final ArrayStrategy strategy;

                InjectSymbolNoInitialNode_(InjectNodeGen root, ArrayStrategy strategy) {
                    super(root, 8);
                    this.strategy = strategy;
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof NotProvided && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubySymbol(arguments1Value_) && this.strategy.matches(arguments0Value_) && !ArrayGuards.isEmptyArray(arguments0Value_)) {
                            return true;
                        }
                    }
                    return false;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof NotProvided && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (RubyGuards.isRubySymbol(arguments1Value_) && this.strategy.matches(arguments0Value_) && !ArrayGuards.isEmptyArray(arguments0Value_)) {
                            return this.root.injectSymbolNoInitial(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_, this.strategy);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InjectNodeGen root, ArrayStrategy strategy) {
                    return new InjectSymbolNoInitialNode_(root, strategy);
                }
            }

            @GeneratedBy(methodName="injectSymbolWithInitial(VirtualFrame, DynamicObject, Object, DynamicObject, NotProvided, ArrayStrategy)", value=ArrayNodes.InjectNode.class)
            private static final class InjectSymbolWithInitialNode_
            extends BaseNode_ {
                private final ArrayStrategy strategy;

                InjectSymbolWithInitialNode_(InjectNodeGen root, ArrayStrategy strategy) {
                    super(root, 7);
                    this.strategy = strategy;
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof DynamicObject && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments2Value_ = (DynamicObject)arguments2Value;
                        if (RubyGuards.isRubySymbol(arguments2Value_) && this.strategy.matches(arguments0Value_) && !ArrayGuards.isEmptyArray(arguments0Value_) && RubyGuards.wasProvided(arguments1Value)) {
                            return true;
                        }
                    }
                    return false;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof DynamicObject && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments2Value_ = (DynamicObject)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (RubyGuards.isRubySymbol(arguments2Value_) && this.strategy.matches(arguments0Value_) && !ArrayGuards.isEmptyArray(arguments0Value_) && RubyGuards.wasProvided(arguments1Value)) {
                            return this.root.injectSymbolWithInitial(frameValue, arguments0Value_, arguments1Value, arguments2Value_, arguments3Value_, this.strategy);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InjectNodeGen root, ArrayStrategy strategy) {
                    return new InjectSymbolWithInitialNode_(root, strategy);
                }
            }

            @GeneratedBy(methodName="injectSymbolEmptyArrayNoInitial(VirtualFrame, DynamicObject, DynamicObject, NotProvided, NotProvided)", value=ArrayNodes.InjectNode.class)
            private static final class InjectSymbolEmptyArrayNoInitialNode_
            extends BaseNode_ {
                InjectSymbolEmptyArrayNoInitialNode_(InjectNodeGen root) {
                    super(root, 6);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof NotProvided && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (RubyGuards.isRubySymbol(arguments1Value_) && ArrayGuards.isEmptyArray(arguments0Value_)) {
                            return this.root.injectSymbolEmptyArrayNoInitial(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InjectNodeGen root) {
                    return new InjectSymbolEmptyArrayNoInitialNode_(root);
                }
            }

            @GeneratedBy(methodName="injectSymbolEmptyArray(VirtualFrame, DynamicObject, Object, DynamicObject, NotProvided)", value=ArrayNodes.InjectNode.class)
            private static final class InjectSymbolEmptyArrayNode_
            extends BaseNode_ {
                InjectSymbolEmptyArrayNode_(InjectNodeGen root) {
                    super(root, 5);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof DynamicObject && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments2Value_ = (DynamicObject)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (RubyGuards.isRubySymbol(arguments2Value_) && ArrayGuards.isEmptyArray(arguments0Value_) && RubyGuards.wasProvided(arguments1Value)) {
                            return this.root.injectSymbolEmptyArray(frameValue, arguments0Value_, arguments1Value, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InjectNodeGen root) {
                    return new InjectSymbolEmptyArrayNode_(root);
                }
            }

            @GeneratedBy(methodName="injectNoInitial(VirtualFrame, DynamicObject, NotProvided, NotProvided, DynamicObject, ArrayStrategy)", value=ArrayNodes.InjectNode.class)
            private static final class InjectNoInitialNode_
            extends BaseNode_ {
                private final ArrayStrategy strategy;

                InjectNoInitialNode_(InjectNodeGen root, ArrayStrategy strategy) {
                    super(root, 4);
                    this.strategy = strategy;
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    DynamicObject arguments0Value_;
                    return arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided && arguments2Value instanceof NotProvided && arguments3Value instanceof DynamicObject && this.strategy.matches(arguments0Value_ = (DynamicObject)arguments0Value) && !ArrayGuards.isEmptyArray(arguments0Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided && arguments2Value instanceof NotProvided && arguments3Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        DynamicObject arguments3Value_ = (DynamicObject)arguments3Value;
                        if (this.strategy.matches(arguments0Value_) && !ArrayGuards.isEmptyArray(arguments0Value_)) {
                            return this.root.injectNoInitial(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_, this.strategy);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InjectNodeGen root, ArrayStrategy strategy) {
                    return new InjectNoInitialNode_(root, strategy);
                }
            }

            @GeneratedBy(methodName="injectWithInitial(VirtualFrame, DynamicObject, Object, NotProvided, DynamicObject, ArrayStrategy)", value=ArrayNodes.InjectNode.class)
            private static final class InjectWithInitialNode_
            extends BaseNode_ {
                private final ArrayStrategy strategy;

                InjectWithInitialNode_(InjectNodeGen root, ArrayStrategy strategy) {
                    super(root, 3);
                    this.strategy = strategy;
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    DynamicObject arguments0Value_;
                    return arguments0Value instanceof DynamicObject && arguments2Value instanceof NotProvided && arguments3Value instanceof DynamicObject && this.strategy.matches(arguments0Value_ = (DynamicObject)arguments0Value) && !ArrayGuards.isEmptyArray(arguments0Value_) && RubyGuards.wasProvided(arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof NotProvided && arguments3Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        DynamicObject arguments3Value_ = (DynamicObject)arguments3Value;
                        if (this.strategy.matches(arguments0Value_) && !ArrayGuards.isEmptyArray(arguments0Value_) && RubyGuards.wasProvided(arguments1Value)) {
                            return this.root.injectWithInitial(frameValue, arguments0Value_, arguments1Value, arguments2Value_, arguments3Value_, this.strategy);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InjectNodeGen root, ArrayStrategy strategy) {
                    return new InjectWithInitialNode_(root, strategy);
                }
            }

            @GeneratedBy(methodName="injectEmptyArrayNoInitial(VirtualFrame, DynamicObject, NotProvided, NotProvided, DynamicObject)", value=ArrayNodes.InjectNode.class)
            private static final class InjectEmptyArrayNoInitialNode_
            extends BaseNode_ {
                InjectEmptyArrayNoInitialNode_(InjectNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided && arguments2Value instanceof NotProvided && arguments3Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        DynamicObject arguments3Value_ = (DynamicObject)arguments3Value;
                        if (ArrayGuards.isEmptyArray(arguments0Value_)) {
                            return this.root.injectEmptyArrayNoInitial(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InjectNodeGen root) {
                    return new InjectEmptyArrayNoInitialNode_(root);
                }
            }

            @GeneratedBy(methodName="injectEmptyArray(VirtualFrame, DynamicObject, Object, NotProvided, DynamicObject)", value=ArrayNodes.InjectNode.class)
            private static final class InjectEmptyArrayNode_
            extends BaseNode_ {
                InjectEmptyArrayNode_(InjectNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof NotProvided && arguments3Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        DynamicObject arguments3Value_ = (DynamicObject)arguments3Value;
                        if (ArrayGuards.isEmptyArray(arguments0Value_) && RubyGuards.wasProvided(arguments1Value)) {
                            return this.root.injectEmptyArray(frameValue, arguments0Value_, arguments1Value, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InjectNodeGen root) {
                    return new InjectEmptyArrayNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.InjectNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(InjectNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InjectNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.InjectNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(InjectNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InjectNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.InjectNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected InjectNodeGen root;

                BaseNode_(InjectNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (InjectNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_, this.root.arguments3_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4, Object var5);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    Object arguments3Value_ = this.root.arguments3_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        BaseNode_ s;
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (arguments2Value instanceof NotProvided && arguments3Value instanceof DynamicObject) {
                            ArrayStrategy strategy4;
                            BaseNode_ s2;
                            if (ArrayGuards.isEmptyArray(arguments0Value_) && RubyGuards.wasProvided(arguments1Value)) {
                                return InjectEmptyArrayNode_.create(this.root);
                            }
                            if (arguments1Value instanceof NotProvided && ArrayGuards.isEmptyArray(arguments0Value_)) {
                                return InjectEmptyArrayNoInitialNode_.create(this.root);
                            }
                            ArrayStrategy strategy3 = ArrayStrategy.of(arguments0Value_);
                            if (strategy3.matches(arguments0Value_) && !ArrayGuards.isEmptyArray(arguments0Value_) && RubyGuards.wasProvided(arguments1Value) && this.countSame(s2 = InjectWithInitialNode_.create(this.root, strategy3)) < 25) {
                                return s2;
                            }
                            if (arguments1Value instanceof NotProvided && (strategy4 = ArrayStrategy.of(arguments0Value_)).matches(arguments0Value_) && !ArrayGuards.isEmptyArray(arguments0Value_) && this.countSame(s = InjectNoInitialNode_.create(this.root, strategy4)) < 25) {
                                return s;
                            }
                        }
                        if (arguments3Value instanceof NotProvided) {
                            DynamicObject arguments1Value_;
                            DynamicObject arguments2Value_;
                            if (arguments2Value instanceof DynamicObject && RubyGuards.isRubySymbol(arguments2Value_ = (DynamicObject)arguments2Value) && ArrayGuards.isEmptyArray(arguments0Value_) && RubyGuards.wasProvided(arguments1Value)) {
                                return InjectSymbolEmptyArrayNode_.create(this.root);
                            }
                            if (arguments1Value instanceof DynamicObject && arguments2Value instanceof NotProvided && RubyGuards.isRubySymbol(arguments1Value_ = (DynamicObject)arguments1Value) && ArrayGuards.isEmptyArray(arguments0Value_)) {
                                return InjectSymbolEmptyArrayNoInitialNode_.create(this.root);
                            }
                            if (arguments2Value instanceof DynamicObject) {
                                arguments2Value_ = (DynamicObject)arguments2Value;
                                ArrayStrategy strategy7 = ArrayStrategy.of(arguments0Value_);
                                if (RubyGuards.isRubySymbol(arguments2Value_) && strategy7.matches(arguments0Value_) && !ArrayGuards.isEmptyArray(arguments0Value_) && RubyGuards.wasProvided(arguments1Value) && this.countSame(s = InjectSymbolWithInitialNode_.create(this.root, strategy7)) < 25) {
                                    return s;
                                }
                            }
                            if (arguments1Value instanceof DynamicObject && arguments2Value instanceof NotProvided) {
                                arguments1Value_ = (DynamicObject)arguments1Value;
                                ArrayStrategy strategy8 = ArrayStrategy.of(arguments0Value_);
                                if (RubyGuards.isRubySymbol(arguments1Value_) && strategy8.matches(arguments0Value_) && !ArrayGuards.isEmptyArray(arguments0Value_) && this.countSame(s = InjectSymbolNoInitialNode_.create(this.root, strategy8)) < 25) {
                                    return s;
                                }
                            }
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.InitializeCopyNode.class)
    public static final class InitializeCopyNodeFactory
    extends NodeFactoryBase<ArrayNodes.InitializeCopyNode> {
        private static InitializeCopyNodeFactory initializeCopyNodeFactoryInstance;

        private InitializeCopyNodeFactory() {
            super(ArrayNodes.InitializeCopyNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyNode.class, RubyNode.class}});
        }

        public ArrayNodes.InitializeCopyNode createNode(Object ... arguments) {
            if (arguments.length == 2 && (arguments[0] == null || arguments[0] instanceof RubyNode) && (arguments[1] == null || arguments[1] instanceof RubyNode)) {
                return InitializeCopyNodeFactory.create((RubyNode)((Object)arguments[0]), (RubyNode)((Object)arguments[1]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.InitializeCopyNode> getInstance() {
            if (initializeCopyNodeFactoryInstance == null) {
                initializeCopyNodeFactoryInstance = new InitializeCopyNodeFactory();
            }
            return initializeCopyNodeFactoryInstance;
        }

        public static ArrayNodes.InitializeCopyNode create(RubyNode self, RubyNode from) {
            return new InitializeCopyNodeGen(self, from);
        }

        @GeneratedBy(value=ArrayNodes.InitializeCopyNode.class)
        public static final class InitializeCopyNodeGen
        extends ArrayNodes.InitializeCopyNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode self_;
            @Node.Child
            private RubyNode from_;
            @Node.Child
            private BaseNode_ specialization_;

            private InitializeCopyNodeGen(RubyNode self, RubyNode from) {
                this.self_ = self;
                this.from_ = this.coerceOtherToAry(from);
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="initializeCopy(DynamicObject, DynamicObject, ReplaceNode)", value=ArrayNodes.InitializeCopyNode.class)
            private static final class InitializeCopyNode_
            extends BaseNode_ {
                @Node.Child
                private ArrayNodes.ReplaceNode replaceNode;

                InitializeCopyNode_(InitializeCopyNodeGen root, ArrayNodes.ReplaceNode replaceNode) {
                    super(root, 1);
                    this.replaceNode = replaceNode;
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object selfValue, Object fromValue) {
                    if (selfValue instanceof DynamicObject && fromValue instanceof DynamicObject) {
                        DynamicObject selfValue_ = (DynamicObject)selfValue;
                        DynamicObject fromValue_ = (DynamicObject)fromValue;
                        return this.root.initializeCopy(selfValue_, fromValue_, this.replaceNode);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, selfValue, fromValue);
                }

                static BaseNode_ create(InitializeCopyNodeGen root, ArrayNodes.ReplaceNode replaceNode) {
                    return new InitializeCopyNode_(root, replaceNode);
                }
            }

            @GeneratedBy(value=ArrayNodes.InitializeCopyNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(InitializeCopyNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object selfValue, Object fromValue) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, selfValue, fromValue);
                }

                static BaseNode_ create(InitializeCopyNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.InitializeCopyNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected InitializeCopyNodeGen root;

                BaseNode_(InitializeCopyNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (InitializeCopyNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.self_, this.root.from_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object selfValue, Object fromValue) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, selfValue, fromValue);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object selfValue_ = this.root.self_.execute(frameValue);
                    Object fromValue_ = this.root.from_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, selfValue_, fromValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object selfValue, Object fromValue) {
                    if (selfValue instanceof DynamicObject && fromValue instanceof DynamicObject) {
                        ArrayNodes.ReplaceNode replaceNode1 = this.root.createReplaceNode();
                        return InitializeCopyNode_.create(this.root, replaceNode1);
                    }
                    return null;
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.InitializeNode.class)
    public static final class InitializeNodeFactory
    extends NodeFactoryBase<ArrayNodes.InitializeNode> {
        private static InitializeNodeFactory initializeNodeFactoryInstance;

        private InitializeNodeFactory() {
            super(ArrayNodes.InitializeNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyNode[].class}});
        }

        public ArrayNodes.InitializeNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return InitializeNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.InitializeNode> getInstance() {
            if (initializeNodeFactoryInstance == null) {
                initializeNodeFactoryInstance = new InitializeNodeFactory();
            }
            return initializeNodeFactoryInstance;
        }

        public static ArrayNodes.InitializeNode create(RubyNode[] arguments) {
            return new InitializeNodeGen(arguments);
        }

        @GeneratedBy(value=ArrayNodes.InitializeNode.class)
        @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
        public static final class InitializeNodeGen
        extends ArrayNodes.InitializeNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @Node.Child
            private RubyNode arguments3_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private InitializeNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.arguments3_ = arguments != null && 3 < arguments.length ? arguments[3] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public DynamicObject executeInitialize(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                return this.specialization_.executeDynamicObject1(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeDynamicObject0(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            private static DynamicObject expectDynamicObject(Object value) throws UnexpectedResultException {
                if (value instanceof DynamicObject) {
                    return (DynamicObject)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="initialize(VirtualFrame, DynamicObject, Object, NotProvided, NotProvided)", value=ArrayNodes.InitializeNode.class)
            private static final class InitializeNode_
            extends BaseNode_ {
                InitializeNode_(InitializeNodeGen root) {
                    super(root, 11);
                }

                @Override
                public DynamicObject executeDynamicObject1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments2Value instanceof NotProvided && arguments3Value instanceof NotProvided) {
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (!RubyGuards.isInteger(arguments1Value) && !RubyGuards.isLong(arguments1Value) && RubyGuards.wasProvided(arguments1Value) && !RubyGuards.isRubyArray(arguments1Value)) {
                            return this.root.initialize(frameValue, arguments0Value, arguments1Value, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().executeDynamicObject1(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof NotProvided && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (!RubyGuards.isInteger(arguments1Value) && !RubyGuards.isLong(arguments1Value) && RubyGuards.wasProvided(arguments1Value) && !RubyGuards.isRubyArray(arguments1Value)) {
                            return this.root.initialize(frameValue, arguments0Value_, arguments1Value, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new InitializeNode_(root);
                }
            }

            @GeneratedBy(methodName="initializeFromArray(DynamicObject, DynamicObject, NotProvided, Object, ReplaceNode)", value=ArrayNodes.InitializeNode.class)
            private static final class InitializeFromArrayNode_
            extends BaseNode_ {
                @Node.Child
                private ArrayNodes.ReplaceNode replaceNode;

                InitializeFromArrayNode_(InitializeNodeGen root, ArrayNodes.ReplaceNode replaceNode) {
                    super(root, 10);
                    this.replaceNode = replaceNode;
                }

                @Override
                public DynamicObject executeDynamicObject1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments1Value instanceof DynamicObject && arguments2Value instanceof NotProvided) {
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (RubyGuards.isRubyArray(arguments1Value_)) {
                            return this.root.initializeFromArray(arguments0Value, arguments1Value_, arguments2Value_, arguments3Value, this.replaceNode);
                        }
                    }
                    return this.getNext().executeDynamicObject1(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (RubyGuards.isRubyArray(arguments1Value_)) {
                            return this.root.initializeFromArray(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value, this.replaceNode);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root, ArrayNodes.ReplaceNode replaceNode) {
                    return new InitializeFromArrayNode_(root, replaceNode);
                }
            }

            @GeneratedBy(methodName="initializeBlock(VirtualFrame, DynamicObject, int, Object, DynamicObject, ArrayBuilderNode)", value=ArrayNodes.InitializeNode.class)
            private static final class InitializeBlockNode_
            extends BaseNode_ {
                @Node.Child
                private ArrayBuilderNode arrayBuilder;
                private final Class<?> arguments1ImplicitType;

                InitializeBlockNode_(InitializeNodeGen root, Object arguments1Value, ArrayBuilderNode arrayBuilder) {
                    super(root, 9);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                    this.arrayBuilder = arrayBuilder;
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((InitializeBlockNode_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    DynamicObject arguments3Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value, arguments3Value);
                    }
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    try {
                        arguments3Value_ = this.root.arguments3_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult());
                    }
                    if (arguments1Value_ >= 0) {
                        return this.root.initializeBlock(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_, this.arrayBuilder);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && arguments3Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        DynamicObject arguments3Value_ = (DynamicObject)arguments3Value;
                        if (arguments1Value_ >= 0) {
                            return this.root.initializeBlock(frameValue, arguments0Value_, arguments1Value_, arguments2Value, arguments3Value_, this.arrayBuilder);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root, Object arguments1Value, ArrayBuilderNode arrayBuilder) {
                    return new InitializeBlockNode_(root, arguments1Value, arrayBuilder);
                }
            }

            @GeneratedBy(methodName="initializeSizeOther(VirtualFrame, DynamicObject, Object, Object, NotProvided)", value=ArrayNodes.InitializeNode.class)
            private static final class InitializeSizeOtherNode_
            extends BaseNode_ {
                InitializeSizeOtherNode_(InitializeNodeGen root) {
                    super(root, 8);
                }

                @Override
                public DynamicObject executeDynamicObject1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments3Value instanceof NotProvided) {
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (RubyGuards.wasProvided(arguments1Value) && !RubyGuards.isInteger(arguments1Value) && !RubyGuards.isLong(arguments1Value) && RubyGuards.wasProvided(arguments2Value)) {
                            return this.root.initializeSizeOther(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value_);
                        }
                    }
                    return this.getNext().executeDynamicObject1(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (RubyGuards.wasProvided(arguments1Value) && !RubyGuards.isInteger(arguments1Value) && !RubyGuards.isLong(arguments1Value) && RubyGuards.wasProvided(arguments2Value)) {
                            return this.root.initializeSizeOther(frameValue, arguments0Value_, arguments1Value, arguments2Value, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new InitializeSizeOtherNode_(root);
                }
            }

            @GeneratedBy(methodName="initializeWithSizeAndValue(DynamicObject, int, Object, NotProvided, ArrayStrategy, ConditionProfile)", value=ArrayNodes.InitializeNode.class)
            private static final class InitializeWithSizeAndValueNode_
            extends BaseNode_ {
                private final ArrayStrategy strategy;
                private final ConditionProfile needsFill;
                private final Class<?> arguments1ImplicitType;

                InitializeWithSizeAndValueNode_(InitializeNodeGen root, Object arguments1Value, ArrayStrategy strategy, ConditionProfile needsFill) {
                    super(root, 7);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                    this.strategy = strategy;
                    this.needsFill = needsFill;
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((InitializeWithSizeAndValueNode_)other).arguments1ImplicitType;
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    int arguments1Value_;
                    return arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && arguments3Value instanceof NotProvided && (arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType)) >= 0 && RubyGuards.wasProvided(arguments2Value) && this.strategy.specializesFor(arguments2Value);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDynamicObject0(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public DynamicObject executeDynamicObject0(VirtualFrame frameValue) throws UnexpectedResultException {
                    NotProvided arguments3Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value));
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value, arguments3Value));
                    }
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    try {
                        arguments3Value_ = this.root.arguments3_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult()));
                    }
                    if (arguments1Value_ >= 0 && RubyGuards.wasProvided(arguments2Value_) && this.strategy.specializesFor(arguments2Value_)) {
                        return this.root.initializeWithSizeAndValue(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_, this.strategy, this.needsFill);
                    }
                    return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_));
                }

                @Override
                public DynamicObject executeDynamicObject1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && arguments3Value instanceof NotProvided) {
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (arguments1Value_ >= 0 && RubyGuards.wasProvided(arguments2Value) && this.strategy.specializesFor(arguments2Value)) {
                            return this.root.initializeWithSizeAndValue(arguments0Value, arguments1Value_, arguments2Value, arguments3Value_, this.strategy, this.needsFill);
                        }
                    }
                    return this.getNext().executeDynamicObject1(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (arguments1Value_ >= 0 && RubyGuards.wasProvided(arguments2Value) && this.strategy.specializesFor(arguments2Value)) {
                            return this.root.initializeWithSizeAndValue(arguments0Value_, arguments1Value_, arguments2Value, arguments3Value_, this.strategy, this.needsFill);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root, Object arguments1Value, ArrayStrategy strategy, ConditionProfile needsFill) {
                    return new InitializeWithSizeAndValueNode_(root, arguments1Value, strategy, needsFill);
                }
            }

            @GeneratedBy(methodName="initializeWithSizeNoValue(DynamicObject, int, NotProvided, NotProvided)", value=ArrayNodes.InitializeNode.class)
            private static final class InitializeWithSizeNoValueNode_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                InitializeWithSizeNoValueNode_(InitializeNodeGen root, Object arguments1Value) {
                    super(root, 6);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((InitializeWithSizeNoValueNode_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDynamicObject0(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public DynamicObject executeDynamicObject0(VirtualFrame frameValue) throws UnexpectedResultException {
                    NotProvided arguments3Value_;
                    NotProvided arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value));
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value, arguments3Value));
                    }
                    try {
                        arguments2Value_ = this.root.arguments2_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult(), arguments3Value));
                    }
                    try {
                        arguments3Value_ = this.root.arguments3_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult()));
                    }
                    if (arguments1Value_ >= 0) {
                        return this.root.initializeWithSizeNoValue(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_));
                }

                @Override
                public DynamicObject executeDynamicObject1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && arguments2Value instanceof NotProvided && arguments3Value instanceof NotProvided) {
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (arguments1Value_ >= 0) {
                            return this.root.initializeWithSizeNoValue(arguments0Value, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().executeDynamicObject1(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && arguments2Value instanceof NotProvided && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (arguments1Value_ >= 0) {
                            return this.root.initializeWithSizeNoValue(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root, Object arguments1Value) {
                    return new InitializeWithSizeNoValueNode_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="initializeSizeTooBig(DynamicObject, long, NotProvided, NotProvided)", value=ArrayNodes.InitializeNode.class)
            private static final class InitializeSizeTooBigNode_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                InitializeSizeTooBigNode_(InitializeNodeGen root, Object arguments1Value) {
                    super(root, 5);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((InitializeSizeTooBigNode_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDynamicObject0(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public DynamicObject executeDynamicObject0(VirtualFrame frameValue) throws UnexpectedResultException {
                    NotProvided arguments3Value_;
                    NotProvided arguments2Value_;
                    long arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value));
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value, arguments3Value));
                    }
                    try {
                        arguments2Value_ = this.root.arguments2_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult(), arguments3Value));
                    }
                    try {
                        arguments3Value_ = this.root.arguments3_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult()));
                    }
                    if (arguments1Value_ >= Integer.MAX_VALUE) {
                        return this.root.initializeSizeTooBig(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_));
                }

                @Override
                public DynamicObject executeDynamicObject1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType) && arguments2Value instanceof NotProvided && arguments3Value instanceof NotProvided) {
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (arguments1Value_ >= Integer.MAX_VALUE) {
                            return this.root.initializeSizeTooBig(arguments0Value, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().executeDynamicObject1(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType) && arguments2Value instanceof NotProvided && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (arguments1Value_ >= Integer.MAX_VALUE) {
                            return this.root.initializeSizeTooBig(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root, Object arguments1Value) {
                    return new InitializeSizeTooBigNode_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="initializeNegativeLongSize(DynamicObject, long, Object, Object)", value=ArrayNodes.InitializeNode.class)
            private static final class InitializeNegativeLongSizeNode_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                InitializeNegativeLongSizeNode_(InitializeNodeGen root, Object arguments1Value) {
                    super(root, 4);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((InitializeNegativeLongSizeNode_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDynamicObject0(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public DynamicObject executeDynamicObject0(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value));
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value, arguments3Value));
                    }
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    Object arguments3Value_ = this.root.arguments3_.execute(frameValue);
                    if (arguments1Value_ < 0L) {
                        return this.root.initializeNegativeLongSize(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_));
                }

                @Override
                public DynamicObject executeDynamicObject1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    long arguments1Value_;
                    if (RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType) && (arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType)) < 0L) {
                        return this.root.initializeNegativeLongSize(arguments0Value, arguments1Value_, arguments2Value, arguments3Value);
                    }
                    return this.getNext().executeDynamicObject1(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        if (arguments1Value_ < 0L) {
                            return this.root.initializeNegativeLongSize(arguments0Value_, arguments1Value_, arguments2Value, arguments3Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root, Object arguments1Value) {
                    return new InitializeNegativeLongSizeNode_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="initializeNegativeIntSize(DynamicObject, int, Object, Object)", value=ArrayNodes.InitializeNode.class)
            private static final class InitializeNegativeIntSizeNode_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                InitializeNegativeIntSizeNode_(InitializeNodeGen root, Object arguments1Value) {
                    super(root, 3);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((InitializeNegativeIntSizeNode_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDynamicObject0(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public DynamicObject executeDynamicObject0(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value));
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value, arguments3Value));
                    }
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    Object arguments3Value_ = this.root.arguments3_.execute(frameValue);
                    if (arguments1Value_ < 0) {
                        return this.root.initializeNegativeIntSize(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return InitializeNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_));
                }

                @Override
                public DynamicObject executeDynamicObject1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    int arguments1Value_;
                    if (RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && (arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType)) < 0) {
                        return this.root.initializeNegativeIntSize(arguments0Value, arguments1Value_, arguments2Value, arguments3Value);
                    }
                    return this.getNext().executeDynamicObject1(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        if (arguments1Value_ < 0) {
                            return this.root.initializeNegativeIntSize(arguments0Value_, arguments1Value_, arguments2Value, arguments3Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root, Object arguments1Value) {
                    return new InitializeNegativeIntSizeNode_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="initializeOnlyBlock(DynamicObject, NotProvided, NotProvided, DynamicObject)", value=ArrayNodes.InitializeNode.class)
            private static final class InitializeOnlyBlockNode_
            extends BaseNode_ {
                InitializeOnlyBlockNode_(InitializeNodeGen root) {
                    super(root, 2);
                }

                @Override
                public DynamicObject executeDynamicObject1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments1Value instanceof NotProvided && arguments2Value instanceof NotProvided && arguments3Value instanceof DynamicObject) {
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        DynamicObject arguments3Value_ = (DynamicObject)arguments3Value;
                        return this.root.initializeOnlyBlock(arguments0Value, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return this.getNext().executeDynamicObject1(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided && arguments2Value instanceof NotProvided && arguments3Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        DynamicObject arguments3Value_ = (DynamicObject)arguments3Value;
                        return this.root.initializeOnlyBlock(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new InitializeOnlyBlockNode_(root);
                }
            }

            @GeneratedBy(methodName="initializeNoArgs(DynamicObject, NotProvided, NotProvided, NotProvided)", value=ArrayNodes.InitializeNode.class)
            private static final class InitializeNoArgsNode_
            extends BaseNode_ {
                InitializeNoArgsNode_(InitializeNodeGen root) {
                    super(root, 1);
                }

                @Override
                public DynamicObject executeDynamicObject1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments1Value instanceof NotProvided && arguments2Value instanceof NotProvided && arguments3Value instanceof NotProvided) {
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        return this.root.initializeNoArgs(arguments0Value, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return this.getNext().executeDynamicObject1(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided && arguments2Value instanceof NotProvided && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        return this.root.initializeNoArgs(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new InitializeNoArgsNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.InitializeNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(InitializeNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.InitializeNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(InitializeNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.InitializeNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected InitializeNodeGen root;

                BaseNode_(InitializeNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (InitializeNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_, this.root.arguments3_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4, Object var5);

                public DynamicObject executeDynamicObject1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return (DynamicObject)this.execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    Object arguments3Value_ = this.root.arguments3_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public DynamicObject executeDynamicObject0(VirtualFrame frameValue) throws UnexpectedResultException {
                    return InitializeNodeGen.expectDynamicObject(this.execute(frameValue));
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        int arguments1Value_;
                        if (arguments1Value instanceof NotProvided && arguments2Value instanceof NotProvided) {
                            if (arguments3Value instanceof NotProvided) {
                                return InitializeNoArgsNode_.create(this.root);
                            }
                            if (arguments3Value instanceof DynamicObject) {
                                return InitializeOnlyBlockNode_.create(this.root);
                            }
                        }
                        if (RubyTypesGen.isImplicitInteger(arguments1Value) && (arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value)) < 0) {
                            return InitializeNegativeIntSizeNode_.create(this.root, arguments1Value);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value) && (arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value)) < 0L) {
                            return InitializeNegativeLongSizeNode_.create(this.root, arguments1Value);
                        }
                        if (arguments3Value instanceof NotProvided) {
                            if (arguments2Value instanceof NotProvided) {
                                if (RubyTypesGen.isImplicitLong(arguments1Value) && (arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value)) >= Integer.MAX_VALUE) {
                                    return InitializeSizeTooBigNode_.create(this.root, arguments1Value);
                                }
                                if (RubyTypesGen.isImplicitInteger(arguments1Value) && (arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value)) >= 0) {
                                    return InitializeWithSizeNoValueNode_.create(this.root, arguments1Value);
                                }
                            }
                            if (RubyTypesGen.isImplicitInteger(arguments1Value)) {
                                ConditionProfile needsFill7;
                                BaseNode_ s;
                                arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value);
                                ArrayStrategy strategy7 = ArrayStrategy.forValue(arguments2Value);
                                if (arguments1Value_ >= 0 && RubyGuards.wasProvided(arguments2Value) && strategy7.specializesFor(arguments2Value) && this.countSame(s = InitializeWithSizeAndValueNode_.create(this.root, arguments1Value, strategy7, needsFill7 = ConditionProfile.createBinaryProfile())) < 25) {
                                    return s;
                                }
                            }
                            if (RubyGuards.wasProvided(arguments1Value) && !RubyGuards.isInteger(arguments1Value) && !RubyGuards.isLong(arguments1Value) && RubyGuards.wasProvided(arguments2Value)) {
                                return InitializeSizeOtherNode_.create(this.root);
                            }
                        }
                        if (RubyTypesGen.isImplicitInteger(arguments1Value) && arguments3Value instanceof DynamicObject && (arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value)) >= 0) {
                            ArrayBuilderNode arrayBuilder9 = ArrayBuilderNode.create(this.root.getContext());
                            return InitializeBlockNode_.create(this.root, arguments1Value, arrayBuilder9);
                        }
                        if (arguments2Value instanceof NotProvided) {
                            if (arguments1Value instanceof DynamicObject && RubyGuards.isRubyArray(arguments1Value_ = (DynamicObject)arguments1Value)) {
                                ArrayNodes.ReplaceNode replaceNode10 = this.root.createReplaceNode();
                                return InitializeFromArrayNode_.create(this.root, replaceNode10);
                            }
                            if (arguments3Value instanceof NotProvided && !RubyGuards.isInteger(arguments1Value) && !RubyGuards.isLong(arguments1Value) && RubyGuards.wasProvided(arguments1Value) && !RubyGuards.isRubyArray(arguments1Value)) {
                                return InitializeNode_.create(this.root);
                            }
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }

                protected final long executeArguments1Long_(Frame frameValue, Class<?> arguments1ImplicitType) throws UnexpectedResultException {
                    if (arguments1ImplicitType == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1ImplicitType == Integer.TYPE) {
                        return RubyTypes.promoteToLong(this.root.arguments1_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return RubyTypesGen.expectImplicitLong(arguments1Value_, arguments1ImplicitType);
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.IncludeNode.class)
    public static final class IncludeNodeFactory
    extends NodeFactoryBase<ArrayNodes.IncludeNode> {
        private static IncludeNodeFactory includeNodeFactoryInstance;

        private IncludeNodeFactory() {
            super(ArrayNodes.IncludeNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.IncludeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return IncludeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.IncludeNode> getInstance() {
            if (includeNodeFactoryInstance == null) {
                includeNodeFactoryInstance = new IncludeNodeFactory();
            }
            return includeNodeFactoryInstance;
        }

        public static ArrayNodes.IncludeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new IncludeNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.IncludeNode.class)
        public static final class IncludeNodeGen
        extends ArrayNodes.IncludeNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private IncludeNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.specialization_.executeBoolean(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="include(VirtualFrame, DynamicObject, Object, ArrayStrategy)", value=ArrayNodes.IncludeNode.class)
            private static final class IncludeNode_
            extends BaseNode_ {
                private final ArrayStrategy strategy;

                IncludeNode_(IncludeNodeGen root, ArrayStrategy strategy) {
                    super(root, 2);
                    this.strategy = strategy;
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    return arguments0Value instanceof DynamicObject && this.strategy.matches(arguments0Value_ = (DynamicObject)arguments0Value);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.root.arguments1_.execute(frameValue);
                        return this.getNext().executeBoolean_(frameValue, ex.getResult(), arguments1Value);
                    }
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    if (this.strategy.matches(arguments0Value_)) {
                        return this.root.include(frameValue, arguments0Value_, arguments1Value_, this.strategy);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && this.strategy.matches(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.include(frameValue, arguments0Value_, arguments1Value, this.strategy);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(IncludeNodeGen root, ArrayStrategy strategy) {
                    return new IncludeNode_(root, strategy);
                }
            }

            @GeneratedBy(methodName="includeNull(VirtualFrame, DynamicObject, Object)", value=ArrayNodes.IncludeNode.class)
            private static final class IncludeNullNode_
            extends BaseNode_ {
                IncludeNullNode_(IncludeNodeGen root) {
                    super(root, 1);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.root.arguments1_.execute(frameValue);
                        return this.getNext().executeBoolean_(frameValue, ex.getResult(), arguments1Value);
                    }
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    if (ArrayGuards.isNullArray(arguments0Value_)) {
                        return this.root.includeNull(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && ArrayGuards.isNullArray(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.includeNull(frameValue, arguments0Value_, arguments1Value);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(IncludeNodeGen root) {
                    return new IncludeNullNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.IncludeNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(IncludeNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(IncludeNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.IncludeNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(IncludeNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (Boolean)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(IncludeNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.IncludeNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected IncludeNodeGen root;

                BaseNode_(IncludeNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (IncludeNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeBoolean_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract boolean executeBoolean_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) {
                    return (Boolean)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        BaseNode_ s;
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (ArrayGuards.isNullArray(arguments0Value_)) {
                            return IncludeNullNode_.create(this.root);
                        }
                        ArrayStrategy strategy2 = ArrayStrategy.of(arguments0Value_);
                        if (strategy2.matches(arguments0Value_) && this.countSame(s = IncludeNode_.create(this.root, strategy2)) < 25) {
                            return s;
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.FillNode.class)
    public static final class FillNodeFactory
    extends NodeFactoryBase<ArrayNodes.FillNode> {
        private static FillNodeFactory fillNodeFactoryInstance;

        private FillNodeFactory() {
            super(ArrayNodes.FillNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyNode[].class}});
        }

        public ArrayNodes.FillNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return FillNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.FillNode> getInstance() {
            if (fillNodeFactoryInstance == null) {
                fillNodeFactoryInstance = new FillNodeFactory();
            }
            return fillNodeFactoryInstance;
        }

        public static ArrayNodes.FillNode create(RubyNode[] arguments) {
            return new FillNodeGen(arguments);
        }

        @GeneratedBy(value=ArrayNodes.FillNode.class)
        @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
        public static final class FillNodeGen
        extends ArrayNodes.FillNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @Node.Child
            private BaseNode_ specialization_;

            private FillNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="fillFallback(VirtualFrame, DynamicObject, Object[], DynamicObject, CallDispatchHeadNode)", value=ArrayNodes.FillNode.class)
            private static final class FillFallback1Node_
            extends BaseNode_ {
                @Node.Child
                private CallDispatchHeadNode callFillInternal;

                FillFallback1Node_(FillNodeGen root, CallDispatchHeadNode callFillInternal) {
                    super(root, 3);
                    this.callFillInternal = callFillInternal;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Object[] && arguments2Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        DynamicObject arguments2Value_ = (DynamicObject)arguments2Value;
                        return this.root.fillFallback(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, this.callFillInternal);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(FillNodeGen root, CallDispatchHeadNode callFillInternal) {
                    return new FillFallback1Node_(root, callFillInternal);
                }
            }

            @GeneratedBy(methodName="fillFallback(VirtualFrame, DynamicObject, Object[], NotProvided, CallDispatchHeadNode)", value=ArrayNodes.FillNode.class)
            private static final class FillFallback0Node_
            extends BaseNode_ {
                @Node.Child
                private CallDispatchHeadNode callFillInternal;

                FillFallback0Node_(FillNodeGen root, CallDispatchHeadNode callFillInternal) {
                    super(root, 2);
                    this.callFillInternal = callFillInternal;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Object[] && arguments2Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        return this.root.fillFallback(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, this.callFillInternal);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(FillNodeGen root, CallDispatchHeadNode callFillInternal) {
                    return new FillFallback0Node_(root, callFillInternal);
                }
            }

            @GeneratedBy(methodName="fill(DynamicObject, Object[], NotProvided, ArrayStrategy)", value=ArrayNodes.FillNode.class)
            private static final class FillNode_
            extends BaseNode_ {
                private final ArrayStrategy strategy;

                FillNode_(FillNodeGen root, ArrayStrategy strategy) {
                    super(root, 1);
                    this.strategy = strategy;
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Object[] && arguments2Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        if (arguments1Value_.length == 1 && this.strategy.matches(arguments0Value_) && this.strategy.accepts(this.root.value(arguments1Value_))) {
                            return true;
                        }
                    }
                    return false;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Object[] && arguments2Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (arguments1Value_.length == 1 && this.strategy.matches(arguments0Value_) && this.strategy.accepts(this.root.value(arguments1Value_))) {
                            return this.root.fill(arguments0Value_, arguments1Value_, arguments2Value_, this.strategy);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(FillNodeGen root, ArrayStrategy strategy) {
                    return new FillNode_(root, strategy);
                }
            }

            @GeneratedBy(value=ArrayNodes.FillNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(FillNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(FillNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.FillNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(FillNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(FillNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.FillNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected FillNodeGen root;

                BaseNode_(FillNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (FillNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Object[]) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        if (arguments2Value instanceof NotProvided) {
                            BaseNode_ s;
                            ArrayStrategy strategy1 = ArrayStrategy.of(arguments0Value_, this.root.value(arguments1Value_));
                            if (arguments1Value_.length == 1 && strategy1.matches(arguments0Value_) && strategy1.accepts(this.root.value(arguments1Value_)) && this.countSame(s = FillNode_.create(this.root, strategy1)) < 25) {
                                return s;
                            }
                            CallDispatchHeadNode callFillInternal2 = CallDispatchHeadNode.createMethodCall();
                            return FillFallback0Node_.create(this.root, callFillInternal2);
                        }
                        if (arguments2Value instanceof DynamicObject) {
                            CallDispatchHeadNode callFillInternal3 = CallDispatchHeadNode.createMethodCall();
                            return FillFallback1Node_.create(this.root, callFillInternal3);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.EachWithIndexNode.class)
    public static final class EachWithIndexNodeFactory
    extends NodeFactoryBase<ArrayNodes.EachWithIndexNode> {
        private static EachWithIndexNodeFactory eachWithIndexNodeFactoryInstance;

        private EachWithIndexNodeFactory() {
            super(ArrayNodes.EachWithIndexNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyNode[].class}});
        }

        public ArrayNodes.EachWithIndexNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return EachWithIndexNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.EachWithIndexNode> getInstance() {
            if (eachWithIndexNodeFactoryInstance == null) {
                eachWithIndexNodeFactoryInstance = new EachWithIndexNodeFactory();
            }
            return eachWithIndexNodeFactoryInstance;
        }

        public static ArrayNodes.EachWithIndexNode create(RubyNode[] arguments) {
            return new EachWithIndexNodeGen(arguments);
        }

        @GeneratedBy(value=ArrayNodes.EachWithIndexNode.class)
        public static final class EachWithIndexNodeGen
        extends ArrayNodes.EachWithIndexNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private EachWithIndexNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="eachWithIndexOther(VirtualFrame, DynamicObject, DynamicObject, ArrayStrategy)", value=ArrayNodes.EachWithIndexNode.class)
            private static final class EachWithIndexOtherNode_
            extends BaseNode_ {
                private final ArrayStrategy strategy;

                EachWithIndexOtherNode_(EachWithIndexNodeGen root, ArrayStrategy strategy) {
                    super(root, 2);
                    this.strategy = strategy;
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    return arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && this.strategy.matches(arguments0Value_ = (DynamicObject)arguments0Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (this.strategy.matches(arguments0Value_)) {
                            return this.root.eachWithIndexOther(frameValue, arguments0Value_, arguments1Value_, this.strategy);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachWithIndexNodeGen root, ArrayStrategy strategy) {
                    return new EachWithIndexOtherNode_(root, strategy);
                }
            }

            @GeneratedBy(methodName="eachWithIndexNull(DynamicObject, DynamicObject)", value=ArrayNodes.EachWithIndexNode.class)
            private static final class EachWithIndexNullNode_
            extends BaseNode_ {
                EachWithIndexNullNode_(EachWithIndexNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isNullArray(arguments0Value_)) {
                            return this.root.eachWithIndexNull(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachWithIndexNodeGen root) {
                    return new EachWithIndexNullNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.EachWithIndexNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(EachWithIndexNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachWithIndexNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.EachWithIndexNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(EachWithIndexNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachWithIndexNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.EachWithIndexNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected EachWithIndexNodeGen root;

                BaseNode_(EachWithIndexNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (EachWithIndexNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        BaseNode_ s;
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (ArrayGuards.isNullArray(arguments0Value_)) {
                            return EachWithIndexNullNode_.create(this.root);
                        }
                        ArrayStrategy strategy2 = ArrayStrategy.of(arguments0Value_);
                        if (strategy2.matches(arguments0Value_) && this.countSame(s = EachWithIndexOtherNode_.create(this.root, strategy2)) < 25) {
                            return s;
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.EachNode.class)
    public static final class EachNodeFactory
    extends NodeFactoryBase<ArrayNodes.EachNode> {
        private static EachNodeFactory eachNodeFactoryInstance;

        private EachNodeFactory() {
            super(ArrayNodes.EachNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.EachNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EachNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.EachNode> getInstance() {
            if (eachNodeFactoryInstance == null) {
                eachNodeFactoryInstance = new EachNodeFactory();
            }
            return eachNodeFactoryInstance;
        }

        public static ArrayNodes.EachNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new EachNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.EachNode.class)
        public static final class EachNodeGen
        extends ArrayNodes.EachNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private EachNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="eachOther(VirtualFrame, DynamicObject, DynamicObject, ArrayStrategy)", value=ArrayNodes.EachNode.class)
            private static final class EachOtherNode_
            extends BaseNode_ {
                private final ArrayStrategy strategy;

                EachOtherNode_(EachNodeGen root, ArrayStrategy strategy) {
                    super(root, 2);
                    this.strategy = strategy;
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    return arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && this.strategy.matches(arguments0Value_ = (DynamicObject)arguments0Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (this.strategy.matches(arguments0Value_)) {
                            return this.root.eachOther(frameValue, arguments0Value_, arguments1Value_, this.strategy);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachNodeGen root, ArrayStrategy strategy) {
                    return new EachOtherNode_(root, strategy);
                }
            }

            @GeneratedBy(methodName="eachNull(VirtualFrame, DynamicObject, DynamicObject)", value=ArrayNodes.EachNode.class)
            private static final class EachNullNode_
            extends BaseNode_ {
                EachNullNode_(EachNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (ArrayGuards.isNullArray(arguments0Value_)) {
                            return this.root.eachNull(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachNodeGen root) {
                    return new EachNullNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.EachNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(EachNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.EachNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(EachNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.EachNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected EachNodeGen root;

                BaseNode_(EachNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (EachNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        BaseNode_ s;
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (ArrayGuards.isNullArray(arguments0Value_)) {
                            return EachNullNode_.create(this.root);
                        }
                        ArrayStrategy strategy2 = ArrayStrategy.of(arguments0Value_);
                        if (strategy2.matches(arguments0Value_) && this.countSame(s = EachOtherNode_.create(this.root, strategy2)) < 25) {
                            return s;
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.DeleteAtNode.class)
    public static final class DeleteAtNodeFactory
    extends NodeFactoryBase<ArrayNodes.DeleteAtNode> {
        private static DeleteAtNodeFactory deleteAtNodeFactoryInstance;

        private DeleteAtNodeFactory() {
            super(ArrayNodes.DeleteAtNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyNode.class, RubyNode.class}});
        }

        public ArrayNodes.DeleteAtNode createNode(Object ... arguments) {
            if (arguments.length == 2 && (arguments[0] == null || arguments[0] instanceof RubyNode) && (arguments[1] == null || arguments[1] instanceof RubyNode)) {
                return DeleteAtNodeFactory.create((RubyNode)((Object)arguments[0]), (RubyNode)((Object)arguments[1]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.DeleteAtNode> getInstance() {
            if (deleteAtNodeFactoryInstance == null) {
                deleteAtNodeFactoryInstance = new DeleteAtNodeFactory();
            }
            return deleteAtNodeFactoryInstance;
        }

        public static ArrayNodes.DeleteAtNode create(RubyNode array, RubyNode index) {
            return new DeleteAtNodeGen(array, index);
        }

        @GeneratedBy(value=ArrayNodes.DeleteAtNode.class)
        public static final class DeleteAtNodeGen
        extends ArrayNodes.DeleteAtNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode array_;
            @Node.Child
            private RubyNode index_;
            @CompilerDirectives.CompilationFinal
            private Class<?> indexType_;
            @Node.Child
            private BaseNode_ specialization_;

            private DeleteAtNodeGen(RubyNode array, RubyNode index) {
                this.array_ = array;
                this.index_ = this.coerceOtherToInt(index);
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="deleteAt(DynamicObject, int, ArrayStrategy, ConditionProfile, BranchProfile)", value=ArrayNodes.DeleteAtNode.class)
            private static final class DeleteAtNode_
            extends BaseNode_ {
                private final ArrayStrategy strategy;
                private final ConditionProfile negativeIndexProfile;
                private final BranchProfile notInBoundsProfile;
                private final Class<?> indexImplicitType;

                DeleteAtNode_(DeleteAtNodeGen root, Object indexValue, ArrayStrategy strategy, ConditionProfile negativeIndexProfile, BranchProfile notInBoundsProfile) {
                    super(root, 2);
                    this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
                    this.strategy = strategy;
                    this.negativeIndexProfile = negativeIndexProfile;
                    this.notInBoundsProfile = notInBoundsProfile;
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.indexImplicitType == ((DeleteAtNode_)other).indexImplicitType;
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arrayValue, Object indexValue) {
                    DynamicObject arrayValue_;
                    return arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && this.strategy.matches(arrayValue_ = (DynamicObject)arrayValue);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int indexValue_;
                    DynamicObject arrayValue_;
                    try {
                        arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object indexValue = this.executeIndex_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), indexValue);
                    }
                    try {
                        if (this.indexImplicitType == Integer.TYPE) {
                            indexValue_ = this.root.index_.executeInteger(frameValue);
                        } else {
                            Object indexValue__ = this.executeIndex_((Frame)frameValue);
                            indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arrayValue_, ex.getResult());
                    }
                    if (this.strategy.matches(arrayValue_)) {
                        return this.root.deleteAt(arrayValue_, indexValue_, this.strategy, this.negativeIndexProfile, this.notInBoundsProfile);
                    }
                    return this.getNext().execute_(frameValue, arrayValue_, indexValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
                    if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType)) {
                        DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                        int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                        if (this.strategy.matches(arrayValue_)) {
                            return this.root.deleteAt(arrayValue_, indexValue_, this.strategy, this.negativeIndexProfile, this.notInBoundsProfile);
                        }
                    }
                    return this.getNext().execute_(frameValue, arrayValue, indexValue);
                }

                static BaseNode_ create(DeleteAtNodeGen root, Object indexValue, ArrayStrategy strategy, ConditionProfile negativeIndexProfile, BranchProfile notInBoundsProfile) {
                    return new DeleteAtNode_(root, indexValue, strategy, negativeIndexProfile, notInBoundsProfile);
                }
            }

            @GeneratedBy(methodName="deleteAtNullOrEmpty(DynamicObject, int)", value=ArrayNodes.DeleteAtNode.class)
            private static final class DeleteAtNullOrEmptyNode_
            extends BaseNode_ {
                private final Class<?> indexImplicitType;

                DeleteAtNullOrEmptyNode_(DeleteAtNodeGen root, Object indexValue) {
                    super(root, 1);
                    this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.indexImplicitType == ((DeleteAtNullOrEmptyNode_)other).indexImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int indexValue_;
                    DynamicObject arrayValue_;
                    try {
                        arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object indexValue = this.executeIndex_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), indexValue);
                    }
                    try {
                        if (this.indexImplicitType == Integer.TYPE) {
                            indexValue_ = this.root.index_.executeInteger(frameValue);
                        } else {
                            Object indexValue__ = this.executeIndex_((Frame)frameValue);
                            indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arrayValue_, ex.getResult());
                    }
                    if (ArrayGuards.isEmptyArray(arrayValue_)) {
                        return this.root.deleteAtNullOrEmpty(arrayValue_, indexValue_);
                    }
                    return this.getNext().execute_(frameValue, arrayValue_, indexValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
                    if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType)) {
                        DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                        int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                        if (ArrayGuards.isEmptyArray(arrayValue_)) {
                            return this.root.deleteAtNullOrEmpty(arrayValue_, indexValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arrayValue, indexValue);
                }

                static BaseNode_ create(DeleteAtNodeGen root, Object indexValue) {
                    return new DeleteAtNullOrEmptyNode_(root, indexValue);
                }
            }

            @GeneratedBy(value=ArrayNodes.DeleteAtNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(DeleteAtNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arrayValue, Object indexValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arrayValue, indexValue));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
                    return this.getNext().execute_(frameValue, arrayValue, indexValue);
                }

                static BaseNode_ create(DeleteAtNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.DeleteAtNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(DeleteAtNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
                    return this.uninitialized((Frame)frameValue, arrayValue, indexValue);
                }

                static BaseNode_ create(DeleteAtNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.DeleteAtNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected DeleteAtNodeGen root;

                BaseNode_(DeleteAtNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (DeleteAtNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.array_, this.root.index_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arrayValue, Object indexValue) {
                    return this.execute_((VirtualFrame)frameValue, arrayValue, indexValue);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arrayValue_ = this.root.array_.execute(frameValue);
                    Object indexValue_ = this.executeIndex_((Frame)frameValue);
                    return this.execute_(frameValue, arrayValue_, indexValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arrayValue, Object indexValue) {
                    if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue)) {
                        BranchProfile notInBoundsProfile2;
                        ConditionProfile negativeIndexProfile2;
                        BaseNode_ s;
                        DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                        if (ArrayGuards.isEmptyArray(arrayValue_)) {
                            return DeleteAtNullOrEmptyNode_.create(this.root, indexValue);
                        }
                        ArrayStrategy strategy2 = ArrayStrategy.of(arrayValue_);
                        if (strategy2.matches(arrayValue_) && this.countSame(s = DeleteAtNode_.create(this.root, indexValue, strategy2, negativeIndexProfile2 = ConditionProfile.createBinaryProfile(), notInBoundsProfile2 = BranchProfile.create())) < 25) {
                            return s;
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeIndex_(Frame frameValue) {
                    Object object;
                    Class indexType_ = this.root.indexType_;
                    if (indexType_ == Integer.TYPE) {
                        return this.root.index_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (indexType_ != null) return this.root.index_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.index_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.indexType_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.indexType_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.indexType_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.DeleteNode.class)
    public static final class DeleteNodeFactory
    extends NodeFactoryBase<ArrayNodes.DeleteNode> {
        private static DeleteNodeFactory deleteNodeFactoryInstance;

        private DeleteNodeFactory() {
            super(ArrayNodes.DeleteNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.DeleteNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DeleteNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.DeleteNode> getInstance() {
            if (deleteNodeFactoryInstance == null) {
                deleteNodeFactoryInstance = new DeleteNodeFactory();
            }
            return deleteNodeFactoryInstance;
        }

        public static ArrayNodes.DeleteNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new DeleteNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.DeleteNode.class)
        public static final class DeleteNodeGen
        extends ArrayNodes.DeleteNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private DeleteNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="delete(VirtualFrame, DynamicObject, Object, ArrayStrategy)", value=ArrayNodes.DeleteNode.class)
            private static final class DeleteNode_
            extends BaseNode_ {
                private final ArrayStrategy strategy;

                DeleteNode_(DeleteNodeGen root, ArrayStrategy strategy) {
                    super(root, 2);
                    this.strategy = strategy;
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    return arguments0Value instanceof DynamicObject && this.strategy.matches(arguments0Value_ = (DynamicObject)arguments0Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && this.strategy.matches(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.delete(frameValue, arguments0Value_, arguments1Value, this.strategy);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DeleteNodeGen root, ArrayStrategy strategy) {
                    return new DeleteNode_(root, strategy);
                }
            }

            @GeneratedBy(methodName="deleteNull(VirtualFrame, DynamicObject, Object)", value=ArrayNodes.DeleteNode.class)
            private static final class DeleteNullNode_
            extends BaseNode_ {
                DeleteNullNode_(DeleteNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && ArrayGuards.isNullArray(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.deleteNull(frameValue, arguments0Value_, arguments1Value);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DeleteNodeGen root) {
                    return new DeleteNullNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.DeleteNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(DeleteNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DeleteNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.DeleteNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(DeleteNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DeleteNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.DeleteNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected DeleteNodeGen root;

                BaseNode_(DeleteNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (DeleteNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        BaseNode_ s;
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (ArrayGuards.isNullArray(arguments0Value_)) {
                            return DeleteNullNode_.create(this.root);
                        }
                        ArrayStrategy strategy2 = ArrayStrategy.of(arguments0Value_);
                        if (strategy2.matches(arguments0Value_) && this.countSame(s = DeleteNode_.create(this.root, strategy2)) < 25) {
                            return s;
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.ConcatNode.class)
    public static final class ConcatNodeFactory
    extends NodeFactoryBase<ArrayNodes.ConcatNode> {
        private static ConcatNodeFactory concatNodeFactoryInstance;

        private ConcatNodeFactory() {
            super(ArrayNodes.ConcatNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public ArrayNodes.ConcatNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return ConcatNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.ConcatNode> getInstance() {
            if (concatNodeFactoryInstance == null) {
                concatNodeFactoryInstance = new ConcatNodeFactory();
            }
            return concatNodeFactoryInstance;
        }

        public static ArrayNodes.ConcatNode create(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode other) {
            return new ConcatNodeGen(context, sourceSection, array, other);
        }

        @GeneratedBy(value=ArrayNodes.ConcatNode.class)
        public static final class ConcatNodeGen
        extends ArrayNodes.ConcatNode {
            @Node.Child
            private RubyNode array_;
            @Node.Child
            private RubyNode other_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ConcatNodeGen(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode other) {
                super(context, sourceSection);
                this.array_ = array;
                this.other_ = this.coerceOtherToAry(other);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject otherValue_;
                DynamicObject arrayValue_;
                try {
                    arrayValue_ = this.array_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object otherValue = this.other_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), otherValue);
                }
                try {
                    otherValue_ = this.other_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arrayValue_, ex.getResult());
                }
                return this.concat(arrayValue_, otherValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arrayValue, Object otherValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.array_, this.other_}, new Object[]{arrayValue, otherValue});
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.CompactBangNode.class)
    public static final class CompactBangNodeFactory
    extends NodeFactoryBase<ArrayNodes.CompactBangNode> {
        private static CompactBangNodeFactory compactBangNodeFactoryInstance;

        private CompactBangNodeFactory() {
            super(ArrayNodes.CompactBangNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyNode[].class}});
        }

        public ArrayNodes.CompactBangNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return CompactBangNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.CompactBangNode> getInstance() {
            if (compactBangNodeFactoryInstance == null) {
                compactBangNodeFactoryInstance = new CompactBangNodeFactory();
            }
            return compactBangNodeFactoryInstance;
        }

        public static ArrayNodes.CompactBangNode create(RubyNode[] arguments) {
            return new CompactBangNodeGen(arguments);
        }

        @GeneratedBy(value=ArrayNodes.CompactBangNode.class)
        public static final class CompactBangNodeGen
        extends ArrayNodes.CompactBangNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private CompactBangNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="compactObjects(DynamicObject)", value=ArrayNodes.CompactBangNode.class)
            private static final class CompactObjectsNode_
            extends BaseNode_ {
                CompactObjectsNode_(CompactBangNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && ArrayGuards.isObjectArray(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.compactObjects(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CompactBangNodeGen root) {
                    return new CompactObjectsNode_(root);
                }
            }

            @GeneratedBy(methodName="compactNotObjects(DynamicObject)", value=ArrayNodes.CompactBangNode.class)
            private static final class CompactNotObjectsNode_
            extends BaseNode_ {
                CompactNotObjectsNode_(CompactBangNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && !ArrayGuards.isObjectArray(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.compactNotObjects(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CompactBangNodeGen root) {
                    return new CompactNotObjectsNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.CompactBangNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(CompactBangNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CompactBangNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.CompactBangNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(CompactBangNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(CompactBangNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.CompactBangNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected CompactBangNodeGen root;

                BaseNode_(CompactBangNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (CompactBangNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (!ArrayGuards.isObjectArray(arguments0Value_)) {
                            return CompactNotObjectsNode_.create(this.root);
                        }
                        return CompactObjectsNode_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.CompactNode.class)
    public static final class CompactNodeFactory
    extends NodeFactoryBase<ArrayNodes.CompactNode> {
        private static CompactNodeFactory compactNodeFactoryInstance;

        private CompactNodeFactory() {
            super(ArrayNodes.CompactNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyNode[].class}});
        }

        public ArrayNodes.CompactNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return CompactNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.CompactNode> getInstance() {
            if (compactNodeFactoryInstance == null) {
                compactNodeFactoryInstance = new CompactNodeFactory();
            }
            return compactNodeFactoryInstance;
        }

        public static ArrayNodes.CompactNode create(RubyNode[] arguments) {
            return new CompactNodeGen(arguments);
        }

        @GeneratedBy(value=ArrayNodes.CompactNode.class)
        public static final class CompactNodeGen
        extends ArrayNodes.CompactNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private CompactNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="compactObjects(DynamicObject)", value=ArrayNodes.CompactNode.class)
            private static final class CompactObjectsNode_
            extends BaseNode_ {
                CompactObjectsNode_(CompactNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && ArrayGuards.isObjectArray(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.compactObjects(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CompactNodeGen root) {
                    return new CompactObjectsNode_(root);
                }
            }

            @GeneratedBy(methodName="compactPrimitive(DynamicObject, ArrayStrategy)", value=ArrayNodes.CompactNode.class)
            private static final class CompactPrimitiveNode_
            extends BaseNode_ {
                private final ArrayStrategy strategy;

                CompactPrimitiveNode_(CompactNodeGen root, ArrayStrategy strategy) {
                    super(root, 2);
                    this.strategy = strategy;
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    return arguments0Value instanceof DynamicObject && !ArrayGuards.isObjectArray(arguments0Value_ = (DynamicObject)arguments0Value) && this.strategy.matches(arguments0Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && !ArrayGuards.isObjectArray(arguments0Value_ = (DynamicObject)arguments0Value) && this.strategy.matches(arguments0Value_)) {
                        return this.root.compactPrimitive(arguments0Value_, this.strategy);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CompactNodeGen root, ArrayStrategy strategy) {
                    return new CompactPrimitiveNode_(root, strategy);
                }
            }

            @GeneratedBy(methodName="compactNull(DynamicObject)", value=ArrayNodes.CompactNode.class)
            private static final class CompactNullNode_
            extends BaseNode_ {
                CompactNullNode_(CompactNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && ArrayGuards.isNullArray(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.compactNull(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CompactNodeGen root) {
                    return new CompactNullNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.CompactNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(CompactNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CompactNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.CompactNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(CompactNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(CompactNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.CompactNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected CompactNodeGen root;

                BaseNode_(CompactNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (CompactNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        BaseNode_ s;
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (ArrayGuards.isNullArray(arguments0Value_)) {
                            return CompactNullNode_.create(this.root);
                        }
                        ArrayStrategy strategy2 = ArrayStrategy.of(arguments0Value_);
                        if (!ArrayGuards.isObjectArray(arguments0Value_) && strategy2.matches(arguments0Value_) && this.countSame(s = CompactPrimitiveNode_.create(this.root, strategy2)) < 25) {
                            return s;
                        }
                        if (ArrayGuards.isObjectArray(arguments0Value_)) {
                            return CompactObjectsNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.ClearNode.class)
    public static final class ClearNodeFactory
    extends NodeFactoryBase<ArrayNodes.ClearNode> {
        private static ClearNodeFactory clearNodeFactoryInstance;

        private ClearNodeFactory() {
            super(ArrayNodes.ClearNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyNode[].class}});
        }

        public ArrayNodes.ClearNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ClearNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.ClearNode> getInstance() {
            if (clearNodeFactoryInstance == null) {
                clearNodeFactoryInstance = new ClearNodeFactory();
            }
            return clearNodeFactoryInstance;
        }

        public static ArrayNodes.ClearNode create(RubyNode[] arguments) {
            return new ClearNodeGen(arguments);
        }

        @GeneratedBy(value=ArrayNodes.ClearNode.class)
        public static final class ClearNodeGen
        extends ArrayNodes.ClearNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ClearNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                if (RubyGuards.isRubyArray(arguments0Value_)) {
                    return this.clear(arguments0Value_);
                }
                throw this.unsupported(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.AtNode.class)
    public static final class AtNodeFactory
    extends NodeFactoryBase<ArrayNodes.AtNode> {
        private static AtNodeFactory atNodeFactoryInstance;

        private AtNodeFactory() {
            super(ArrayNodes.AtNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyNode.class, RubyNode.class}});
        }

        public ArrayNodes.AtNode createNode(Object ... arguments) {
            if (arguments.length == 2 && (arguments[0] == null || arguments[0] instanceof RubyNode) && (arguments[1] == null || arguments[1] instanceof RubyNode)) {
                return AtNodeFactory.create((RubyNode)((Object)arguments[0]), (RubyNode)((Object)arguments[1]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.AtNode> getInstance() {
            if (atNodeFactoryInstance == null) {
                atNodeFactoryInstance = new AtNodeFactory();
            }
            return atNodeFactoryInstance;
        }

        public static ArrayNodes.AtNode create(RubyNode array, RubyNode index) {
            return new AtNodeGen(array, index);
        }

        @GeneratedBy(value=ArrayNodes.AtNode.class)
        public static final class AtNodeGen
        extends ArrayNodes.AtNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode array_;
            @Node.Child
            private RubyNode index_;
            @CompilerDirectives.CompilationFinal
            private Class<?> indexType_;
            @Node.Child
            private BaseNode_ specialization_;

            private AtNodeGen(RubyNode array, RubyNode index) {
                this.array_ = array;
                this.index_ = this.coerceOtherToInt(index);
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="at(DynamicObject, int)", value=ArrayNodes.AtNode.class)
            private static final class AtNode_
            extends BaseNode_ {
                private final Class<?> indexImplicitType;

                AtNode_(AtNodeGen root, Object indexValue) {
                    super(root, 1);
                    this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.indexImplicitType == ((AtNode_)other).indexImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int indexValue_;
                    DynamicObject arrayValue_;
                    try {
                        arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object indexValue = this.executeIndex_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), indexValue);
                    }
                    try {
                        if (this.indexImplicitType == Integer.TYPE) {
                            indexValue_ = this.root.index_.executeInteger(frameValue);
                        } else {
                            Object indexValue__ = this.executeIndex_((Frame)frameValue);
                            indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arrayValue_, ex.getResult());
                    }
                    return this.root.at(arrayValue_, indexValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
                    if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType)) {
                        DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                        int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                        return this.root.at(arrayValue_, indexValue_);
                    }
                    return this.getNext().execute_(frameValue, arrayValue, indexValue);
                }

                static BaseNode_ create(AtNodeGen root, Object indexValue) {
                    return new AtNode_(root, indexValue);
                }
            }

            @GeneratedBy(value=ArrayNodes.AtNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(AtNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arrayValue, Object indexValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arrayValue, indexValue));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
                    return this.getNext().execute_(frameValue, arrayValue, indexValue);
                }

                static BaseNode_ create(AtNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.AtNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(AtNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
                    return this.uninitialized((Frame)frameValue, arrayValue, indexValue);
                }

                static BaseNode_ create(AtNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.AtNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected AtNodeGen root;

                BaseNode_(AtNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (AtNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.array_, this.root.index_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arrayValue, Object indexValue) {
                    return this.execute_((VirtualFrame)frameValue, arrayValue, indexValue);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arrayValue_ = this.root.array_.execute(frameValue);
                    Object indexValue_ = this.executeIndex_((Frame)frameValue);
                    return this.execute_(frameValue, arrayValue_, indexValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arrayValue, Object indexValue) {
                    if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue)) {
                        return AtNode_.create(this.root, indexValue);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeIndex_(Frame frameValue) {
                    Object object;
                    Class indexType_ = this.root.indexType_;
                    if (indexType_ == Integer.TYPE) {
                        return this.root.index_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (indexType_ != null) return this.root.index_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.index_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.indexType_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.indexType_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.indexType_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.IndexSetNode.class)
    public static final class IndexSetNodeFactory
    extends NodeFactoryBase<ArrayNodes.IndexSetNode> {
        private static IndexSetNodeFactory indexSetNodeFactoryInstance;

        private IndexSetNodeFactory() {
            super(ArrayNodes.IndexSetNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyNode[].class}});
        }

        public ArrayNodes.IndexSetNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return IndexSetNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.IndexSetNode> getInstance() {
            if (indexSetNodeFactoryInstance == null) {
                indexSetNodeFactoryInstance = new IndexSetNodeFactory();
            }
            return indexSetNodeFactoryInstance;
        }

        public static ArrayNodes.IndexSetNode create(RubyNode[] arguments) {
            return new IndexSetNodeGen(arguments);
        }

        @GeneratedBy(value=ArrayNodes.IndexSetNode.class)
        @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
        public static final class IndexSetNodeGen
        extends ArrayNodes.IndexSetNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @Node.Child
            private RubyNode arguments3_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private IndexSetNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.arguments3_ = arguments != null && 3 < arguments.length ? arguments[3] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object executeSet(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                return this.specialization_.execute1(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute0(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="setRange(VirtualFrame, DynamicObject, DynamicObject, Object, NotProvided, ConditionProfile, ConditionProfile)", value=ArrayNodes.IndexSetNode.class)
            private static final class SetRangeNode_
            extends BaseNode_ {
                private final ConditionProfile negativeBeginProfile;
                private final ConditionProfile negativeEndProfile;

                SetRangeNode_(IndexSetNodeGen root, ConditionProfile negativeBeginProfile, ConditionProfile negativeEndProfile) {
                    super(root, 7);
                    this.negativeBeginProfile = negativeBeginProfile;
                    this.negativeEndProfile = negativeEndProfile;
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments1Value instanceof DynamicObject && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (RubyGuards.isIntegerFixnumRange(arguments1Value_)) {
                            return this.root.setRange(frameValue, arguments0Value, arguments1Value_, arguments2Value, arguments3Value_, this.negativeBeginProfile, this.negativeEndProfile);
                        }
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (RubyGuards.isIntegerFixnumRange(arguments1Value_)) {
                            return this.root.setRange(frameValue, arguments0Value_, arguments1Value_, arguments2Value, arguments3Value_, this.negativeBeginProfile, this.negativeEndProfile);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(IndexSetNodeGen root, ConditionProfile negativeBeginProfile, ConditionProfile negativeEndProfile) {
                    return new SetRangeNode_(root, negativeBeginProfile, negativeEndProfile);
                }
            }

            @GeneratedBy(methodName="setStartLengthNotInt(VirtualFrame, DynamicObject, Object, Object, Object, ConditionProfile)", value=ArrayNodes.IndexSetNode.class)
            private static final class SetStartLengthNotIntNode_
            extends BaseNode_ {
                private final ConditionProfile negativeIndexProfile;

                SetStartLengthNotIntNode_(IndexSetNodeGen root, ConditionProfile negativeIndexProfile) {
                    super(root, 6);
                    this.negativeIndexProfile = negativeIndexProfile;
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (!(RubyGuards.isInteger(arguments1Value) && RubyGuards.isInteger(arguments2Value) || !RubyGuards.wasProvided(arguments3Value))) {
                        return this.root.setStartLengthNotInt(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, this.negativeIndexProfile);
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (!(RubyGuards.isInteger(arguments1Value) && RubyGuards.isInteger(arguments2Value) || !RubyGuards.wasProvided(arguments3Value))) {
                            return this.root.setStartLengthNotInt(frameValue, arguments0Value_, arguments1Value, arguments2Value, arguments3Value, this.negativeIndexProfile);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(IndexSetNodeGen root, ConditionProfile negativeIndexProfile) {
                    return new SetStartLengthNotIntNode_(root, negativeIndexProfile);
                }
            }

            @GeneratedBy(methodName="setOtherArray(VirtualFrame, DynamicObject, int, int, DynamicObject, ConditionProfile, ConditionProfile, ConditionProfile)", value=ArrayNodes.IndexSetNode.class)
            private static final class SetOtherArrayNode_
            extends BaseNode_ {
                private final ConditionProfile negativeIndexProfile;
                private final ConditionProfile needCopy;
                private final ConditionProfile recursive;
                private final Class<?> arguments1ImplicitType;
                private final Class<?> arguments2ImplicitType;

                SetOtherArrayNode_(IndexSetNodeGen root, Object arguments1Value, Object arguments2Value, ConditionProfile negativeIndexProfile, ConditionProfile needCopy, ConditionProfile recursive) {
                    super(root, 5);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                    this.arguments2ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments2Value);
                    this.negativeIndexProfile = negativeIndexProfile;
                    this.needCopy = needCopy;
                    this.recursive = recursive;
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((SetOtherArrayNode_)other).arguments1ImplicitType && this.arguments2ImplicitType == ((SetOtherArrayNode_)other).arguments2ImplicitType;
                }

                @Override
                public Object execute0(VirtualFrame frameValue) {
                    DynamicObject arguments3Value_;
                    int arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value, arguments3Value);
                    }
                    try {
                        if (this.arguments2ImplicitType == Integer.TYPE) {
                            arguments2Value_ = this.root.arguments2_.executeInteger(frameValue);
                        } else {
                            Object arguments2Value__ = this.executeArguments2_((Frame)frameValue);
                            arguments2Value_ = RubyTypesGen.expectImplicitInteger(arguments2Value__, this.arguments2ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult(), arguments3Value);
                    }
                    try {
                        arguments3Value_ = this.root.arguments3_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyArray(arguments3Value_) && arguments2Value_ != this.root.getArraySize(arguments3Value_)) {
                        return this.root.setOtherArray(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_, this.negativeIndexProfile, this.needCopy, this.recursive);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && RubyTypesGen.isImplicitInteger(arguments2Value, this.arguments2ImplicitType) && arguments3Value instanceof DynamicObject) {
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        int arguments2Value_ = RubyTypesGen.asImplicitInteger(arguments2Value, this.arguments2ImplicitType);
                        DynamicObject arguments3Value_ = (DynamicObject)arguments3Value;
                        if (RubyGuards.isRubyArray(arguments3Value_) && arguments2Value_ != this.root.getArraySize(arguments3Value_)) {
                            return this.root.setOtherArray(frameValue, arguments0Value, arguments1Value_, arguments2Value_, arguments3Value_, this.negativeIndexProfile, this.needCopy, this.recursive);
                        }
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && RubyTypesGen.isImplicitInteger(arguments2Value, this.arguments2ImplicitType) && arguments3Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        int arguments2Value_ = RubyTypesGen.asImplicitInteger(arguments2Value, this.arguments2ImplicitType);
                        DynamicObject arguments3Value_ = (DynamicObject)arguments3Value;
                        if (RubyGuards.isRubyArray(arguments3Value_) && arguments2Value_ != this.root.getArraySize(arguments3Value_)) {
                            return this.root.setOtherArray(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_, this.negativeIndexProfile, this.needCopy, this.recursive);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(IndexSetNodeGen root, Object arguments1Value, Object arguments2Value, ConditionProfile negativeIndexProfile, ConditionProfile needCopy, ConditionProfile recursive) {
                    return new SetOtherArrayNode_(root, arguments1Value, arguments2Value, negativeIndexProfile, needCopy, recursive);
                }
            }

            @GeneratedBy(methodName="setOtherIntArraySameLength(DynamicObject, int, int, DynamicObject, ConditionProfile)", value=ArrayNodes.IndexSetNode.class)
            private static final class SetOtherIntArraySameLengthNode_
            extends BaseNode_ {
                private final ConditionProfile negativeIndexProfile;
                private final Class<?> arguments1ImplicitType;
                private final Class<?> arguments2ImplicitType;

                SetOtherIntArraySameLengthNode_(IndexSetNodeGen root, Object arguments1Value, Object arguments2Value, ConditionProfile negativeIndexProfile) {
                    super(root, 4);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                    this.arguments2ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments2Value);
                    this.negativeIndexProfile = negativeIndexProfile;
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((SetOtherIntArraySameLengthNode_)other).arguments1ImplicitType && this.arguments2ImplicitType == ((SetOtherIntArraySameLengthNode_)other).arguments2ImplicitType;
                }

                @Override
                public Object execute0(VirtualFrame frameValue) {
                    DynamicObject arguments3Value_;
                    int arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value, arguments3Value);
                    }
                    try {
                        if (this.arguments2ImplicitType == Integer.TYPE) {
                            arguments2Value_ = this.root.arguments2_.executeInteger(frameValue);
                        } else {
                            Object arguments2Value__ = this.executeArguments2_((Frame)frameValue);
                            arguments2Value_ = RubyTypesGen.expectImplicitInteger(arguments2Value__, this.arguments2ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult(), arguments3Value);
                    }
                    try {
                        arguments3Value_ = this.root.arguments3_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyArray(arguments3Value_) && arguments2Value_ == this.root.getArraySize(arguments3Value_)) {
                        return this.root.setOtherIntArraySameLength(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_, this.negativeIndexProfile);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && RubyTypesGen.isImplicitInteger(arguments2Value, this.arguments2ImplicitType) && arguments3Value instanceof DynamicObject) {
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        int arguments2Value_ = RubyTypesGen.asImplicitInteger(arguments2Value, this.arguments2ImplicitType);
                        DynamicObject arguments3Value_ = (DynamicObject)arguments3Value;
                        if (RubyGuards.isRubyArray(arguments3Value_) && arguments2Value_ == this.root.getArraySize(arguments3Value_)) {
                            return this.root.setOtherIntArraySameLength(arguments0Value, arguments1Value_, arguments2Value_, arguments3Value_, this.negativeIndexProfile);
                        }
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && RubyTypesGen.isImplicitInteger(arguments2Value, this.arguments2ImplicitType) && arguments3Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        int arguments2Value_ = RubyTypesGen.asImplicitInteger(arguments2Value, this.arguments2ImplicitType);
                        DynamicObject arguments3Value_ = (DynamicObject)arguments3Value;
                        if (RubyGuards.isRubyArray(arguments3Value_) && arguments2Value_ == this.root.getArraySize(arguments3Value_)) {
                            return this.root.setOtherIntArraySameLength(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_, this.negativeIndexProfile);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(IndexSetNodeGen root, Object arguments1Value, Object arguments2Value, ConditionProfile negativeIndexProfile) {
                    return new SetOtherIntArraySameLengthNode_(root, arguments1Value, arguments2Value, negativeIndexProfile);
                }
            }

            @GeneratedBy(methodName="setObject(VirtualFrame, DynamicObject, int, int, Object, ArrayStrategy, ConditionProfile)", value=ArrayNodes.IndexSetNode.class)
            private static final class SetObjectNode_
            extends BaseNode_ {
                private final ArrayStrategy strategy;
                private final ConditionProfile negativeIndexProfile;
                private final Class<?> arguments1ImplicitType;
                private final Class<?> arguments2ImplicitType;

                SetObjectNode_(IndexSetNodeGen root, Object arguments1Value, Object arguments2Value, ArrayStrategy strategy, ConditionProfile negativeIndexProfile) {
                    super(root, 3);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                    this.arguments2ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments2Value);
                    this.strategy = strategy;
                    this.negativeIndexProfile = negativeIndexProfile;
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((SetObjectNode_)other).arguments1ImplicitType && this.arguments2ImplicitType == ((SetObjectNode_)other).arguments2ImplicitType;
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && RubyTypesGen.isImplicitInteger(arguments2Value, this.arguments2ImplicitType) && !RubyGuards.isRubyArray(arguments3Value) && RubyGuards.wasProvided(arguments3Value) && this.strategy.specializesFor(arguments3Value);
                }

                @Override
                public Object execute0(VirtualFrame frameValue) {
                    int arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value, arguments3Value);
                    }
                    try {
                        if (this.arguments2ImplicitType == Integer.TYPE) {
                            arguments2Value_ = this.root.arguments2_.executeInteger(frameValue);
                        } else {
                            Object arguments2Value__ = this.executeArguments2_((Frame)frameValue);
                            arguments2Value_ = RubyTypesGen.expectImplicitInteger(arguments2Value__, this.arguments2ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult(), arguments3Value);
                    }
                    Object arguments3Value_ = this.root.arguments3_.execute(frameValue);
                    if (!RubyGuards.isRubyArray(arguments3Value_) && RubyGuards.wasProvided(arguments3Value_) && this.strategy.specializesFor(arguments3Value_)) {
                        return this.root.setObject(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_, this.strategy, this.negativeIndexProfile);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && RubyTypesGen.isImplicitInteger(arguments2Value, this.arguments2ImplicitType)) {
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        int arguments2Value_ = RubyTypesGen.asImplicitInteger(arguments2Value, this.arguments2ImplicitType);
                        if (!RubyGuards.isRubyArray(arguments3Value) && RubyGuards.wasProvided(arguments3Value) && this.strategy.specializesFor(arguments3Value)) {
                            return this.root.setObject(frameValue, arguments0Value, arguments1Value_, arguments2Value_, arguments3Value, this.strategy, this.negativeIndexProfile);
                        }
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && RubyTypesGen.isImplicitInteger(arguments2Value, this.arguments2ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        int arguments2Value_ = RubyTypesGen.asImplicitInteger(arguments2Value, this.arguments2ImplicitType);
                        if (!RubyGuards.isRubyArray(arguments3Value) && RubyGuards.wasProvided(arguments3Value) && this.strategy.specializesFor(arguments3Value)) {
                            return this.root.setObject(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value, this.strategy, this.negativeIndexProfile);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(IndexSetNodeGen root, Object arguments1Value, Object arguments2Value, ArrayStrategy strategy, ConditionProfile negativeIndexProfile) {
                    return new SetObjectNode_(root, arguments1Value, arguments2Value, strategy, negativeIndexProfile);
                }
            }

            @GeneratedBy(methodName="set(VirtualFrame, DynamicObject, Object, Object, NotProvided)", value=ArrayNodes.IndexSetNode.class)
            private static final class Set1Node_
            extends BaseNode_ {
                Set1Node_(IndexSetNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments3Value instanceof NotProvided) {
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (!RubyGuards.isInteger(arguments1Value) && !RubyGuards.isIntegerFixnumRange(arguments1Value)) {
                            return this.root.set(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value_);
                        }
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (!RubyGuards.isInteger(arguments1Value) && !RubyGuards.isIntegerFixnumRange(arguments1Value)) {
                            return this.root.set(frameValue, arguments0Value_, arguments1Value, arguments2Value, arguments3Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(IndexSetNodeGen root) {
                    return new Set1Node_(root);
                }
            }

            @GeneratedBy(methodName="set(DynamicObject, int, Object, NotProvided, ConditionProfile)", value=ArrayNodes.IndexSetNode.class)
            private static final class Set0Node_
            extends BaseNode_ {
                private final ConditionProfile negativeIndexProfile;
                private final Class<?> arguments1ImplicitType;

                Set0Node_(IndexSetNodeGen root, Object arguments1Value, ConditionProfile negativeIndexProfile) {
                    super(root, 1);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                    this.negativeIndexProfile = negativeIndexProfile;
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Set0Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute0(VirtualFrame frameValue) {
                    NotProvided arguments3Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        Object arguments3Value = this.root.arguments3_.execute(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value, arguments3Value);
                    }
                    Object arguments2Value_ = this.executeArguments2_((Frame)frameValue);
                    try {
                        arguments3Value_ = this.root.arguments3_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult());
                    }
                    return this.root.set(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_, this.negativeIndexProfile);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && arguments3Value instanceof NotProvided) {
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        return this.root.set(arguments0Value, arguments1Value_, arguments2Value, arguments3Value_, this.negativeIndexProfile);
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        return this.root.set(arguments0Value_, arguments1Value_, arguments2Value, arguments3Value_, this.negativeIndexProfile);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(IndexSetNodeGen root, Object arguments1Value, ConditionProfile negativeIndexProfile) {
                    return new Set0Node_(root, arguments1Value, negativeIndexProfile);
                }
            }

            @GeneratedBy(value=ArrayNodes.IndexSetNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(IndexSetNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(IndexSetNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.IndexSetNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(IndexSetNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(IndexSetNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.IndexSetNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected IndexSetNodeGen root;

                BaseNode_(IndexSetNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (IndexSetNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_, this.root.arguments3_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4, Object var5);

                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                public Object execute0(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    Object arguments2Value_ = this.executeArguments2_((Frame)frameValue);
                    Object arguments3Value_ = this.root.arguments3_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute0(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments1Value_;
                        if (arguments3Value instanceof NotProvided) {
                            if (RubyTypesGen.isImplicitInteger(arguments1Value)) {
                                ConditionProfile negativeIndexProfile1 = ConditionProfile.createBinaryProfile();
                                return Set0Node_.create(this.root, arguments1Value, negativeIndexProfile1);
                            }
                            if (!RubyGuards.isInteger(arguments1Value) && !RubyGuards.isIntegerFixnumRange(arguments1Value)) {
                                return Set1Node_.create(this.root);
                            }
                        }
                        if (RubyTypesGen.isImplicitInteger(arguments1Value) && RubyTypesGen.isImplicitInteger(arguments2Value)) {
                            ConditionProfile negativeIndexProfile3;
                            BaseNode_ s;
                            int arguments2Value_ = RubyTypesGen.asImplicitInteger(arguments2Value);
                            ArrayStrategy strategy3 = ArrayStrategy.forValue(arguments3Value);
                            if (!RubyGuards.isRubyArray(arguments3Value) && RubyGuards.wasProvided(arguments3Value) && strategy3.specializesFor(arguments3Value) && this.countSame(s = SetObjectNode_.create(this.root, arguments1Value, arguments2Value, strategy3, negativeIndexProfile3 = ConditionProfile.createBinaryProfile())) < 25) {
                                return s;
                            }
                            if (arguments3Value instanceof DynamicObject) {
                                DynamicObject arguments3Value_ = (DynamicObject)arguments3Value;
                                if (RubyGuards.isRubyArray(arguments3Value_) && arguments2Value_ == this.root.getArraySize(arguments3Value_)) {
                                    ConditionProfile negativeIndexProfile4 = ConditionProfile.createBinaryProfile();
                                    return SetOtherIntArraySameLengthNode_.create(this.root, arguments1Value, arguments2Value, negativeIndexProfile4);
                                }
                                if (RubyGuards.isRubyArray(arguments3Value_) && arguments2Value_ != this.root.getArraySize(arguments3Value_)) {
                                    ConditionProfile negativeIndexProfile5 = ConditionProfile.createBinaryProfile();
                                    ConditionProfile needCopy5 = ConditionProfile.createBinaryProfile();
                                    ConditionProfile recursive5 = ConditionProfile.createBinaryProfile();
                                    return SetOtherArrayNode_.create(this.root, arguments1Value, arguments2Value, negativeIndexProfile5, needCopy5, recursive5);
                                }
                            }
                        }
                        if (!(RubyGuards.isInteger(arguments1Value) && RubyGuards.isInteger(arguments2Value) || !RubyGuards.wasProvided(arguments3Value))) {
                            ConditionProfile negativeIndexProfile6 = ConditionProfile.createBinaryProfile();
                            return SetStartLengthNotIntNode_.create(this.root, negativeIndexProfile6);
                        }
                        if (arguments1Value instanceof DynamicObject && arguments3Value instanceof NotProvided && RubyGuards.isIntegerFixnumRange(arguments1Value_ = (DynamicObject)arguments1Value)) {
                            ConditionProfile negativeBeginProfile7 = ConditionProfile.createBinaryProfile();
                            ConditionProfile negativeEndProfile7 = ConditionProfile.createBinaryProfile();
                            return SetRangeNode_.create(this.root, negativeBeginProfile7, negativeEndProfile7);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments2_(Frame frameValue) {
                    Object object;
                    Class arguments2Type_ = this.root.arguments2Type_;
                    if (arguments2Type_ == Integer.TYPE) {
                        return this.root.arguments2_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments2Type_ != null) return this.root.arguments2_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments2_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments2Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments2Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments2Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.IndexNode.class)
    public static final class IndexNodeFactory
    extends NodeFactoryBase<ArrayNodes.IndexNode> {
        private static IndexNodeFactory indexNodeFactoryInstance;

        private IndexNodeFactory() {
            super(ArrayNodes.IndexNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.IndexNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return IndexNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.IndexNode> getInstance() {
            if (indexNodeFactoryInstance == null) {
                indexNodeFactoryInstance = new IndexNodeFactory();
            }
            return indexNodeFactoryInstance;
        }

        public static ArrayNodes.IndexNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new IndexNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.IndexNode.class)
        public static final class IndexNodeGen
        extends ArrayNodes.IndexNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private IndexNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeDynamicObject(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            private static DynamicObject expectDynamicObject(Object value) throws UnexpectedResultException {
                if (value instanceof DynamicObject) {
                    return (DynamicObject)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="fallbackSlice(VirtualFrame, DynamicObject, Object, Object)", value=ArrayNodes.IndexNode.class)
            private static final class FallbackSliceNode_
            extends BaseNode_ {
                FallbackSliceNode_(IndexNodeGen root) {
                    super(root, 5);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (!RubyGuards.isIntegerFixnumRange(arguments1Value) && RubyGuards.wasProvided(arguments2Value)) {
                            return this.root.fallbackSlice(frameValue, arguments0Value_, arguments1Value, arguments2Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(IndexNodeGen root) {
                    return new FallbackSliceNode_(root);
                }
            }

            @GeneratedBy(methodName="fallbackIndex(VirtualFrame, DynamicObject, Object, NotProvided)", value=ArrayNodes.IndexNode.class)
            private static final class FallbackIndexNode_
            extends BaseNode_ {
                FallbackIndexNode_(IndexNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (!RubyGuards.isInteger(arguments1Value) && !RubyGuards.isIntegerFixnumRange(arguments1Value)) {
                            return this.root.fallbackIndex(frameValue, arguments0Value_, arguments1Value, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(IndexNodeGen root) {
                    return new FallbackIndexNode_(root);
                }
            }

            @GeneratedBy(methodName="slice(VirtualFrame, DynamicObject, DynamicObject, NotProvided, ConditionProfile, ConditionProfile)", value=ArrayNodes.IndexNode.class)
            private static final class Slice1Node_
            extends BaseNode_ {
                private final ConditionProfile negativeBeginProfile;
                private final ConditionProfile negativeEndProfile;

                Slice1Node_(IndexNodeGen root, ConditionProfile negativeBeginProfile, ConditionProfile negativeEndProfile) {
                    super(root, 3);
                    this.negativeBeginProfile = negativeBeginProfile;
                    this.negativeEndProfile = negativeEndProfile;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (RubyGuards.isIntegerFixnumRange(arguments1Value_)) {
                            return this.root.slice(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, this.negativeBeginProfile, this.negativeEndProfile);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(IndexNodeGen root, ConditionProfile negativeBeginProfile, ConditionProfile negativeEndProfile) {
                    return new Slice1Node_(root, negativeBeginProfile, negativeEndProfile);
                }
            }

            @GeneratedBy(methodName="slice(VirtualFrame, DynamicObject, int, int)", value=ArrayNodes.IndexNode.class)
            private static final class Slice0Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;
                private final Class<?> arguments2ImplicitType;

                Slice0Node_(IndexNodeGen root, Object arguments1Value, Object arguments2Value) {
                    super(root, 2);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                    this.arguments2ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments2Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Slice0Node_)other).arguments1ImplicitType && this.arguments2ImplicitType == ((Slice0Node_)other).arguments2ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        return IndexNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value));
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        return IndexNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value));
                    }
                    try {
                        if (this.arguments2ImplicitType == Integer.TYPE) {
                            arguments2Value_ = this.root.arguments2_.executeInteger(frameValue);
                        } else {
                            Object arguments2Value__ = this.executeArguments2_((Frame)frameValue);
                            arguments2Value_ = RubyTypesGen.expectImplicitInteger(arguments2Value__, this.arguments2ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return IndexNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult()));
                    }
                    return this.root.slice(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && RubyTypesGen.isImplicitInteger(arguments2Value, this.arguments2ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        int arguments2Value_ = RubyTypesGen.asImplicitInteger(arguments2Value, this.arguments2ImplicitType);
                        return this.root.slice(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(IndexNodeGen root, Object arguments1Value, Object arguments2Value) {
                    return new Slice0Node_(root, arguments1Value, arguments2Value);
                }
            }

            @GeneratedBy(methodName="index(DynamicObject, int, NotProvided)", value=ArrayNodes.IndexNode.class)
            private static final class IndexNode_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                IndexNode_(IndexNodeGen root, Object arguments1Value) {
                    super(root, 1);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((IndexNode_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    NotProvided arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value);
                    }
                    try {
                        arguments2Value_ = this.root.arguments2_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult());
                    }
                    return this.root.index(arguments0Value_, arguments1Value_, arguments2Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && arguments2Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        return this.root.index(arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(IndexNodeGen root, Object arguments1Value) {
                    return new IndexNode_(root, arguments1Value);
                }
            }

            @GeneratedBy(value=ArrayNodes.IndexNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(IndexNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(IndexNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.IndexNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(IndexNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(IndexNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.IndexNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected IndexNodeGen root;

                BaseNode_(IndexNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (IndexNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    Object arguments2Value_ = this.executeArguments2_((Frame)frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    return IndexNodeGen.expectDynamicObject(this.execute(frameValue));
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        if (RubyTypesGen.isImplicitInteger(arguments1Value)) {
                            if (arguments2Value instanceof NotProvided) {
                                return IndexNode_.create(this.root, arguments1Value);
                            }
                            if (RubyTypesGen.isImplicitInteger(arguments2Value)) {
                                return Slice0Node_.create(this.root, arguments1Value, arguments2Value);
                            }
                        }
                        if (arguments2Value instanceof NotProvided) {
                            DynamicObject arguments1Value_;
                            if (arguments1Value instanceof DynamicObject && RubyGuards.isIntegerFixnumRange(arguments1Value_ = (DynamicObject)arguments1Value)) {
                                ConditionProfile negativeBeginProfile3 = ConditionProfile.createBinaryProfile();
                                ConditionProfile negativeEndProfile3 = ConditionProfile.createBinaryProfile();
                                return Slice1Node_.create(this.root, negativeBeginProfile3, negativeEndProfile3);
                            }
                            if (!RubyGuards.isInteger(arguments1Value) && !RubyGuards.isIntegerFixnumRange(arguments1Value)) {
                                return FallbackIndexNode_.create(this.root);
                            }
                        }
                        if (!RubyGuards.isIntegerFixnumRange(arguments1Value) && RubyGuards.wasProvided(arguments2Value)) {
                            return FallbackSliceNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments2_(Frame frameValue) {
                    Object object;
                    Class arguments2Type_ = this.root.arguments2Type_;
                    if (arguments2Type_ == Integer.TYPE) {
                        return this.root.arguments2_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments2Type_ != null) return this.root.arguments2_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments2_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments2Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments2Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments2Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.MulNode.class)
    public static final class MulNodeFactory
    extends NodeFactoryBase<ArrayNodes.MulNode> {
        private static MulNodeFactory mulNodeFactoryInstance;

        private MulNodeFactory() {
            super(ArrayNodes.MulNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.MulNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MulNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.MulNode> getInstance() {
            if (mulNodeFactoryInstance == null) {
                mulNodeFactoryInstance = new MulNodeFactory();
            }
            return mulNodeFactoryInstance;
        }

        public static ArrayNodes.MulNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new MulNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.MulNode.class)
        public static final class MulNodeGen
        extends ArrayNodes.MulNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private MulNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            protected Object executeMul(VirtualFrame frameValue, DynamicObject arguments0Value, int arguments1Value) {
                return this.specialization_.execute1(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute0(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeDynamicObject(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            private static DynamicObject expectDynamicObject(Object value) throws UnexpectedResultException {
                if (value instanceof DynamicObject) {
                    return (DynamicObject)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="mulObjectCount(VirtualFrame, DynamicObject, Object, SnippetNode)", value=ArrayNodes.MulNode.class)
            private static final class MulObjectCountNode_
            extends BaseNode_ {
                @Node.Child
                private SnippetNode snippetNode;

                MulObjectCountNode_(MulNodeGen root, SnippetNode snippetNode) {
                    super(root, 4);
                    this.snippetNode = snippetNode;
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, int arguments1Value) {
                    if (!RubyGuards.isInteger(arguments1Value) && !RubyGuards.isRubyString(arguments1Value)) {
                        return this.root.mulObjectCount(frameValue, arguments0Value, arguments1Value, this.snippetNode);
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (!RubyGuards.isInteger(arguments1Value) && !RubyGuards.isRubyString(arguments1Value)) {
                            return this.root.mulObjectCount(frameValue, arguments0Value_, arguments1Value, this.snippetNode);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MulNodeGen root, SnippetNode snippetNode) {
                    return new MulObjectCountNode_(root, snippetNode);
                }
            }

            @GeneratedBy(methodName="mulObject(VirtualFrame, DynamicObject, DynamicObject, CallDispatchHeadNode)", value=ArrayNodes.MulNode.class)
            private static final class MulObjectNode_
            extends BaseNode_ {
                @Node.Child
                private CallDispatchHeadNode callNode;

                MulObjectNode_(MulNodeGen root, CallDispatchHeadNode callNode) {
                    super(root, 3);
                    this.callNode = callNode;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments1Value_)) {
                            return this.root.mulObject(frameValue, arguments0Value_, arguments1Value_, this.callNode);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MulNodeGen root, CallDispatchHeadNode callNode) {
                    return new MulObjectNode_(root, callNode);
                }
            }

            @GeneratedBy(methodName="mulIntegerFixnum(DynamicObject, int, ArrayStrategy)", value=ArrayNodes.MulNode.class)
            private static final class MulIntegerFixnumNode_
            extends BaseNode_ {
                private final ArrayStrategy strategy;
                private final Class<?> arguments1ImplicitType;

                MulIntegerFixnumNode_(MulNodeGen root, Object arguments1Value, ArrayStrategy strategy) {
                    super(root, 2);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                    this.strategy = strategy;
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((MulIntegerFixnumNode_)other).arguments1ImplicitType;
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    return arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && this.strategy.matches(arguments0Value_ = (DynamicObject)arguments0Value) && !ArrayGuards.isNullArray(arguments0Value_);
                }

                @Override
                public Object execute0(VirtualFrame frameValue) {
                    try {
                        return this.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return MulNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return MulNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (this.strategy.matches(arguments0Value_) && !ArrayGuards.isNullArray(arguments0Value_)) {
                        return this.root.mulIntegerFixnum(arguments0Value_, arguments1Value_, this.strategy);
                    }
                    return MulNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, int arguments1Value) {
                    if (this.strategy.matches(arguments0Value) && !ArrayGuards.isNullArray(arguments0Value)) {
                        return this.root.mulIntegerFixnum(arguments0Value, arguments1Value, this.strategy);
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        if (this.strategy.matches(arguments0Value_) && !ArrayGuards.isNullArray(arguments0Value_)) {
                            return this.root.mulIntegerFixnum(arguments0Value_, arguments1Value_, this.strategy);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MulNodeGen root, Object arguments1Value, ArrayStrategy strategy) {
                    return new MulIntegerFixnumNode_(root, arguments1Value, strategy);
                }
            }

            @GeneratedBy(methodName="mulEmpty(DynamicObject, int)", value=ArrayNodes.MulNode.class)
            private static final class MulEmptyNode_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                MulEmptyNode_(MulNodeGen root, Object arguments1Value) {
                    super(root, 1);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((MulEmptyNode_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute0(VirtualFrame frameValue) {
                    try {
                        return this.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return MulNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return MulNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (ArrayGuards.isNullArray(arguments0Value_)) {
                        return this.root.mulEmpty(arguments0Value_, arguments1Value_);
                    }
                    return MulNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, int arguments1Value) {
                    if (ArrayGuards.isNullArray(arguments0Value)) {
                        return this.root.mulEmpty(arguments0Value, arguments1Value);
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        if (ArrayGuards.isNullArray(arguments0Value_)) {
                            return this.root.mulEmpty(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MulNodeGen root, Object arguments1Value) {
                    return new MulEmptyNode_(root, arguments1Value);
                }
            }

            @GeneratedBy(value=ArrayNodes.MulNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(MulNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MulNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.MulNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(MulNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MulNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.MulNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected MulNodeGen root;

                BaseNode_(MulNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (MulNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, int arguments1Value) {
                    return this.execute_(frameValue, arguments0Value, arguments1Value);
                }

                public Object execute0(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute0(frameValue);
                }

                public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    return MulNodeGen.expectDynamicObject(this.execute0(frameValue));
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments1Value_;
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (RubyTypesGen.isImplicitInteger(arguments1Value)) {
                            BaseNode_ s;
                            if (ArrayGuards.isNullArray(arguments0Value_)) {
                                return MulEmptyNode_.create(this.root, arguments1Value);
                            }
                            ArrayStrategy strategy2 = ArrayStrategy.of(arguments0Value_);
                            if (strategy2.matches(arguments0Value_) && !ArrayGuards.isNullArray(arguments0Value_) && this.countSame(s = MulIntegerFixnumNode_.create(this.root, arguments1Value, strategy2)) < 25) {
                                return s;
                            }
                        }
                        if (arguments1Value instanceof DynamicObject && RubyGuards.isRubyString(arguments1Value_ = (DynamicObject)arguments1Value)) {
                            CallDispatchHeadNode callNode3 = CallDispatchHeadNode.createMethodCall();
                            return MulObjectNode_.create(this.root, callNode3);
                        }
                        if (!RubyGuards.isInteger(arguments1Value) && !RubyGuards.isRubyString(arguments1Value)) {
                            SnippetNode snippetNode4 = new SnippetNode();
                            return MulObjectCountNode_.create(this.root, snippetNode4);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.AddNode.class)
    public static final class AddNodeFactory
    extends NodeFactoryBase<ArrayNodes.AddNode> {
        private static AddNodeFactory addNodeFactoryInstance;

        private AddNodeFactory() {
            super(ArrayNodes.AddNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyNode.class, RubyNode.class}});
        }

        public ArrayNodes.AddNode createNode(Object ... arguments) {
            if (arguments.length == 2 && (arguments[0] == null || arguments[0] instanceof RubyNode) && (arguments[1] == null || arguments[1] instanceof RubyNode)) {
                return AddNodeFactory.create((RubyNode)((Object)arguments[0]), (RubyNode)((Object)arguments[1]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.AddNode> getInstance() {
            if (addNodeFactoryInstance == null) {
                addNodeFactoryInstance = new AddNodeFactory();
            }
            return addNodeFactoryInstance;
        }

        public static ArrayNodes.AddNode create(RubyNode a, RubyNode b) {
            return new AddNodeGen(a, b);
        }

        @GeneratedBy(value=ArrayNodes.AddNode.class)
        @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
        public static final class AddNodeGen
        extends ArrayNodes.AddNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode a_;
            @Node.Child
            private RubyNode b_;
            @Node.Child
            private BaseNode_ specialization_;

            private AddNodeGen(RubyNode a, RubyNode b) {
                this.a_ = a;
                this.b_ = this.coerceOtherToAry(b);
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="addGeneralize(DynamicObject, DynamicObject, ArrayStrategy, ArrayStrategy, ArrayStrategy)", value=ArrayNodes.AddNode.class)
            private static final class AddGeneralizeNode_
            extends BaseNode_ {
                private final ArrayStrategy aStrategy;
                private final ArrayStrategy bStrategy;
                private final ArrayStrategy generalized;

                AddGeneralizeNode_(AddNodeGen root, ArrayStrategy aStrategy, ArrayStrategy bStrategy, ArrayStrategy generalized) {
                    super(root, 5);
                    this.aStrategy = aStrategy;
                    this.bStrategy = bStrategy;
                    this.generalized = generalized;
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof DynamicObject && bValue instanceof DynamicObject) {
                        DynamicObject aValue_ = (DynamicObject)aValue;
                        DynamicObject bValue_ = (DynamicObject)bValue;
                        if (this.aStrategy.matches(aValue_) && this.bStrategy.matches(bValue_)) {
                            assert (this.aStrategy != this.bStrategy);
                            return true;
                        }
                    }
                    return false;
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof DynamicObject && bValue instanceof DynamicObject) {
                        DynamicObject aValue_ = (DynamicObject)aValue;
                        DynamicObject bValue_ = (DynamicObject)bValue;
                        if (this.aStrategy.matches(aValue_) && this.bStrategy.matches(bValue_)) {
                            assert (this.aStrategy != this.bStrategy);
                            return this.root.addGeneralize(aValue_, bValue_, this.aStrategy, this.bStrategy, this.generalized);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(AddNodeGen root, ArrayStrategy aStrategy, ArrayStrategy bStrategy, ArrayStrategy generalized) {
                    return new AddGeneralizeNode_(root, aStrategy, bStrategy, generalized);
                }
            }

            @GeneratedBy(methodName="addSameType(DynamicObject, DynamicObject, ArrayStrategy)", value=ArrayNodes.AddNode.class)
            private static final class AddSameTypeNode_
            extends BaseNode_ {
                private final ArrayStrategy strategy;

                AddSameTypeNode_(AddNodeGen root, ArrayStrategy strategy) {
                    super(root, 4);
                    this.strategy = strategy;
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof DynamicObject && bValue instanceof DynamicObject) {
                        DynamicObject aValue_ = (DynamicObject)aValue;
                        DynamicObject bValue_ = (DynamicObject)bValue;
                        if (this.strategy.matches(aValue_) && this.strategy.matches(bValue_)) {
                            return true;
                        }
                    }
                    return false;
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof DynamicObject && bValue instanceof DynamicObject) {
                        DynamicObject aValue_ = (DynamicObject)aValue;
                        DynamicObject bValue_ = (DynamicObject)bValue;
                        if (this.strategy.matches(aValue_) && this.strategy.matches(bValue_)) {
                            return this.root.addSameType(aValue_, bValue_, this.strategy);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(AddNodeGen root, ArrayStrategy strategy) {
                    return new AddSameTypeNode_(root, strategy);
                }
            }

            @GeneratedBy(methodName="addOtherNull(DynamicObject, DynamicObject, ArrayStrategy)", value=ArrayNodes.AddNode.class)
            private static final class AddOtherNullNode_
            extends BaseNode_ {
                private final ArrayStrategy strategy;

                AddOtherNullNode_(AddNodeGen root, ArrayStrategy strategy) {
                    super(root, 3);
                    this.strategy = strategy;
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof DynamicObject && bValue instanceof DynamicObject) {
                        DynamicObject aValue_ = (DynamicObject)aValue;
                        DynamicObject bValue_ = (DynamicObject)bValue;
                        if (!ArrayGuards.isNullArray(aValue_) && ArrayGuards.isNullArray(bValue_) && this.strategy.matches(aValue_)) {
                            return true;
                        }
                    }
                    return false;
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof DynamicObject && bValue instanceof DynamicObject) {
                        DynamicObject aValue_ = (DynamicObject)aValue;
                        DynamicObject bValue_ = (DynamicObject)bValue;
                        if (!ArrayGuards.isNullArray(aValue_) && ArrayGuards.isNullArray(bValue_) && this.strategy.matches(aValue_)) {
                            return this.root.addOtherNull(aValue_, bValue_, this.strategy);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(AddNodeGen root, ArrayStrategy strategy) {
                    return new AddOtherNullNode_(root, strategy);
                }
            }

            @GeneratedBy(methodName="addNullOther(DynamicObject, DynamicObject, ArrayStrategy)", value=ArrayNodes.AddNode.class)
            private static final class AddNullOtherNode_
            extends BaseNode_ {
                private final ArrayStrategy strategy;

                AddNullOtherNode_(AddNodeGen root, ArrayStrategy strategy) {
                    super(root, 2);
                    this.strategy = strategy;
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof DynamicObject && bValue instanceof DynamicObject) {
                        DynamicObject aValue_ = (DynamicObject)aValue;
                        DynamicObject bValue_ = (DynamicObject)bValue;
                        if (ArrayGuards.isNullArray(aValue_) && !ArrayGuards.isNullArray(bValue_) && this.strategy.matches(bValue_)) {
                            return true;
                        }
                    }
                    return false;
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof DynamicObject && bValue instanceof DynamicObject) {
                        DynamicObject aValue_ = (DynamicObject)aValue;
                        DynamicObject bValue_ = (DynamicObject)bValue;
                        if (ArrayGuards.isNullArray(aValue_) && !ArrayGuards.isNullArray(bValue_) && this.strategy.matches(bValue_)) {
                            return this.root.addNullOther(aValue_, bValue_, this.strategy);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(AddNodeGen root, ArrayStrategy strategy) {
                    return new AddNullOtherNode_(root, strategy);
                }
            }

            @GeneratedBy(methodName="addNullNull(DynamicObject, DynamicObject)", value=ArrayNodes.AddNode.class)
            private static final class AddNullNullNode_
            extends BaseNode_ {
                AddNullNullNode_(AddNodeGen root) {
                    super(root, 1);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof DynamicObject && bValue instanceof DynamicObject) {
                        DynamicObject aValue_ = (DynamicObject)aValue;
                        DynamicObject bValue_ = (DynamicObject)bValue;
                        if (ArrayGuards.isNullArray(aValue_) && ArrayGuards.isNullArray(bValue_)) {
                            return this.root.addNullNull(aValue_, bValue_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(AddNodeGen root) {
                    return new AddNullNullNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.AddNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(AddNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object aValue, Object bValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, aValue, bValue));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    return this.getNext().executeDynamicObject_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(AddNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.AddNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(AddNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, aValue, bValue);
                }

                static BaseNode_ create(AddNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ArrayNodes.AddNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected AddNodeGen root;

                BaseNode_(AddNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (AddNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.a_, this.root.b_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object aValue, Object bValue) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, aValue, bValue);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object aValue_ = this.root.a_.execute(frameValue);
                    Object bValue_ = this.root.b_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, aValue_, bValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof DynamicObject && bValue instanceof DynamicObject) {
                        ArrayStrategy generalized5;
                        BaseNode_ s;
                        BaseNode_ s2;
                        BaseNode_ s3;
                        BaseNode_ s4;
                        DynamicObject aValue_ = (DynamicObject)aValue;
                        DynamicObject bValue_ = (DynamicObject)bValue;
                        if (ArrayGuards.isNullArray(aValue_) && ArrayGuards.isNullArray(bValue_)) {
                            return AddNullNullNode_.create(this.root);
                        }
                        ArrayStrategy strategy2 = ArrayStrategy.of(bValue_);
                        if (ArrayGuards.isNullArray(aValue_) && !ArrayGuards.isNullArray(bValue_) && strategy2.matches(bValue_) && this.countSame(s4 = AddNullOtherNode_.create(this.root, strategy2)) < 25) {
                            return s4;
                        }
                        ArrayStrategy strategy3 = ArrayStrategy.of(aValue_);
                        if (!ArrayGuards.isNullArray(aValue_) && ArrayGuards.isNullArray(bValue_) && strategy3.matches(aValue_) && this.countSame(s3 = AddOtherNullNode_.create(this.root, strategy3)) < 25) {
                            return s3;
                        }
                        ArrayStrategy strategy4 = ArrayStrategy.of(aValue_);
                        if (strategy4.matches(aValue_) && strategy4.matches(bValue_) && this.countSame(s2 = AddSameTypeNode_.create(this.root, strategy4)) < 25) {
                            return s2;
                        }
                        ArrayStrategy aStrategy5 = ArrayStrategy.of(aValue_);
                        ArrayStrategy bStrategy5 = ArrayStrategy.of(bValue_);
                        if (aStrategy5.matches(aValue_) && bStrategy5.matches(bValue_) && aStrategy5 != bStrategy5 && this.countSame(s = AddGeneralizeNode_.create(this.root, aStrategy5, bStrategy5, generalized5 = aStrategy5.generalize(bStrategy5))) < 25) {
                            return s;
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.AllocateNode.class)
    public static final class AllocateNodeFactory
    extends NodeFactoryBase<ArrayNodes.AllocateNode> {
        private static AllocateNodeFactory allocateNodeFactoryInstance;

        private AllocateNodeFactory() {
            super(ArrayNodes.AllocateNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.AllocateNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AllocateNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayNodes.AllocateNode> getInstance() {
            if (allocateNodeFactoryInstance == null) {
                allocateNodeFactoryInstance = new AllocateNodeFactory();
            }
            return allocateNodeFactoryInstance;
        }

        public static ArrayNodes.AllocateNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new AllocateNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ArrayNodes.AllocateNode.class)
        public static final class AllocateNodeGen
        extends ArrayNodes.AllocateNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private AllocateNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.allocate(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }
}

