/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.layouts;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.math.BigInteger;
import java.util.EnumSet;
import org.jruby.truffle.runtime.layouts.BasicObjectLayoutImpl;
import org.jruby.truffle.runtime.layouts.BignumLayout;

public class BignumLayoutImpl
extends BasicObjectLayoutImpl
implements BignumLayout {
    public static final BignumLayout INSTANCE = new BignumLayoutImpl();
    protected static final Shape.Allocator BIGNUM_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey VALUE_IDENTIFIER = new HiddenKey("value");
    protected static final Property VALUE_PROPERTY = Property.create((Object)VALUE_IDENTIFIER, (Location)BIGNUM_ALLOCATOR.locationForType(BigInteger.class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), (int)0);

    protected BignumLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createBignumShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape((ObjectType)new BignumType(logicalClass, metaClass)).addProperty(VALUE_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createBignum(DynamicObjectFactory factory, BigInteger value) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant((Object)factory);
        assert (this.createsBignum(factory));
        assert (factory.getShape().hasProperty((Object)VALUE_IDENTIFIER));
        assert (value != null);
        return factory.newInstance(new Object[]{value});
    }

    @Override
    public boolean isBignum(Object object) {
        return object instanceof DynamicObject && this.isBignum((DynamicObject)object);
    }

    @Override
    public boolean isBignum(DynamicObject object) {
        return this.isBignum(object.getShape().getObjectType());
    }

    private boolean isBignum(ObjectType objectType) {
        return objectType instanceof BignumType;
    }

    private boolean createsBignum(DynamicObjectFactory factory) {
        return this.isBignum(factory.getShape().getObjectType());
    }

    @Override
    public BigInteger getValue(DynamicObject object) {
        assert (this.isBignum(object));
        assert (object.getShape().hasProperty((Object)VALUE_IDENTIFIER));
        return (BigInteger)VALUE_PROPERTY.get(object, true);
    }

    protected static class BignumType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public BignumType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public BignumType setLogicalClass(DynamicObject logicalClass) {
            return new BignumType(logicalClass, this.metaClass);
        }

        @Override
        public BignumType setMetaClass(DynamicObject metaClass) {
            return new BignumType(this.logicalClass, metaClass);
        }
    }
}

