/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.nodes.Node;
import java.util.ArrayList;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.backtrace.Activation;
import org.jruby.truffle.runtime.backtrace.Backtrace;
import org.jruby.truffle.runtime.core.CoreSourceSection;
import org.jruby.truffle.runtime.methods.InternalMethod;

public abstract class RubyCallStack {
    @CompilerDirectives.TruffleBoundary
    public static FrameInstance getCallerFrame(final RubyContext context) {
        return (FrameInstance)Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<FrameInstance>(){

            public FrameInstance visitFrame(FrameInstance frameInstance) {
                InternalMethod method = RubyCallStack.getMethod(frameInstance);
                assert (method != null);
                if (!context.getCoreLibrary().isSend(method)) {
                    return frameInstance;
                }
                return null;
            }
        });
    }

    public static InternalMethod getCallingMethod(RubyContext context) {
        return RubyCallStack.getMethod(RubyCallStack.getCallerFrame(context));
    }

    private static InternalMethod getMethod(FrameInstance frame) {
        CompilerAsserts.neverPartOfCompilation();
        return RubyArguments.getMethod(frame.getFrame(FrameInstance.FrameAccess.READ_ONLY, true).getArguments());
    }

    public static Backtrace getBacktrace(Node currentNode) {
        return RubyCallStack.getBacktrace(currentNode, 0);
    }

    public static Backtrace getBacktrace(Node currentNode, int omit) {
        return RubyCallStack.getBacktrace(currentNode, omit, false);
    }

    public static Backtrace getBacktrace(Node currentNode, final int omit, final boolean filterNullSourceSection) {
        CompilerAsserts.neverPartOfCompilation();
        final ArrayList<Activation> activations = new ArrayList<Activation>();
        if (omit == 0 && currentNode != null && Truffle.getRuntime().getCurrentFrame() != null) {
            activations.add(new Activation(currentNode, Truffle.getRuntime().getCurrentFrame().getFrame(FrameInstance.FrameAccess.MATERIALIZE, true).materialize()));
        }
        Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<InternalMethod>(){
            int depth = 1;

            public InternalMethod visitFrame(FrameInstance frameInstance) {
                if (frameInstance.getCallNode() != null && this.depth >= omit && (!filterNullSourceSection || frameInstance.getCallNode().getEncapsulatingSourceSection() != null && frameInstance.getCallNode().getEncapsulatingSourceSection().getSource() != null)) {
                    activations.add(new Activation(frameInstance.getCallNode(), frameInstance.getFrame(FrameInstance.FrameAccess.MATERIALIZE, true).materialize()));
                }
                ++this.depth;
                return null;
            }
        });
        return new Backtrace(activations.toArray(new Activation[activations.size()]));
    }

    public static Node getTopMostUserCallNode() {
        CompilerAsserts.neverPartOfCompilation();
        return (Node)Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<Node>(){

            public Node visitFrame(FrameInstance frameInstance) {
                if (CoreSourceSection.isCoreSourceSection(frameInstance.getCallNode().getEncapsulatingSourceSection())) {
                    return null;
                }
                return frameInstance.getCallNode();
            }
        });
    }
}

