/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypes;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.MutexNodes;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;

@GeneratedBy(value=MutexNodes.class)
public final class MutexNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(AllocateNodeFactory.getInstance(), LockNodeFactory.getInstance(), IsLockedNodeFactory.getInstance(), IsOwnedNodeFactory.getInstance(), TryLockNodeFactory.getInstance(), UnlockNodeFactory.getInstance(), SleepNodeFactory.getInstance());
    }

    @GeneratedBy(value=MutexNodes.SleepNode.class)
    public static final class SleepNodeFactory
    extends NodeFactoryBase<MutexNodes.SleepNode> {
        private static SleepNodeFactory sleepNodeFactoryInstance;

        private SleepNodeFactory() {
            super(MutexNodes.SleepNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MutexNodes.SleepNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SleepNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MutexNodes.SleepNode> getInstance() {
            if (sleepNodeFactoryInstance == null) {
                sleepNodeFactoryInstance = new SleepNodeFactory();
            }
            return sleepNodeFactoryInstance;
        }

        public static MutexNodes.SleepNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SleepNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=MutexNodes.SleepNode.class)
        public static final class SleepNodeGen
        extends MutexNodes.SleepNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private SleepNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) {
                return this.specialization_.executeLong(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="sleep(DynamicObject, double)", value=MutexNodes.SleepNode.class)
            private static final class Sleep3Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Sleep3Node_(SleepNodeGen root, Object arguments1Value) {
                    super(root, 4);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Sleep3Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeLong(frameValue);
                }

                @Override
                public long executeLong(VirtualFrame frameValue) {
                    double arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeLong_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Double.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitDouble(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeLong_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.sleep(arguments0Value_, arguments1Value_);
                }

                @Override
                public long executeLong_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitDouble(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        double arguments1Value_ = RubyTypesGen.asImplicitDouble(arguments1Value, this.arguments1ImplicitType);
                        return this.root.sleep(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeLong_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SleepNodeGen root, Object arguments1Value) {
                    return new Sleep3Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="sleep(DynamicObject, long)", value=MutexNodes.SleepNode.class)
            private static final class Sleep2Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Sleep2Node_(SleepNodeGen root, Object arguments1Value) {
                    super(root, 3);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Sleep2Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeLong(frameValue);
                }

                @Override
                public long executeLong(VirtualFrame frameValue) {
                    long arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeLong_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Long.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeLong(frameValue);
                        } else if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = RubyTypes.promoteToLong(this.root.arguments1_.executeInteger(frameValue));
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitLong(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeLong_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.sleep(arguments0Value_, arguments1Value_);
                }

                @Override
                public long executeLong_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.sleep(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeLong_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SleepNodeGen root, Object arguments1Value) {
                    return new Sleep2Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="sleep(DynamicObject, DynamicObject)", value=MutexNodes.SleepNode.class)
            private static final class Sleep1Node_
            extends BaseNode_ {
                Sleep1Node_(SleepNodeGen root) {
                    super(root, 2);
                }

                @Override
                public long executeLong(VirtualFrame frameValue) {
                    DynamicObject arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeLong_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeLong_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (this.root.isNil(arguments1Value_)) {
                        return this.root.sleep(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeLong_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public long executeLong_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (this.root.isNil(arguments1Value_)) {
                            return this.root.sleep(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeLong_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SleepNodeGen root) {
                    return new Sleep1Node_(root);
                }
            }

            @GeneratedBy(methodName="sleep(DynamicObject, NotProvided)", value=MutexNodes.SleepNode.class)
            private static final class Sleep0Node_
            extends BaseNode_ {
                Sleep0Node_(SleepNodeGen root) {
                    super(root, 1);
                }

                @Override
                public long executeLong(VirtualFrame frameValue) {
                    NotProvided arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeLong_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeLong_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.sleep(arguments0Value_, arguments1Value_);
                }

                @Override
                public long executeLong_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        return this.root.sleep(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeLong_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SleepNodeGen root) {
                    return new Sleep0Node_(root);
                }
            }

            @GeneratedBy(value=MutexNodes.SleepNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SleepNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public long executeLong(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return this.getNext().executeLong_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public long executeLong_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeLong_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SleepNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MutexNodes.SleepNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SleepNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public long executeLong_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (Long)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SleepNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MutexNodes.SleepNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected SleepNodeGen root;

                BaseNode_(SleepNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (SleepNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeLong_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract long executeLong_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return this.executeLong_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public long executeLong(VirtualFrame frameValue) {
                    return (Long)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments1Value_;
                        if (arguments1Value instanceof NotProvided) {
                            return Sleep0Node_.create(this.root);
                        }
                        if (arguments1Value instanceof DynamicObject && this.root.isNil(arguments1Value_ = (DynamicObject)arguments1Value)) {
                            return Sleep1Node_.create(this.root);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Sleep2Node_.create(this.root, arguments1Value);
                        }
                        if (RubyTypesGen.isImplicitDouble(arguments1Value)) {
                            return Sleep3Node_.create(this.root, arguments1Value);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Double.TYPE) {
                        return this.root.arguments1_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MutexNodes.UnlockNode.class)
    public static final class UnlockNodeFactory
    extends NodeFactoryBase<MutexNodes.UnlockNode> {
        private static UnlockNodeFactory unlockNodeFactoryInstance;

        private UnlockNodeFactory() {
            super(MutexNodes.UnlockNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
        }

        public MutexNodes.UnlockNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
                return UnlockNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MutexNodes.UnlockNode> getInstance() {
            if (unlockNodeFactoryInstance == null) {
                unlockNodeFactoryInstance = new UnlockNodeFactory();
            }
            return unlockNodeFactoryInstance;
        }

        public static MutexNodes.UnlockNode create(RubyContext context, SourceSection sourceSection, RubyNode operand) {
            return new UnlockNodeGen(context, sourceSection, operand);
        }

        @GeneratedBy(value=MutexNodes.UnlockNode.class)
        public static final class UnlockNodeGen
        extends MutexNodes.UnlockNode {
            @Node.Child
            private RubyNode operand_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private UnlockNodeGen(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection);
                this.operand_ = operand;
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject operandValue_;
                try {
                    operandValue_ = this.operand_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.unlock(operandValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object operandValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.operand_}, new Object[]{operandValue});
            }
        }
    }

    @GeneratedBy(value=MutexNodes.TryLockNode.class)
    public static final class TryLockNodeFactory
    extends NodeFactoryBase<MutexNodes.TryLockNode> {
        private static TryLockNodeFactory tryLockNodeFactoryInstance;

        private TryLockNodeFactory() {
            super(MutexNodes.TryLockNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
        }

        public MutexNodes.TryLockNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
                return TryLockNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MutexNodes.TryLockNode> getInstance() {
            if (tryLockNodeFactoryInstance == null) {
                tryLockNodeFactoryInstance = new TryLockNodeFactory();
            }
            return tryLockNodeFactoryInstance;
        }

        public static MutexNodes.TryLockNode create(RubyContext context, SourceSection sourceSection, RubyNode operand) {
            return new TryLockNodeGen(context, sourceSection, operand);
        }

        @GeneratedBy(value=MutexNodes.TryLockNode.class)
        public static final class TryLockNodeGen
        extends MutexNodes.TryLockNode {
            @Node.Child
            private RubyNode operand_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private TryLockNodeGen(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection);
                this.operand_ = operand;
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                DynamicObject operandValue_;
                try {
                    operandValue_ = this.operand_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.tryLock(operandValue_);
            }

            private UnsupportedSpecializationException unsupported(Object operandValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.operand_}, new Object[]{operandValue});
            }
        }
    }

    @GeneratedBy(value=MutexNodes.IsOwnedNode.class)
    public static final class IsOwnedNodeFactory
    extends NodeFactoryBase<MutexNodes.IsOwnedNode> {
        private static IsOwnedNodeFactory isOwnedNodeFactoryInstance;

        private IsOwnedNodeFactory() {
            super(MutexNodes.IsOwnedNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
        }

        public MutexNodes.IsOwnedNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
                return IsOwnedNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MutexNodes.IsOwnedNode> getInstance() {
            if (isOwnedNodeFactoryInstance == null) {
                isOwnedNodeFactoryInstance = new IsOwnedNodeFactory();
            }
            return isOwnedNodeFactoryInstance;
        }

        public static MutexNodes.IsOwnedNode create(RubyContext context, SourceSection sourceSection, RubyNode operand) {
            return new IsOwnedNodeGen(context, sourceSection, operand);
        }

        @GeneratedBy(value=MutexNodes.IsOwnedNode.class)
        public static final class IsOwnedNodeGen
        extends MutexNodes.IsOwnedNode {
            @Node.Child
            private RubyNode operand_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private IsOwnedNodeGen(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection);
                this.operand_ = operand;
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                DynamicObject operandValue_;
                try {
                    operandValue_ = this.operand_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.isOwned(operandValue_);
            }

            private UnsupportedSpecializationException unsupported(Object operandValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.operand_}, new Object[]{operandValue});
            }
        }
    }

    @GeneratedBy(value=MutexNodes.IsLockedNode.class)
    public static final class IsLockedNodeFactory
    extends NodeFactoryBase<MutexNodes.IsLockedNode> {
        private static IsLockedNodeFactory isLockedNodeFactoryInstance;

        private IsLockedNodeFactory() {
            super(MutexNodes.IsLockedNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
        }

        public MutexNodes.IsLockedNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
                return IsLockedNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MutexNodes.IsLockedNode> getInstance() {
            if (isLockedNodeFactoryInstance == null) {
                isLockedNodeFactoryInstance = new IsLockedNodeFactory();
            }
            return isLockedNodeFactoryInstance;
        }

        public static MutexNodes.IsLockedNode create(RubyContext context, SourceSection sourceSection, RubyNode operand) {
            return new IsLockedNodeGen(context, sourceSection, operand);
        }

        @GeneratedBy(value=MutexNodes.IsLockedNode.class)
        public static final class IsLockedNodeGen
        extends MutexNodes.IsLockedNode {
            @Node.Child
            private RubyNode operand_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private IsLockedNodeGen(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection);
                this.operand_ = operand;
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                DynamicObject operandValue_;
                try {
                    operandValue_ = this.operand_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.isLocked(operandValue_);
            }

            private UnsupportedSpecializationException unsupported(Object operandValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.operand_}, new Object[]{operandValue});
            }
        }
    }

    @GeneratedBy(value=MutexNodes.LockNode.class)
    public static final class LockNodeFactory
    extends NodeFactoryBase<MutexNodes.LockNode> {
        private static LockNodeFactory lockNodeFactoryInstance;

        private LockNodeFactory() {
            super(MutexNodes.LockNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
        }

        public MutexNodes.LockNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
                return LockNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MutexNodes.LockNode> getInstance() {
            if (lockNodeFactoryInstance == null) {
                lockNodeFactoryInstance = new LockNodeFactory();
            }
            return lockNodeFactoryInstance;
        }

        public static MutexNodes.LockNode create(RubyContext context, SourceSection sourceSection, RubyNode operand) {
            return new LockNodeGen(context, sourceSection, operand);
        }

        @GeneratedBy(value=MutexNodes.LockNode.class)
        public static final class LockNodeGen
        extends MutexNodes.LockNode {
            @Node.Child
            private RubyNode operand_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private LockNodeGen(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection);
                this.operand_ = operand;
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject operandValue_;
                try {
                    operandValue_ = this.operand_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.lock(operandValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object operandValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.operand_}, new Object[]{operandValue});
            }
        }
    }

    @GeneratedBy(value=MutexNodes.AllocateNode.class)
    public static final class AllocateNodeFactory
    extends NodeFactoryBase<MutexNodes.AllocateNode> {
        private static AllocateNodeFactory allocateNodeFactoryInstance;

        private AllocateNodeFactory() {
            super(MutexNodes.AllocateNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MutexNodes.AllocateNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AllocateNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MutexNodes.AllocateNode> getInstance() {
            if (allocateNodeFactoryInstance == null) {
                allocateNodeFactoryInstance = new AllocateNodeFactory();
            }
            return allocateNodeFactoryInstance;
        }

        public static MutexNodes.AllocateNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new AllocateNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=MutexNodes.AllocateNode.class)
        public static final class AllocateNodeGen
        extends MutexNodes.AllocateNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private AllocateNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.allocate(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }
}

