/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.FixnumOrBignumNode;
import org.jruby.truffle.nodes.core.GeneralDivModNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.layouts.Layouts;

@CoreClass(name="Float")
public abstract class FloatNodes {

    @CoreMethod(names={"java_to_s"}, visibility=Visibility.PRIVATE)
    public static abstract class JavaToSNode
    extends CoreMethodArrayArgumentsNode {
        public JavaToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject javaToS(double value) {
            return this.create7BitString(StringOperations.encodeByteList(String.format("%.15g", value), (Encoding)USASCIIEncoding.INSTANCE));
        }
    }

    @CoreMethod(names={"to_f"})
    public static abstract class ToFNode
    extends CoreMethodArrayArgumentsNode {
        public ToFNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public double toF(double value) {
            return value;
        }
    }

    @CoreMethod(names={"to_i", "to_int", "truncate"})
    public static abstract class ToINode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private FixnumOrBignumNode fixnumOrBignum;

        public ToINode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.fixnumOrBignum = new FixnumOrBignumNode(context, sourceSection);
        }

        public abstract Object executeToI(VirtualFrame var1, double var2);

        @Specialization
        Object toI(double value) {
            if (Double.isInfinite(value)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().floatDomainError("Infinity", this));
            }
            if (Double.isNaN(value)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().floatDomainError("NaN", this));
            }
            return this.fixnumOrBignum.fixnumOrBignum(value);
        }
    }

    @CoreMethod(names={"round"}, optional=1)
    public static abstract class RoundNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private FixnumOrBignumNode fixnumOrBignum;

        public RoundNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.fixnumOrBignum = new FixnumOrBignumNode(context, sourceSection);
        }

        @Specialization(guards={"doubleInLongRange(n)"})
        public long roundFittingLong(double n, NotProvided ndigits, @Cached(value="createBinaryProfile()") ConditionProfile positiveProfile) {
            long l = (long)n;
            if (positiveProfile.profile(n >= 0.0)) {
                if (n - (double)l >= 0.5) {
                    ++l;
                }
                return l;
            }
            if ((double)l - n >= 0.5) {
                --l;
            }
            return l;
        }

        protected boolean doubleInLongRange(double n) {
            return -9.223372036854776E18 < n && n < 9.223372036854776E18;
        }

        @Specialization
        public Object round(double n, NotProvided ndigits, @Cached(value="createBinaryProfile()") ConditionProfile positiveProfile) {
            if (Double.isInfinite(n)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().floatDomainError("Infinity", this));
            }
            if (Double.isNaN(n)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().floatDomainError("NaN", this));
            }
            double f = n;
            if (positiveProfile.profile(f >= 0.0)) {
                if (n - (f = Math.floor(f)) >= 0.5) {
                    f += 1.0;
                }
            } else if ((f = Math.ceil(f)) - n >= 0.5) {
                f -= 1.0;
            }
            return this.fixnumOrBignum.fixnumOrBignum(f);
        }

        @Specialization(guards={"wasProvided(ndigits)"})
        public Object round(VirtualFrame frame, double n, Object ndigits) {
            return this.ruby(frame, "round_internal(ndigits)", "ndigits", ndigits);
        }
    }

    @CoreMethod(names={"nan?"})
    public static abstract class NaNNode
    extends CoreMethodArrayArgumentsNode {
        public NaNNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean nan(double value) {
            return Double.isNaN(value);
        }
    }

    @CoreMethod(names={"infinite?"})
    public static abstract class InfiniteNode
    extends CoreMethodArrayArgumentsNode {
        public InfiniteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object infinite(double value) {
            if (Double.isInfinite(value)) {
                if (value < 0.0) {
                    return -1;
                }
                return 1;
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"floor"})
    public static abstract class FloorNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private FixnumOrBignumNode fixnumOrBignum;

        public FloorNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.fixnumOrBignum = new FixnumOrBignumNode(context, sourceSection);
        }

        @Specialization
        public Object floor(double n) {
            return this.fixnumOrBignum.fixnumOrBignum(Math.floor(n));
        }
    }

    @CoreMethod(names={"ceil"})
    public static abstract class CeilNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private FixnumOrBignumNode fixnumOrBignum;

        public CeilNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.fixnumOrBignum = new FixnumOrBignumNode(context, sourceSection);
        }

        @Specialization
        public Object ceil(double n) {
            return this.fixnumOrBignum.fixnumOrBignum(Math.ceil(n));
        }
    }

    @CoreMethod(names={"abs", "magnitude"})
    public static abstract class AbsNode
    extends CoreMethodArrayArgumentsNode {
        public AbsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public double abs(double n) {
            return Math.abs(n);
        }
    }

    @CoreMethod(names={">"}, required=1)
    public static abstract class GreaterNode
    extends CoreMethodArrayArgumentsNode {
        public GreaterNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean greater(double a, long b) {
            return a > (double)b;
        }

        @Specialization
        public boolean greater(double a, double b) {
            return a > b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean greater(double a, DynamicObject b) {
            return a > Layouts.BIGNUM.getValue(b).doubleValue();
        }

        @Specialization(guards={"!isRubyBignum(b)", "!isInteger(b)", "!isLong(b)", "!isDouble(b)"})
        public Object greaterCoerced(VirtualFrame frame, double a, Object b) {
            return this.ruby(frame, "b, a = math_coerce(other, :compare_error); a > b", "other", b);
        }
    }

    @CoreMethod(names={">="}, required=1)
    public static abstract class GreaterEqualNode
    extends CoreMethodArrayArgumentsNode {
        public GreaterEqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean greaterEqual(double a, long b) {
            return a >= (double)b;
        }

        @Specialization
        public boolean greaterEqual(double a, double b) {
            return a >= b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean greaterEqual(double a, DynamicObject b) {
            return a >= Layouts.BIGNUM.getValue(b).doubleValue();
        }

        @Specialization(guards={"!isRubyBignum(b)", "!isInteger(b)", "!isLong(b)", "!isDouble(b)"})
        public Object greaterEqualCoerced(VirtualFrame frame, double a, Object b) {
            return this.ruby(frame, "b, a = math_coerce other, :compare_error; a >= b", "other", b);
        }
    }

    @CoreMethod(names={"<=>"}, required=1)
    public static abstract class CompareNode
    extends CoreMethodArrayArgumentsNode {
        public CompareNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNaN(a)"})
        public DynamicObject compareFirstNaN(double a, Object b) {
            return this.nil();
        }

        @Specialization(guards={"isNaN(b)"})
        public DynamicObject compareSecondNaN(Object a, double b) {
            return this.nil();
        }

        @Specialization(guards={"!isNaN(a)"})
        public int compare(double a, long b) {
            return Double.compare(a, b);
        }

        @Specialization(guards={"isInfinity(a)", "isRubyBignum(b)"})
        public int compareInfinity(double a, DynamicObject b) {
            if (a < 0.0) {
                return -1;
            }
            return 1;
        }

        @Specialization(guards={"!isNaN(a)", "!isInfinity(a)", "isRubyBignum(b)"})
        public int compareBignum(double a, DynamicObject b) {
            return Double.compare(a, Layouts.BIGNUM.getValue(b).doubleValue());
        }

        @Specialization(guards={"!isNaN(a)", "!isNaN(b)"})
        public int compare(double a, double b) {
            return Double.compare(a, b);
        }

        @Specialization(guards={"!isNaN(a)", "!isRubyBignum(b)"})
        public DynamicObject compare(double a, DynamicObject b) {
            return this.nil();
        }
    }

    @CoreMethod(names={"==", "==="}, required=1)
    public static abstract class EqualNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode fallbackCallNode;

        public EqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean equal(double a, long b) {
            return a == (double)b;
        }

        @Specialization
        public boolean equal(double a, double b) {
            return a == b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean equal(double a, DynamicObject b) {
            return a == Layouts.BIGNUM.getValue(b).doubleValue();
        }

        @Specialization(guards={"!isRubyBignum(b)"})
        public Object equal(VirtualFrame frame, double a, DynamicObject b) {
            if (this.fallbackCallNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.fallbackCallNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCallOnSelf(this.getContext()));
            }
            return this.fallbackCallNode.call(frame, a, "equal_fallback", null, b);
        }
    }

    @CoreMethod(names={"eql?"}, required=1)
    public static abstract class EqlNode
    extends CoreMethodArrayArgumentsNode {
        public EqlNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean eql(double a, double b) {
            return a == b;
        }

        @Specialization(guards={"!isDouble(b)"})
        public boolean eqlGeneral(double a, Object b) {
            return false;
        }
    }

    @CoreMethod(names={"<="}, required=1)
    public static abstract class LessEqualNode
    extends CoreMethodArrayArgumentsNode {
        public LessEqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean lessEqual(double a, long b) {
            return a <= (double)b;
        }

        @Specialization
        public boolean lessEqual(double a, double b) {
            return a <= b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean lessEqual(double a, DynamicObject b) {
            return a <= Layouts.BIGNUM.getValue(b).doubleValue();
        }

        @Specialization(guards={"!isRubyBignum(b)", "!isInteger(b)", "!isLong(b)", "!isDouble(b)"})
        public Object lessEqualCoerced(VirtualFrame frame, double a, Object b) {
            return this.ruby(frame, "b, a = math_coerce other, :compare_error; a <= b", "other", b);
        }
    }

    @CoreMethod(names={"<"}, required=1)
    public static abstract class LessNode
    extends CoreMethodArrayArgumentsNode {
        public LessNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean less(double a, long b) {
            return a < (double)b;
        }

        @Specialization
        public boolean less(double a, double b) {
            return a < b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean lessBignum(double a, DynamicObject b) {
            return a < Layouts.BIGNUM.getValue(b).doubleValue();
        }

        @Specialization(guards={"!isRubyBignum(b)", "!isInteger(b)", "!isLong(b)", "!isDouble(b)"})
        public Object lessCoerced(VirtualFrame frame, double a, Object b) {
            return this.ruby(frame, "b, a = math_coerce other, :compare_error; a < b", "other", b);
        }
    }

    @CoreMethod(names={"divmod"}, required=1)
    public static abstract class DivModNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private GeneralDivModNode divModNode;

        public DivModNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.divModNode = new GeneralDivModNode(context, sourceSection);
        }

        @Specialization
        public DynamicObject divMod(double a, long b) {
            return this.divModNode.execute(a, b);
        }

        @Specialization
        public DynamicObject divMod(double a, double b) {
            return this.divModNode.execute(a, b);
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public DynamicObject divMod(double a, DynamicObject b) {
            return this.divModNode.execute(a, Layouts.BIGNUM.getValue(b));
        }

        @Specialization(guards={"!isRubyBignum(b)"})
        public Object divModCoerced(VirtualFrame frame, double a, DynamicObject b) {
            return this.ruby(frame, "redo_coerced :divmod, b", "b", b);
        }
    }

    @CoreMethod(names={"%"}, required=1)
    public static abstract class ModNode
    extends CoreMethodArrayArgumentsNode {
        private final ConditionProfile lessThanZeroProfile = ConditionProfile.createBinaryProfile();

        public ModNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public double mod(double a, long b) {
            return this.mod(a, (double)b);
        }

        @Specialization
        public double mod(double a, double b) {
            if (b == 0.0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().zeroDivisionError(this));
            }
            double result = Math.IEEEremainder(a, b);
            if (this.lessThanZeroProfile.profile(b * result < 0.0)) {
                result += b;
            }
            return result;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public double mod(double a, DynamicObject b) {
            return this.mod(a, Layouts.BIGNUM.getValue(b).doubleValue());
        }

        @Specialization(guards={"!isRubyBignum(b)"})
        public Object modCoerced(VirtualFrame frame, double a, DynamicObject b) {
            return this.ruby(frame, "redo_coerced :mod, b", "b", b);
        }
    }

    @CoreMethod(names={"/", "__slash__"}, required=1)
    public static abstract class DivNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode redoCoercedNode;

        public DivNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public double div(double a, long b) {
            return a / (double)b;
        }

        @Specialization
        public double div(double a, double b) {
            return a / b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public double div(double a, DynamicObject b) {
            return a / Layouts.BIGNUM.getValue(b).doubleValue();
        }

        @Specialization(guards={"!isInteger(b)", "!isLong(b)", "!isDouble(b)", "!isRubyBignum(b)"})
        public Object div(VirtualFrame frame, double a, Object b) {
            if (this.redoCoercedNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.redoCoercedNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCallOnSelf(this.getContext()));
            }
            return this.redoCoercedNode.call(frame, a, "redo_coerced", null, this.getSymbol("/"), b);
        }
    }

    @CoreMethod(names={"**"}, required=1)
    public static abstract class PowNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode complexConvertNode;
        @Node.Child
        private CallDispatchHeadNode complexPowNode;
        private final ConditionProfile complexProfile = ConditionProfile.createBinaryProfile();

        public PowNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public double pow(double a, long b) {
            return Math.pow(a, b);
        }

        @Specialization
        public Object pow(VirtualFrame frame, double a, double b) {
            if (this.complexProfile.profile(a < 0.0 && b != (double)Math.round(b))) {
                if (this.complexConvertNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.complexConvertNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), true));
                    this.complexPowNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
                }
                Object aComplex = this.complexConvertNode.call(frame, this.getContext().getCoreLibrary().getComplexClass(), "convert", null, a, 0);
                return this.complexPowNode.call(frame, aComplex, "**", null, b);
            }
            return Math.pow(a, b);
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public double pow(double a, DynamicObject b) {
            return Math.pow(a, Layouts.BIGNUM.getValue(b).doubleValue());
        }

        @Specialization(guards={"!isRubyBignum(b)"})
        public Object powCoerced(VirtualFrame frame, double a, DynamicObject b) {
            return this.ruby(frame, "redo_coerced :**, b", "b", b);
        }
    }

    @CoreMethod(names={"*"}, required=1)
    public static abstract class MulNode
    extends CoreMethodArrayArgumentsNode {
        public MulNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public double mul(double a, long b) {
            return a * (double)b;
        }

        @Specialization
        public double mul(double a, double b) {
            return a * b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public double mul(double a, DynamicObject b) {
            return a * Layouts.BIGNUM.getValue(b).doubleValue();
        }

        @Specialization(guards={"!isRubyBignum(b)"})
        public Object mulCoerced(VirtualFrame frame, double a, DynamicObject b) {
            return this.ruby(frame, "redo_coerced :*, b", "b", b);
        }
    }

    @CoreMethod(names={"-"}, required=1)
    public static abstract class SubNode
    extends CoreMethodArrayArgumentsNode {
        public SubNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public double sub(double a, long b) {
            return a - (double)b;
        }

        @Specialization
        public double sub(double a, double b) {
            return a - b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public double sub(double a, DynamicObject b) {
            return a - Layouts.BIGNUM.getValue(b).doubleValue();
        }

        @Specialization(guards={"!isRubyBignum(b)"})
        public Object subCoerced(VirtualFrame frame, double a, DynamicObject b) {
            return this.ruby(frame, "redo_coerced :-, b", "b", b);
        }
    }

    @CoreMethod(names={"+"}, required=1)
    public static abstract class AddNode
    extends CoreMethodArrayArgumentsNode {
        public AddNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public double add(double a, long b) {
            return a + (double)b;
        }

        @Specialization
        public double add(double a, double b) {
            return a + b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public double add(double a, DynamicObject b) {
            return a + Layouts.BIGNUM.getValue(b).doubleValue();
        }

        @Specialization(guards={"!isRubyBignum(b)"})
        public Object addCoerced(VirtualFrame frame, double a, DynamicObject b) {
            return this.ruby(frame, "redo_coerced :+, b", "b", b);
        }
    }

    @CoreMethod(names={"-@"})
    public static abstract class NegNode
    extends CoreMethodArrayArgumentsNode {
        public NegNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public double neg(double value) {
            return -value;
        }
    }
}

