/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.dsl.internal.SuppressFBWarnings;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.BindingNodes;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.locals.ReadFrameSlotNode;
import org.jruby.truffle.nodes.locals.WriteFrameSlotNode;
import org.jruby.truffle.runtime.RubyContext;

@GeneratedBy(value=BindingNodes.class)
public final class BindingNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(DupNodeFactory.getInstance(), LocalVariableGetNodeFactory.getInstance(), LocalVariableSetNodeFactory.getInstance(), LocalVariablesNodeFactory.getInstance(), ReceiverNodeFactory.getInstance(), AllocateNodeFactory.getInstance());
    }

    @GeneratedBy(value=BindingNodes.AllocateNode.class)
    public static final class AllocateNodeFactory
    extends NodeFactoryBase<BindingNodes.AllocateNode> {
        private static AllocateNodeFactory allocateNodeFactoryInstance;

        private AllocateNodeFactory() {
            super(BindingNodes.AllocateNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
        }

        public BindingNodes.AllocateNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
                return AllocateNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BindingNodes.AllocateNode> getInstance() {
            if (allocateNodeFactoryInstance == null) {
                allocateNodeFactoryInstance = new AllocateNodeFactory();
            }
            return allocateNodeFactoryInstance;
        }

        public static BindingNodes.AllocateNode create(RubyContext context, SourceSection sourceSection, RubyNode operand) {
            return new AllocateNodeGen(context, sourceSection, operand);
        }

        @GeneratedBy(value=BindingNodes.AllocateNode.class)
        public static final class AllocateNodeGen
        extends BindingNodes.AllocateNode {
            @Node.Child
            private RubyNode operand_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private AllocateNodeGen(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection);
                this.operand_ = operand;
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject operandValue_;
                try {
                    operandValue_ = this.operand_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.allocate(operandValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object operandValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.operand_}, new Object[]{operandValue});
            }
        }
    }

    @GeneratedBy(value=BindingNodes.ReceiverNode.class)
    public static final class ReceiverNodeFactory
    extends NodeFactoryBase<BindingNodes.ReceiverNode> {
        private static ReceiverNodeFactory receiverNodeFactoryInstance;

        private ReceiverNodeFactory() {
            super(BindingNodes.ReceiverNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
        }

        public BindingNodes.ReceiverNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
                return ReceiverNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BindingNodes.ReceiverNode> getInstance() {
            if (receiverNodeFactoryInstance == null) {
                receiverNodeFactoryInstance = new ReceiverNodeFactory();
            }
            return receiverNodeFactoryInstance;
        }

        public static BindingNodes.ReceiverNode create(RubyContext context, SourceSection sourceSection, RubyNode operand) {
            return new ReceiverNodeGen(context, sourceSection, operand);
        }

        @GeneratedBy(value=BindingNodes.ReceiverNode.class)
        public static final class ReceiverNodeGen
        extends BindingNodes.ReceiverNode {
            @Node.Child
            private RubyNode operand_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ReceiverNodeGen(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection);
                this.operand_ = operand;
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject operandValue_;
                try {
                    operandValue_ = this.operand_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.receiver(operandValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object operandValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.operand_}, new Object[]{operandValue});
            }
        }
    }

    @GeneratedBy(value=BindingNodes.LocalVariablesNode.class)
    public static final class LocalVariablesNodeFactory
    extends NodeFactoryBase<BindingNodes.LocalVariablesNode> {
        private static LocalVariablesNodeFactory localVariablesNodeFactoryInstance;

        private LocalVariablesNodeFactory() {
            super(BindingNodes.LocalVariablesNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BindingNodes.LocalVariablesNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LocalVariablesNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BindingNodes.LocalVariablesNode> getInstance() {
            if (localVariablesNodeFactoryInstance == null) {
                localVariablesNodeFactoryInstance = new LocalVariablesNodeFactory();
            }
            return localVariablesNodeFactoryInstance;
        }

        public static BindingNodes.LocalVariablesNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new LocalVariablesNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BindingNodes.LocalVariablesNode.class)
        public static final class LocalVariablesNodeGen
        extends BindingNodes.LocalVariablesNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private LocalVariablesNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.localVariables(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=BindingNodes.LocalVariableSetNode.class)
    public static final class LocalVariableSetNodeFactory
    extends NodeFactoryBase<BindingNodes.LocalVariableSetNode> {
        private static LocalVariableSetNodeFactory localVariableSetNodeFactoryInstance;

        private LocalVariableSetNodeFactory() {
            super(BindingNodes.LocalVariableSetNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BindingNodes.LocalVariableSetNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LocalVariableSetNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BindingNodes.LocalVariableSetNode> getInstance() {
            if (localVariableSetNodeFactoryInstance == null) {
                localVariableSetNodeFactoryInstance = new LocalVariableSetNodeFactory();
            }
            return localVariableSetNodeFactoryInstance;
        }

        public static BindingNodes.LocalVariableSetNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new LocalVariableSetNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BindingNodes.LocalVariableSetNode.class)
        @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
        public static final class LocalVariableSetNodeGen
        extends BindingNodes.LocalVariableSetNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @Node.Child
            private BaseNode_ specialization_;

            private LocalVariableSetNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="localVariableSetLastLine(DynamicObject, DynamicObject, Object)", value=BindingNodes.LocalVariableSetNode.class)
            private static final class LocalVariableSetLastLineNode_
            extends BaseNode_ {
                LocalVariableSetLastLineNode_(LocalVariableSetNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubySymbol(arguments1Value_) && this.root.isLastLine(arguments1Value_)) {
                            return this.root.localVariableSetLastLine(arguments0Value_, arguments1Value_, arguments2Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(LocalVariableSetNodeGen root) {
                    return new LocalVariableSetLastLineNode_(root);
                }
            }

            @GeneratedBy(methodName="localVariableSetUncached(DynamicObject, DynamicObject, Object)", value=BindingNodes.LocalVariableSetNode.class)
            private static final class LocalVariableSetUncachedNode_
            extends BaseNode_ {
                LocalVariableSetUncachedNode_(LocalVariableSetNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubySymbol(arguments1Value_) && !this.root.isLastLine(arguments1Value_)) {
                            return this.root.localVariableSetUncached(arguments0Value_, arguments1Value_, arguments2Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(LocalVariableSetNodeGen root) {
                    return new LocalVariableSetUncachedNode_(root);
                }
            }

            @GeneratedBy(methodName="localVariableSetCached(DynamicObject, DynamicObject, Object, DynamicObject, FrameDescriptor, FrameSlotAndDepth, WriteFrameSlotNode)", value=BindingNodes.LocalVariableSetNode.class)
            private static final class LocalVariableSetCachedNode_
            extends BaseNode_ {
                private final DynamicObject cachedSymbol;
                private final FrameDescriptor cachedFrameDescriptor;
                private final BindingNodes.FrameSlotAndDepth cachedFrameSlot;
                @Node.Child
                private WriteFrameSlotNode writeLocalVariableNode;

                LocalVariableSetCachedNode_(LocalVariableSetNodeGen root, DynamicObject cachedSymbol, FrameDescriptor cachedFrameDescriptor, BindingNodes.FrameSlotAndDepth cachedFrameSlot, WriteFrameSlotNode writeLocalVariableNode) {
                    super(root, 1);
                    this.cachedSymbol = cachedSymbol;
                    this.cachedFrameDescriptor = cachedFrameDescriptor;
                    this.cachedFrameSlot = cachedFrameSlot;
                    this.writeLocalVariableNode = writeLocalVariableNode;
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubySymbol(arguments1Value_) && !this.root.isLastLine(arguments1Value_) && BindingNodes.getFrameDescriptor(arguments0Value_) == this.cachedFrameDescriptor && arguments1Value_ == this.cachedSymbol) {
                            return true;
                        }
                    }
                    return false;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubySymbol(arguments1Value_) && !this.root.isLastLine(arguments1Value_) && BindingNodes.getFrameDescriptor(arguments0Value_) == this.cachedFrameDescriptor && arguments1Value_ == this.cachedSymbol) {
                            return this.root.localVariableSetCached(arguments0Value_, arguments1Value_, arguments2Value, this.cachedSymbol, this.cachedFrameDescriptor, this.cachedFrameSlot, this.writeLocalVariableNode);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(LocalVariableSetNodeGen root, DynamicObject cachedSymbol, FrameDescriptor cachedFrameDescriptor, BindingNodes.FrameSlotAndDepth cachedFrameSlot, WriteFrameSlotNode writeLocalVariableNode) {
                    return new LocalVariableSetCachedNode_(root, cachedSymbol, cachedFrameDescriptor, cachedFrameSlot, writeLocalVariableNode);
                }
            }

            @GeneratedBy(value=BindingNodes.LocalVariableSetNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(LocalVariableSetNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(LocalVariableSetNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BindingNodes.LocalVariableSetNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(LocalVariableSetNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(LocalVariableSetNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BindingNodes.LocalVariableSetNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected LocalVariableSetNodeGen root;

                BaseNode_(LocalVariableSetNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (LocalVariableSetNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        WriteFrameSlotNode writeLocalVariableNode1;
                        BindingNodes.FrameSlotAndDepth cachedFrameSlot1;
                        BaseNode_ s;
                        DynamicObject arguments1Value_;
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject cachedSymbol1 = arguments1Value_ = (DynamicObject)arguments1Value;
                        FrameDescriptor cachedFrameDescriptor1 = BindingNodes.getFrameDescriptor(arguments0Value_);
                        if (RubyGuards.isRubySymbol(arguments1Value_) && !this.root.isLastLine(arguments1Value_) && BindingNodes.getFrameDescriptor(arguments0Value_) == cachedFrameDescriptor1 && arguments1Value_ == cachedSymbol1 && this.countSame(s = LocalVariableSetCachedNode_.create(this.root, cachedSymbol1, cachedFrameDescriptor1, cachedFrameSlot1 = this.root.findFrameSlot(arguments0Value_, arguments1Value_), writeLocalVariableNode1 = this.root.createWriteNode(cachedFrameSlot1))) < this.root.getCacheLimit()) {
                            return s;
                        }
                        if (RubyGuards.isRubySymbol(arguments1Value_) && !this.root.isLastLine(arguments1Value_)) {
                            return LocalVariableSetUncachedNode_.create(this.root);
                        }
                        if (RubyGuards.isRubySymbol(arguments1Value_) && this.root.isLastLine(arguments1Value_)) {
                            return LocalVariableSetLastLineNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=BindingNodes.LocalVariableGetNode.class)
    public static final class LocalVariableGetNodeFactory
    extends NodeFactoryBase<BindingNodes.LocalVariableGetNode> {
        private static LocalVariableGetNodeFactory localVariableGetNodeFactoryInstance;

        private LocalVariableGetNodeFactory() {
            super(BindingNodes.LocalVariableGetNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BindingNodes.LocalVariableGetNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LocalVariableGetNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BindingNodes.LocalVariableGetNode> getInstance() {
            if (localVariableGetNodeFactoryInstance == null) {
                localVariableGetNodeFactoryInstance = new LocalVariableGetNodeFactory();
            }
            return localVariableGetNodeFactoryInstance;
        }

        public static BindingNodes.LocalVariableGetNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new LocalVariableGetNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BindingNodes.LocalVariableGetNode.class)
        @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
        public static final class LocalVariableGetNodeGen
        extends BindingNodes.LocalVariableGetNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private LocalVariableGetNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="localVariableGetLastLine(DynamicObject, DynamicObject)", value=BindingNodes.LocalVariableGetNode.class)
            private static final class LocalVariableGetLastLineNode_
            extends BaseNode_ {
                LocalVariableGetLastLineNode_(LocalVariableGetNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubySymbol(arguments1Value_) && this.root.isLastLine(arguments1Value_)) {
                            return this.root.localVariableGetLastLine(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LocalVariableGetNodeGen root) {
                    return new LocalVariableGetLastLineNode_(root);
                }
            }

            @GeneratedBy(methodName="localVariableGetUncached(DynamicObject, DynamicObject)", value=BindingNodes.LocalVariableGetNode.class)
            private static final class LocalVariableGetUncachedNode_
            extends BaseNode_ {
                LocalVariableGetUncachedNode_(LocalVariableGetNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubySymbol(arguments1Value_) && !this.root.isLastLine(arguments1Value_)) {
                            return this.root.localVariableGetUncached(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LocalVariableGetNodeGen root) {
                    return new LocalVariableGetUncachedNode_(root);
                }
            }

            @GeneratedBy(methodName="localVariableGetCached(DynamicObject, DynamicObject, DynamicObject, DynamicObject, FrameSlotAndDepth, ReadFrameSlotNode)", value=BindingNodes.LocalVariableGetNode.class)
            private static final class LocalVariableGetCachedNode_
            extends BaseNode_ {
                private final DynamicObject cachedSymbol;
                private final DynamicObject cachedBinding;
                private final BindingNodes.FrameSlotAndDepth cachedFrameSlot;
                @Node.Child
                private ReadFrameSlotNode readLocalVariableNode;

                LocalVariableGetCachedNode_(LocalVariableGetNodeGen root, DynamicObject cachedSymbol, DynamicObject cachedBinding, BindingNodes.FrameSlotAndDepth cachedFrameSlot, ReadFrameSlotNode readLocalVariableNode) {
                    super(root, 1);
                    this.cachedSymbol = cachedSymbol;
                    this.cachedBinding = cachedBinding;
                    this.cachedFrameSlot = cachedFrameSlot;
                    this.readLocalVariableNode = readLocalVariableNode;
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubySymbol(arguments1Value_) && arguments1Value_ == this.cachedSymbol && this.root.compatibleFrames(arguments0Value_, this.cachedBinding)) {
                            assert (!this.root.isLastLine(this.cachedSymbol));
                            assert (this.cachedFrameSlot != null);
                            return true;
                        }
                    }
                    return false;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubySymbol(arguments1Value_) && arguments1Value_ == this.cachedSymbol && this.root.compatibleFrames(arguments0Value_, this.cachedBinding)) {
                            assert (!this.root.isLastLine(this.cachedSymbol));
                            assert (this.cachedFrameSlot != null);
                            return this.root.localVariableGetCached(arguments0Value_, arguments1Value_, this.cachedSymbol, this.cachedBinding, this.cachedFrameSlot, this.readLocalVariableNode);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LocalVariableGetNodeGen root, DynamicObject cachedSymbol, DynamicObject cachedBinding, BindingNodes.FrameSlotAndDepth cachedFrameSlot, ReadFrameSlotNode readLocalVariableNode) {
                    return new LocalVariableGetCachedNode_(root, cachedSymbol, cachedBinding, cachedFrameSlot, readLocalVariableNode);
                }
            }

            @GeneratedBy(value=BindingNodes.LocalVariableGetNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(LocalVariableGetNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LocalVariableGetNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BindingNodes.LocalVariableGetNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(LocalVariableGetNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LocalVariableGetNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BindingNodes.LocalVariableGetNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected LocalVariableGetNodeGen root;

                BaseNode_(LocalVariableGetNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (LocalVariableGetNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        ReadFrameSlotNode readLocalVariableNode1;
                        BaseNode_ s;
                        DynamicObject arguments1Value_;
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject cachedSymbol1 = arguments1Value_ = (DynamicObject)arguments1Value;
                        DynamicObject cachedBinding1 = arguments0Value_;
                        BindingNodes.FrameSlotAndDepth cachedFrameSlot1 = BindingNodes.findFrameSlotOrNull(arguments0Value_, arguments1Value_);
                        if (RubyGuards.isRubySymbol(arguments1Value_) && arguments1Value_ == cachedSymbol1 && !this.root.isLastLine(cachedSymbol1) && this.root.compatibleFrames(arguments0Value_, cachedBinding1) && cachedFrameSlot1 != null && this.countSame(s = LocalVariableGetCachedNode_.create(this.root, cachedSymbol1, cachedBinding1, cachedFrameSlot1, readLocalVariableNode1 = this.root.createReadNode(cachedFrameSlot1))) < this.root.getCacheLimit()) {
                            return s;
                        }
                        if (RubyGuards.isRubySymbol(arguments1Value_) && !this.root.isLastLine(arguments1Value_)) {
                            return LocalVariableGetUncachedNode_.create(this.root);
                        }
                        if (RubyGuards.isRubySymbol(arguments1Value_) && this.root.isLastLine(arguments1Value_)) {
                            return LocalVariableGetLastLineNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=BindingNodes.DupNode.class)
    public static final class DupNodeFactory
    extends NodeFactoryBase<BindingNodes.DupNode> {
        private static DupNodeFactory dupNodeFactoryInstance;

        private DupNodeFactory() {
            super(BindingNodes.DupNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
        }

        public BindingNodes.DupNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
                return DupNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BindingNodes.DupNode> getInstance() {
            if (dupNodeFactoryInstance == null) {
                dupNodeFactoryInstance = new DupNodeFactory();
            }
            return dupNodeFactoryInstance;
        }

        public static BindingNodes.DupNode create(RubyContext context, SourceSection sourceSection, RubyNode operand) {
            return new DupNodeGen(context, sourceSection, operand);
        }

        @GeneratedBy(value=BindingNodes.DupNode.class)
        public static final class DupNodeGen
        extends BindingNodes.DupNode {
            @Node.Child
            private RubyNode operand_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private DupNodeGen(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection);
                this.operand_ = operand;
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject operandValue_;
                try {
                    operandValue_ = this.operand_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.dup(operandValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object operandValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.operand_}, new Object[]{operandValue});
            }
        }
    }
}

