/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.format.nodes.read;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import java.nio.ByteBuffer;
import org.jcodings.Encoding;
import org.jruby.truffle.format.nodes.PackNode;
import org.jruby.truffle.format.nodes.SourceNode;
import org.jruby.truffle.format.runtime.exceptions.FormatException;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.util.ByteList;
import org.jruby.util.Pack;

@NodeChildren(value={@NodeChild(value="value", type=SourceNode.class)})
public abstract class ReadBase64StringNode
extends PackNode {
    public ReadBase64StringNode(RubyContext context) {
        super(context);
    }

    @Specialization
    public Object read(VirtualFrame frame, byte[] source) {
        ByteBuffer encode = ByteBuffer.wrap(source, this.getSourcePosition(frame), this.getSourceLength(frame) - this.getSourcePosition(frame));
        int occurrences = encode.remaining();
        int length = encode.remaining() * 3 / 4;
        byte[] lElem = new byte[length];
        int a = -1;
        int b = -1;
        int c = 0;
        int index = 0;
        int s = -1;
        if (occurrences == 0) {
            if (encode.remaining() % 4 != 0) {
                throw new FormatException("invalid base64");
            }
            while (encode.hasRemaining() && s != 61) {
                c = -1;
                b = -1;
                a = -1;
                int d = -2;
                s = Pack.safeGet((ByteBuffer)encode);
                a = Pack.b64_xtable[s];
                if (a == -1) {
                    throw new FormatException("invalid base64");
                }
                s = Pack.safeGet((ByteBuffer)encode);
                b = Pack.b64_xtable[s];
                if (b == -1) {
                    throw new FormatException("invalid base64");
                }
                s = Pack.safeGet((ByteBuffer)encode);
                c = Pack.b64_xtable[s];
                if (s == 61) {
                    if (Pack.safeGet((ByteBuffer)encode) == 61) break;
                    throw new FormatException("invalid base64");
                }
                if (c == -1) {
                    throw new FormatException("invalid base64");
                }
                s = Pack.safeGet((ByteBuffer)encode);
                d = Pack.b64_xtable[s];
                if (s == 61) break;
                if (d == -1) {
                    throw new FormatException("invalid base64");
                }
                lElem[index++] = (byte)((a << 2 | b >> 4) & 0xFF);
                lElem[index++] = (byte)((b << 4 | c >> 2) & 0xFF);
                lElem[index++] = (byte)((c << 6 | d) & 0xFF);
            }
            if (encode.hasRemaining()) {
                throw new FormatException("invalid base64");
            }
            if (a != -1 && b != -1) {
                if (c == -1 && s == 61) {
                    if ((b & 0xF) != 0) {
                        throw new FormatException("invalid base64");
                    }
                    lElem[index++] = (byte)((a << 2 | b >> 4) & 0xFF);
                } else if (c != -1 && s == 61) {
                    if ((c & 3) != 0) {
                        throw new FormatException("invalid base64");
                    }
                    lElem[index++] = (byte)((a << 2 | b >> 4) & 0xFF);
                    lElem[index++] = (byte)((b << 4 | c >> 2) & 0xFF);
                }
            }
        } else {
            while (encode.hasRemaining()) {
                int d = -1;
                c = -1;
                b = -1;
                a = -1;
                s = Pack.safeGet((ByteBuffer)encode);
                while ((a = Pack.b64_xtable[s]) == -1 && encode.hasRemaining()) {
                    s = Pack.safeGet((ByteBuffer)encode);
                }
                if (a == -1) break;
                s = Pack.safeGet((ByteBuffer)encode);
                while ((b = Pack.b64_xtable[s]) == -1 && encode.hasRemaining()) {
                    s = Pack.safeGet((ByteBuffer)encode);
                }
                if (b == -1) break;
                s = Pack.safeGet((ByteBuffer)encode);
                while ((c = Pack.b64_xtable[s]) == -1 && encode.hasRemaining() && s != 61) {
                    s = Pack.safeGet((ByteBuffer)encode);
                }
                if (s == 61 || c == -1) {
                    if (s != 61) break;
                    encode.position(encode.position() - 1);
                    break;
                }
                s = Pack.safeGet((ByteBuffer)encode);
                while ((d = Pack.b64_xtable[s]) == -1 && encode.hasRemaining() && s != 61) {
                    s = Pack.safeGet((ByteBuffer)encode);
                }
                if (s == 61 || d == -1) {
                    if (s != 61) break;
                    encode.position(encode.position() - 1);
                    break;
                }
                lElem[index++] = (byte)((a << 2 | b >> 4) & 0xFF);
                lElem[index++] = (byte)((b << 4 | c >> 2) & 0xFF);
                lElem[index++] = (byte)((c << 6 | d) & 0xFF);
            }
            if (a != -1 && b != -1) {
                if (c == -1 && s == 61) {
                    lElem[index++] = (byte)((a << 2 | b >> 4) & 0xFF);
                } else if (c != -1 && s == 61) {
                    lElem[index++] = (byte)((a << 2 | b >> 4) & 0xFF);
                    lElem[index++] = (byte)((b << 4 | c >> 2) & 0xFF);
                }
            }
        }
        Encoding encoding = Encoding.load((String)"ASCII");
        ByteList result = new ByteList(lElem, 0, index, encoding, false);
        this.setSourcePosition(frame, encode.position());
        return Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), result, 0, null);
    }
}

