/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.format.nodes.read;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.jruby.truffle.format.nodes.PackNode;
import org.jruby.truffle.format.nodes.SourceNode;
import org.jruby.truffle.nodes.core.FixnumOrBignumNode;
import org.jruby.truffle.runtime.RubyContext;

@NodeChildren(value={@NodeChild(value="source", type=SourceNode.class)})
public abstract class ReadBERNode
extends PackNode {
    @Node.Child
    private FixnumOrBignumNode fixnumOrBignumNode;

    public ReadBERNode(RubyContext context) {
        super(context);
        this.fixnumOrBignumNode = FixnumOrBignumNode.create(context, null);
    }

    @Specialization
    protected Object encode(VirtualFrame frame, byte[] source) {
        CompilerDirectives.transferToInterpreter();
        ByteBuffer encode = ByteBuffer.wrap(source, this.getSourcePosition(frame), this.getSourceLength(frame) - this.getSourcePosition(frame));
        long ul = 0L;
        long ulmask = -33554432L;
        BigInteger big128 = BigInteger.valueOf(128L);
        int pos = encode.position();
        ul <<= 7;
        ul |= (long)(encode.get(pos) & 0x7F);
        if ((encode.get(pos++) & 0x80) == 0) {
            this.setSourcePosition(frame, this.getSourcePosition(frame) + pos);
            return ul;
        }
        if ((ul & ulmask) == 0L) {
            BigInteger big = BigInteger.valueOf(ul);
            while (pos < encode.limit()) {
                BigInteger v;
                BigInteger mulResult = big.multiply(big128);
                big = v = mulResult.add(BigInteger.valueOf(encode.get(pos) & 0x7F));
                if ((encode.get(pos++) & 0x80) != 0) continue;
                this.setSourcePosition(frame, this.getSourcePosition(frame) + pos);
                return this.fixnumOrBignumNode.fixnumOrBignum(big);
            }
        }
        try {
            encode.position(pos);
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }
}

