/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.methods;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.ReturnID;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.BreakException;
import org.jruby.truffle.runtime.control.NextException;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.control.RedoException;
import org.jruby.truffle.runtime.control.RetryException;
import org.jruby.truffle.runtime.control.ReturnException;

public class CatchForLambdaNode
extends RubyNode {
    @Node.Child
    private RubyNode body;
    private final ReturnID returnID;
    private final BranchProfile returnProfile = BranchProfile.create();
    private final ConditionProfile matchingReturnProfile = ConditionProfile.createBinaryProfile();
    private final BranchProfile redoProfile = BranchProfile.create();
    private final BranchProfile nextProfile = BranchProfile.create();
    private final BranchProfile breakProfile = BranchProfile.create();

    public CatchForLambdaNode(RubyContext context, SourceSection sourceSection, RubyNode body, ReturnID returnID) {
        super(context, sourceSection);
        this.body = body;
        this.returnID = returnID;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        while (true) {
            try {
                return this.body.execute(frame);
            }
            catch (ReturnException e) {
                this.returnProfile.enter();
                if (this.matchingReturnProfile.profile(e.getReturnID() == this.returnID)) {
                    return e.getValue();
                }
                throw e;
            }
            catch (RetryException e) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().syntaxError("Invalid retry", this));
            }
            catch (RedoException e) {
                this.redoProfile.enter();
                this.getContext().getSafepointManager().poll(this);
                continue;
            }
            catch (NextException e) {
                this.nextProfile.enter();
                return e.getResult();
            }
            catch (BreakException e) {
                this.breakProfile.enter();
                return e.getResult();
            }
            break;
        }
    }
}

