/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.KernelNodes;
import org.jruby.truffle.nodes.core.KernelNodesFactory;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.dispatch.MissingBehavior;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;

@NodeChild(value="value", type=RubyNode.class)
public abstract class NumericToFloatNode
extends RubyNode {
    @Node.Child
    private KernelNodes.IsANode isANode;
    @Node.Child
    CallDispatchHeadNode toFloatCallNode;
    private final String method;

    public NumericToFloatNode(RubyContext context, SourceSection sourceSection, String method) {
        super(context, sourceSection);
        this.isANode = KernelNodesFactory.IsANodeFactory.create(context, sourceSection, new RubyNode[]{null, null});
        this.method = method;
    }

    public abstract double executeDouble(VirtualFrame var1, DynamicObject var2);

    private Object callToFloat(VirtualFrame frame, DynamicObject value) {
        if (this.toFloatCallNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toFloatCallNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), MissingBehavior.RETURN_MISSING));
        }
        return this.toFloatCallNode.call(frame, value, this.method, null, new Object[0]);
    }

    @Specialization(guards={"isNumeric(frame, value)"})
    protected double castNumeric(VirtualFrame frame, DynamicObject value) {
        Object result = this.callToFloat(frame, value);
        if (result instanceof Double) {
            return (Double)result;
        }
        CompilerDirectives.transferToInterpreter();
        throw new RaiseException(this.getContext().getCoreLibrary().typeErrorCantConvertTo(value, "Float", this.method, result, this));
    }

    @Fallback
    protected double fallback(Object value) {
        CompilerDirectives.transferToInterpreter();
        throw new RaiseException(this.getContext().getCoreLibrary().typeErrorCantConvertInto(value, "Float", this));
    }

    protected boolean isNumeric(VirtualFrame frame, Object value) {
        return this.isANode.executeIsA(frame, value, this.getContext().getCoreLibrary().getNumericClass());
    }
}

