/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.objects.ReadInstanceVariableNode;
import org.jruby.truffle.nodes.objectstorage.WriteHeadObjectFieldNode;
import org.jruby.truffle.nodes.objectstorage.WriteHeadObjectFieldNodeGen;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.translator.WriteNode;

public class WriteInstanceVariableNode
extends RubyNode
implements WriteNode {
    @Node.Child
    private RubyNode receiver;
    @Node.Child
    private RubyNode rhs;
    @Node.Child
    private WriteHeadObjectFieldNode writeNode;
    private final boolean isGlobal;

    public WriteInstanceVariableNode(RubyContext context, SourceSection sourceSection, String name, RubyNode receiver, RubyNode rhs, boolean isGlobal) {
        super(context, sourceSection);
        this.receiver = receiver;
        this.rhs = rhs;
        this.writeNode = WriteHeadObjectFieldNodeGen.create(name);
        this.isGlobal = isGlobal;
    }

    @Override
    public int executeInteger(VirtualFrame frame) throws UnexpectedResultException {
        Object object = this.receiver.execute(frame);
        if (object instanceof DynamicObject) {
            try {
                int value = this.rhs.executeInteger(frame);
                this.writeNode.execute((DynamicObject)object, value);
                return value;
            }
            catch (UnexpectedResultException e) {
                this.writeNode.execute((DynamicObject)object, e.getResult());
                throw e;
            }
        }
        CompilerDirectives.transferToInterpreter();
        throw new RaiseException(this.getContext().getCoreLibrary().frozenError(Layouts.MODULE.getFields(this.getContext().getCoreLibrary().getLogicalClass(object)).getName(), this));
    }

    @Override
    public long executeLong(VirtualFrame frame) throws UnexpectedResultException {
        Object object = this.receiver.execute(frame);
        if (object instanceof DynamicObject) {
            try {
                long value = this.rhs.executeLong(frame);
                this.writeNode.execute((DynamicObject)object, value);
                return value;
            }
            catch (UnexpectedResultException e) {
                this.writeNode.execute((DynamicObject)object, e.getResult());
                throw e;
            }
        }
        CompilerDirectives.transferToInterpreter();
        throw new RaiseException(this.getContext().getCoreLibrary().frozenError(Layouts.MODULE.getFields(this.getContext().getCoreLibrary().getLogicalClass(object)).getName(), this));
    }

    @Override
    public double executeDouble(VirtualFrame frame) throws UnexpectedResultException {
        Object object = this.receiver.execute(frame);
        if (object instanceof DynamicObject) {
            try {
                double value = this.rhs.executeDouble(frame);
                this.writeNode.execute((DynamicObject)object, value);
                return value;
            }
            catch (UnexpectedResultException e) {
                this.writeNode.execute((DynamicObject)object, e.getResult());
                throw e;
            }
        }
        CompilerDirectives.transferToInterpreter();
        throw new RaiseException(this.getContext().getCoreLibrary().frozenError(Layouts.MODULE.getFields(this.getContext().getCoreLibrary().getLogicalClass(object)).getName(), this));
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object object = this.receiver.execute(frame);
        Object value = this.rhs.execute(frame);
        if (!(object instanceof DynamicObject)) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().frozenError(Layouts.MODULE.getFields(this.getContext().getCoreLibrary().getLogicalClass(object)).getName(), this));
        }
        this.writeNode.execute((DynamicObject)object, value);
        return value;
    }

    @Override
    public RubyNode makeReadNode() {
        return new ReadInstanceVariableNode(this.getContext(), this.getSourceSection(), (String)this.writeNode.getName(), this.receiver, this.isGlobal);
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        return this.create7BitString(StringOperations.encodeByteList("assignment", (Encoding)UTF8Encoding.INSTANCE));
    }
}

