/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.exceptions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.exceptions.MainExitException;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.IntegerCastNode;
import org.jruby.truffle.nodes.cast.IntegerCastNodeGen;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.subsystems.AtExitManager;

public class TopLevelRaiseHandler
extends RubyNode {
    @Node.Child
    private RubyNode body;
    @Node.Child
    private IntegerCastNode integerCastNode;

    public TopLevelRaiseHandler(RubyContext context, SourceSection sourceSection, RubyNode body) {
        super(context, sourceSection);
        this.body = body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(VirtualFrame frame) {
        DynamicObject lastException = null;
        try {
            this.body.execute(frame);
        }
        catch (RaiseException e) {
            lastException = AtExitManager.handleAtExitException(this.getContext(), e);
            return lastException;
        }
        finally {
            DynamicObject atExitException = this.getContext().runAtExitHooks();
            if (atExitException != null) {
                lastException = atExitException;
            }
            this.getContext().shutdown();
            throw new MainExitException(this.statusFromException(lastException));
        }
    }

    private int statusFromException(DynamicObject exception) {
        if (exception == null) {
            return 0;
        }
        if (Layouts.BASIC_OBJECT.getLogicalClass(exception) == this.getContext().getCoreLibrary().getSystemExitClass()) {
            return this.castToInt(exception.get((Object)"@status", null));
        }
        return 1;
    }

    private int castToInt(Object value) {
        if (this.integerCastNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.integerCastNode = (IntegerCastNode)this.insert(IntegerCastNodeGen.create(this.getContext(), this.getSourceSection(), null));
        }
        return this.integerCastNode.executeCastInt(value);
    }
}

