/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayGuards;
import org.jruby.truffle.nodes.core.array.EnsureCapacityArrayNode;
import org.jruby.truffle.nodes.core.array.EnsureCapacityArrayNodeGen;
import org.jruby.truffle.nodes.core.array.GeneralizeArrayNode;
import org.jruby.truffle.nodes.core.array.GeneralizeArrayNodeGen;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.layouts.Layouts;

@ImportStatic(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array", type=RubyNode.class), @NodeChild(value="index", type=RubyNode.class), @NodeChild(value="value", type=RubyNode.class)})
public abstract class ArrayWriteNormalizedNode
extends RubyNode {
    @Node.Child
    private EnsureCapacityArrayNode ensureCapacityNode;
    @Node.Child
    private GeneralizeArrayNode generalizeNode;

    public ArrayWriteNormalizedNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.ensureCapacityNode = EnsureCapacityArrayNodeGen.create(context, sourceSection, null, null);
        this.generalizeNode = GeneralizeArrayNodeGen.create(context, sourceSection, null, null);
    }

    public abstract Object executeWrite(VirtualFrame var1, DynamicObject var2, int var3, Object var4);

    @Specialization(guards={"isRubyArray(array)", "isNullArray(array)", "index == 0"})
    public boolean writeNull0(DynamicObject array, int index, boolean value) {
        Layouts.ARRAY.setStore(array, new Object[]{value});
        Layouts.ARRAY.setSize(array, 1);
        return value;
    }

    @Specialization(guards={"isRubyArray(array)", "isNullArray(array)", "index == 0"})
    public int writeNull0(DynamicObject array, int index, int value) {
        Layouts.ARRAY.setStore(array, new int[]{value});
        Layouts.ARRAY.setSize(array, 1);
        return value;
    }

    @Specialization(guards={"isRubyArray(array)", "isNullArray(array)", "index == 0"})
    public long writeNull0(DynamicObject array, int index, long value) {
        Layouts.ARRAY.setStore(array, new long[]{value});
        Layouts.ARRAY.setSize(array, 1);
        return value;
    }

    @Specialization(guards={"isRubyArray(array)", "isNullArray(array)", "index == 0"})
    public double writeNull0(DynamicObject array, int index, double value) {
        Layouts.ARRAY.setStore(array, new double[]{value});
        Layouts.ARRAY.setSize(array, 1);
        return value;
    }

    @Specialization(guards={"isRubyArray(array)", "isNullArray(array)", "index == 0"})
    public DynamicObject writeNull0(DynamicObject array, int index, DynamicObject value) {
        Layouts.ARRAY.setStore(array, new Object[]{value});
        Layouts.ARRAY.setSize(array, 1);
        return value;
    }

    @Specialization(guards={"isRubyArray(array)", "isNullArray(array)", "index != 0"})
    public Object writeNullBeyond(DynamicObject array, int index, Object value) {
        Object[] store = new Object[index + 1];
        for (int n = 0; n < index; ++n) {
            store[n] = this.nil();
        }
        store[index] = value;
        Layouts.ARRAY.setStore(array, store);
        Layouts.ARRAY.setSize(array, store.length);
        return value;
    }

    @Specialization(guards={"isRubyArray(array)", "isIntArray(array)", "isInBounds(array, index)"})
    public int writeWithin(DynamicObject array, int index, int value) {
        int[] store = (int[])Layouts.ARRAY.getStore(array);
        store[index] = value;
        return value;
    }

    @Specialization(guards={"isRubyArray(array)", "isLongArray(array)", "isInBounds(array, index)"})
    public long writeWithin(DynamicObject array, int index, long value) {
        long[] store = (long[])Layouts.ARRAY.getStore(array);
        store[index] = value;
        return value;
    }

    @Specialization(guards={"isRubyArray(array)", "isDoubleArray(array)", "isInBounds(array, index)"})
    public double writeWithin(DynamicObject array, int index, double value) {
        double[] store = (double[])Layouts.ARRAY.getStore(array);
        store[index] = value;
        return value;
    }

    @Specialization(guards={"isRubyArray(array)", "isObjectArray(array)", "isInBounds(array, index)"})
    public Object writeWithin(DynamicObject array, int index, Object value) {
        Object[] store = (Object[])Layouts.ARRAY.getStore(array);
        store[index] = value;
        return value;
    }

    @Specialization(guards={"isRubyArray(array)", "isIntArray(array)", "isInBounds(array, index)"})
    public long writeWithinInt(DynamicObject array, int index, long value) {
        int[] intStore = (int[])Layouts.ARRAY.getStore(array);
        long[] longStore = new long[Layouts.ARRAY.getSize(array)];
        for (int n = 0; n < Layouts.ARRAY.getSize(array); ++n) {
            longStore[n] = intStore[n];
        }
        longStore[index] = value;
        Layouts.ARRAY.setStore(array, longStore);
        Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array));
        return value;
    }

    @Specialization(guards={"isRubyArray(array)", "isIntArray(array)", "isInBounds(array, index)", "!isInteger(value)", "!isLong(value)"})
    public Object writeWithinInt(DynamicObject array, int index, Object value) {
        Object[] objectStore = ArrayUtils.box((int[])Layouts.ARRAY.getStore(array));
        objectStore[index] = value;
        Layouts.ARRAY.setStore(array, objectStore);
        Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array));
        return value;
    }

    @Specialization(guards={"isRubyArray(array)", "isLongArray(array)", "isInBounds(array, index)", "!isInteger(value)", "!isLong(value)"})
    public Object writeWithinLong(DynamicObject array, int index, Object value) {
        Object[] objectStore = ArrayUtils.box((long[])Layouts.ARRAY.getStore(array));
        objectStore[index] = value;
        Layouts.ARRAY.setStore(array, objectStore);
        Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array));
        return value;
    }

    @Specialization(guards={"isRubyArray(array)", "isDoubleArray(array)", "isInBounds(array, index)", "!isDouble(value)"})
    public Object writeWithinDouble(DynamicObject array, int index, Object value) {
        Object[] objectStore = ArrayUtils.box((double[])Layouts.ARRAY.getStore(array));
        objectStore[index] = value;
        Layouts.ARRAY.setStore(array, objectStore);
        Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array));
        return value;
    }

    @Specialization(guards={"isRubyArray(array)", "isIntArray(array)", "isExtendingByOne(array, index)"})
    public int writeExtendByOne(VirtualFrame frame, DynamicObject array, int index, int value) {
        this.ensureCapacityNode.executeEnsureCapacity(frame, array, index + 1);
        ((int[])Layouts.ARRAY.getStore((DynamicObject)array))[index] = value;
        Layouts.ARRAY.setSize(array, index + 1);
        return value;
    }

    @Specialization(guards={"isRubyArray(array)", "isLongArray(array)", "isExtendingByOne(array, index)"})
    public long writeExtendByOne(VirtualFrame frame, DynamicObject array, int index, long value) {
        this.ensureCapacityNode.executeEnsureCapacity(frame, array, index + 1);
        ((long[])Layouts.ARRAY.getStore((DynamicObject)array))[index] = value;
        Layouts.ARRAY.setSize(array, index + 1);
        return value;
    }

    @Specialization(guards={"isRubyArray(array)", "isDoubleArray(array)", "isExtendingByOne(array, index)"})
    public double writeExtendByOne(VirtualFrame frame, DynamicObject array, int index, double value) {
        this.ensureCapacityNode.executeEnsureCapacity(frame, array, index + 1);
        ((double[])Layouts.ARRAY.getStore((DynamicObject)array))[index] = value;
        Layouts.ARRAY.setSize(array, index + 1);
        return value;
    }

    @Specialization(guards={"isRubyArray(array)", "isObjectArray(array)", "isExtendingByOne(array, index)"})
    public Object writeExtendByOne(VirtualFrame frame, DynamicObject array, int index, Object value) {
        this.ensureCapacityNode.executeEnsureCapacity(frame, array, index + 1);
        ((Object[])Layouts.ARRAY.getStore((DynamicObject)array))[index] = value;
        Layouts.ARRAY.setSize(array, index + 1);
        return value;
    }

    @Specialization(guards={"isRubyArray(array)", "!isObjectArray(array)", "!isInBounds(array, index)", "!isExtendingByOne(array, index)"})
    public Object writeBeyondPrimitive(VirtualFrame frame, DynamicObject array, int index, Object value) {
        this.generalizeNode.executeGeneralize(frame, array, index + 1);
        Object[] objectStore = (Object[])Layouts.ARRAY.getStore(array);
        for (int n = Layouts.ARRAY.getSize(array); n < index; ++n) {
            objectStore[n] = this.nil();
        }
        objectStore[index] = value;
        Layouts.ARRAY.setSize(array, index + 1);
        return value;
    }

    @Specialization(guards={"isRubyArray(array)", "isObjectArray(array)", "!isInBounds(array, index)", "!isExtendingByOne(array, index)"})
    public Object writeBeyondObject(VirtualFrame frame, DynamicObject array, int index, Object value) {
        this.ensureCapacityNode.executeEnsureCapacity(frame, array, index + 1);
        Object[] objectStore = (Object[])Layouts.ARRAY.getStore(array);
        for (int n = Layouts.ARRAY.getSize(array); n < index; ++n) {
            objectStore[n] = this.nil();
        }
        objectStore[index] = value;
        Layouts.ARRAY.setSize(array, index + 1);
        return value;
    }

    protected static boolean isInBounds(DynamicObject array, int index) {
        return index >= 0 && index < Layouts.ARRAY.getSize(array);
    }

    protected static boolean isExtendingByOne(DynamicObject array, int index) {
        return index == Layouts.ARRAY.getSize(array);
    }
}

