/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.layouts;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.Layout;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import org.jruby.truffle.runtime.RubyObjectType;
import org.jruby.truffle.runtime.layouts.BasicObjectLayout;

public class BasicObjectLayoutImpl
implements BasicObjectLayout {
    public static final BasicObjectLayout INSTANCE = new BasicObjectLayoutImpl();
    protected static final Layout LAYOUT = Layout.createLayout((EnumSet)Layout.INT_TO_LONG);
    protected static final Shape.Allocator BASIC_OBJECT_ALLOCATOR = LAYOUT.createAllocator();

    protected BasicObjectLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createBasicObjectShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape((ObjectType)new BasicObjectType(logicalClass, metaClass)).createFactory();
    }

    @Override
    public DynamicObject createBasicObject(DynamicObjectFactory factory) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant((Object)factory);
        assert (this.createsBasicObject(factory));
        return factory.newInstance(new Object[0]);
    }

    @Override
    public boolean isBasicObject(Object object) {
        return object instanceof DynamicObject && this.isBasicObject((DynamicObject)object);
    }

    private boolean isBasicObject(DynamicObject object) {
        return this.isBasicObject(object.getShape().getObjectType());
    }

    private boolean isBasicObject(ObjectType objectType) {
        return objectType instanceof BasicObjectType;
    }

    private boolean createsBasicObject(DynamicObjectFactory factory) {
        return this.isBasicObject(factory.getShape().getObjectType());
    }

    @Override
    public DynamicObject getLogicalClass(ObjectType objectType) {
        assert (this.isBasicObject(objectType));
        return ((BasicObjectType)objectType).getLogicalClass();
    }

    @Override
    public DynamicObject getLogicalClass(DynamicObject object) {
        assert (this.isBasicObject(object));
        return this.getObjectType(object).getLogicalClass();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public DynamicObjectFactory setLogicalClass(DynamicObjectFactory factory, DynamicObject value) {
        assert (this.createsBasicObject(factory));
        Shape shape = factory.getShape();
        return shape.changeType((ObjectType)((BasicObjectType)shape.getObjectType()).setLogicalClass(value)).createFactory();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void setLogicalClass(DynamicObject object, DynamicObject value) {
        assert (this.isBasicObject(object));
        Shape shape = object.getShape();
        object.setShapeAndResize(shape, shape.changeType((ObjectType)this.getObjectType(object).setLogicalClass(value)));
    }

    @Override
    public DynamicObject getMetaClass(DynamicObject object) {
        assert (this.isBasicObject(object));
        return this.getObjectType(object).getMetaClass();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public DynamicObjectFactory setMetaClass(DynamicObjectFactory factory, DynamicObject value) {
        assert (this.createsBasicObject(factory));
        Shape shape = factory.getShape();
        return shape.changeType((ObjectType)((BasicObjectType)shape.getObjectType()).setMetaClass(value)).createFactory();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void setMetaClass(DynamicObject object, DynamicObject value) {
        assert (this.isBasicObject(object));
        Shape shape = object.getShape();
        object.setShapeAndResize(shape, shape.changeType((ObjectType)this.getObjectType(object).setMetaClass(value)));
    }

    private BasicObjectType getObjectType(DynamicObject object) {
        assert (this.isBasicObject(object));
        return (BasicObjectType)object.getShape().getObjectType();
    }

    protected static class BasicObjectType
    extends RubyObjectType {
        protected final DynamicObject logicalClass;
        protected final DynamicObject metaClass;

        public BasicObjectType(DynamicObject logicalClass, DynamicObject metaClass) {
            this.logicalClass = logicalClass;
            this.metaClass = metaClass;
        }

        public DynamicObject getLogicalClass() {
            return this.logicalClass;
        }

        public BasicObjectType setLogicalClass(DynamicObject logicalClass) {
            return new BasicObjectType(logicalClass, this.metaClass);
        }

        public DynamicObject getMetaClass() {
            return this.metaClass;
        }

        public BasicObjectType setMetaClass(DynamicObject metaClass) {
            return new BasicObjectType(this.logicalClass, metaClass);
        }
    }
}

