/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.math.BigInteger;
import java.util.Random;
import org.jruby.RubyRandom;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;

public abstract class RandomizerPrimitiveNodes {
    @CompilerDirectives.TruffleBoundary
    private static int randomInt(org.jruby.util.Random random) {
        return random.genrandInt32();
    }

    @RubiniusPrimitive(name="randomizer_gen_seed")
    public static abstract class RandomizerGenSeedPrimitiveNode
    extends RubiniusPrimitiveNode {
        public RandomizerGenSeedPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject randomizerGenSeed(DynamicObject randomizerClass) {
            BigInteger seed = RubyRandom.randomSeedBigInteger((Random)this.getContext().getRuntime().getRandom());
            return Layouts.BIGNUM.createBignum(this.getContext().getCoreLibrary().getBignumFactory(), seed);
        }
    }

    @RubiniusPrimitive(name="randomizer_rand_int")
    public static abstract class RandomizerRandIntPrimitiveNode
    extends RubiniusPrimitiveNode {
        public RandomizerRandIntPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int randomizerRandInt(DynamicObject randomizer, int limit) {
            org.jruby.util.Random r = Layouts.RANDOMIZER.getRandom(randomizer);
            return (int)RandomizerRandIntPrimitiveNode.randInt(r, limit);
        }

        @Specialization
        public long randomizerRandInt(DynamicObject randomizer, long limit) {
            org.jruby.util.Random r = Layouts.RANDOMIZER.getRandom(randomizer);
            return RandomizerRandIntPrimitiveNode.randInt(r, limit);
        }

        @CompilerDirectives.TruffleBoundary
        protected static long randInt(org.jruby.util.Random r, long limit) {
            return RubyRandom.randLimitedFixnumInner((org.jruby.util.Random)r, (long)limit);
        }
    }

    @RubiniusPrimitive(name="randomizer_rand_float")
    public static abstract class RandomizerRandFloatPrimitiveNode
    extends RubiniusPrimitiveNode {
        public RandomizerRandFloatPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public double randomizerRandFloat(DynamicObject randomizer) {
            org.jruby.util.Random r = Layouts.RANDOMIZER.getRandom(randomizer);
            int a = RandomizerPrimitiveNodes.randomInt(r) >>> 5;
            int b = RandomizerPrimitiveNodes.randomInt(r) >>> 6;
            return ((double)a * 6.7108864E7 + (double)b) * (double)1.110223E-16f;
        }
    }

    @RubiniusPrimitive(name="randomizer_seed")
    public static abstract class RandomizerSeedPrimitiveNode
    extends RubiniusPrimitiveNode {
        public RandomizerSeedPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyBignum(seed)"})
        public DynamicObject randomizerSeed(DynamicObject randomizer, DynamicObject seed) {
            Layouts.RANDOMIZER.setRandom(randomizer, RandomizerSeedPrimitiveNode.randomFromBigInteger(Layouts.BIGNUM.getValue(seed)));
            return randomizer;
        }

        @Specialization
        public DynamicObject randomizerSeed(DynamicObject randomizer, long seed) {
            Layouts.RANDOMIZER.setRandom(randomizer, RandomizerSeedPrimitiveNode.randomFromLong(seed));
            return randomizer;
        }

        @CompilerDirectives.TruffleBoundary
        protected static org.jruby.util.Random randomFromBigInteger(BigInteger seed) {
            return RubyRandom.RandomType.randomFromBigInteger((BigInteger)seed);
        }

        @CompilerDirectives.TruffleBoundary
        protected static org.jruby.util.Random randomFromLong(long seed) {
            return RubyRandom.RandomType.randomFromLong((long)seed);
        }
    }

    @RubiniusPrimitive(name="randomizer_allocate", needsSelf=false)
    public static abstract class RandomizerAllocatePrimitiveNode
    extends RubiniusPrimitiveNode {
        public RandomizerAllocatePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject randomizerAllocate() {
            return Layouts.RANDOMIZER.createRandomizer(this.getContext().getCoreLibrary().getRandomizerFactory(), new org.jruby.util.Random());
        }
    }
}

