/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.joni.Matcher;
import org.joni.NameEntry;
import org.joni.Regex;
import org.joni.Region;
import org.joni.Syntax;
import org.joni.exception.SyntaxException;
import org.joni.exception.ValueException;
import org.jruby.Ruby;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.coerce.ToStrNode;
import org.jruby.truffle.nodes.coerce.ToStrNodeGen;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyCallStack;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.util.ByteList;
import org.jruby.util.CodeRangeable;
import org.jruby.util.RegexpOptions;
import org.jruby.util.RegexpSupport;

@CoreClass(name="Regexp")
public abstract class RegexpNodes {
    @CompilerDirectives.TruffleBoundary
    public static Object matchCommon(RubyContext context, DynamicObject regexp, DynamicObject source, boolean operator, boolean setNamedCaptures, int startPos) {
        assert (RubyGuards.isRubyRegexp(regexp));
        assert (RubyGuards.isRubyString(source));
        ByteList sourceByteList = StringOperations.getByteList(source);
        ByteList bl = Layouts.REGEXP.getSource(regexp);
        Encoding enc = RegexpNodes.checkEncoding(regexp, StringOperations.getCodeRangeable(source), true);
        ByteList preprocessed = RegexpSupport.preprocess((Ruby)context.getRuntime(), (ByteList)bl, (Encoding)enc, (Encoding[])new Encoding[]{null}, (RegexpSupport.ErrorMode)RegexpSupport.ErrorMode.RAISE);
        Regex r = new Regex(preprocessed.getUnsafeBytes(), preprocessed.getBegin(), preprocessed.getBegin() + preprocessed.getRealSize(), Layouts.REGEXP.getOptions(regexp).toJoniOptions(), RegexpNodes.checkEncoding(regexp, StringOperations.getCodeRangeable(source), true));
        Matcher matcher = r.matcher(sourceByteList.unsafeBytes(), sourceByteList.begin(), sourceByteList.begin() + sourceByteList.realSize());
        int range = sourceByteList.begin() + sourceByteList.realSize();
        return RegexpNodes.matchCommon(context, regexp, source, operator, setNamedCaptures, matcher, sourceByteList.begin() + startPos, range);
    }

    @CompilerDirectives.TruffleBoundary
    public static Object matchCommon(RubyContext context, DynamicObject regexp, DynamicObject source, boolean operator, boolean setNamedCaptures, Matcher matcher, int startPos, int range) {
        assert (RubyGuards.isRubyRegexp(regexp));
        assert (RubyGuards.isRubyString(source));
        ByteList bytes = StringOperations.getByteList(source);
        Frame frame = RubyCallStack.getCallerFrame(context).getFrame(FrameInstance.FrameAccess.READ_WRITE, true);
        int match = matcher.search(startPos, range, 0);
        DynamicObject nil = context.getCoreLibrary().getNilObject();
        if (match == -1) {
            RegexpNodes.setThreadLocal(context, "$~", nil);
            if (setNamedCaptures && Layouts.REGEXP.getRegex(regexp).numberOfNames() > 0) {
                Iterator i = Layouts.REGEXP.getRegex(regexp).namedBackrefIterator();
                while (i.hasNext()) {
                    NameEntry e = (NameEntry)i.next();
                    String name = new String(e.name, e.nameP, e.nameEnd - e.nameP, StandardCharsets.UTF_8).intern();
                    RegexpNodes.setLocalVariable(frame, name, nil);
                }
            }
            return nil;
        }
        Region region = matcher.getEagerRegion();
        Object[] values = new Object[region.numRegs];
        for (int n = 0; n < region.numRegs; ++n) {
            int start = region.beg[n];
            int end = region.end[n];
            if (operator) {
                DynamicObject groupString = start > -1 && end > -1 ? RegexpNodes.createSubstring(source, start, end - start) : nil;
                values[n] = groupString;
                continue;
            }
            values[n] = start == -1 || end == -1 ? nil : RegexpNodes.createSubstring(source, start, end - start);
        }
        DynamicObject pre = RegexpNodes.createSubstring(source, 0, region.beg[0]);
        DynamicObject post = RegexpNodes.createSubstring(source, region.end[0], bytes.length() - region.end[0]);
        DynamicObject global = RegexpNodes.createSubstring(source, region.beg[0], region.end[0] - region.beg[0]);
        DynamicObject matchObject = Layouts.MATCH_DATA.createMatchData(Layouts.CLASS.getInstanceFactory(context.getCoreLibrary().getMatchDataClass()), source, regexp, region, values, pre, post, global, matcher.getBegin(), matcher.getEnd(), false, null, null);
        if (operator && values.length > 0) {
            int nonNil = values.length - 1;
            while (values[nonNil] == nil) {
                --nonNil;
            }
        }
        RegexpNodes.setThreadLocal(context, "$~", matchObject);
        if (setNamedCaptures && Layouts.REGEXP.getRegex(regexp).numberOfNames() > 0) {
            Iterator i = Layouts.REGEXP.getRegex(regexp).namedBackrefIterator();
            while (i.hasNext()) {
                DynamicObject value;
                NameEntry e = (NameEntry)i.next();
                String name = new String(e.name, e.nameP, e.nameEnd - e.nameP, StandardCharsets.UTF_8).intern();
                int nth = Layouts.REGEXP.getRegex(regexp).nameToBackrefNumber(e.name, e.nameP, e.nameEnd, region);
                if (nth >= region.numRegs || nth < 0 && (nth += region.numRegs) <= 0) {
                    value = nil;
                } else {
                    int start = region.beg[nth];
                    int end = region.end[nth];
                    value = start != -1 ? RegexpNodes.createSubstring(source, start, end - start) : nil;
                }
                RegexpNodes.setLocalVariable(frame, name, value);
            }
        }
        if (operator) {
            return matcher.getBegin();
        }
        return matchObject;
    }

    @CompilerDirectives.TruffleBoundary
    private static DynamicObject createSubstring(DynamicObject source, int start, int length) {
        assert (RubyGuards.isRubyString(source));
        ByteList bytes = new ByteList(StringOperations.getByteList(source), start, length);
        DynamicObject ret = Layouts.STRING.createString(Layouts.CLASS.getInstanceFactory(Layouts.BASIC_OBJECT.getLogicalClass(source)), bytes, 0, null);
        Layouts.STRING.setCodeRange(ret, Layouts.STRING.getCodeRange(source));
        return ret;
    }

    private static void setLocalVariable(Frame frame, String name, Object value) {
        assert (value != null);
        while (frame != null) {
            FrameSlot slot = frame.getFrameDescriptor().findFrameSlot((Object)name);
            if (slot != null) {
                frame.setObject(slot, value);
                break;
            }
            frame = RubyArguments.getDeclarationFrame(frame.getArguments());
        }
    }

    private static void setThreadLocal(RubyContext context, String name, Object value) {
        assert (value != null);
        Layouts.THREAD.getThreadLocals(context.getThreadManager().getCurrentThread()).define((Object)name, value, 0);
    }

    @CompilerDirectives.TruffleBoundary
    public static Regex compile(Node currentNode, RubyContext context, ByteList bytes, RegexpOptions options) {
        try {
            Encoding enc = bytes.getEncoding();
            Encoding[] fixedEnc = new Encoding[]{null};
            ByteList unescaped = RegexpSupport.preprocess((Ruby)context.getRuntime(), (ByteList)bytes, (Encoding)enc, (Encoding[])fixedEnc, (RegexpSupport.ErrorMode)RegexpSupport.ErrorMode.RAISE);
            if (fixedEnc[0] != null) {
                if (fixedEnc[0] != enc && options.isFixed() || fixedEnc[0] != ASCIIEncoding.INSTANCE && options.isEncodingNone()) {
                    RegexpSupport.raiseRegexpError19((Ruby)context.getRuntime(), (ByteList)bytes, (Encoding)enc, (RegexpOptions)options, (String)"incompatible character encoding");
                }
                if (fixedEnc[0] != ASCIIEncoding.INSTANCE) {
                    options.setFixed(true);
                    enc = fixedEnc[0];
                }
            } else if (!options.isFixed()) {
                enc = USASCIIEncoding.INSTANCE;
            }
            if (fixedEnc[0] != null) {
                options.setFixed(true);
            }
            bytes.setEncoding(enc);
            Regex ret = new Regex(unescaped.getUnsafeBytes(), unescaped.getBegin(), unescaped.getBegin() + unescaped.getRealSize(), options.toJoniOptions(), enc, Syntax.RUBY);
            ret.setUserObject((Object)bytes);
            return ret;
        }
        catch (ValueException e) {
            throw new RaiseException(context.getCoreLibrary().runtimeError("error compiling regex", currentNode));
        }
        catch (SyntaxException e) {
            throw new RaiseException(context.getCoreLibrary().regexpError(e.getMessage(), currentNode));
        }
    }

    public static Object getCachedNames(DynamicObject regexp) {
        return Layouts.REGEXP.getCachedNames(regexp);
    }

    public static void setCachedNames(DynamicObject regexp, Object cachedNames) {
        Layouts.REGEXP.setCachedNames(regexp, cachedNames);
    }

    public static void setRegex(DynamicObject regexp, Regex regex) {
        Layouts.REGEXP.setRegex(regexp, regex);
    }

    public static void setSource(DynamicObject regexp, ByteList source) {
        Layouts.REGEXP.setSource(regexp, source);
    }

    public static void setOptions(DynamicObject regexp, RegexpOptions options) {
        Layouts.REGEXP.setOptions(regexp, options);
    }

    public static Encoding checkEncoding(DynamicObject regexp, CodeRangeable str, boolean warn) {
        assert (RubyGuards.isRubyRegexp(regexp));
        Regex pattern = Layouts.REGEXP.getRegex(regexp);
        Encoding enc = str.getByteList().getEncoding();
        if (!enc.isAsciiCompatible()) {
            if (enc != pattern.getEncoding()) {
                // empty if block
            }
        } else if (Layouts.REGEXP.getOptions(regexp).isFixed()) {
            enc = pattern.getEncoding();
        }
        return enc;
    }

    public static void initialize(RubyContext context, DynamicObject regexp, Node currentNode, ByteList setSource, int options) {
        assert (RubyGuards.isRubyRegexp(regexp));
        RegexpNodes.setSource(regexp, setSource);
        RegexpNodes.setOptions(regexp, RegexpOptions.fromEmbeddedOptions((int)options));
        RegexpNodes.setRegex(regexp, RegexpNodes.compile(currentNode, context, setSource, Layouts.REGEXP.getOptions(regexp)));
    }

    public static void initialize(DynamicObject regexp, Regex setRegex, ByteList setSource) {
        assert (RubyGuards.isRubyRegexp(regexp));
        RegexpNodes.setRegex(regexp, setRegex);
        RegexpNodes.setSource(regexp, setSource);
    }

    public static DynamicObject createRubyRegexp(RubyContext context, Node currentNode, DynamicObject regexpClass, ByteList regex, RegexpOptions options) {
        return Layouts.REGEXP.createRegexp(Layouts.CLASS.getInstanceFactory(regexpClass), RegexpNodes.compile(currentNode, context, regex, options), regex, options, null);
    }

    public static DynamicObject createRubyRegexp(DynamicObject regexpClass, Regex regex, ByteList source, RegexpOptions options) {
        DynamicObject regexp = Layouts.REGEXP.createRegexp(Layouts.CLASS.getInstanceFactory(regexpClass), null, null, RegexpOptions.NULL_OPTIONS, null);
        RegexpNodes.setOptions(regexp, options);
        RegexpNodes.initialize(regexp, regex, source);
        return regexp;
    }

    public static DynamicObject createRubyRegexp(DynamicObject regexpClass, Regex regex, ByteList source) {
        DynamicObject regexp = Layouts.REGEXP.createRegexp(Layouts.CLASS.getInstanceFactory(regexpClass), null, null, RegexpOptions.NULL_OPTIONS, null);
        RegexpNodes.initialize(regexp, regex, source);
        return regexp;
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        public AllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            return Layouts.REGEXP.createRegexp(Layouts.CLASS.getInstanceFactory(rubyClass), null, null, RegexpOptions.NULL_OPTIONS, null);
        }
    }

    @NodeChild(value="self")
    public static abstract class RubiniusNamesNode
    extends RubyNode {
        @Node.Child
        private CallDispatchHeadNode newLookupTableNode;
        @Node.Child
        private CallDispatchHeadNode lookupTableWriteNode;

        public RubiniusNamesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"!anyNames(regexp)"})
        public DynamicObject rubiniusNamesNoCaptures(DynamicObject regexp) {
            return this.nil();
        }

        @Specialization(guards={"anyNames(regexp)"})
        public Object rubiniusNames(VirtualFrame frame, DynamicObject regexp) {
            if (RegexpNodes.getCachedNames(regexp) != null) {
                return RegexpNodes.getCachedNames(regexp);
            }
            if (this.newLookupTableNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.newLookupTableNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            if (this.lookupTableWriteNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.lookupTableWriteNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            Object namesLookupTable = this.newLookupTableNode.call(frame, this.getContext().getCoreLibrary().getLookupTableClass(), "new", null, new Object[0]);
            Iterator i = Layouts.REGEXP.getRegex(regexp).namedBackrefIterator();
            while (i.hasNext()) {
                NameEntry e = (NameEntry)i.next();
                DynamicObject name = this.getSymbol(new ByteList(e.name, e.nameP, e.nameEnd - e.nameP, false));
                int[] backrefs = e.getBackRefs();
                DynamicObject backrefsRubyArray = Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), backrefs, backrefs.length);
                this.lookupTableWriteNode.call(frame, namesLookupTable, "[]=", null, name, backrefsRubyArray);
            }
            RegexpNodes.setCachedNames(regexp, namesLookupTable);
            return namesLookupTable;
        }

        public static boolean anyNames(DynamicObject regexp) {
            return Layouts.REGEXP.getRegex(regexp).numberOfNames() > 0;
        }
    }

    @CoreMethod(names={"to_s"})
    public static abstract class ToSNode
    extends CoreMethodArrayArgumentsNode {
        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject toS(DynamicObject regexp) {
            return this.createString(((RubyString)RubyRegexp.newRegexp((Ruby)this.getContext().getRuntime(), (ByteList)Layouts.REGEXP.getSource(regexp), (int)Layouts.REGEXP.getRegex(regexp).getOptions()).to_s()).getByteList());
        }
    }

    @CoreMethod(names={"source"})
    public static abstract class SourceNode
    extends CoreMethodArrayArgumentsNode {
        public SourceNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject source(DynamicObject regexp) {
            return this.createString(Layouts.REGEXP.getSource(regexp).dup());
        }
    }

    @CoreMethod(names={"search_from"}, required=2)
    public static abstract class SearchFromNode
    extends CoreMethodArrayArgumentsNode {
        public SearchFromNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(string)"})
        public Object searchFrom(DynamicObject regexp, DynamicObject string, int startPos) {
            return RegexpNodes.matchCommon(this.getContext(), regexp, string, false, false, startPos);
        }
    }

    @CoreMethod(names={"quote", "escape"}, needsSelf=false, onSingleton=true, required=1)
    public static abstract class QuoteNode
    extends CoreMethodArrayArgumentsNode {
        public QuoteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(raw)"})
        public DynamicObject quoteString(DynamicObject raw) {
            boolean isAsciiOnly = StringOperations.getByteList(raw).getEncoding().isAsciiCompatible() && StringOperations.scanForCodeRange(raw) == 16;
            return this.createString(RubyRegexp.quote19((ByteList)StringOperations.getByteList(raw), (boolean)isAsciiOnly));
        }

        @Specialization(guards={"isRubySymbol(raw)"})
        public DynamicObject quoteSymbol(DynamicObject raw) {
            return this.quoteString(this.createString(StringOperations.encodeByteList(Layouts.SYMBOL.getString(raw), (Encoding)UTF8Encoding.INSTANCE)));
        }
    }

    @CoreMethod(names={"match_start"}, required=2)
    public static abstract class MatchStartNode
    extends CoreMethodArrayArgumentsNode {
        public MatchStartNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(string)"})
        public Object matchStart(DynamicObject regexp, DynamicObject string, int startPos) {
            Object matchResult = RegexpNodes.matchCommon(this.getContext(), regexp, string, false, false, startPos);
            if (RubyGuards.isRubyMatchData(matchResult) && Layouts.MATCH_DATA.getRegion((DynamicObject)((DynamicObject)matchResult)).numRegs > 0 && Layouts.MATCH_DATA.getRegion((DynamicObject)((DynamicObject)matchResult)).beg[0] == startPos) {
                return matchResult;
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"hash"})
    public static abstract class HashNode
    extends CoreMethodArrayArgumentsNode {
        public HashNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int hash(DynamicObject regexp) {
            int options = Layouts.REGEXP.getRegex(regexp).getOptions() & 0xFFFFFFDF;
            return options ^ Layouts.REGEXP.getSource(regexp).hashCode();
        }
    }

    @CoreMethod(names={"escape"}, onSingleton=true, required=1)
    public static abstract class EscapeNode
    extends CoreMethodArrayArgumentsNode {
        public EscapeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(pattern)"})
        public DynamicObject escape(DynamicObject pattern) {
            return this.createString(StringOperations.encodeByteList(RubyRegexp.quote19((ByteList)new ByteList(StringOperations.getByteList(pattern)), (boolean)true).toString(), (Encoding)UTF8Encoding.INSTANCE));
        }
    }

    @CoreMethod(names={"=~"}, required=1)
    public static abstract class MatchOperatorNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode toSNode;
        @Node.Child
        private ToStrNode toStrNode;

        public MatchOperatorNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(string)"})
        public Object match(DynamicObject regexp, DynamicObject string) {
            return RegexpNodes.matchCommon(this.getContext(), regexp, string, true, true, 0);
        }

        @Specialization(guards={"isRubySymbol(symbol)"})
        public Object match(VirtualFrame frame, DynamicObject regexp, DynamicObject symbol) {
            if (this.toSNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toSNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            return this.match(regexp, (DynamicObject)this.toSNode.call(frame, symbol, "to_s", null, new Object[0]));
        }

        @Specialization(guards={"isNil(nil)"})
        public Object match(DynamicObject regexp, Object nil) {
            return this.nil();
        }

        @Specialization(guards={"!isRubyString(other)", "!isRubySymbol(other)", "!isNil(other)"})
        public Object matchGeneric(VirtualFrame frame, DynamicObject regexp, DynamicObject other) {
            if (this.toStrNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toStrNode = (ToStrNode)this.insert(ToStrNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.match(regexp, this.toStrNode.executeToStr(frame, other));
        }
    }
}

