/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.constants;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.constants.RestartableReadConstantNode;
import org.jruby.truffle.nodes.core.KernelNodes;
import org.jruby.truffle.nodes.core.KernelNodesFactory;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyConstant;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.util.IdUtil;

@NodeChildren(value={@NodeChild(value="module"), @NodeChild(value="name"), @NodeChild(value="constant")})
public abstract class GetConstantNode
extends RubyNode {
    private final RestartableReadConstantNode readConstantNode;
    @Node.Child
    private CallDispatchHeadNode constMissingNode;

    public GetConstantNode(RubyContext context, SourceSection sourceSection, RestartableReadConstantNode readConstantNode) {
        super(context, sourceSection);
        this.readConstantNode = readConstantNode;
    }

    public abstract Object executeGetConstant(VirtualFrame var1, Object var2, String var3, RubyConstant var4);

    @Specialization(guards={"constant != null", "!constant.isAutoload()"})
    protected Object getConstant(DynamicObject module, String name, RubyConstant constant) {
        return constant.getValue();
    }

    @Specialization(guards={"constant != null", "constant.isAutoload()"})
    protected Object autoloadConstant(VirtualFrame frame, DynamicObject module, String name, RubyConstant constant, @Cached(value="createRequireNode()") KernelNodes.RequireNode requireNode, @Cached(value="deepCopyReadConstantNode()") RestartableReadConstantNode readConstantNode) {
        DynamicObject path = (DynamicObject)constant.getValue();
        Layouts.MODULE.getFields(constant.getDeclaringModule()).removeConstant(this.getContext(), this, name);
        try {
            requireNode.require(path);
            return readConstantNode.readConstant(frame, module, name);
        }
        catch (RaiseException e) {
            Layouts.MODULE.getFields(constant.getDeclaringModule()).setAutoloadConstant(this.getContext(), this, name, path);
            throw e;
        }
    }

    @Specialization(guards={"constant == null", "guardName(name, cachedName, sameNameProfile)"}, limit="getCacheLimit()")
    protected Object missingConstantCached(VirtualFrame frame, DynamicObject module, String name, Object constant, @Cached(value="name") String cachedName, @Cached(value="isValidConstantName(name)") boolean isValidConstantName, @Cached(value="getSymbol(name)") DynamicObject symbolName, @Cached(value="createBinaryProfile()") ConditionProfile sameNameProfile) {
        return this.doMissingConstant(frame, module, name, isValidConstantName, symbolName);
    }

    @Specialization(guards={"constant == null"})
    protected Object missingConstantUncached(VirtualFrame frame, DynamicObject module, String name, Object constant) {
        boolean isValidConstantName = this.isValidConstantName(name);
        return this.doMissingConstant(frame, module, name, isValidConstantName, this.getSymbol(name));
    }

    private Object doMissingConstant(VirtualFrame frame, DynamicObject module, String name, boolean isValidConstantName, DynamicObject symbolName) {
        if (!isValidConstantName) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().nameError(String.format("wrong constant name %s", name), name, this));
        }
        if (this.constMissingNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.constMissingNode = (CallDispatchHeadNode)this.insert(this.createConstMissingNode());
        }
        return this.constMissingNode.call(frame, module, "const_missing", null, symbolName);
    }

    protected KernelNodes.RequireNode createRequireNode() {
        return KernelNodesFactory.RequireNodeFactory.create(this.getContext(), this.getSourceSection(), null);
    }

    protected RestartableReadConstantNode deepCopyReadConstantNode() {
        return (RestartableReadConstantNode)this.readConstantNode.deepCopy();
    }

    protected boolean isValidConstantName(String name) {
        return IdUtil.isValidConstantName19((String)name);
    }

    protected CallDispatchHeadNode createConstMissingNode() {
        return DispatchHeadNodeFactory.createMethodCall(this.getContext());
    }

    protected boolean guardName(String name, String cachedName, ConditionProfile sameNameProfile) {
        if (sameNameProfile.profile(name == cachedName)) {
            return true;
        }
        return name.equals(cachedName);
    }

    protected int getCacheLimit() {
        return this.getContext().getOptions().CONSTANT_LOOKUP_CACHE;
    }
}

