/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.rubinius;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jruby.ext.ffi.Platform;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.rubinius.DarwinRubiniusConfiguration;
import org.jruby.truffle.runtime.rubinius.DefaultRubiniusConfiguration;
import org.jruby.truffle.runtime.rubinius.LinuxRubiniusConfiguration;

public class RubiniusConfiguration {
    private final Map<String, Object> configuration = new HashMap<String, Object>();

    public static RubiniusConfiguration create(RubyContext context) {
        RubiniusConfiguration configuration = new RubiniusConfiguration();
        DefaultRubiniusConfiguration.load(configuration, context);
        switch (Platform.getPlatform().getOS()) {
            case DARWIN: {
                DarwinRubiniusConfiguration.load(configuration, context);
                break;
            }
            case LINUX: {
                LinuxRubiniusConfiguration.load(configuration, context);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return configuration;
    }

    private RubiniusConfiguration() {
    }

    public void config(String key, Object value) {
        this.configuration.put(key, value);
    }

    public Object get(String key) {
        return this.configuration.get(key);
    }

    public Collection<String> getSection(String section) {
        ArrayList<String> sectionKeys = new ArrayList<String>();
        for (String key : this.configuration.keySet()) {
            if (!key.startsWith(section)) continue;
            sectionKeys.add(key);
        }
        return sectionKeys;
    }
}

