/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.layouts;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import org.jruby.truffle.om.dsl.api.UnexpectedLayoutRefusalException;
import org.jruby.truffle.runtime.layouts.BasicObjectLayoutImpl;
import org.jruby.truffle.runtime.layouts.BindingLayout;

public class BindingLayoutImpl
extends BasicObjectLayoutImpl
implements BindingLayout {
    public static final BindingLayout INSTANCE = new BindingLayoutImpl();
    protected static final Shape.Allocator BINDING_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey SELF_IDENTIFIER = new HiddenKey("self");
    protected static final Property SELF_PROPERTY = Property.create((Object)SELF_IDENTIFIER, (Location)BINDING_ALLOCATOR.locationForType(Object.class), (int)0);
    protected static final HiddenKey FRAME_IDENTIFIER = new HiddenKey("frame");
    protected static final Property FRAME_PROPERTY = Property.create((Object)FRAME_IDENTIFIER, (Location)BINDING_ALLOCATOR.locationForType(MaterializedFrame.class), (int)0);

    protected BindingLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createBindingShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape((ObjectType)new BindingType(logicalClass, metaClass)).addProperty(SELF_PROPERTY).addProperty(FRAME_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createBinding(DynamicObjectFactory factory, Object self, MaterializedFrame frame) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant((Object)factory);
        assert (this.createsBinding(factory));
        assert (factory.getShape().hasProperty((Object)SELF_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)FRAME_IDENTIFIER));
        return factory.newInstance(new Object[]{self, frame});
    }

    @Override
    public boolean isBinding(DynamicObject object) {
        return this.isBinding(object.getShape().getObjectType());
    }

    private boolean isBinding(ObjectType objectType) {
        return objectType instanceof BindingType;
    }

    private boolean createsBinding(DynamicObjectFactory factory) {
        return this.isBinding(factory.getShape().getObjectType());
    }

    @Override
    public Object getSelf(DynamicObject object) {
        assert (this.isBinding(object));
        assert (object.getShape().hasProperty((Object)SELF_IDENTIFIER));
        return SELF_PROPERTY.get(object, true);
    }

    @Override
    public void setSelf(DynamicObject object, Object value) {
        assert (this.isBinding(object));
        assert (object.getShape().hasProperty((Object)SELF_IDENTIFIER));
        try {
            SELF_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    @Override
    public MaterializedFrame getFrame(DynamicObject object) {
        assert (this.isBinding(object));
        assert (object.getShape().hasProperty((Object)FRAME_IDENTIFIER));
        return (MaterializedFrame)FRAME_PROPERTY.get(object, true);
    }

    @Override
    public void setFrame(DynamicObject object, MaterializedFrame value) {
        assert (this.isBinding(object));
        assert (object.getShape().hasProperty((Object)FRAME_IDENTIFIER));
        try {
            FRAME_PROPERTY.set(object, (Object)value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    protected static class BindingType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public BindingType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public BindingType setLogicalClass(DynamicObject logicalClass) {
            return new BindingType(logicalClass, this.metaClass);
        }

        @Override
        public BindingType setMetaClass(DynamicObject metaClass) {
            return new BindingType(this.logicalClass, metaClass);
        }
    }
}

