/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.pack.nodes.format;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.jruby.truffle.pack.nodes.PackNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.util.ByteList;

@NodeChildren(value={@NodeChild(value="value", type=PackNode.class)})
public abstract class FormatIntegerNode
extends PackNode {
    private final int spacePadding;
    private final int zeroPadding;
    private final char format;

    public FormatIntegerNode(RubyContext context, int spacePadding, int zeroPadding, char format) {
        super(context);
        this.spacePadding = spacePadding;
        this.zeroPadding = zeroPadding;
        this.format = format;
    }

    @Specialization
    public ByteList format(int value) {
        return this.doFormat(value);
    }

    @Specialization
    public ByteList format(long value) {
        return this.doFormat(value);
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"isRubyBignum(value)"})
    public ByteList format(DynamicObject value) {
        String formatted;
        BigInteger bigInteger = Layouts.BIGNUM.getValue(value);
        switch (this.format) {
            case 'd': 
            case 'i': 
            case 'u': {
                formatted = bigInteger.toString();
                break;
            }
            case 'x': {
                formatted = bigInteger.toString(16).toLowerCase(Locale.ENGLISH);
                break;
            }
            case 'X': {
                formatted = bigInteger.toString(16).toUpperCase(Locale.ENGLISH);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        while (formatted.length() < this.spacePadding) {
            formatted = " " + formatted;
        }
        while (formatted.length() < this.zeroPadding) {
            formatted = "0" + formatted;
        }
        return new ByteList(formatted.getBytes(StandardCharsets.US_ASCII));
    }

    @CompilerDirectives.TruffleBoundary
    protected ByteList doFormat(Object value) {
        StringBuilder builder = new StringBuilder();
        builder.append("%");
        if (this.spacePadding != -1) {
            builder.append(" ");
            builder.append(this.spacePadding);
            if (this.zeroPadding != -1) {
                builder.append(".");
                builder.append(this.zeroPadding);
            }
        } else if (this.zeroPadding != -1) {
            builder.append("0");
            builder.append(this.zeroPadding);
        }
        builder.append(this.format);
        return new ByteList(String.format(builder.toString(), value).getBytes(StandardCharsets.US_ASCII));
    }
}

