/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jruby.truffle.nodes.objects.IsTaintedNode;
import org.jruby.truffle.nodes.objects.IsTaintedNodeGen;
import org.jruby.truffle.nodes.objects.TaintNode;
import org.jruby.truffle.nodes.objects.TaintNodeGen;
import org.jruby.truffle.nodes.objectstorage.ReadHeadObjectFieldNode;
import org.jruby.truffle.nodes.objectstorage.WriteHeadObjectFieldNode;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.object.ObjectIDOperations;

public abstract class ObjectPrimitiveNodes {

    @RubiniusPrimitive(name="object_infect", needsSelf=false)
    public static abstract class ObjectInfectPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private IsTaintedNode isTaintedNode;
        @Node.Child
        private TaintNode taintNode;

        public ObjectInfectPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object objectInfect(Object host, Object source) {
            if (this.isTaintedNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.isTaintedNode = (IsTaintedNode)this.insert(IsTaintedNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if (this.isTaintedNode.executeIsTainted(source)) {
                if (this.taintNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.taintNode = (TaintNode)this.insert(TaintNodeGen.create(this.getContext(), this.getSourceSection(), null));
                }
                this.taintNode.executeTaint(host);
            }
            return host;
        }
    }

    @RubiniusPrimitive(name="object_id")
    public static abstract class ObjectIDPrimitiveNode
    extends RubiniusPrimitiveNode {
        public ObjectIDPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public abstract Object executeObjectID(VirtualFrame var1, Object var2);

        @Specialization(guards={"isNil(nil)"})
        public int objectID(Object nil) {
            return 4;
        }

        @Specialization(guards={"value"})
        public int objectIDTrue(boolean value) {
            return 2;
        }

        @Specialization(guards={"!value"})
        public int objectIDFalse(boolean value) {
            return 0;
        }

        @Specialization
        public long objectID(int value) {
            return ObjectIDOperations.smallFixnumToID(value);
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public long objectIDSmallFixnumOverflow(long value) throws ArithmeticException {
            return ObjectIDOperations.smallFixnumToIDOverflow(value);
        }

        @Specialization
        public Object objectID(long value, @Cached(value="createCountingProfile()") ConditionProfile smallProfile) {
            if (smallProfile.profile(ObjectIDOperations.isSmallFixnum(value))) {
                return ObjectIDOperations.smallFixnumToID(value);
            }
            return ObjectIDOperations.largeFixnumToID(this.getContext(), value);
        }

        @Specialization
        public Object objectID(double value) {
            return ObjectIDOperations.floatToID(this.getContext(), value);
        }

        @Specialization
        public long objectID(DynamicObject object, @Cached(value="createReadObjectIDNode()") ReadHeadObjectFieldNode readObjectIdNode, @Cached(value="createWriteObjectIDNode()") WriteHeadObjectFieldNode writeObjectIdNode) {
            Object id = readObjectIdNode.execute(object);
            if (id == this.nil()) {
                long newId = this.getContext().getNextObjectID();
                writeObjectIdNode.execute(object, newId);
                return newId;
            }
            return (Long)id;
        }

        protected ReadHeadObjectFieldNode createReadObjectIDNode() {
            return new ReadHeadObjectFieldNode(Layouts.OBJECT_ID_IDENTIFIER);
        }

        protected WriteHeadObjectFieldNode createWriteObjectIDNode() {
            return new WriteHeadObjectFieldNode(Layouts.OBJECT_ID_IDENTIFIER);
        }
    }
}

