/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objectstorage;

import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.IntLocation;
import com.oracle.truffle.api.object.Shape;
import org.jruby.truffle.nodes.objectstorage.ReadObjectFieldChainNode;
import org.jruby.truffle.nodes.objectstorage.ReadObjectFieldNode;

@NodeInfo(cost=NodeCost.POLYMORPHIC)
public class ReadIntegerObjectFieldNode
extends ReadObjectFieldChainNode {
    private final IntLocation storageLocation;

    public ReadIntegerObjectFieldNode(Shape objectLayout, IntLocation storageLocation, ReadObjectFieldNode next) {
        super(objectLayout, next);
        this.storageLocation = storageLocation;
    }

    @Override
    public int executeInteger(DynamicObject object) throws UnexpectedResultException {
        boolean condition;
        try {
            this.objectLayout.getValidAssumption().check();
        }
        catch (InvalidAssumptionException e) {
            this.replace(this.next);
            return this.next.executeInteger(object);
        }
        boolean bl = condition = object.getShape() == this.objectLayout;
        if (condition) {
            return this.storageLocation.getInt(object, this.objectLayout);
        }
        return this.next.executeInteger(object);
    }

    @Override
    public Object execute(DynamicObject object) {
        boolean condition;
        try {
            this.objectLayout.getValidAssumption().check();
        }
        catch (InvalidAssumptionException e) {
            this.replace(this.next);
            return this.next.execute(object);
        }
        boolean bl = condition = object.getShape() == this.objectLayout;
        if (condition) {
            return this.storageLocation.get(object, this.objectLayout);
        }
        return this.next.execute(object);
    }
}

