/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.RubyString;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.objects.WriteInstanceVariableNode;
import org.jruby.truffle.nodes.objectstorage.ReadHeadObjectFieldNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.translator.ReadNode;

public class ReadInstanceVariableNode
extends RubyNode
implements ReadNode {
    @Node.Child
    private RubyNode receiver;
    @Node.Child
    private ReadHeadObjectFieldNode readNode;
    private final boolean isGlobal;
    private final BranchProfile primitiveProfile = BranchProfile.create();

    public ReadInstanceVariableNode(RubyContext context, SourceSection sourceSection, String name, RubyNode receiver, boolean isGlobal) {
        super(context, sourceSection);
        this.receiver = receiver;
        this.readNode = new ReadHeadObjectFieldNode(name);
        this.isGlobal = isGlobal;
    }

    @Override
    public int executeInteger(VirtualFrame frame) throws UnexpectedResultException {
        Object receiverObject = this.receiver.execute(frame);
        if (receiverObject instanceof DynamicObject) {
            return this.readNode.executeInteger((DynamicObject)receiverObject);
        }
        CompilerDirectives.transferToInterpreter();
        throw new UnexpectedResultException((Object)this.nil());
    }

    @Override
    public long executeLong(VirtualFrame frame) throws UnexpectedResultException {
        Object receiverObject = this.receiver.execute(frame);
        if (receiverObject instanceof DynamicObject) {
            return this.readNode.executeLong((DynamicObject)receiverObject);
        }
        CompilerDirectives.transferToInterpreter();
        throw new UnexpectedResultException((Object)this.nil());
    }

    @Override
    public double executeDouble(VirtualFrame frame) throws UnexpectedResultException {
        Object receiverObject = this.receiver.execute(frame);
        if (receiverObject instanceof DynamicObject) {
            return this.readNode.executeDouble((DynamicObject)receiverObject);
        }
        CompilerDirectives.transferToInterpreter();
        throw new UnexpectedResultException((Object)this.nil());
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object receiverObject = this.receiver.execute(frame);
        if (receiverObject instanceof DynamicObject) {
            return this.readNode.execute((DynamicObject)receiverObject);
        }
        this.primitiveProfile.enter();
        return this.nil();
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        CompilerDirectives.transferToInterpreter();
        if (this.isGlobal) {
            DynamicObject receiverValue = (DynamicObject)this.receiver.execute(frame);
            if (this.readNode.getName().equals("$~") || this.readNode.getName().equals("$!")) {
                return Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), RubyString.encodeBytelist((CharSequence)"global-variable", (Encoding)UTF8Encoding.INSTANCE), 16, null);
            }
            if (this.readNode.isSet(receiverValue)) {
                if (this.readNode.execute(receiverValue) == this.nil()) {
                    return this.nil();
                }
                return Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), RubyString.encodeBytelist((CharSequence)"global-variable", (Encoding)UTF8Encoding.INSTANCE), 16, null);
            }
            return this.nil();
        }
        Object receiverObject = this.receiver.execute(frame);
        if (receiverObject instanceof DynamicObject) {
            DynamicObject receiverRubyObject = (DynamicObject)receiverObject;
            Shape layout = receiverRubyObject.getShape();
            Property storageLocation = layout.getProperty(this.readNode.getName());
            if (storageLocation != null) {
                return Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), RubyString.encodeBytelist((CharSequence)"instance-variable", (Encoding)UTF8Encoding.INSTANCE), 16, null);
            }
            return this.nil();
        }
        return false;
    }

    @Override
    public RubyNode makeWriteNode(RubyNode rhs) {
        return new WriteInstanceVariableNode(this.getContext(), this.getSourceSection(), (String)this.readNode.getName(), this.receiver, rhs, this.isGlobal);
    }
}

