/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.methods;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.objects.MetaClassNode;
import org.jruby.truffle.nodes.objects.MetaClassNodeGen;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.methods.InternalMethod;

@NodeChildren(value={@NodeChild(value="self"), @NodeChild(value="name")})
public abstract class LookupMethodNode
extends RubyNode {
    @Node.Child
    MetaClassNode metaClassNode;

    public LookupMethodNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.metaClassNode = MetaClassNodeGen.create(context, sourceSection, null);
    }

    public abstract InternalMethod executeLookupMethod(VirtualFrame var1, Object var2, String var3);

    @Specialization(guards={"metaClass(frame, self) == selfMetaClass", "name == cachedName"}, assumptions={"getUnmodifiedAssumption(selfMetaClass)"}, limit="getCacheLimit()")
    protected InternalMethod lookupMethodCached(VirtualFrame frame, Object self, String name, @Cached(value="metaClass(frame, self)") DynamicObject selfMetaClass, @Cached(value="name") String cachedName, @Cached(value="doLookup(selfMetaClass, name)") InternalMethod method) {
        return method;
    }

    public Assumption getUnmodifiedAssumption(DynamicObject module) {
        return Layouts.MODULE.getFields(module).getUnmodifiedAssumption();
    }

    @Specialization
    protected InternalMethod lookupMethodUncached(VirtualFrame frame, Object self, String name) {
        DynamicObject selfMetaClass = this.metaClass(frame, self);
        return this.doLookup(selfMetaClass, name);
    }

    protected DynamicObject metaClass(VirtualFrame frame, Object object) {
        return this.metaClassNode.executeMetaClass(frame, object);
    }

    protected InternalMethod doLookup(DynamicObject selfMetaClass, String name) {
        assert (RubyGuards.isRubyClass(selfMetaClass));
        InternalMethod method = ModuleOperations.lookupMethod(selfMetaClass, name);
        if (method != null && method.isUndefined()) {
            method = null;
        }
        return method;
    }
}

