/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.literal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.CoreLibrary;
import org.jruby.truffle.runtime.layouts.Layouts;

@NodeChildren(value={@NodeChild(value="begin"), @NodeChild(value="end")})
public abstract class RangeLiteralNode
extends RubyNode {
    private final boolean excludeEnd;
    @Node.Child
    private CallDispatchHeadNode cmpNode;

    public RangeLiteralNode(RubyContext context, SourceSection sourceSection, boolean excludeEnd) {
        super(context, sourceSection);
        this.excludeEnd = excludeEnd;
    }

    @Specialization
    public DynamicObject intRange(int begin, int end) {
        return Layouts.INTEGER_FIXNUM_RANGE.createIntegerFixnumRange(this.getContext().getCoreLibrary().getIntegerFixnumRangeFactory(), this.excludeEnd, begin, end);
    }

    @Specialization(guards={"fitsIntoInteger(begin)", "fitsIntoInteger(end)"})
    public DynamicObject longFittingIntRange(long begin, long end) {
        return Layouts.INTEGER_FIXNUM_RANGE.createIntegerFixnumRange(this.getContext().getCoreLibrary().getIntegerFixnumRangeFactory(), this.excludeEnd, (int)begin, (int)end);
    }

    @Specialization(guards={"!fitsIntoInteger(begin) || !fitsIntoInteger(end)"})
    public DynamicObject longRange(long begin, long end) {
        return Layouts.LONG_FIXNUM_RANGE.createLongFixnumRange(this.getContext().getCoreLibrary().getLongFixnumRangeFactory(), this.excludeEnd, begin, end);
    }

    @Specialization(guards={"!isIntOrLong(begin) || !isIntOrLong(end)"})
    public Object doRange(VirtualFrame frame, Object begin, Object end) {
        Object cmpResult;
        if (this.cmpNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.cmpNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
        }
        try {
            cmpResult = this.cmpNode.call(frame, begin, "<=>", null, end);
        }
        catch (RaiseException e) {
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError("bad value for range", this));
        }
        if (cmpResult == this.nil()) {
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError("bad value for range", this));
        }
        DynamicObject rangeClass = this.getContext().getCoreLibrary().getRangeClass();
        return Layouts.OBJECT_RANGE.createObjectRange(Layouts.CLASS.getInstanceFactory(rangeClass), this.excludeEnd, begin, end);
    }

    protected boolean fitsIntoInteger(long value) {
        return CoreLibrary.fitsIntoInteger(value);
    }

    protected boolean isIntOrLong(Object value) {
        return RubyGuards.isInteger(value) || RubyGuards.isLong(value);
    }
}

