/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.dispatch;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.messages.Message;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.interop.messages.Argument;
import com.oracle.truffle.interop.messages.Read;
import com.oracle.truffle.interop.messages.Receiver;
import com.oracle.truffle.interop.node.ForeignObjectAccessNode;
import java.util.concurrent.Callable;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.dispatch.CachedBooleanDispatchNode;
import org.jruby.truffle.nodes.dispatch.CachedBoxedDispatchNode;
import org.jruby.truffle.nodes.dispatch.CachedBoxedMethodMissingDispatchNode;
import org.jruby.truffle.nodes.dispatch.CachedBoxedReturnMissingDispatchNode;
import org.jruby.truffle.nodes.dispatch.CachedBoxedSymbolDispatchNode;
import org.jruby.truffle.nodes.dispatch.CachedForeignDispatchNode;
import org.jruby.truffle.nodes.dispatch.CachedForeignGlobalDispatchNode;
import org.jruby.truffle.nodes.dispatch.CachedSingletonDispatchNode;
import org.jruby.truffle.nodes.dispatch.CachedUnboxedDispatchNode;
import org.jruby.truffle.nodes.dispatch.DispatchAction;
import org.jruby.truffle.nodes.dispatch.DispatchNode;
import org.jruby.truffle.nodes.dispatch.MissingBehavior;
import org.jruby.truffle.nodes.dispatch.UncachedDispatchNode;
import org.jruby.truffle.nodes.objects.SingletonClassNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyCallStack;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.methods.InternalMethod;

public final class UnresolvedDispatchNode
extends DispatchNode {
    private int depth = 0;
    private final boolean ignoreVisibility;
    private final boolean indirect;
    private final MissingBehavior missingBehavior;
    @Node.Child
    private SingletonClassNode singletonClassNode;

    public UnresolvedDispatchNode(RubyContext context, boolean ignoreVisibility, boolean indirect, MissingBehavior missingBehavior, DispatchAction dispatchAction) {
        super(context, dispatchAction);
        this.ignoreVisibility = ignoreVisibility;
        this.indirect = indirect;
        this.missingBehavior = missingBehavior;
    }

    @Override
    protected boolean guard(Object methodName, Object receiver) {
        return false;
    }

    @Override
    public Object executeDispatch(final VirtualFrame frame, final Object receiverObject, final Object methodName, Object blockObject, final Object argumentsObjects) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        DispatchNode dispatch = (DispatchNode)((Object)this.atomic(new Callable<DispatchNode>(){

            @Override
            public DispatchNode call() throws Exception {
                DispatchNode newDispathNode;
                DispatchNode first;
                for (DispatchNode lookupDispatch = first = UnresolvedDispatchNode.this.getHeadNode().getFirstDispatchNode(); lookupDispatch != null; lookupDispatch = lookupDispatch.getNext()) {
                    if (!lookupDispatch.guard(methodName, receiverObject)) continue;
                    return lookupDispatch;
                }
                if (UnresolvedDispatchNode.this.depth == UnresolvedDispatchNode.this.getContext().getOptions().DISPATCH_POLYMORPHIC_MAX) {
                    newDispathNode = new UncachedDispatchNode(UnresolvedDispatchNode.this.getContext(), UnresolvedDispatchNode.this.ignoreVisibility, UnresolvedDispatchNode.this.getDispatchAction(), UnresolvedDispatchNode.this.missingBehavior);
                } else {
                    UnresolvedDispatchNode.this.depth++;
                    newDispathNode = receiverObject instanceof DynamicObject ? UnresolvedDispatchNode.this.doDynamicObject(frame, first, receiverObject, methodName, argumentsObjects) : (RubyGuards.isForeignObject(receiverObject) ? UnresolvedDispatchNode.this.createForeign(argumentsObjects, first, methodName) : UnresolvedDispatchNode.this.doUnboxedObject(frame, first, receiverObject, methodName));
                }
                first.replace(newDispathNode);
                return newDispathNode;
            }
        }));
        return dispatch.executeDispatch(frame, receiverObject, methodName, blockObject, argumentsObjects);
    }

    private DispatchNode createForeign(Object argumentsObjects, DispatchNode first, Object methodName) {
        Object[] args = (Object[])argumentsObjects;
        return new CachedForeignDispatchNode(this.getContext(), first, methodName, args.length);
    }

    private DispatchNode doUnboxedObject(VirtualFrame frame, DispatchNode first, Object receiverObject, Object methodName) {
        String methodNameString;
        DynamicObject callerClass = this.ignoreVisibility ? null : this.getContext().getCoreLibrary().getMetaClass(RubyArguments.getSelf(frame.getArguments()));
        InternalMethod method = this.lookup(callerClass, receiverObject, methodNameString = this.toString(methodName), this.ignoreVisibility);
        if (method == null) {
            return this.createMethodMissingNode(first, methodName, receiverObject);
        }
        if (receiverObject instanceof Boolean) {
            Assumption falseUnmodifiedAssumption = Layouts.MODULE.getFields(this.getContext().getCoreLibrary().getFalseClass()).getUnmodifiedAssumption();
            InternalMethod falseMethod = this.lookup(callerClass, false, methodNameString, this.ignoreVisibility);
            Assumption trueUnmodifiedAssumption = Layouts.MODULE.getFields(this.getContext().getCoreLibrary().getTrueClass()).getUnmodifiedAssumption();
            InternalMethod trueMethod = this.lookup(callerClass, true, methodNameString, this.ignoreVisibility);
            if (falseMethod == null && trueMethod == null) {
                throw new UnsupportedOperationException();
            }
            return new CachedBooleanDispatchNode(this.getContext(), methodName, first, falseUnmodifiedAssumption, null, falseMethod, trueUnmodifiedAssumption, null, trueMethod, this.indirect, this.getDispatchAction());
        }
        return new CachedUnboxedDispatchNode(this.getContext(), methodName, first, receiverObject.getClass(), Layouts.MODULE.getFields(this.getContext().getCoreLibrary().getLogicalClass(receiverObject)).getUnmodifiedAssumption(), method, this.indirect, this.getDispatchAction());
    }

    private DispatchNode doDynamicObject(VirtualFrame frame, DispatchNode first, Object receiverObject, Object methodName, Object argumentsObjects) {
        DynamicObject callerClass;
        if (this.ignoreVisibility) {
            callerClass = null;
        } else if (this.getDispatchAction() == DispatchAction.RESPOND_TO_METHOD) {
            Frame callerFrame = RubyCallStack.getCallerFrame(this.getContext()).getFrame(FrameInstance.FrameAccess.READ_ONLY, true);
            callerClass = this.getContext().getCoreLibrary().getMetaClass(RubyArguments.getSelf(callerFrame.getArguments()));
        } else {
            callerClass = this.getContext().getCoreLibrary().getMetaClass(RubyArguments.getSelf(frame.getArguments()));
        }
        InternalMethod method = this.lookup(callerClass, receiverObject, this.toString(methodName), this.ignoreVisibility);
        if (method == null) {
            DispatchNode multilanguage = this.tryMultilanguage(frame, first, methodName, argumentsObjects);
            if (multilanguage != null) {
                return multilanguage;
            }
            return this.createMethodMissingNode(first, methodName, receiverObject);
        }
        DynamicObject receiverMetaClass = this.getContext().getCoreLibrary().getMetaClass(receiverObject);
        if (RubyGuards.isRubySymbol(receiverObject)) {
            return new CachedBoxedSymbolDispatchNode(this.getContext(), methodName, first, method, this.indirect, this.getDispatchAction());
        }
        if (Layouts.CLASS.getIsSingleton(receiverMetaClass)) {
            return new CachedSingletonDispatchNode(this.getContext(), methodName, first, (DynamicObject)receiverObject, receiverMetaClass, method, this.indirect, this.getDispatchAction());
        }
        return new CachedBoxedDispatchNode(this.getContext(), methodName, first, ((DynamicObject)receiverObject).getShape(), receiverMetaClass, method, this.indirect, this.getDispatchAction());
    }

    private String toString(Object methodName) {
        if (methodName instanceof String) {
            return (String)methodName;
        }
        if (RubyGuards.isRubyString(methodName)) {
            return methodName.toString();
        }
        if (RubyGuards.isRubySymbol(methodName)) {
            return Layouts.SYMBOL.getString((DynamicObject)methodName);
        }
        throw new UnsupportedOperationException();
    }

    private DispatchNode tryMultilanguage(VirtualFrame frame, DispatchNode first, Object methodName, Object argumentsObjects) {
        if (this.getContext().getMultilanguageObject() != null) {
            CompilerAsserts.neverPartOfCompilation();
            TruffleObject multilanguageObject = this.getContext().getMultilanguageObject();
            ForeignObjectAccessNode readLanguage = ForeignObjectAccessNode.getAccess((Message)Read.create((Receiver)Receiver.create(), (Argument)Argument.create()));
            TruffleObject language = (TruffleObject)readLanguage.executeForeign(frame, multilanguageObject, new Object[]{methodName});
            Object[] arguments = (Object[])argumentsObjects;
            if (language != null) {
                return new CachedForeignGlobalDispatchNode(this.getContext(), first, methodName, language, arguments.length);
            }
        }
        return null;
    }

    private DispatchNode createMethodMissingNode(DispatchNode first, Object methodName, Object receiverObject) {
        Shape shape = receiverObject instanceof DynamicObject ? ((DynamicObject)receiverObject).getShape() : null;
        switch (this.missingBehavior) {
            case RETURN_MISSING: {
                return new CachedBoxedReturnMissingDispatchNode(this.getContext(), methodName, first, shape, this.getContext().getCoreLibrary().getMetaClass(receiverObject), this.indirect, this.getDispatchAction());
            }
            case CALL_METHOD_MISSING: {
                InternalMethod method = this.lookup(null, receiverObject, "method_missing", true);
                if (method == null) {
                    throw new RaiseException(this.getContext().getCoreLibrary().runtimeError(receiverObject.toString() + " didn't have a #method_missing", this));
                }
                if (this.getContext().getOptions().DISPATCH_METAPROGRAMMING_ALWAYS_UNCACHED) {
                    return new UncachedDispatchNode(this.getContext(), this.ignoreVisibility, this.getDispatchAction(), this.missingBehavior);
                }
                return new CachedBoxedMethodMissingDispatchNode(this.getContext(), methodName, first, shape, this.getContext().getCoreLibrary().getMetaClass(receiverObject), method, this.getContext().getOptions().DISPATCH_METAPROGRAMMING_ALWAYS_INDIRECT, this.getDispatchAction());
            }
        }
        throw new UnsupportedOperationException(this.missingBehavior.toString());
    }
}

