/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.dispatch;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.dispatch.CachedDispatchNode;
import org.jruby.truffle.nodes.dispatch.DispatchAction;
import org.jruby.truffle.nodes.dispatch.DispatchNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.methods.InternalMethod;

public class CachedSingletonDispatchNode
extends CachedDispatchNode {
    private final DynamicObject expectedReceiver;
    private final Assumption unmodifiedAssumption;
    private final InternalMethod method;
    @Node.Child
    private DirectCallNode callNode;
    @Node.Child
    private IndirectCallNode indirectCallNode;

    public CachedSingletonDispatchNode(RubyContext context, Object cachedName, DispatchNode next, DynamicObject expectedReceiver, DynamicObject expectedClass, InternalMethod method, boolean indirect, DispatchAction dispatchAction) {
        super(context, cachedName, next, indirect, dispatchAction);
        assert (RubyGuards.isRubyClass(expectedClass));
        this.expectedReceiver = expectedReceiver;
        this.unmodifiedAssumption = Layouts.MODULE.getFields(expectedClass).getUnmodifiedAssumption();
        this.next = next;
        this.method = method;
        if (method != null) {
            if (indirect) {
                this.indirectCallNode = Truffle.getRuntime().createIndirectCallNode();
            } else {
                this.callNode = Truffle.getRuntime().createDirectCallNode(method.getCallTarget());
                if (this.callNode.isCallTargetCloningAllowed() && method.getSharedMethodInfo().shouldAlwaysSplit() || method.getDeclaringModule() != null && Layouts.MODULE.getFields(method.getDeclaringModule()).getName().equals("TruffleInterop")) {
                    this.insert((Node)this.callNode);
                    this.callNode.cloneCallTarget();
                }
            }
        }
    }

    @Override
    public boolean guard(Object methodName, Object receiver) {
        return this.guardName(methodName) && receiver == this.expectedReceiver;
    }

    @Override
    public Object executeDispatch(VirtualFrame frame, Object receiverObject, Object methodName, Object blockObject, Object argumentsObjects) {
        if (!this.guard(methodName, receiverObject)) {
            return this.next.executeDispatch(frame, receiverObject, methodName, blockObject, argumentsObjects);
        }
        try {
            this.unmodifiedAssumption.check();
        }
        catch (InvalidAssumptionException e) {
            return this.resetAndDispatch(frame, receiverObject, methodName, (DynamicObject)blockObject, argumentsObjects, "class modified");
        }
        switch (this.getDispatchAction()) {
            case CALL_METHOD: {
                if (this.isIndirect()) {
                    return this.indirectCallNode.call(frame, this.method.getCallTarget(), RubyArguments.pack(this.method, this.method.getDeclarationFrame(), this.expectedReceiver, (DynamicObject)blockObject, (Object[])argumentsObjects));
                }
                return this.callNode.call(frame, RubyArguments.pack(this.method, this.method.getDeclarationFrame(), this.expectedReceiver, (DynamicObject)blockObject, (Object[])argumentsObjects));
            }
            case RESPOND_TO_METHOD: {
                return true;
            }
        }
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return String.format("CachedBoxedDispatchNode(:%s, %s@%x, %s)", this.getCachedNameAsSymbol().toString(), this.expectedReceiver, this.expectedReceiver.hashCode(), this.method == null ? "null" : this.method.toString());
    }

    @Override
    public boolean couldOptimizeKeywordArguments() {
        return false;
    }

    public InternalMethod getMethod() {
        return this.method;
    }

    public Assumption getUnmodifiedAssumption() {
        return this.unmodifiedAssumption;
    }
}

