/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyGC;
import org.jruby.RubyString;
import org.jruby.ext.rbconfig.RbConfigLibrary;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.UnaryCoreMethodNode;
import org.jruby.truffle.nodes.core.YieldingCoreMethodNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyCallStack;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.backtrace.BacktraceFormatter;
import org.jruby.truffle.runtime.backtrace.BacktraceInterleaver;
import org.jruby.truffle.runtime.cext.CExtManager;
import org.jruby.truffle.runtime.cext.CExtSubsystem;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.ArrayOperations;
import org.jruby.truffle.runtime.core.CoreLibrary;
import org.jruby.truffle.runtime.hash.BucketsStrategy;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.subsystems.SimpleShell;
import org.jruby.util.ByteList;
import org.jruby.util.Memo;

@CoreClass(name="Truffle::Primitive")
public abstract class TrufflePrimitiveNodes {

    @CoreMethod(names={"print_interleaved_backtrace"}, onSingleton=true)
    public static abstract class PrintInterleavedBacktraceNode
    extends CoreMethodNode {
        public PrintInterleavedBacktraceNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject printInterleavedBacktrace() {
            List<String> rubyBacktrace = BacktraceFormatter.createDefaultFormatter(this.getContext()).formatBacktrace(null, RubyCallStack.getBacktrace(this));
            StackTraceElement[] javaStacktrace = new Exception().getStackTrace();
            for (String line : BacktraceInterleaver.interleave(rubyBacktrace, javaStacktrace)) {
                System.err.println(line);
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"synchronized"}, isModuleFunction=true, required=1, needsBlock=true)
    public static abstract class SynchronizedPrimitiveNode
    extends YieldingCoreMethodNode {
        public SynchronizedPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isRubyProc(block)"})
        public Object synchronize(VirtualFrame frame, DynamicObject self, DynamicObject block) {
            DynamicObject dynamicObject = self;
            synchronized (dynamicObject) {
                return this.yield(frame, block, new Object[0]);
            }
        }
    }

    @CoreMethod(names={"fixnum_lower"}, isModuleFunction=true, required=1)
    public static abstract class FixnumLowerPrimitiveNode
    extends UnaryCoreMethodNode {
        public FixnumLowerPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int lower(int value) {
            return value;
        }

        @Specialization(guards={"canLower(value)"})
        public int lower(long value) {
            return (int)value;
        }

        @Specialization(guards={"!canLower(value)"})
        public long lowerFails(long value) {
            return value;
        }

        protected static boolean canLower(long value) {
            return CoreLibrary.fitsIntoInteger(value);
        }
    }

    @CoreMethod(names={"install_rubinius_primitive"}, isModuleFunction=true, required=1)
    public static abstract class InstallRubiniusPrimitiveNode
    extends CoreMethodArrayArgumentsNode {
        public InstallRubiniusPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyMethod(rubyMethod)"})
        public Object installRubiniusPrimitive(DynamicObject rubyMethod) {
            String name = Layouts.METHOD.getMethod(rubyMethod).getName();
            this.getContext().getRubiniusPrimitiveManager().installPrimitive(name, rubyMethod);
            return this.nil();
        }
    }

    @CoreMethod(names={"at_exit"}, isModuleFunction=true, needsBlock=true, required=1)
    public static abstract class AtExitSystemNode
    extends CoreMethodArrayArgumentsNode {
        public AtExitSystemNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyProc(block)"})
        public Object atExit(boolean always, DynamicObject block) {
            this.getContext().getAtExitManager().add(block, always);
            return this.nil();
        }
    }

    @CoreMethod(names={"host_os"}, onSingleton=true)
    public static abstract class HostOSNode
    extends CoreMethodNode {
        public HostOSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject hostOS() {
            return Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), RubyString.encodeBytelist((CharSequence)RbConfigLibrary.getOSName(), (Encoding)UTF8Encoding.INSTANCE), 0, null);
        }
    }

    @CoreMethod(names={"jruby_home_directory"}, onSingleton=true)
    public static abstract class JRubyHomeDirectoryNode
    extends CoreMethodNode {
        public JRubyHomeDirectoryNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject jrubyHomeDirectory() {
            return Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), RubyString.encodeBytelist((CharSequence)this.getContext().getRuntime().getJRubyHome(), (Encoding)UTF8Encoding.INSTANCE), 0, null);
        }
    }

    @CoreMethod(names={"debug_print"}, onSingleton=true, required=1)
    public static abstract class DebugPrintNode
    extends CoreMethodArrayArgumentsNode {
        public DebugPrintNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(string)"})
        public DynamicObject debugPrint(DynamicObject string) {
            System.err.println(string.toString());
            return this.nil();
        }
    }

    @CoreMethod(names={"cext_supported?"}, needsSelf=false, onSingleton=true)
    public static abstract class CExtSupportedNode
    extends CoreMethodArrayArgumentsNode {
        public CExtSupportedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public boolean cExtSupported() {
            return CExtManager.getSubsystem() != null;
        }
    }

    @CoreMethod(names={"cext_load"}, onSingleton=true, needsSelf=false, required=3)
    public static abstract class CExtLoadNode
    extends CoreMethodArrayArgumentsNode {
        public CExtLoadNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyArray(initFunctions)", "isRubyArray(cFlags)", "isRubyArray(files)"})
        public boolean cExtLoad(DynamicObject initFunctions, DynamicObject cFlags, DynamicObject files) {
            CExtSubsystem subsystem = CExtManager.getSubsystem();
            if (subsystem == null) {
                throw new UnsupportedOperationException();
            }
            subsystem.load(this.toStrings(initFunctions), this.toStrings(cFlags), this.toStrings(files));
            return true;
        }

        private String[] toStrings(DynamicObject array) {
            assert (RubyGuards.isRubyArray(array));
            String[] strings = new String[Layouts.ARRAY.getSize(array)];
            int n = 0;
            for (Object object : ArrayOperations.toIterable(array)) {
                if (RubyGuards.isRubyString(object) || RubyGuards.isRubySymbol(object)) {
                    strings[n] = object.toString();
                    ++n;
                    continue;
                }
                throw new RaiseException(this.getContext().getCoreLibrary().typeErrorCantConvertInto(this.getContext().getCoreLibrary().getLogicalClass(object), this.getContext().getCoreLibrary().getStringClass(), this));
            }
            return strings;
        }
    }

    @CoreMethod(names={"detach"}, onSingleton=true, required=2)
    public static abstract class DetachNode
    extends CoreMethodArrayArgumentsNode {
        public DetachNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(file)"})
        public DynamicObject detach(DynamicObject file, int line) {
            this.getContext().getAttachmentsManager().detach(file.toString(), line);
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"attach"}, onSingleton=true, required=2, needsBlock=true)
    public static abstract class AttachNode
    extends CoreMethodArrayArgumentsNode {
        public AttachNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(file)", "isRubyProc(block)"})
        public DynamicObject attach(DynamicObject file, int line, DynamicObject block) {
            this.getContext().getAttachmentsManager().attach(file.toString(), line, block);
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"coverage_start"}, onSingleton=true)
    public static abstract class CoverageStartNode
    extends CoreMethodArrayArgumentsNode {
        public CoverageStartNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject coverageStart() {
            if (this.getContext().getCoverageTracker() == null) {
                throw new UnsupportedOperationException("coverage is disabled");
            }
            this.getContext().getCoverageTracker().install();
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"coverage_result"}, onSingleton=true)
    public static abstract class CoverageResultNode
    extends CoreMethodArrayArgumentsNode {
        public CoverageResultNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject coverageResult() {
            if (this.getContext().getCoverageTracker() == null) {
                throw new UnsupportedOperationException("coverage is disabled");
            }
            HashMap<DynamicObject, DynamicObject> converted = new HashMap<DynamicObject, DynamicObject>();
            for (Map.Entry source : this.getContext().getCoverageTracker().getCounts().entrySet()) {
                Object[] store = this.lineCountsStore((Long[])source.getValue());
                DynamicObject array = Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), store, store.length);
                converted.put(Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), RubyString.encodeBytelist((CharSequence)((Source)source.getKey()).getPath(), (Encoding)UTF8Encoding.INSTANCE), 0, null), array);
            }
            return BucketsStrategy.create(this.getContext(), converted.entrySet(), false);
        }

        private Object[] lineCountsStore(Long[] array) {
            Object[] store = new Object[array.length];
            for (int n = 0; n < array.length; ++n) {
                store[n] = array[n] == null ? this.getContext().getCoreLibrary().getNilObject() : array[n];
            }
            return store;
        }
    }

    @CoreMethod(names={"simple_shell"}, onSingleton=true)
    public static abstract class SimpleShellNode
    extends CoreMethodArrayArgumentsNode {
        public SimpleShellNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject simpleShell() {
            new SimpleShell(this.getContext()).run(RubyCallStack.getCallerFrame(this.getContext()).getFrame(FrameInstance.FrameAccess.MATERIALIZE, true).materialize(), this);
            return this.nil();
        }
    }

    @CoreMethod(names={"graal_version"}, onSingleton=true)
    public static abstract class GraalVersionNode
    extends CoreMethodArrayArgumentsNode {
        public GraalVersionNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject graalVersion() {
            return Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), RubyString.encodeBytelist((CharSequence)System.getProperty("graal.version", "unknown"), (Encoding)UTF8Encoding.INSTANCE), 0, null);
        }
    }

    @CoreMethod(names={"substrate?"}, onSingleton=true)
    public static abstract class SubstrateNode
    extends CoreMethodArrayArgumentsNode {
        public SubstrateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean substrate() {
            return Ruby.isSubstrateVM();
        }
    }

    @CoreMethod(names={"graal?"}, onSingleton=true)
    public static abstract class GraalNode
    extends CoreMethodArrayArgumentsNode {
        public GraalNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public boolean graal() {
            return Truffle.getRuntime().getName().toLowerCase(Locale.ENGLISH).contains("graal");
        }
    }

    @CoreMethod(names={"dump_string"}, onSingleton=true, required=1)
    public static abstract class DumpStringNode
    extends CoreMethodArrayArgumentsNode {
        public DumpStringNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(string)"})
        public DynamicObject dumpString(DynamicObject string) {
            StringBuilder builder = new StringBuilder();
            ByteList byteList = Layouts.STRING.getByteList(string);
            for (int i = 0; i < byteList.length(); ++i) {
                builder.append(String.format("\\x%02x", byteList.get(i)));
            }
            return Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), RubyString.encodeBytelist((CharSequence)builder.toString(), (Encoding)UTF8Encoding.INSTANCE), 0, null);
        }
    }

    @CoreMethod(names={"java_class_of"}, onSingleton=true, required=1)
    public static abstract class JavaClassOfNode
    extends CoreMethodArrayArgumentsNode {
        public JavaClassOfNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject javaClassOf(Object value) {
            return Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), RubyString.encodeBytelist((CharSequence)value.getClass().getSimpleName(), (Encoding)UTF8Encoding.INSTANCE), 0, null);
        }
    }

    @CoreMethod(names={"assert_not_compiled"}, onSingleton=true)
    public static abstract class AssertNotCompiledNode
    extends CoreMethodArrayArgumentsNode {
        public AssertNotCompiledNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject assertNotCompiled() {
            throw new RaiseException(this.getContext().getCoreLibrary().runtimeError("Truffle::Primitive.assert_not_compiled can only be called lexically", this));
        }
    }

    @CoreMethod(names={"assert_constant"}, onSingleton=true, required=1)
    public static abstract class AssertConstantNode
    extends CoreMethodArrayArgumentsNode {
        public AssertConstantNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject assertConstant(Object value) {
            throw new RaiseException(this.getContext().getCoreLibrary().runtimeError("Truffle::Primitive.assert_constant can only be called lexically", this));
        }
    }

    @CoreMethod(names={"gc_time"}, onSingleton=true)
    public static abstract class GCTimeNode
    extends CoreMethodArrayArgumentsNode {
        public GCTimeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public long gcTime() {
            return RubyGC.getCollectionTime();
        }
    }

    @CoreMethod(names={"gc_count"}, onSingleton=true)
    public static abstract class GCCountNode
    extends CoreMethodArrayArgumentsNode {
        public GCCountNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int gcCount() {
            return RubyGC.getCollectionCount();
        }
    }

    @CoreMethod(names={"source_of_caller"}, onSingleton=true)
    public static abstract class SourceOfCallerNode
    extends CoreMethodArrayArgumentsNode {
        public SourceOfCallerNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject sourceOfCaller() {
            final Memo frameCount = new Memo((Object)0);
            String source = (String)Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<String>(){

                public String visitFrame(FrameInstance frameInstance) {
                    if ((Integer)frameCount.get() == 1) {
                        return frameInstance.getCallNode().getEncapsulatingSourceSection().getSource().getName();
                    }
                    frameCount.set((Object)((Integer)frameCount.get() + 1));
                    return null;
                }
            });
            return Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), RubyString.encodeBytelist((CharSequence)source, (Encoding)UTF8Encoding.INSTANCE), 0, null);
        }
    }

    @CoreMethod(names={"binding_of_caller"}, onSingleton=true)
    public static abstract class BindingOfCallerNode
    extends CoreMethodArrayArgumentsNode {
        public BindingOfCallerNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject bindingOfCaller() {
            final Memo frameCount = new Memo((Object)0);
            MaterializedFrame frame = (MaterializedFrame)Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<MaterializedFrame>(){

                public MaterializedFrame visitFrame(FrameInstance frameInstance) {
                    if ((Integer)frameCount.get() == 1) {
                        return frameInstance.getFrame(FrameInstance.FrameAccess.READ_WRITE, false).materialize();
                    }
                    frameCount.set((Object)((Integer)frameCount.get() + 1));
                    return null;
                }
            });
            return Layouts.BINDING.createBinding(this.getContext().getCoreLibrary().getBindingFactory(), RubyArguments.getSelf(frame.getArguments()), frame);
        }
    }
}

