/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.BooleanCastNodeGen;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.YieldingCoreMethodNode;
import org.jruby.truffle.nodes.core.array.ArrayBuilderNode;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;

@CoreClass(name="Range")
public abstract class RangeNodes {

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        public AllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            return Layouts.OBJECT_RANGE.createObjectRange(Layouts.CLASS.getInstanceFactory(rubyClass), false, this.nil(), this.nil());
        }
    }

    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="self"), @NodeChild(type=RubyNode.class, value="excludeEnd")})
    public static abstract class InternalSetExcludeEndNode
    extends RubyNode {
        public InternalSetExcludeEndNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"excludeEnd"})
        public RubyNode castToBoolean(RubyNode excludeEnd) {
            return BooleanCastNodeGen.create(this.getContext(), this.getSourceSection(), excludeEnd);
        }

        @Specialization(guards={"isObjectRange(range)"})
        public boolean setExcludeEnd(DynamicObject range, boolean excludeEnd) {
            Layouts.OBJECT_RANGE.setExcludedEnd(range, excludeEnd);
            return excludeEnd;
        }
    }

    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="self"), @NodeChild(type=RubyNode.class, value="end")})
    public static abstract class InternalSetEndNode
    extends RubyNode {
        public InternalSetEndNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isObjectRange(range)"})
        public Object setEnd(DynamicObject range, Object end) {
            Layouts.OBJECT_RANGE.setEnd(range, end);
            return end;
        }
    }

    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="self"), @NodeChild(type=RubyNode.class, value="begin")})
    public static abstract class InternalSetBeginNode
    extends RubyNode {
        public InternalSetBeginNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isObjectRange(range)"})
        public Object setBegin(DynamicObject range, Object begin) {
            Layouts.OBJECT_RANGE.setBegin(range, begin);
            return begin;
        }
    }

    @CoreMethod(names={"to_a"}, lowerFixnumSelf=true)
    public static abstract class ToANode
    extends CoreMethodArrayArgumentsNode {
        public ToANode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isIntegerFixnumRange(range)"})
        public DynamicObject toA(DynamicObject range) {
            int begin = Layouts.INTEGER_FIXNUM_RANGE.getBegin(range);
            int result = Layouts.INTEGER_FIXNUM_RANGE.getExcludedEnd(range) ? Layouts.INTEGER_FIXNUM_RANGE.getEnd(range) : Layouts.INTEGER_FIXNUM_RANGE.getEnd(range) + 1;
            int length = result - begin;
            if (length < 0) {
                return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), null, 0);
            }
            int[] values = new int[length];
            for (int n = 0; n < length; ++n) {
                values[n] = begin + n;
            }
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), values, length);
        }

        @Specialization(guards={"isObjectRange(range)"})
        public Object toA(VirtualFrame frame, DynamicObject range) {
            return this.ruby(frame, "to_a_internal", new Object[0]);
        }
    }

    @CoreMethod(names={"step"}, needsBlock=true, optional=1, returnsEnumeratorIfNoBlock=true)
    public static abstract class StepNode
    extends YieldingCoreMethodNode {
        public StepNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isIntegerFixnumRange(range)", "step > 0", "isRubyProc(block)"})
        public Object stepInt(VirtualFrame frame, DynamicObject range, int step, DynamicObject block) {
            int count = 0;
            try {
                int result = Layouts.INTEGER_FIXNUM_RANGE.getExcludedEnd(range) ? Layouts.INTEGER_FIXNUM_RANGE.getEnd(range) : Layouts.INTEGER_FIXNUM_RANGE.getEnd(range) + 1;
                for (int n = Layouts.INTEGER_FIXNUM_RANGE.getBegin(range); n < result; n += step) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    this.yield(frame, block, n);
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return range;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isLongFixnumRange(range)", "step > 0", "isRubyProc(block)"})
        public Object stepLong(VirtualFrame frame, DynamicObject range, int step, DynamicObject block) {
            int count = 0;
            try {
                long result = Layouts.LONG_FIXNUM_RANGE.getExcludedEnd(range) ? Layouts.LONG_FIXNUM_RANGE.getEnd(range) : Layouts.LONG_FIXNUM_RANGE.getEnd(range) + 1L;
                for (long n = Layouts.LONG_FIXNUM_RANGE.getBegin(range); n < result; n += (long)step) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    this.yield(frame, block, n);
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return range;
        }

        @Specialization(guards={"isIntegerFixnumRange(range)", "wasProvided(step)", "isRubyProc(block)"})
        public Object stepFallbackInt(VirtualFrame frame, DynamicObject range, Object step, DynamicObject block) {
            return this.ruby(frame, "step_internal(step, &block)", "step", step, "block", block);
        }

        @Specialization(guards={"isLongFixnumRange(range)", "wasProvided(step)", "isRubyProc(block)"})
        public Object stepFallbackLong(VirtualFrame frame, DynamicObject range, Object step, DynamicObject block) {
            return this.ruby(frame, "step_internal(step, &block)", "step", step, "block", block);
        }

        @Specialization(guards={"isIntegerFixnumRange(range)"})
        public Object stepInt(VirtualFrame frame, DynamicObject range, NotProvided step, NotProvided block) {
            return this.ruby(frame, "step_internal", new Object[0]);
        }

        @Specialization(guards={"isIntegerFixnumRange(range)", "isRubyProc(block)"})
        public Object stepInt(VirtualFrame frame, DynamicObject range, NotProvided step, DynamicObject block) {
            return this.ruby(frame, "step_internal(&block)", "block", block);
        }

        @Specialization(guards={"isIntegerFixnumRange(range)", "!isInteger(step)", "!isLong(step)", "wasProvided(step)"})
        public Object stepInt(VirtualFrame frame, DynamicObject range, Object step, NotProvided block) {
            return this.ruby(frame, "step_internal(step)", "step", step);
        }

        @Specialization(guards={"isLongFixnumRange(range)"})
        public Object stepLong(VirtualFrame frame, DynamicObject range, NotProvided step, NotProvided block) {
            return this.ruby(frame, "step_internal", new Object[0]);
        }

        @Specialization(guards={"isLongFixnumRange(range)", "isRubyProc(block)"})
        public Object stepLong(VirtualFrame frame, DynamicObject range, NotProvided step, DynamicObject block) {
            return this.ruby(frame, "step_internal(&block)", "block", block);
        }

        @Specialization(guards={"isLongFixnumRange(range)", "wasProvided(step)"})
        public Object stepLong(VirtualFrame frame, DynamicObject range, Object step, NotProvided block) {
            return this.ruby(frame, "step_internal(step)", "step", step);
        }

        @Specialization(guards={"isObjectRange(range)", "wasProvided(step)", "isRubyProc(block)"})
        public Object stepObject(VirtualFrame frame, DynamicObject range, Object step, DynamicObject block) {
            return this.ruby(frame, "step_internal(step, &block)", "step", step, "block", block);
        }

        @Specialization(guards={"isObjectRange(range)"})
        public Object stepObject(VirtualFrame frame, DynamicObject range, NotProvided step, NotProvided block) {
            return this.ruby(frame, "step_internal", new Object[0]);
        }

        @Specialization(guards={"isObjectRange(range)", "isRubyProc(block)"})
        public Object stepObject(VirtualFrame frame, DynamicObject range, NotProvided step, DynamicObject block) {
            return this.ruby(frame, "step_internal(&block)", "block", block);
        }

        @Specialization(guards={"isObjectRange(range)", "wasProvided(step)"})
        public Object step(VirtualFrame frame, DynamicObject range, Object step, NotProvided block) {
            return this.ruby(frame, "step_internal(step)", "step", step);
        }
    }

    @CoreMethod(names={"end"})
    public static abstract class EndNode
    extends CoreMethodArrayArgumentsNode {
        public EndNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isIntegerFixnumRange(range)"})
        public int lastInt(DynamicObject range) {
            return Layouts.INTEGER_FIXNUM_RANGE.getEnd(range);
        }

        @Specialization(guards={"isLongFixnumRange(range)"})
        public long lastLong(DynamicObject range) {
            return Layouts.LONG_FIXNUM_RANGE.getEnd(range);
        }

        @Specialization(guards={"isObjectRange(range)"})
        public Object lastObject(DynamicObject range) {
            return Layouts.OBJECT_RANGE.getEnd(range);
        }
    }

    @CoreMethod(names={"initialize_internal"}, required=2, optional=1)
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isObjectRange(range)"})
        public DynamicObject initialize(DynamicObject range, Object begin, Object end, NotProvided excludeEnd) {
            return this.initialize(range, begin, end, false);
        }

        @Specialization(guards={"isObjectRange(range)"})
        public DynamicObject initialize(DynamicObject range, Object begin, Object end, boolean excludeEnd) {
            Layouts.OBJECT_RANGE.setExcludedEnd(range, excludeEnd);
            Layouts.OBJECT_RANGE.setBegin(range, begin);
            Layouts.OBJECT_RANGE.setEnd(range, end);
            return range;
        }
    }

    @CoreMethod(names={"begin"})
    public static abstract class BeginNode
    extends CoreMethodArrayArgumentsNode {
        public BeginNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isIntegerFixnumRange(range)"})
        public int eachInt(DynamicObject range) {
            return Layouts.INTEGER_FIXNUM_RANGE.getBegin(range);
        }

        @Specialization(guards={"isLongFixnumRange(range)"})
        public long eachLong(DynamicObject range) {
            return Layouts.LONG_FIXNUM_RANGE.getBegin(range);
        }

        @Specialization(guards={"isObjectRange(range)"})
        public Object eachObject(DynamicObject range) {
            return Layouts.OBJECT_RANGE.getBegin(range);
        }
    }

    @CoreMethod(names={"exclude_end?"})
    public static abstract class ExcludeEndNode
    extends CoreMethodArrayArgumentsNode {
        public ExcludeEndNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isIntegerFixnumRange(range)"})
        public boolean excludeEndInt(DynamicObject range) {
            return Layouts.INTEGER_FIXNUM_RANGE.getExcludedEnd(range);
        }

        @Specialization(guards={"isLongFixnumRange(range)"})
        public boolean excludeEndLong(DynamicObject range) {
            return Layouts.LONG_FIXNUM_RANGE.getExcludedEnd(range);
        }

        @Specialization(guards={"isObjectRange(range)"})
        public boolean excludeEndObject(DynamicObject range) {
            return Layouts.OBJECT_RANGE.getExcludedEnd(range);
        }
    }

    @CoreMethod(names={"each"}, needsBlock=true, lowerFixnumSelf=true, returnsEnumeratorIfNoBlock=true)
    public static abstract class EachNode
    extends YieldingCoreMethodNode {
        public EachNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isIntegerFixnumRange(range)", "isRubyProc(block)"})
        public Object eachInt(VirtualFrame frame, DynamicObject range, DynamicObject block) {
            int result = Layouts.INTEGER_FIXNUM_RANGE.getExcludedEnd(range) ? Layouts.INTEGER_FIXNUM_RANGE.getEnd(range) : Layouts.INTEGER_FIXNUM_RANGE.getEnd(range) + 1;
            int exclusiveEnd = result;
            int count = 0;
            try {
                for (int n = Layouts.INTEGER_FIXNUM_RANGE.getBegin(range); n < exclusiveEnd; ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    this.yield(frame, block, n);
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return range;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isLongFixnumRange(range)", "isRubyProc(block)"})
        public Object eachLong(VirtualFrame frame, DynamicObject range, DynamicObject block) {
            long result = Layouts.LONG_FIXNUM_RANGE.getExcludedEnd(range) ? Layouts.LONG_FIXNUM_RANGE.getEnd(range) : Layouts.LONG_FIXNUM_RANGE.getEnd(range) + 1L;
            long exclusiveEnd = result;
            int count = 0;
            try {
                for (long n = Layouts.LONG_FIXNUM_RANGE.getBegin(range); n < exclusiveEnd; ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    this.yield(frame, block, n);
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return range;
        }

        @Specialization(guards={"isLongFixnumRange(range)"})
        public Object eachObject(VirtualFrame frame, DynamicObject range, NotProvided block) {
            return this.ruby(frame, "each_internal(&block)", "block", this.nil());
        }

        @Specialization(guards={"isObjectRange(range)"})
        public Object each(VirtualFrame frame, DynamicObject range, NotProvided block) {
            return this.ruby(frame, "each_internal(&block)", "block", this.nil());
        }

        @Specialization(guards={"isObjectRange(range)", "isRubyProc(block)"})
        public Object each(VirtualFrame frame, DynamicObject range, DynamicObject block) {
            return this.ruby(frame, "each_internal(&block)", "block", block);
        }
    }

    @CoreMethod(names={"collect", "map"}, needsBlock=true, lowerFixnumSelf=true)
    public static abstract class CollectNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private ArrayBuilderNode arrayBuilder;

        public CollectNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.arrayBuilder = new ArrayBuilderNode.UninitializedArrayBuilderNode(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isIntegerFixnumRange(range)", "isRubyProc(block)"})
        public DynamicObject collect(VirtualFrame frame, DynamicObject range, DynamicObject block) {
            int begin = Layouts.INTEGER_FIXNUM_RANGE.getBegin(range);
            int result = Layouts.INTEGER_FIXNUM_RANGE.getExcludedEnd(range) ? Layouts.INTEGER_FIXNUM_RANGE.getEnd(range) : Layouts.INTEGER_FIXNUM_RANGE.getEnd(range) + 1;
            int exclusiveEnd = result;
            int length = exclusiveEnd - begin;
            Object store = this.arrayBuilder.start(length);
            int count = 0;
            try {
                for (int n = 0; n < length; ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    store = this.arrayBuilder.appendValue(store, n, this.yield(frame, block, n));
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), this.arrayBuilder.finish(store, length), length);
        }
    }
}

