/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.KernelNodes;
import org.jruby.truffle.nodes.core.UnaryCoreMethodNode;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.subsystems.ThreadManager;

@CoreClass(name="Mutex")
public abstract class MutexNodes {

    @CoreMethod(names={"sleep"}, optional=1)
    public static abstract class SleepNode
    extends CoreMethodArrayArgumentsNode {
        public SleepNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public long sleep(DynamicObject mutex, NotProvided duration) {
            return this.doSleepMillis(mutex, Long.MAX_VALUE);
        }

        @Specialization(guards={"isNil(duration)"})
        public long sleep(DynamicObject mutex, DynamicObject duration) {
            return this.sleep(mutex, NotProvided.INSTANCE);
        }

        @Specialization
        public long sleep(DynamicObject mutex, long duration) {
            return this.doSleepMillis(mutex, duration * 1000L);
        }

        @Specialization
        public long sleep(DynamicObject mutex, double duration) {
            return this.doSleepMillis(mutex, (long)(duration * 1000.0));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long doSleepMillis(DynamicObject mutex, long durationInMillis) {
            if (durationInMillis < 0L) {
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("time interval must be positive", this));
            }
            ReentrantLock lock = Layouts.MUTEX.getLock(mutex);
            DynamicObject thread = this.getContext().getThreadManager().getCurrentThread();
            Layouts.THREAD.getWakeUp(thread).getAndSet(false);
            UnlockNode.unlock(lock, thread, this);
            try {
                long l = KernelNodes.SleepNode.sleepFor(this, this.getContext(), durationInMillis);
                return l;
            }
            finally {
                LockNode.lock(lock, thread, this);
            }
        }
    }

    @CoreMethod(names={"unlock"})
    public static abstract class UnlockNode
    extends UnaryCoreMethodNode {
        public UnlockNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject unlock(DynamicObject mutex) {
            ReentrantLock lock = Layouts.MUTEX.getLock(mutex);
            DynamicObject thread = this.getContext().getThreadManager().getCurrentThread();
            UnlockNode.unlock(lock, thread, this);
            return mutex;
        }

        protected static void unlock(ReentrantLock lock, DynamicObject thread, RubyNode currentNode) {
            assert (RubyGuards.isRubyThread(thread));
            RubyContext context = currentNode.getContext();
            try {
                lock.unlock();
            }
            catch (IllegalMonitorStateException e) {
                if (!lock.isLocked()) {
                    throw new RaiseException(context.getCoreLibrary().threadError("Attempt to unlock a mutex which is not locked", currentNode));
                }
                throw new RaiseException(context.getCoreLibrary().threadError("Attempt to unlock a mutex which is locked by another thread", currentNode));
            }
            Layouts.THREAD.getOwnedLocks(thread).remove(lock);
        }
    }

    @CoreMethod(names={"try_lock"})
    public static abstract class TryLockNode
    extends UnaryCoreMethodNode {
        public TryLockNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean tryLock(DynamicObject mutex) {
            ReentrantLock lock = Layouts.MUTEX.getLock(mutex);
            if (lock.isHeldByCurrentThread()) {
                return false;
            }
            if (lock.tryLock()) {
                DynamicObject thread = this.getContext().getThreadManager().getCurrentThread();
                Layouts.THREAD.getOwnedLocks(thread).add(lock);
                return true;
            }
            return false;
        }
    }

    @CoreMethod(names={"owned?"})
    public static abstract class IsOwnedNode
    extends UnaryCoreMethodNode {
        public IsOwnedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean isOwned(DynamicObject mutex) {
            return Layouts.MUTEX.getLock(mutex).isHeldByCurrentThread();
        }
    }

    @CoreMethod(names={"locked?"})
    public static abstract class IsLockedNode
    extends UnaryCoreMethodNode {
        public IsLockedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean isLocked(DynamicObject mutex) {
            return Layouts.MUTEX.getLock(mutex).isLocked();
        }
    }

    @CoreMethod(names={"lock"})
    public static abstract class LockNode
    extends UnaryCoreMethodNode {
        public LockNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject lock(DynamicObject mutex) {
            ReentrantLock lock = Layouts.MUTEX.getLock(mutex);
            DynamicObject thread = this.getContext().getThreadManager().getCurrentThread();
            LockNode.lock(lock, thread, this);
            return mutex;
        }

        protected static void lock(final ReentrantLock lock, final DynamicObject thread, RubyNode currentNode) {
            assert (RubyGuards.isRubyThread(thread));
            RubyContext context = currentNode.getContext();
            if (lock.isHeldByCurrentThread()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(context.getCoreLibrary().threadError("deadlock; recursive locking", currentNode));
            }
            context.getThreadManager().runUntilResult(currentNode, new ThreadManager.BlockingAction<Boolean>(){

                @Override
                public Boolean block() throws InterruptedException {
                    lock.lockInterruptibly();
                    Layouts.THREAD.getOwnedLocks(thread).add(lock);
                    return true;
                }
            });
        }
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        public AllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            return Layouts.MUTEX.createMutex(Layouts.CLASS.getInstanceFactory(rubyClass), new ReentrantLock());
        }
    }
}

