/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.EnumSet;
import java.util.List;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.RubyString;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.objectstorage.ReadHeadObjectFieldNode;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyCallStack;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.backtrace.Backtrace;
import org.jruby.truffle.runtime.backtrace.BacktraceFormatter;
import org.jruby.truffle.runtime.layouts.Layouts;

@CoreClass(name="Exception")
public abstract class ExceptionNodes {
    @CompilerDirectives.TruffleBoundary
    public static DynamicObject asRubyStringArray(DynamicObject exception) {
        assert (RubyGuards.isRubyException(exception));
        assert (Layouts.EXCEPTION.getBacktrace(exception) != null);
        RubyContext context = Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getLogicalClass(exception)).getContext();
        List<String> lines = new BacktraceFormatter(context, EnumSet.of(BacktraceFormatter.FormattingFlags.OMIT_FROM_PREFIX)).formatBacktrace(exception, Layouts.EXCEPTION.getBacktrace(exception));
        Object[] array = new Object[lines.size()];
        for (int n = 0; n < lines.size(); ++n) {
            array[n] = Layouts.STRING.createString(Layouts.CLASS.getInstanceFactory(Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getLogicalClass(exception)).getContext().getCoreLibrary().getStringClass()), RubyString.encodeBytelist((CharSequence)lines.get(n), (Encoding)UTF8Encoding.INSTANCE), 0, null);
        }
        return Layouts.ARRAY.createArray(Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getLogicalClass(exception)).getContext().getCoreLibrary().getArrayFactory(), array, array.length);
    }

    public static void setMessage(DynamicObject exception, Object message) {
        Layouts.EXCEPTION.setMessage(exception, message);
    }

    public static DynamicObject createRubyException(DynamicObject rubyClass) {
        return Layouts.EXCEPTION.createException(Layouts.CLASS.getInstanceFactory(rubyClass), null, null);
    }

    public static DynamicObject createRubyException(DynamicObject rubyClass, Object message, Backtrace backtrace) {
        return Layouts.EXCEPTION.createException(Layouts.CLASS.getInstanceFactory(rubyClass), message, backtrace);
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        public AllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            return ExceptionNodes.createRubyException(rubyClass);
        }
    }

    @CoreMethod(names={"message"})
    public static abstract class MessageNode
    extends CoreMethodArrayArgumentsNode {
        public MessageNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object message(DynamicObject exception) {
            Object message = Layouts.EXCEPTION.getMessage(exception);
            if (message == null) {
                String className = Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getLogicalClass(exception)).getName();
                return Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), RubyString.encodeBytelist((CharSequence)className, (Encoding)UTF8Encoding.INSTANCE), 0, null);
            }
            return message;
        }
    }

    @CoreMethod(names={"capture_backtrace!"}, optional=1)
    public static abstract class CaptureBacktraceNode
    extends CoreMethodArrayArgumentsNode {
        public CaptureBacktraceNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject captureBacktrace(DynamicObject exception, NotProvided offset) {
            return this.captureBacktrace(exception, 1);
        }

        @Specialization
        public DynamicObject captureBacktrace(DynamicObject exception, int offset) {
            Backtrace backtrace = RubyCallStack.getBacktrace(this, offset);
            Layouts.EXCEPTION.setBacktrace(exception, backtrace);
            return this.nil();
        }
    }

    @CoreMethod(names={"backtrace"})
    public static abstract class BacktraceNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        ReadHeadObjectFieldNode readCustomBacktrace = new ReadHeadObjectFieldNode("@custom_backtrace");

        public BacktraceNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object backtrace(DynamicObject exception) {
            if (this.readCustomBacktrace.isSet(exception)) {
                return this.readCustomBacktrace.execute(exception);
            }
            if (Layouts.EXCEPTION.getBacktrace(exception) != null) {
                return ExceptionNodes.asRubyStringArray(exception);
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"initialize"}, optional=1)
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject initialize(DynamicObject exception, NotProvided message) {
            ExceptionNodes.setMessage(exception, this.nil());
            return exception;
        }

        @Specialization(guards={"wasProvided(message)"})
        public DynamicObject initialize(DynamicObject exception, Object message) {
            ExceptionNodes.setMessage(exception, message);
            return exception;
        }
    }
}

