/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerOptions;
import com.oracle.truffle.api.ExecutionContext;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrument.ASTProber;
import com.oracle.truffle.api.instrument.Probe;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.tools.CoverageTracker;
import java.io.File;
import java.io.PrintStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import jnr.ffi.LibraryLoader;
import jnr.posix.POSIX;
import jnr.posix.POSIXFactory;
import jnr.posix.POSIXHandler;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyNil;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.TruffleContextInterface;
import org.jruby.ext.ffi.Platform;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyRootNode;
import org.jruby.truffle.nodes.control.SequenceNode;
import org.jruby.truffle.nodes.core.BignumNodes;
import org.jruby.truffle.nodes.core.BindingNodes;
import org.jruby.truffle.nodes.core.EncodingNodes;
import org.jruby.truffle.nodes.core.LoadRequiredLibrariesNode;
import org.jruby.truffle.nodes.core.SetTopLevelBindingNode;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.exceptions.TopLevelRaiseHandler;
import org.jruby.truffle.nodes.instrument.RubyDefaultASTProber;
import org.jruby.truffle.nodes.methods.SetMethodDeclarationContext;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveManager;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.CoreLibrary;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.SymbolTable;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.truffle.runtime.rubinius.RubiniusConfiguration;
import org.jruby.truffle.runtime.sockets.NativeSockets;
import org.jruby.truffle.runtime.subsystems.AtExitManager;
import org.jruby.truffle.runtime.subsystems.AttachmentsManager;
import org.jruby.truffle.runtime.subsystems.FeatureManager;
import org.jruby.truffle.runtime.subsystems.InstrumentationServerManager;
import org.jruby.truffle.runtime.subsystems.ObjectSpaceManager;
import org.jruby.truffle.runtime.subsystems.SafepointManager;
import org.jruby.truffle.runtime.subsystems.SourceManager;
import org.jruby.truffle.runtime.subsystems.ThreadManager;
import org.jruby.truffle.runtime.subsystems.TraceManager;
import org.jruby.truffle.runtime.subsystems.TrufflePOSIXHandler;
import org.jruby.truffle.runtime.subsystems.Warnings;
import org.jruby.truffle.translator.NodeWrapper;
import org.jruby.truffle.translator.TranslatorDriver;
import org.jruby.util.ByteList;
import org.jruby.util.cli.Options;

public class RubyContext
extends ExecutionContext
implements TruffleContextInterface {
    private static volatile RubyContext latestInstance;
    private static final boolean TRUFFLE_COVERAGE;
    private static final int INSTRUMENTATION_SERVER_PORT;
    private final Ruby runtime;
    private final POSIX posix;
    private final NativeSockets nativeSockets;
    private final CoreLibrary coreLibrary;
    private final FeatureManager featureManager;
    private final TraceManager traceManager;
    private final ObjectSpaceManager objectSpaceManager;
    private final ThreadManager threadManager;
    private final AtExitManager atExitManager;
    private final SymbolTable symbolTable = new SymbolTable(this);
    private final Warnings warnings;
    private final SafepointManager safepointManager;
    private final LexicalScope rootLexicalScope;
    private final CompilerOptions compilerOptions;
    private final RubiniusPrimitiveManager rubiniusPrimitiveManager;
    private final CoverageTracker coverageTracker;
    private final InstrumentationServerManager instrumentationServerManager;
    private final AttachmentsManager attachmentsManager;
    private final SourceManager sourceManager;
    private final RubiniusConfiguration rubiniusConfiguration;
    private final AtomicLong nextObjectID = new AtomicLong(6L);
    private final boolean runningOnWindows;
    private final PrintStream debugStandardOut;
    private TruffleObject multilanguageObject;

    public RubyContext(Ruby runtime) {
        latestInstance = this;
        assert (runtime != null);
        this.compilerOptions = Truffle.getRuntime().createCompilerOptions();
        if (this.compilerOptions.supportsOption("MinTimeThreshold")) {
            this.compilerOptions.setOption("MinTimeThreshold", (Object)100000000);
        }
        if (this.compilerOptions.supportsOption("MinInliningMaxCallerSize")) {
            this.compilerOptions.setOption("MinInliningMaxCallerSize", (Object)5000);
        }
        Probe.registerASTProber((ASTProber)new RubyDefaultASTProber());
        this.coverageTracker = TRUFFLE_COVERAGE ? new CoverageTracker() : null;
        this.safepointManager = new SafepointManager(this);
        this.runtime = runtime;
        this.posix = POSIXFactory.getNativePOSIX((POSIXHandler)new TrufflePOSIXHandler(this));
        LibraryLoader loader = LibraryLoader.create(NativeSockets.class);
        loader.library("c");
        this.nativeSockets = (NativeSockets)loader.load();
        this.warnings = new Warnings(this);
        this.objectSpaceManager = new ObjectSpaceManager(this);
        this.coreLibrary = new CoreLibrary(this);
        this.rootLexicalScope = new LexicalScope(null, this.coreLibrary.getObjectClass());
        this.coreLibrary.initialize();
        this.featureManager = new FeatureManager(this);
        this.traceManager = new TraceManager();
        this.atExitManager = new AtExitManager(this);
        this.threadManager = new ThreadManager(this);
        this.threadManager.initialize();
        this.rubiniusPrimitiveManager = new RubiniusPrimitiveManager();
        this.rubiniusPrimitiveManager.addAnnotatedPrimitives();
        if (INSTRUMENTATION_SERVER_PORT != 0) {
            this.instrumentationServerManager = new InstrumentationServerManager(this, INSTRUMENTATION_SERVER_PORT);
            this.instrumentationServerManager.start();
        } else {
            this.instrumentationServerManager = null;
        }
        this.runningOnWindows = Platform.getPlatform().getOS() == Platform.OS_TYPE.WINDOWS;
        this.attachmentsManager = new AttachmentsManager(this);
        this.sourceManager = new SourceManager(this);
        this.rubiniusConfiguration = RubiniusConfiguration.create(this);
        PrintStream configStandardOut = runtime.getInstanceConfig().getOutput();
        this.debugStandardOut = configStandardOut == System.out ? null : configStandardOut;
    }

    public void initialize() {
        this.coreLibrary.initializeAfterMethodsAdded();
        for (IRubyObject arg : ((RubyArray)this.runtime.getObject().getConstant("ARGV")).toJavaArray()) {
            assert (arg != null);
            ArrayNodes.slowPush(this.coreLibrary.getArgv(), StringNodes.createString(this.coreLibrary.getStringClass(), arg.toString()));
        }
        RubyBasicObject loadPath = (RubyBasicObject)this.coreLibrary.getGlobalVariablesObject().getInstanceVariable("$:");
        String home = this.runtime.getInstanceConfig().getJRubyHome();
        ArrayList<String> excludedLibPaths = new ArrayList<String>();
        excludedLibPaths.add(new File(home, "lib/ruby/2.2/site_ruby").toString().replace('\\', '/'));
        excludedLibPaths.add(new File(home, "lib/ruby/shared").toString().replace('\\', '/'));
        excludedLibPaths.add(new File(home, "lib/ruby/stdlib").toString().replace('\\', '/'));
        for (IRubyObject path : ((RubyArray)this.runtime.getLoadService().getLoadPath()).toJavaArray()) {
            if (excludedLibPaths.contains(path.toString())) continue;
            ArrayNodes.slowPush(loadPath, StringNodes.createString(this.coreLibrary.getStringClass(), new File(path.toString()).getAbsolutePath()));
        }
        ArrayNodes.slowPush(loadPath, StringNodes.createString(this.coreLibrary.getStringClass(), new File(home, "lib/ruby/truffle/mri").toString()));
        ArrayNodes.slowPush(loadPath, StringNodes.createString(this.coreLibrary.getStringClass(), new File(home, "lib/ruby/truffle/truffle").toString()));
        for (String lib : Arrays.asList("rubysl-strscan", "rubysl-stringio", "rubysl-complex", "rubysl-date", "rubysl-pathname", "rubysl-tempfile", "rubysl-socket", "rubysl-securerandom", "rubysl-timeout", "rubysl-webrick")) {
            ArrayNodes.slowPush(loadPath, StringNodes.createString(this.coreLibrary.getStringClass(), new File(home, "lib/ruby/truffle/rubysl/" + lib + "/lib").toString()));
        }
        ArrayNodes.slowPush(loadPath, StringNodes.createString(this.coreLibrary.getStringClass(), new File(home, "lib/ruby/truffle/shims").toString()));
    }

    public static String checkInstanceVariableName(RubyContext context, String name, Node currentNode) {
        if (!name.startsWith("@")) {
            throw new RaiseException(context.getCoreLibrary().nameErrorInstanceNameNotAllowable(name, currentNode));
        }
        return name;
    }

    public static String checkClassVariableName(RubyContext context, String name, Node currentNode) {
        if (!name.startsWith("@@")) {
            throw new RaiseException(context.getCoreLibrary().nameErrorInstanceNameNotAllowable(name, currentNode));
        }
        return name;
    }

    public boolean isRunningOnWindows() {
        return this.runningOnWindows;
    }

    public void loadFile(String fileName, Node currentNode) {
        if (new File(fileName).isAbsolute()) {
            this.loadFileAbsolute(fileName, currentNode);
        } else {
            this.loadFileAbsolute(this.getRuntime().getCurrentDirectory() + File.separator + fileName, currentNode);
        }
    }

    private void loadFileAbsolute(String fileName, Node currentNode) {
        Source source = this.sourceManager.forFile(fileName);
        this.load(source, currentNode, NodeWrapper.IDENTITY);
    }

    public void load(Source source, Node currentNode, final NodeWrapper nodeWrapper) {
        final NodeWrapper loadWrapper = new NodeWrapper(){

            @Override
            public RubyNode wrap(RubyNode node) {
                return new SetMethodDeclarationContext(node.getContext(), node.getSourceSection(), Visibility.PRIVATE, "load", node);
            }
        };
        NodeWrapper composed = new NodeWrapper(){

            @Override
            public RubyNode wrap(RubyNode node) {
                return nodeWrapper.wrap(loadWrapper.wrap(node));
            }
        };
        this.execute(source, (Encoding)UTF8Encoding.INSTANCE, TranslatorDriver.ParserContext.TOP_LEVEL, this.coreLibrary.getMainObject(), null, currentNode, composed);
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public RubyBasicObject getSymbol(String name) {
        return this.symbolTable.getSymbol(name);
    }

    public RubyBasicObject getSymbol(ByteList name) {
        return this.symbolTable.getSymbol(name);
    }

    @CompilerDirectives.TruffleBoundary
    public Object instanceEval(ByteList code, Object self, String filename, Node currentNode) {
        Source source = Source.fromText((CharSequence)code, (String)filename);
        return this.execute(source, code.getEncoding(), TranslatorDriver.ParserContext.EVAL, self, null, currentNode, new NodeWrapper(){

            @Override
            public RubyNode wrap(RubyNode node) {
                return new SetMethodDeclarationContext(node.getContext(), node.getSourceSection(), Visibility.PUBLIC, "instance_eval", node);
            }
        });
    }

    public Object instanceEval(ByteList code, Object self, Node currentNode) {
        return this.instanceEval(code, self, "(eval)", currentNode);
    }

    public Object eval(Source source) {
        return this.execute(source, (Encoding)UTF8Encoding.INSTANCE, TranslatorDriver.ParserContext.EVAL, this.getCoreLibrary().getMainObject(), null, null, new NodeWrapper(){

            @Override
            public RubyNode wrap(RubyNode node) {
                return new SetMethodDeclarationContext(node.getContext(), node.getSourceSection(), Visibility.PRIVATE, "simple eval", node);
            }
        });
    }

    @CompilerDirectives.TruffleBoundary
    public Object eval(String code, RubyBasicObject binding, boolean ownScopeForAssignments, String filename, Node currentNode) {
        assert (RubyGuards.isRubyBinding(binding));
        return this.eval(ByteList.create((CharSequence)code), binding, ownScopeForAssignments, filename, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public Object eval(ByteList code, RubyBasicObject binding, boolean ownScopeForAssignments, String filename, Node currentNode) {
        assert (RubyGuards.isRubyBinding(binding));
        Source source = Source.fromText((CharSequence)code, (String)filename);
        return this.execute(source, code.getEncoding(), TranslatorDriver.ParserContext.EVAL, BindingNodes.getSelf(binding), BindingNodes.getFrame(binding), ownScopeForAssignments, currentNode, NodeWrapper.IDENTITY);
    }

    @CompilerDirectives.TruffleBoundary
    public Object eval(ByteList code, RubyBasicObject binding, boolean ownScopeForAssignments, Node currentNode) {
        assert (RubyGuards.isRubyBinding(binding));
        return this.eval(code, binding, ownScopeForAssignments, "(eval)", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public Object execute(Source source, Encoding defaultEncoding, TranslatorDriver.ParserContext parserContext, Object self, MaterializedFrame parentFrame, Node currentNode, NodeWrapper wrapper) {
        return this.execute(source, defaultEncoding, parserContext, self, parentFrame, true, currentNode, wrapper);
    }

    @CompilerDirectives.TruffleBoundary
    public Object execute(Source source, Encoding defaultEncoding, TranslatorDriver.ParserContext parserContext, Object self, MaterializedFrame parentFrame, boolean ownScopeForAssignments, Node currentNode, NodeWrapper wrapper) {
        TranslatorDriver translator = new TranslatorDriver(this);
        RubyRootNode rootNode = translator.parse(this, source, defaultEncoding, parserContext, parentFrame, ownScopeForAssignments, currentNode, wrapper);
        RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)rootNode);
        InternalMethod method = new InternalMethod(rootNode.getSharedMethodInfo(), rootNode.getSharedMethodInfo().getName(), this.getCoreLibrary().getObjectClass(), Visibility.PUBLIC, false, (CallTarget)callTarget, parentFrame);
        return callTarget.call(RubyArguments.pack(method, parentFrame, self, null, new Object[0]));
    }

    public long getNextObjectID() {
        long id = this.nextObjectID.getAndAdd(2L);
        if (id < 0L) {
            this.nextObjectID.set(Long.MIN_VALUE);
            throw new RuntimeException("Object IDs exhausted");
        }
        return id;
    }

    public void innerShutdown(boolean normalExit) {
        this.atExitManager.run(normalExit);
        if (this.instrumentationServerManager != null) {
            this.instrumentationServerManager.shutdown();
        }
        this.threadManager.shutdown();
    }

    public Object makeTuple(VirtualFrame frame, CallDispatchHeadNode newTupleNode, Object ... values) {
        return newTupleNode.call(frame, this.getCoreLibrary().getTupleClass(), "create", null, values);
    }

    public IRubyObject toJRuby(Object object) {
        if (object == this.getCoreLibrary().getNilObject()) {
            return this.runtime.getNil();
        }
        if (object == this.getCoreLibrary().getKernelModule()) {
            return this.runtime.getKernel();
        }
        if (object == this.getCoreLibrary().getMainObject()) {
            return this.runtime.getTopSelf();
        }
        if (object instanceof Boolean) {
            return this.runtime.newBoolean(((Boolean)object).booleanValue());
        }
        if (object instanceof Integer) {
            return this.runtime.newFixnum(((Integer)object).intValue());
        }
        if (object instanceof Long) {
            return this.runtime.newFixnum(((Long)object).longValue());
        }
        if (object instanceof Double) {
            return this.runtime.newFloat(((Double)object).doubleValue());
        }
        if (RubyGuards.isRubyString(object)) {
            return this.toJRubyString((RubyBasicObject)object);
        }
        if (RubyGuards.isRubyArray(object)) {
            return this.toJRubyArray((RubyBasicObject)object);
        }
        if (RubyGuards.isRubyEncoding(object)) {
            return this.toJRubyEncoding((RubyBasicObject)object);
        }
        throw this.getRuntime().newRuntimeError("cannot pass " + object + " (" + object.getClass().getName() + ") to JRuby");
    }

    public IRubyObject[] toJRuby(Object ... objects) {
        IRubyObject[] store = new IRubyObject[objects.length];
        for (int n = 0; n < objects.length; ++n) {
            store[n] = this.toJRuby(objects[n]);
        }
        return store;
    }

    public RubyArray toJRubyArray(RubyBasicObject array) {
        assert (RubyGuards.isRubyArray(array));
        return this.runtime.newArray(this.toJRuby(ArrayNodes.slowToArray(array)));
    }

    public IRubyObject toJRubyEncoding(RubyBasicObject encoding) {
        assert (RubyGuards.isRubyEncoding(encoding));
        return this.runtime.getEncodingService().rubyEncodingFromObject((IRubyObject)this.runtime.newString(EncodingNodes.getName(encoding)));
    }

    public RubyString toJRubyString(RubyBasicObject string) {
        assert (RubyGuards.isRubyString(string));
        RubyString jrubyString = this.runtime.newString(StringNodes.getByteList(string).dup());
        Object tainted = RubyBasicObject.getInstanceVariable(string, RubyBasicObject.TAINTED_IDENTIFIER);
        if (tainted instanceof Boolean && ((Boolean)tainted).booleanValue()) {
            jrubyString.setTaint(true);
        }
        return jrubyString;
    }

    public Object toTruffle(IRubyObject object) {
        if (object == this.runtime.getTopSelf()) {
            return this.getCoreLibrary().getMainObject();
        }
        if (object == this.runtime.getKernel()) {
            return this.getCoreLibrary().getKernelModule();
        }
        if (object instanceof RubyNil) {
            return this.getCoreLibrary().getNilObject();
        }
        if (object instanceof RubyBoolean.True) {
            return true;
        }
        if (object instanceof RubyBoolean.False) {
            return false;
        }
        if (object instanceof RubyFixnum) {
            long value = ((RubyFixnum)object).getLongValue();
            if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
                return value;
            }
            return (int)value;
        }
        if (object instanceof RubyFloat) {
            return ((RubyFloat)object).getDoubleValue();
        }
        if (object instanceof RubyBignum) {
            BigInteger value = ((RubyBignum)object).getBigIntegerValue();
            return BignumNodes.createRubyBignum(this.coreLibrary.getBignumClass(), value);
        }
        if (object instanceof RubyString) {
            return this.toTruffle((RubyString)object);
        }
        if (object instanceof RubySymbol) {
            return this.getSymbolTable().getSymbol(object.toString());
        }
        if (object instanceof RubyArray) {
            return this.toTruffle((RubyArray)object);
        }
        if (object instanceof RubyException) {
            return this.toTruffle((RubyException)object, null);
        }
        throw object.getRuntime().newRuntimeError("cannot pass " + object.inspect() + " (" + object.getClass().getName() + ") to Truffle");
    }

    public RubyBasicObject toTruffle(RubyArray array) {
        Object[] store = new Object[array.size()];
        for (int n = 0; n < store.length; ++n) {
            store[n] = this.toTruffle(array.entry(n));
        }
        return ArrayNodes.fromObjects(this.coreLibrary.getArrayClass(), store);
    }

    public RubyBasicObject toTruffle(RubyString jrubyString) {
        RubyBasicObject truffleString = StringNodes.createString(this.getCoreLibrary().getStringClass(), jrubyString.getByteList().dup());
        if (jrubyString.isTaint()) {
            RubyBasicObject.setInstanceVariable(truffleString, RubyBasicObject.TAINTED_IDENTIFIER, true);
        }
        return truffleString;
    }

    public org.jruby.truffle.runtime.core.RubyException toTruffle(RubyException jrubyException, RubyNode currentNode) {
        switch (jrubyException.getMetaClass().getName()) {
            case "ArgumentError": {
                return this.getCoreLibrary().argumentError(jrubyException.getMessage().toString(), currentNode);
            }
            case "Encoding::CompatibilityError": {
                return this.getCoreLibrary().encodingCompatibilityError(jrubyException.getMessage().toString(), currentNode);
            }
            case "TypeError": {
                return this.getCoreLibrary().typeError(jrubyException.getMessage().toString(), currentNode);
            }
            case "RegexpError": {
                return this.getCoreLibrary().regexpError(jrubyException.getMessage().toString(), currentNode);
            }
        }
        throw new UnsupportedOperationException("Don't know how to translate " + jrubyException.getMetaClass().getName());
    }

    public Ruby getRuntime() {
        return this.runtime;
    }

    public CoreLibrary getCoreLibrary() {
        return this.coreLibrary;
    }

    public FeatureManager getFeatureManager() {
        return this.featureManager;
    }

    public ObjectSpaceManager getObjectSpaceManager() {
        return this.objectSpaceManager;
    }

    public ThreadManager getThreadManager() {
        return this.threadManager;
    }

    public AtExitManager getAtExitManager() {
        return this.atExitManager;
    }

    public String getLanguageShortName() {
        return "ruby";
    }

    public TraceManager getTraceManager() {
        return this.traceManager;
    }

    public Warnings getWarnings() {
        return this.warnings;
    }

    public SafepointManager getSafepointManager() {
        return this.safepointManager;
    }

    public Random getRandom() {
        return ThreadLocalRandom.current();
    }

    public LexicalScope getRootLexicalScope() {
        return this.rootLexicalScope;
    }

    public CompilerOptions getCompilerOptions() {
        return this.compilerOptions;
    }

    public RubiniusPrimitiveManager getRubiniusPrimitiveManager() {
        return this.rubiniusPrimitiveManager;
    }

    public TruffleObject getMultilanguageObject() {
        return this.multilanguageObject;
    }

    public void setMultilanguageObject(TruffleObject multilanguageObject) {
        this.multilanguageObject = multilanguageObject;
    }

    public CoverageTracker getCoverageTracker() {
        return this.coverageTracker;
    }

    public static RubyContext getLatestInstance() {
        return latestInstance;
    }

    public AttachmentsManager getAttachmentsManager() {
        return this.attachmentsManager;
    }

    public SourceManager getSourceManager() {
        return this.sourceManager;
    }

    public RubiniusConfiguration getRubiniusConfiguration() {
        return this.rubiniusConfiguration;
    }

    public POSIX getPosix() {
        return this.posix;
    }

    public NativeSockets getNativeSockets() {
        return this.nativeSockets;
    }

    public Object execute(org.jruby.ast.RootNode rootNode) {
        RubyBasicObject.setInstanceVariable(this.coreLibrary.getGlobalVariablesObject(), "$0", this.toTruffle(this.runtime.getGlobalVariables().get("$0")));
        String inputFile = rootNode.getPosition().getFile();
        Source source = inputFile.equals("-e") ? Source.fromText((CharSequence)new String(this.runtime.getInstanceConfig().inlineScript(), StandardCharsets.UTF_8), (String)"-e") : this.sourceManager.forFile(inputFile);
        this.featureManager.setMainScriptSource(source);
        this.load(source, null, new NodeWrapper(){

            @Override
            public RubyNode wrap(RubyNode node) {
                RubyContext context = node.getContext();
                SourceSection sourceSection = node.getSourceSection();
                return new TopLevelRaiseHandler(context, sourceSection, SequenceNode.sequence(context, sourceSection, new SetTopLevelBindingNode(context, sourceSection), new LoadRequiredLibrariesNode(context, sourceSection), node));
            }
        });
        return this.coreLibrary.getNilObject();
    }

    public void shutdown() {
        this.innerShutdown(true);
    }

    public PrintStream getDebugStandardOut() {
        return this.debugStandardOut;
    }

    static {
        TRUFFLE_COVERAGE = (Boolean)Options.TRUFFLE_COVERAGE.load();
        INSTRUMENTATION_SERVER_PORT = (Integer)Options.TRUFFLE_INSTRUMENTATION_SERVER_PORT.load();
    }
}

