/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.pack.nodes.format;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import java.nio.charset.StandardCharsets;
import org.jruby.truffle.pack.nodes.PackNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.util.ByteList;

@NodeChildren(value={@NodeChild(value="value", type=PackNode.class)})
public abstract class FormatFloatNode
extends PackNode {
    private final int spacePadding;
    private final int zeroPadding;
    private final int precision;
    private final char format;

    public FormatFloatNode(RubyContext context, int spacePadding, int zeroPadding, int precision, char format) {
        super(context);
        this.spacePadding = spacePadding;
        this.zeroPadding = zeroPadding;
        this.precision = precision;
        this.format = format;
    }

    @Specialization
    @CompilerDirectives.TruffleBoundary
    public ByteList format(double value) {
        if (this.format == 'G' || this.format == 'g') {
            if (value - Math.rint(value) == 0.0) {
                return ByteList.create((CharSequence)String.valueOf((long)value));
            }
            return ByteList.create((CharSequence)String.valueOf(value));
        }
        StringBuilder builder = new StringBuilder();
        builder.append("%");
        if (this.spacePadding != -1) {
            builder.append(" ");
            builder.append(this.spacePadding);
            if (this.zeroPadding != -1) {
                builder.append(".");
                builder.append(this.zeroPadding);
            }
        } else if (this.zeroPadding != -1 && this.zeroPadding != 0) {
            builder.append("0");
            builder.append(this.zeroPadding);
        }
        if (this.precision != -1) {
            builder.append(".");
            builder.append(this.precision);
        }
        builder.append(this.format);
        return new ByteList(String.format(builder.toString(), value).getBytes(StandardCharsets.US_ASCII));
    }
}

