/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.yield;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.core.ProcNodes;
import org.jruby.truffle.nodes.yield.YieldDispatchNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.util.cli.Options;

@NodeInfo(cost=NodeCost.POLYMORPHIC)
public class CachedYieldDispatchNode
extends YieldDispatchNode {
    private static final boolean INLINER_ALWAYS_CLONE_YIELD = (Boolean)Options.TRUFFLE_INLINER_ALWAYS_CLONE_YIELD.load();
    private static final boolean INLINER_ALWAYS_INLINE_YIELD = (Boolean)Options.TRUFFLE_INLINER_ALWAYS_INLINE_YIELD.load();
    @Node.Child
    private DirectCallNode callNode;
    @Node.Child
    private YieldDispatchNode next;

    public CachedYieldDispatchNode(RubyContext context, RubyBasicObject block, YieldDispatchNode next) {
        super(context);
        assert (RubyGuards.isRubyProc(block));
        this.callNode = Truffle.getRuntime().createDirectCallNode(ProcNodes.getCallTargetForBlocks(block));
        this.insert((Node)this.callNode);
        if (INLINER_ALWAYS_CLONE_YIELD && this.callNode.isCallTargetCloningAllowed()) {
            this.callNode.cloneCallTarget();
        }
        if (INLINER_ALWAYS_INLINE_YIELD && this.callNode.isInlinable()) {
            this.callNode.forceInlining();
        }
        this.next = next;
    }

    @Override
    protected boolean guard(RubyBasicObject block) {
        return ProcNodes.getCallTargetForBlocks(block) == this.callNode.getCallTarget();
    }

    @Override
    protected YieldDispatchNode getNext() {
        return this.next;
    }

    @Override
    public Object dispatchWithSelfAndBlock(VirtualFrame frame, RubyBasicObject block, Object self, RubyBasicObject modifiedBlock, Object ... argumentsObjects) {
        assert (block == null || RubyGuards.isRubyProc(block));
        assert (modifiedBlock == null || RubyGuards.isRubyProc(modifiedBlock));
        if (this.guard(block)) {
            return this.callNode.call(frame, RubyArguments.pack(ProcNodes.getMethod(block), ProcNodes.getDeclarationFrame(block), self, modifiedBlock, argumentsObjects));
        }
        return this.next.dispatchWithSelfAndBlock(frame, block, self, modifiedBlock, argumentsObjects);
    }

    public String toString() {
        return String.format("CachedYieldDispatchNode(%s)", this.callNode.getCallTarget());
    }
}

