/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.joni.Matcher;
import org.joni.Regex;
import org.jruby.Ruby;
import org.jruby.truffle.nodes.core.RegexpGuards;
import org.jruby.truffle.nodes.core.RegexpNodes;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.util.ByteList;
import org.jruby.util.RegexpSupport;

public abstract class RegexpPrimitiveNodes {

    @RubiniusPrimitive(name="regexp_set_block_last_match")
    public static abstract class RegexpSetBlockLastMatchPrimitiveNode
    extends RubiniusPrimitiveNode {
        public RegexpSetBlockLastMatchPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject setBlockLastMatch(RubyClass regexpClass) {
            return this.nil();
        }
    }

    @RubiniusPrimitive(name="regexp_set_last_match")
    public static abstract class RegexpSetLastMatchPrimitiveNode
    extends RubiniusPrimitiveNode {
        public RegexpSetLastMatchPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object setLastMatch(RubyClass regexpClass, Object matchData) {
            RubyBasicObject.setInstanceVariable(this.getContext().getThreadManager().getCurrentThread().getThreadLocals(), "$~", matchData);
            return matchData;
        }
    }

    @RubiniusPrimitive(name="regexp_search_region", lowerFixnumParameters={1, 2})
    @ImportStatic(value={RegexpGuards.class})
    public static abstract class RegexpSearchRegionPrimitiveNode
    extends RubiniusPrimitiveNode {
        public RegexpSearchRegionPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"!isInitialized(regexp)", "isRubyString(string)"})
        public Object searchRegionNotInitialized(RubyBasicObject regexp, RubyBasicObject string, int start, int end, boolean forward) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().typeError("uninitialized Regexp", this));
        }

        @Specialization(guards={"isRubyString(string)", "!isValidEncoding(string)"})
        public Object searchRegionInvalidEncoding(RubyBasicObject regexp, RubyBasicObject string, int start, int end, boolean forward) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError(String.format("invalid byte sequence in %s", StringNodes.getByteList(string).getEncoding()), this));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isInitialized(regexp)", "isRubyString(string)", "isValidEncoding(string)"})
        public Object searchRegion(RubyBasicObject regexp, RubyBasicObject string, int start, int end, boolean forward) {
            ByteList stringBl = StringNodes.getByteList(string);
            ByteList bl = RegexpNodes.getSource(regexp);
            Encoding enc = RegexpNodes.checkEncoding(regexp, StringNodes.getCodeRangeable(string), true);
            ByteList preprocessed = RegexpSupport.preprocess((Ruby)this.getContext().getRuntime(), (ByteList)bl, (Encoding)enc, (Encoding[])new Encoding[]{null}, (RegexpSupport.ErrorMode)RegexpSupport.ErrorMode.RAISE);
            Regex r = new Regex(preprocessed.getUnsafeBytes(), preprocessed.getBegin(), preprocessed.getBegin() + preprocessed.getRealSize(), RegexpNodes.getRegex(regexp).getOptions(), RegexpNodes.checkEncoding(regexp, StringNodes.getCodeRangeable(string), true));
            Matcher matcher = r.matcher(stringBl.getUnsafeBytes(), stringBl.begin(), stringBl.begin() + stringBl.realSize());
            if (forward) {
                return RegexpNodes.matchCommon(regexp, string, false, false, matcher, start + stringBl.begin(), end + stringBl.begin());
            }
            return RegexpNodes.matchCommon(regexp, string, false, false, matcher, end + stringBl.begin(), start + stringBl.begin());
        }
    }

    @RubiniusPrimitive(name="regexp_propagate_last_match")
    public static abstract class RegexpPropagateLastMatchPrimitiveNode
    extends RubiniusPrimitiveNode {
        public RegexpPropagateLastMatchPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject propagateLastMatch(RubyClass regexpClass) {
            return this.nil();
        }
    }

    @RubiniusPrimitive(name="regexp_options")
    @ImportStatic(value={RegexpGuards.class})
    public static abstract class RegexpOptionsPrimitiveNode
    extends RubiniusPrimitiveNode {
        public RegexpOptionsPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isInitialized(regexp)"})
        public int options(RubyBasicObject regexp) {
            return RegexpNodes.getOptions(regexp).toOptions();
        }

        @Specialization(guards={"!isInitialized(regexp)"})
        public int optionsNotInitialized(RubyBasicObject regexp) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().typeError("uninitialized Regexp", this));
        }
    }

    @RubiniusPrimitive(name="regexp_initialize")
    @ImportStatic(value={RegexpGuards.class})
    public static abstract class RegexpInitializePrimitiveNode
    extends RubiniusPrimitiveNode {
        public RegexpInitializePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRegexpLiteral(regexp)", "isRubyString(pattern)"})
        public RubyBasicObject initializeRegexpLiteral(RubyBasicObject regexp, RubyBasicObject pattern, int options) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().securityError("can't modify literal regexp", this));
        }

        @Specialization(guards={"!isRegexpLiteral(regexp)", "isInitialized(regexp)", "isRubyString(pattern)"})
        public RubyBasicObject initializeAlreadyInitialized(RubyBasicObject regexp, RubyBasicObject pattern, int options) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().typeError("already initialized regexp", this));
        }

        @Specialization(guards={"!isRegexpLiteral(regexp)", "!isInitialized(regexp)", "isRubyString(pattern)"})
        public RubyBasicObject initialize(RubyBasicObject regexp, RubyBasicObject pattern, int options) {
            RegexpNodes.initialize(regexp, this, StringNodes.getByteList(pattern), options);
            return regexp;
        }
    }

    @RubiniusPrimitive(name="regexp_fixed_encoding_p")
    public static abstract class RegexpFixedEncodingPrimitiveNode
    extends RubiniusPrimitiveNode {
        public RegexpFixedEncodingPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean fixedEncoding(RubyBasicObject regexp) {
            return RegexpNodes.getOptions(regexp).isFixed();
        }
    }
}

