/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import jnr.constants.platform.Errno;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyException;

public abstract class ExceptionPrimitiveNodes {

    @RubiniusPrimitive(name="exception_errno_error", needsSelf=false)
    public static abstract class ExceptionErrnoErrorPrimitiveNode
    extends RubiniusPrimitiveNode {
        protected static final int EPERM = Errno.EPERM.intValue();
        protected static final int ENOENT = Errno.ENOENT.intValue();
        protected static final int EBADF = Errno.EBADF.intValue();
        protected static final int EEXIST = Errno.EEXIST.intValue();
        protected static final int EACCES = Errno.EACCES.intValue();
        protected static final int EFAULT = Errno.EFAULT.intValue();
        protected static final int ENOTDIR = Errno.ENOTDIR.intValue();
        protected static final int EINVAL = Errno.EINVAL.intValue();
        protected static final int EINPROGRESS = Errno.EINPROGRESS.intValue();

        public static boolean isExceptionSupported(int errno) {
            return errno == EPERM || errno == ENOENT || errno == EBADF || errno == EEXIST || errno == EACCES || errno == EFAULT || errno == ENOTDIR || errno == EINVAL || errno == EINPROGRESS;
        }

        public ExceptionErrnoErrorPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(message)", "errno == EPERM"})
        public RubyException eperm(RubyBasicObject message, int errno) {
            return this.getContext().getCoreLibrary().operationNotPermittedError(message.toString(), this);
        }

        @Specialization(guards={"errno == EPERM", "isNil(message)"})
        public RubyException eperm(Object message, int errno) {
            return this.getContext().getCoreLibrary().operationNotPermittedError("nil", this);
        }

        @Specialization(guards={"isRubyString(message)", "errno == ENOENT"})
        public RubyException enoent(RubyBasicObject message, int errno) {
            return this.getContext().getCoreLibrary().fileNotFoundError(message.toString(), this);
        }

        @Specialization(guards={"errno == ENOENT", "isNil(message)"})
        public RubyException enoent(Object message, int errno) {
            return this.getContext().getCoreLibrary().fileNotFoundError("nil", this);
        }

        @Specialization(guards={"errno == EBADF", "isNil(message)"})
        public RubyException ebadf(Object message, int errno) {
            return this.getContext().getCoreLibrary().badFileDescriptor(this);
        }

        @Specialization(guards={"isRubyString(message)", "errno == EEXIST"})
        public RubyException eexist(RubyBasicObject message, int errno) {
            return this.getContext().getCoreLibrary().fileExistsError(message.toString(), this);
        }

        @Specialization(guards={"errno == EEXIST", "isNil(message)"})
        public RubyException eexist(Object message, int errno) {
            return this.getContext().getCoreLibrary().fileExistsError("nil", this);
        }

        @Specialization(guards={"isRubyString(message)", "errno == EACCES"})
        public RubyException eacces(RubyBasicObject message, int errno) {
            return this.getContext().getCoreLibrary().permissionDeniedError(message.toString(), this);
        }

        @Specialization(guards={"errno == EACCES", "isNil(message)"})
        public RubyException eacces(Object message, int errno) {
            return this.getContext().getCoreLibrary().permissionDeniedError("nil", this);
        }

        @Specialization(guards={"isRubyString(message)", "errno == EFAULT"})
        public RubyException efault(RubyBasicObject message, int errno) {
            return this.getContext().getCoreLibrary().badAddressError(this);
        }

        @Specialization(guards={"errno == EFAULT", "isNil(message)"})
        public RubyException efault(Object message, int errno) {
            return this.getContext().getCoreLibrary().badAddressError(this);
        }

        @Specialization(guards={"isRubyString(message)", "errno == ENOTDIR"})
        public RubyException enotdir(RubyBasicObject message, int errno) {
            return this.getContext().getCoreLibrary().notDirectoryError(message.toString(), this);
        }

        @Specialization(guards={"isRubyString(message)", "errno == EINVAL"})
        public RubyException einval(RubyBasicObject message, int errno) {
            return this.getContext().getCoreLibrary().errnoError(errno, this);
        }

        @Specialization(guards={"isRubyString(message)", "errno == EINPROGRESS"})
        public RubyException einprogress(RubyBasicObject message, int errno) {
            return this.getContext().getCoreLibrary().errnoError(errno, this);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isExceptionSupported(errno)"})
        public RubyException unsupported(Object message, int errno) {
            Errno errnoObject = Errno.valueOf((long)errno);
            String messageString = RubyGuards.isRubyString(message) ? message.toString() : (message == this.nil() ? "nil" : "unsupported message type");
            if (errnoObject == null) {
                throw new UnsupportedOperationException("errno: " + errno + " " + messageString);
            }
            throw new UnsupportedOperationException("errno: " + errnoObject.name());
        }
    }
}

