/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.methods;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.methods.InternalMethod;

@NodeChildren(value={@NodeChild(value="method"), @NodeChild(value="module")})
public abstract class CanBindMethodToModuleNode
extends RubyNode {
    public CanBindMethodToModuleNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract boolean executeCanBindMethodToModule(VirtualFrame var1, InternalMethod var2, RubyModule var3);

    @Specialization(guards={"method.getDeclaringModule() == declaringModule", "module == cachedModule"}, limit="getCacheLimit()")
    protected boolean canBindMethodToCached(VirtualFrame frame, InternalMethod method, RubyModule module, @Cached(value="method.getDeclaringModule()") RubyModule declaringModule, @Cached(value="module") RubyModule cachedModule, @Cached(value="canBindMethodTo(declaringModule, cachedModule)") boolean canBindMethodTo) {
        return canBindMethodTo;
    }

    @Specialization
    protected boolean canBindMethodToUncached(VirtualFrame frame, InternalMethod method, RubyModule module) {
        RubyModule declaringModule = method.getDeclaringModule();
        return this.canBindMethodTo(declaringModule, module);
    }

    protected boolean canBindMethodTo(RubyModule declaringModule, RubyModule module) {
        return ModuleOperations.canBindMethodTo(declaringModule, module);
    }
}

