/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.ext;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypes;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.cast.IntegerCastNode;
import org.jruby.truffle.nodes.coerce.ToIntNode;
import org.jruby.truffle.nodes.constants.GetConstantNode;
import org.jruby.truffle.nodes.ext.BigDecimalNodes;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyModule;

@GeneratedBy(value=BigDecimalNodes.class)
public final class BigDecimalNodesFactory {
    public static List<NodeFactory<? extends BigDecimalNodes.BigDecimalCoreMethodNode>> getFactories() {
        return Arrays.asList(CreateBigDecimalNodeFactory.getInstance(), InitializeNodeFactory.getInstance(), AddOpNodeFactory.getInstance(), AddNodeFactory.getInstance(), SubOpNodeFactory.getInstance(), SubNodeFactory.getInstance(), NegNodeFactory.getInstance(), MultOpNodeFactory.getInstance(), MultNodeFactory.getInstance(), DivOpNodeFactory.getInstance(), DivNodeFactory.getInstance(), DivModNodeFactory.getInstance(), RemainderNodeFactory.getInstance(), ModuloNodeFactory.getInstance(), PowerNodeFactory.getInstance(), SqrtNodeFactory.getInstance(), CompareNodeFactory.getInstance(), ZeroNodeFactory.getInstance(), SignNodeFactory.getInstance(), NanNodeFactory.getInstance(), ExponentNodeFactory.getInstance(), AbsNodeFactory.getInstance(), RoundNodeFactory.getInstance(), FiniteNodeFactory.getInstance(), InfiniteNodeFactory.getInstance(), PrecsNodeFactory.getInstance(), ToFNodeFactory.getInstance(), UnscaledNodeFactory.getInstance(), ToINodeFactory.getInstance());
    }

    @GeneratedBy(value=BigDecimalNodes.BigDecimalCoerceNode.class)
    public static final class BigDecimalCoerceNodeGen
    extends BigDecimalNodes.BigDecimalCoerceNode
    implements SpecializedNode {
        @Node.Child
        private RubyNode value_;
        @Node.Child
        private BigDecimalNodes.BigDecimalCastNode cast_;
        @Node.Child
        private BaseNode_ specialization_;

        private BigDecimalCoerceNodeGen(RubyContext context, SourceSection sourceSection, RubyNode value, BigDecimalNodes.BigDecimalCastNode cast) {
            super(context, sourceSection);
            this.value_ = value;
            this.cast_ = cast;
            this.specialization_ = UninitializedNode_.create(this);
        }

        public NodeCost getCost() {
            return this.specialization_.getNodeCost();
        }

        @Override
        public RubyBasicObject executeBigDecimal(VirtualFrame frameValue, Object valueValue) {
            return this.specialization_.executeRubyBasicObject1(frameValue, valueValue);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.specialization_.execute(frameValue);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.specialization_.executeVoid(frameValue);
        }

        public SpecializationNode getSpecializationNode() {
            return this.specialization_;
        }

        public Node deepCopy() {
            return SpecializationNode.updateRoot((Node)super.deepCopy());
        }

        public static BigDecimalNodes.BigDecimalCoerceNode create(RubyContext context, SourceSection sourceSection, RubyNode value, BigDecimalNodes.BigDecimalCastNode cast) {
            return new BigDecimalCoerceNodeGen(context, sourceSection, value, cast);
        }

        @GeneratedBy(methodName="doBigDecimal(RubyBasicObject, RubyBasicObject)", value=BigDecimalNodes.BigDecimalCoerceNode.class)
        private static final class BigDecimal1Node_
        extends BaseNode_ {
            BigDecimal1Node_(BigDecimalCoerceNodeGen root) {
                super(root, 2);
            }

            @Override
            public Object execute_(VirtualFrame frameValue, Object valueValue, Object castValue) {
                if (valueValue instanceof RubyBasicObject && castValue instanceof RubyBasicObject) {
                    RubyBasicObject valueValue_ = (RubyBasicObject)valueValue;
                    RubyBasicObject castValue_ = (RubyBasicObject)castValue;
                    if (RubyGuards.isRubyBigDecimal(valueValue_) && this.root.isNil(castValue_)) {
                        return this.root.doBigDecimal(valueValue_, castValue_);
                    }
                }
                return this.getNext().execute_(frameValue, valueValue, castValue);
            }

            static BaseNode_ create(BigDecimalCoerceNodeGen root) {
                return new BigDecimal1Node_(root);
            }
        }

        @GeneratedBy(methodName="doBigDecimal(VirtualFrame, Object, BigDecimal)", value=BigDecimalNodes.BigDecimalCoerceNode.class)
        private static final class BigDecimal0Node_
        extends BaseNode_ {
            BigDecimal0Node_(BigDecimalCoerceNodeGen root) {
                super(root, 1);
            }

            @Override
            public Object execute_(VirtualFrame frameValue, Object valueValue, Object castValue) {
                if (castValue instanceof BigDecimal) {
                    BigDecimal castValue_ = (BigDecimal)castValue;
                    return this.root.doBigDecimal(frameValue, valueValue, castValue_);
                }
                return this.getNext().execute_(frameValue, valueValue, castValue);
            }

            static BaseNode_ create(BigDecimalCoerceNodeGen root) {
                return new BigDecimal0Node_(root);
            }
        }

        @GeneratedBy(value=BigDecimalNodes.BigDecimalCoerceNode.class)
        private static final class PolymorphicNode_
        extends BaseNode_ {
            PolymorphicNode_(BigDecimalCoerceNodeGen root) {
                super(root, 0);
            }

            public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object valueValue, Object castValue) {
                return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, valueValue, castValue));
            }

            @Override
            public Object execute_(VirtualFrame frameValue, Object valueValue, Object castValue) {
                return this.getNext().execute_(frameValue, valueValue, castValue);
            }

            static BaseNode_ create(BigDecimalCoerceNodeGen root) {
                return new PolymorphicNode_(root);
            }
        }

        @GeneratedBy(value=BigDecimalNodes.BigDecimalCoerceNode.class)
        private static final class UninitializedNode_
        extends BaseNode_ {
            UninitializedNode_(BigDecimalCoerceNodeGen root) {
                super(root, Integer.MAX_VALUE);
            }

            @Override
            public Object execute_(VirtualFrame frameValue, Object valueValue, Object castValue) {
                return this.uninitialized((Frame)frameValue, valueValue, castValue);
            }

            static BaseNode_ create(BigDecimalCoerceNodeGen root) {
                return new UninitializedNode_(root);
            }
        }

        @GeneratedBy(value=BigDecimalNodes.BigDecimalCoerceNode.class)
        private static abstract class BaseNode_
        extends SpecializationNode {
            protected final BigDecimalCoerceNodeGen root;

            BaseNode_(BigDecimalCoerceNodeGen root, int index) {
                super(index);
                this.root = root;
            }

            protected final Node[] getSuppliedChildren() {
                return new Node[]{this.root.value_, this.root.cast_};
            }

            public final Object acceptAndExecute(Frame frameValue, Object valueValue, Object castValue) {
                return this.execute_((VirtualFrame)frameValue, valueValue, castValue);
            }

            public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

            public RubyBasicObject executeRubyBasicObject1(VirtualFrame frameValue, Object valueValue) {
                Object castValue_ = this.root.cast_.executeObject(frameValue, valueValue);
                return (RubyBasicObject)this.execute_(frameValue, valueValue, castValue_);
            }

            public Object execute(VirtualFrame frameValue) {
                Object valueValue_ = this.root.value_.execute(frameValue);
                return this.executeRubyBasicObject1(frameValue, valueValue_);
            }

            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected final SpecializationNode createNext(Frame frameValue, Object valueValue, Object castValue) {
                if (castValue instanceof BigDecimal) {
                    return BigDecimal0Node_.create(this.root);
                }
                if (valueValue instanceof RubyBasicObject && castValue instanceof RubyBasicObject) {
                    RubyBasicObject valueValue_ = (RubyBasicObject)valueValue;
                    RubyBasicObject castValue_ = (RubyBasicObject)castValue;
                    if (RubyGuards.isRubyBigDecimal(valueValue_) && this.root.isNil(castValue_)) {
                        return BigDecimal1Node_.create(this.root);
                    }
                }
                return null;
            }

            protected final SpecializationNode createPolymorphic() {
                return PolymorphicNode_.create(this.root);
            }

            protected final BaseNode_ getNext() {
                return (BaseNode_)this.next;
            }
        }
    }

    @GeneratedBy(value=BigDecimalNodes.BigDecimalCastNode.class)
    public static final class BigDecimalCastNodeGen
    extends BigDecimalNodes.BigDecimalCastNode
    implements SpecializedNode {
        @Node.Child
        private RubyNode value_;
        @CompilerDirectives.CompilationFinal
        private Class<?> valueType_;
        @Node.Child
        private BaseNode_ specialization_;

        private BigDecimalCastNodeGen(RubyContext context, SourceSection sourceSection, RubyNode value) {
            super(context, sourceSection);
            this.value_ = value;
            this.specialization_ = UninitializedNode_.create(this);
        }

        public NodeCost getCost() {
            return this.specialization_.getNodeCost();
        }

        @Override
        public Object executeObject(VirtualFrame frameValue, Object valueValue) {
            return this.specialization_.execute1(frameValue, valueValue);
        }

        @Override
        public BigDecimal executeBigDecimal(VirtualFrame frameValue, Object valueValue) {
            return this.specialization_.executeBigDecimal(frameValue, valueValue);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.specialization_.execute0(frameValue);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.specialization_.executeVoid(frameValue);
        }

        public SpecializationNode getSpecializationNode() {
            return this.specialization_;
        }

        public Node deepCopy() {
            return SpecializationNode.updateRoot((Node)super.deepCopy());
        }

        public static BigDecimalNodes.BigDecimalCastNode create(RubyContext context, SourceSection sourceSection, RubyNode value) {
            return new BigDecimalCastNodeGen(context, sourceSection, value);
        }

        @GeneratedBy(methodName="doBigDecimalFallback(Object)", value=BigDecimalNodes.BigDecimalCastNode.class)
        private static final class FallbackNode_
        extends BaseNode_ {
            FallbackNode_(BigDecimalCastNodeGen root) {
                super(root, 0x7FFFFFFE);
            }

            @CompilerDirectives.TruffleBoundary
            private boolean guardFallback(Object valueValue) {
                return this.createNext(null, valueValue) == null;
            }

            @Override
            public Object execute1(VirtualFrame frameValue, Object valueValue) {
                if (this.guardFallback(valueValue)) {
                    return this.root.doBigDecimalFallback(valueValue);
                }
                return this.getNext().execute1(frameValue, valueValue);
            }

            static BaseNode_ create(BigDecimalCastNodeGen root) {
                return new FallbackNode_(root);
            }
        }

        @GeneratedBy(methodName="doBigDecimal(RubyBasicObject)", value=BigDecimalNodes.BigDecimalCastNode.class)
        private static final class BigDecimalNode_
        extends BaseNode_ {
            BigDecimalNode_(BigDecimalCastNodeGen root) {
                super(root, 4);
            }

            @Override
            public Object execute1(VirtualFrame frameValue, Object valueValue) {
                RubyBasicObject valueValue_;
                if (valueValue instanceof RubyBasicObject && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(valueValue_ = (RubyBasicObject)valueValue)) {
                    return this.root.doBigDecimal(valueValue_);
                }
                return this.getNext().execute1(frameValue, valueValue);
            }

            static BaseNode_ create(BigDecimalCastNodeGen root) {
                return new BigDecimalNode_(root);
            }
        }

        @GeneratedBy(methodName="doBignum(RubyBasicObject)", value=BigDecimalNodes.BigDecimalCastNode.class)
        private static final class BignumNode_
        extends BaseNode_ {
            BignumNode_(BigDecimalCastNodeGen root) {
                super(root, 3);
            }

            @Override
            public Object execute1(VirtualFrame frameValue, Object valueValue) {
                RubyBasicObject valueValue_;
                if (valueValue instanceof RubyBasicObject && RubyGuards.isRubyBignum(valueValue_ = (RubyBasicObject)valueValue)) {
                    return this.root.doBignum(valueValue_);
                }
                return this.getNext().execute1(frameValue, valueValue);
            }

            static BaseNode_ create(BigDecimalCastNodeGen root) {
                return new BignumNode_(root);
            }
        }

        @GeneratedBy(methodName="doDouble(double)", value=BigDecimalNodes.BigDecimalCastNode.class)
        private static final class DoubleNode_
        extends BaseNode_ {
            DoubleNode_(BigDecimalCastNodeGen root) {
                super(root, 2);
            }

            @Override
            public Object execute0(VirtualFrame frameValue) {
                double valueValue_;
                try {
                    valueValue_ = this.root.value_.executeDouble(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.getNext().executeBigDecimal(frameValue, ex.getResult());
                }
                return this.root.doDouble(valueValue_);
            }

            @Override
            public Object execute1(VirtualFrame frameValue, Object valueValue) {
                if (valueValue instanceof Double) {
                    double valueValue_ = (Double)valueValue;
                    return this.root.doDouble(valueValue_);
                }
                return this.getNext().execute1(frameValue, valueValue);
            }

            static BaseNode_ create(BigDecimalCastNodeGen root) {
                return new DoubleNode_(root);
            }
        }

        @GeneratedBy(methodName="doInt(long)", value=BigDecimalNodes.BigDecimalCastNode.class)
        private static final class IntNode_
        extends BaseNode_ {
            private final Class<?> valueImplicitType;

            IntNode_(BigDecimalCastNodeGen root, Object valueValue) {
                super(root, 1);
                this.valueImplicitType = RubyTypesGen.getImplicitLongClass(valueValue);
            }

            public boolean isSame(SpecializationNode other) {
                return super.isSame(other) && this.valueImplicitType == ((IntNode_)other).valueImplicitType;
            }

            @Override
            public Object execute0(VirtualFrame frameValue) {
                long valueValue_;
                block4: {
                    try {
                        if (this.valueImplicitType == Long.TYPE) {
                            valueValue_ = this.root.value_.executeLong(frameValue);
                            break block4;
                        }
                        if (this.valueImplicitType == Integer.TYPE) {
                            valueValue_ = RubyTypes.int2long(this.root.value_.executeInteger(frameValue));
                            break block4;
                        }
                        Object valueValue__ = this.executeValue_((Frame)frameValue);
                        throw new UnexpectedResultException(valueValue__);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBigDecimal(frameValue, ex.getResult());
                    }
                }
                return this.root.doInt(valueValue_);
            }

            @Override
            public Object execute1(VirtualFrame frameValue, Object valueValue) {
                if (RubyTypesGen.isImplicitLong(valueValue, this.valueImplicitType)) {
                    long valueValue_ = RubyTypesGen.asImplicitLong(valueValue, this.valueImplicitType);
                    return this.root.doInt(valueValue_);
                }
                return this.getNext().execute1(frameValue, valueValue);
            }

            static BaseNode_ create(BigDecimalCastNodeGen root, Object valueValue) {
                return new IntNode_(root, valueValue);
            }
        }

        @GeneratedBy(value=BigDecimalNodes.BigDecimalCastNode.class)
        private static final class PolymorphicNode_
        extends BaseNode_ {
            PolymorphicNode_(BigDecimalCastNodeGen root) {
                super(root, 0);
            }

            public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object valueValue) {
                return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, valueValue));
            }

            @Override
            public Object execute1(VirtualFrame frameValue, Object valueValue) {
                return this.getNext().execute1(frameValue, valueValue);
            }

            static BaseNode_ create(BigDecimalCastNodeGen root) {
                return new PolymorphicNode_(root);
            }
        }

        @GeneratedBy(value=BigDecimalNodes.BigDecimalCastNode.class)
        private static final class UninitializedNode_
        extends BaseNode_ {
            UninitializedNode_(BigDecimalCastNodeGen root) {
                super(root, Integer.MAX_VALUE);
            }

            @Override
            public Object execute1(VirtualFrame frameValue, Object valueValue) {
                return this.uninitialized((Frame)frameValue, valueValue);
            }

            static BaseNode_ create(BigDecimalCastNodeGen root) {
                return new UninitializedNode_(root);
            }
        }

        @GeneratedBy(value=BigDecimalNodes.BigDecimalCastNode.class)
        private static abstract class BaseNode_
        extends SpecializationNode {
            protected final BigDecimalCastNodeGen root;

            BaseNode_(BigDecimalCastNodeGen root, int index) {
                super(index);
                this.root = root;
            }

            protected final Node[] getSuppliedChildren() {
                return new Node[]{this.root.value_};
            }

            public final Object acceptAndExecute(Frame frameValue, Object valueValue) {
                return this.execute1((VirtualFrame)frameValue, valueValue);
            }

            public abstract Object execute1(VirtualFrame var1, Object var2);

            public BigDecimal executeBigDecimal(VirtualFrame frameValue, Object valueValue) {
                return (BigDecimal)this.execute1(frameValue, valueValue);
            }

            public Object execute0(VirtualFrame frameValue) {
                Object valueValue_ = this.executeValue_((Frame)frameValue);
                return this.executeBigDecimal(frameValue, valueValue_);
            }

            public void executeVoid(VirtualFrame frameValue) {
                this.execute0(frameValue);
            }

            protected final SpecializationNode createNext(Frame frameValue, Object valueValue) {
                if (RubyTypesGen.isImplicitLong(valueValue)) {
                    return IntNode_.create(this.root, valueValue);
                }
                if (valueValue instanceof Double) {
                    return DoubleNode_.create(this.root);
                }
                if (valueValue instanceof RubyBasicObject) {
                    RubyBasicObject valueValue_ = (RubyBasicObject)valueValue;
                    if (RubyGuards.isRubyBignum(valueValue_)) {
                        return BignumNode_.create(this.root);
                    }
                    if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(valueValue_)) {
                        return BigDecimalNode_.create(this.root);
                    }
                }
                return null;
            }

            protected final SpecializationNode createFallback() {
                return FallbackNode_.create(this.root);
            }

            protected final SpecializationNode createPolymorphic() {
                return PolymorphicNode_.create(this.root);
            }

            protected final BaseNode_ getNext() {
                return (BaseNode_)this.next;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            protected final Object executeValue_(Frame frameValue) {
                Object object;
                Class valueType_ = this.root.valueType_;
                if (valueType_ == Double.TYPE) {
                    return this.root.value_.executeDouble((VirtualFrame)frameValue);
                }
                if (valueType_ == Integer.TYPE) {
                    return this.root.value_.executeInteger((VirtualFrame)frameValue);
                }
                if (valueType_ == Long.TYPE) {
                    return this.root.value_.executeLong((VirtualFrame)frameValue);
                }
                if (valueType_ != null) return this.root.value_.execute((VirtualFrame)frameValue);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Class<Object> _type = Object.class;
                try {
                    Object _value = this.root.value_.execute((VirtualFrame)frameValue);
                    _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                    object = _value;
                }
                catch (Throwable throwable) {
                    try {
                        this.root.valueType_ = _type;
                        throw throwable;
                    }
                    catch (UnexpectedResultException ex) {
                        this.root.valueType_ = Object.class;
                        return ex.getResult();
                    }
                }
                this.root.valueType_ = _type;
                return object;
            }
        }
    }

    @GeneratedBy(value=BigDecimalNodes.ToINode.class)
    public static final class ToINodeFactory
    extends NodeFactoryBase<BigDecimalNodes.ToINode> {
        private static ToINodeFactory toINodeFactoryInstance;

        private ToINodeFactory() {
            super(BigDecimalNodes.ToINode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BigDecimalNodes.ToINode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToINodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BigDecimalNodes.ToINode> getInstance() {
            if (toINodeFactoryInstance == null) {
                toINodeFactoryInstance = new ToINodeFactory();
            }
            return toINodeFactoryInstance;
        }

        public static BigDecimalNodes.ToINode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ToINodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BigDecimalNodes.ToINode.class)
        public static final class ToINodeGen
        extends BigDecimalNodes.ToINode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private ToINodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeInt(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="toISpecial(RubyBasicObject)", value=BigDecimalNodes.ToINode.class)
            private static final class ToISpecialNode_
            extends BaseNode_ {
                ToISpecialNode_(ToINodeGen root) {
                    super(root, 2);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ToINodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                        return this.root.toISpecial(arguments0Value_);
                    }
                    return ToINodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && !BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.toISpecial(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ToINodeGen root) {
                    return new ToISpecialNode_(root);
                }
            }

            @GeneratedBy(methodName="toINormal(RubyBasicObject)", value=BigDecimalNodes.ToINode.class)
            private static final class ToINormalNode_
            extends BaseNode_ {
                ToINormalNode_(ToINodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.toINormal(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ToINodeGen root) {
                    return new ToINormalNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.ToINode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ToINodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ToINodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.ToINode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ToINodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ToINodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.ToINode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final ToINodeGen root;

                BaseNode_(ToINodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    return ToINodeGen.expectInteger(this.execute(frameValue));
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                            return ToINormalNode_.create(this.root);
                        }
                        return ToISpecialNode_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=BigDecimalNodes.UnscaledNode.class)
    public static final class UnscaledNodeFactory
    extends NodeFactoryBase<BigDecimalNodes.UnscaledNode> {
        private static UnscaledNodeFactory unscaledNodeFactoryInstance;

        private UnscaledNodeFactory() {
            super(BigDecimalNodes.UnscaledNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BigDecimalNodes.UnscaledNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return UnscaledNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BigDecimalNodes.UnscaledNode> getInstance() {
            if (unscaledNodeFactoryInstance == null) {
                unscaledNodeFactoryInstance = new UnscaledNodeFactory();
            }
            return unscaledNodeFactoryInstance;
        }

        public static BigDecimalNodes.UnscaledNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new UnscaledNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BigDecimalNodes.UnscaledNode.class)
        public static final class UnscaledNodeGen
        extends BigDecimalNodes.UnscaledNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private UnscaledNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="unscaledSpecial(RubyBasicObject)", value=BigDecimalNodes.UnscaledNode.class)
            private static final class UnscaledSpecialNode_
            extends BaseNode_ {
                UnscaledSpecialNode_(UnscaledNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && !BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.unscaledSpecial(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(UnscaledNodeGen root) {
                    return new UnscaledSpecialNode_(root);
                }
            }

            @GeneratedBy(methodName="unscaled(RubyBasicObject)", value=BigDecimalNodes.UnscaledNode.class)
            private static final class UnscaledNode_
            extends BaseNode_ {
                UnscaledNode_(UnscaledNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.unscaled(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(UnscaledNodeGen root) {
                    return new UnscaledNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.UnscaledNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(UnscaledNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(UnscaledNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.UnscaledNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(UnscaledNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(UnscaledNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.UnscaledNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final UnscaledNodeGen root;

                BaseNode_(UnscaledNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                            return UnscaledNode_.create(this.root);
                        }
                        return UnscaledSpecialNode_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=BigDecimalNodes.ToFNode.class)
    public static final class ToFNodeFactory
    extends NodeFactoryBase<BigDecimalNodes.ToFNode> {
        private static ToFNodeFactory toFNodeFactoryInstance;

        private ToFNodeFactory() {
            super(BigDecimalNodes.ToFNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BigDecimalNodes.ToFNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToFNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BigDecimalNodes.ToFNode> getInstance() {
            if (toFNodeFactoryInstance == null) {
                toFNodeFactoryInstance = new ToFNodeFactory();
            }
            return toFNodeFactoryInstance;
        }

        public static BigDecimalNodes.ToFNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ToFNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BigDecimalNodes.ToFNode.class)
        public static final class ToFNodeGen
        extends BigDecimalNodes.ToFNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private ToFNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="toFSpecial(RubyBasicObject)", value=BigDecimalNodes.ToFNode.class)
            private static final class ToFSpecialNode_
            extends BaseNode_ {
                ToFSpecialNode_(ToFNodeGen root) {
                    super(root, 2);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                        return this.root.toFSpecial(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && !BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.toFSpecial(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ToFNodeGen root) {
                    return new ToFSpecialNode_(root);
                }
            }

            @GeneratedBy(methodName="toFNormal(RubyBasicObject)", value=BigDecimalNodes.ToFNode.class)
            private static final class ToFNormalNode_
            extends BaseNode_ {
                ToFNormalNode_(ToFNodeGen root) {
                    super(root, 1);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                        return this.root.toFNormal(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.toFNormal(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ToFNodeGen root) {
                    return new ToFNormalNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.ToFNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ToFNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ToFNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.ToFNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ToFNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ToFNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.ToFNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final ToFNodeGen root;

                BaseNode_(ToFNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                            return ToFNormalNode_.create(this.root);
                        }
                        return ToFSpecialNode_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=BigDecimalNodes.PrecsNode.class)
    public static final class PrecsNodeFactory
    extends NodeFactoryBase<BigDecimalNodes.PrecsNode> {
        private static PrecsNodeFactory precsNodeFactoryInstance;

        private PrecsNodeFactory() {
            super(BigDecimalNodes.PrecsNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BigDecimalNodes.PrecsNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PrecsNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BigDecimalNodes.PrecsNode> getInstance() {
            if (precsNodeFactoryInstance == null) {
                precsNodeFactoryInstance = new PrecsNodeFactory();
            }
            return precsNodeFactoryInstance;
        }

        public static BigDecimalNodes.PrecsNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new PrecsNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BigDecimalNodes.PrecsNode.class)
        public static final class PrecsNodeGen
        extends BigDecimalNodes.PrecsNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private PrecsNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="precsSpecial(RubyBasicObject)", value=BigDecimalNodes.PrecsNode.class)
            private static final class PrecsSpecialNode_
            extends BaseNode_ {
                PrecsSpecialNode_(PrecsNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && !BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.precsSpecial(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(PrecsNodeGen root) {
                    return new PrecsSpecialNode_(root);
                }
            }

            @GeneratedBy(methodName="precsNormal(RubyBasicObject)", value=BigDecimalNodes.PrecsNode.class)
            private static final class PrecsNormalNode_
            extends BaseNode_ {
                PrecsNormalNode_(PrecsNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.precsNormal(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(PrecsNodeGen root) {
                    return new PrecsNormalNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.PrecsNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(PrecsNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(PrecsNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.PrecsNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(PrecsNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(PrecsNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.PrecsNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final PrecsNodeGen root;

                BaseNode_(PrecsNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                            return PrecsNormalNode_.create(this.root);
                        }
                        return PrecsSpecialNode_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=BigDecimalNodes.InfiniteNode.class)
    public static final class InfiniteNodeFactory
    extends NodeFactoryBase<BigDecimalNodes.InfiniteNode> {
        private static InfiniteNodeFactory infiniteNodeFactoryInstance;

        private InfiniteNodeFactory() {
            super(BigDecimalNodes.InfiniteNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BigDecimalNodes.InfiniteNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InfiniteNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BigDecimalNodes.InfiniteNode> getInstance() {
            if (infiniteNodeFactoryInstance == null) {
                infiniteNodeFactoryInstance = new InfiniteNodeFactory();
            }
            return infiniteNodeFactoryInstance;
        }

        public static BigDecimalNodes.InfiniteNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new InfiniteNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BigDecimalNodes.InfiniteNode.class)
        public static final class InfiniteNodeGen
        extends BigDecimalNodes.InfiniteNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private InfiniteNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="infiniteSpecial(RubyBasicObject)", value=BigDecimalNodes.InfiniteNode.class)
            private static final class InfiniteSpecialNode_
            extends BaseNode_ {
                InfiniteSpecialNode_(InfiniteNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && !BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.infiniteSpecial(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(InfiniteNodeGen root) {
                    return new InfiniteSpecialNode_(root);
                }
            }

            @GeneratedBy(methodName="infiniteNormal(RubyBasicObject)", value=BigDecimalNodes.InfiniteNode.class)
            private static final class InfiniteNormalNode_
            extends BaseNode_ {
                InfiniteNormalNode_(InfiniteNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.infiniteNormal(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(InfiniteNodeGen root) {
                    return new InfiniteNormalNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.InfiniteNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(InfiniteNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(InfiniteNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.InfiniteNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(InfiniteNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(InfiniteNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.InfiniteNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final InfiniteNodeGen root;

                BaseNode_(InfiniteNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                            return InfiniteNormalNode_.create(this.root);
                        }
                        return InfiniteSpecialNode_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=BigDecimalNodes.FiniteNode.class)
    public static final class FiniteNodeFactory
    extends NodeFactoryBase<BigDecimalNodes.FiniteNode> {
        private static FiniteNodeFactory finiteNodeFactoryInstance;

        private FiniteNodeFactory() {
            super(BigDecimalNodes.FiniteNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BigDecimalNodes.FiniteNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return FiniteNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BigDecimalNodes.FiniteNode> getInstance() {
            if (finiteNodeFactoryInstance == null) {
                finiteNodeFactoryInstance = new FiniteNodeFactory();
            }
            return finiteNodeFactoryInstance;
        }

        public static BigDecimalNodes.FiniteNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new FiniteNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BigDecimalNodes.FiniteNode.class)
        public static final class FiniteNodeGen
        extends BigDecimalNodes.FiniteNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private FiniteNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.specialization_.executeBoolean(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="finiteSpecial(RubyBasicObject)", value=BigDecimalNodes.FiniteNode.class)
            private static final class FiniteSpecialNode_
            extends BaseNode_ {
                FiniteSpecialNode_(FiniteNodeGen root) {
                    super(root, 2);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, ex.getResult());
                    }
                    if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                        return this.root.finiteSpecial(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && !BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.finiteSpecial(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(FiniteNodeGen root) {
                    return new FiniteSpecialNode_(root);
                }
            }

            @GeneratedBy(methodName="finiteNormal(RubyBasicObject)", value=BigDecimalNodes.FiniteNode.class)
            private static final class FiniteNormalNode_
            extends BaseNode_ {
                FiniteNormalNode_(FiniteNodeGen root) {
                    super(root, 1);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, ex.getResult());
                    }
                    if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                        return this.root.finiteNormal(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.finiteNormal(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(FiniteNodeGen root) {
                    return new FiniteNormalNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.FiniteNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(FiniteNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(FiniteNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.FiniteNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(FiniteNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Boolean)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(FiniteNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.FiniteNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final FiniteNodeGen root;

                BaseNode_(FiniteNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeBoolean_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract boolean executeBoolean_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeBoolean_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) {
                    return (Boolean)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                            return FiniteNormalNode_.create(this.root);
                        }
                        return FiniteSpecialNode_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=BigDecimalNodes.RoundNode.class)
    public static final class RoundNodeFactory
    extends NodeFactoryBase<BigDecimalNodes.RoundNode> {
        private static RoundNodeFactory roundNodeFactoryInstance;

        private RoundNodeFactory() {
            super(BigDecimalNodes.RoundNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BigDecimalNodes.RoundNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return RoundNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BigDecimalNodes.RoundNode> getInstance() {
            if (roundNodeFactoryInstance == null) {
                roundNodeFactoryInstance = new RoundNodeFactory();
            }
            return roundNodeFactoryInstance;
        }

        public static BigDecimalNodes.RoundNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new RoundNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BigDecimalNodes.RoundNode.class)
        public static final class RoundNodeGen
        extends BigDecimalNodes.RoundNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private RoundNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="roundSpecial(VirtualFrame, RubyBasicObject, Object, Object)", value=BigDecimalNodes.RoundNode.class)
            private static final class RoundSpecialNode_
            extends BaseNode_ {
                RoundSpecialNode_(RoundNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && !BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.roundSpecial(frameValue, arguments0Value_, arguments1Value, arguments2Value);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(RoundNodeGen root) {
                    return new RoundSpecialNode_(root);
                }
            }

            @GeneratedBy(methodName="round(VirtualFrame, RubyBasicObject, int, int)", value=BigDecimalNodes.RoundNode.class)
            private static final class Round2Node_
            extends BaseNode_ {
                Round2Node_(RoundNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments2Value_;
                    int arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value);
                    }
                    try {
                        arguments2Value_ = this.root.arguments2_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult());
                    }
                    if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                        return this.root.round(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof Integer && arguments2Value instanceof Integer) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        int arguments2Value_ = (Integer)arguments2Value;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                            return this.root.round(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(RoundNodeGen root) {
                    return new Round2Node_(root);
                }
            }

            @GeneratedBy(methodName="round(VirtualFrame, RubyBasicObject, int, NotProvided)", value=BigDecimalNodes.RoundNode.class)
            private static final class Round1Node_
            extends BaseNode_ {
                Round1Node_(RoundNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    NotProvided arguments2Value_;
                    int arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value);
                    }
                    try {
                        arguments2Value_ = this.root.arguments2_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult());
                    }
                    if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                        return this.root.round(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof Integer && arguments2Value instanceof NotProvided) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                            return this.root.round(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(RoundNodeGen root) {
                    return new Round1Node_(root);
                }
            }

            @GeneratedBy(methodName="round(VirtualFrame, RubyBasicObject, NotProvided, NotProvided)", value=BigDecimalNodes.RoundNode.class)
            private static final class Round0Node_
            extends BaseNode_ {
                Round0Node_(RoundNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof NotProvided && arguments2Value instanceof NotProvided) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                            return this.root.round(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(RoundNodeGen root) {
                    return new Round0Node_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.RoundNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(RoundNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(RoundNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.RoundNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(RoundNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(RoundNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.RoundNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final RoundNodeGen root;

                BaseNode_(RoundNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    Object arguments2Value_ = this.executeArguments2_((Frame)frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (arguments2Value instanceof NotProvided) {
                            if (arguments1Value instanceof NotProvided && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                                return Round0Node_.create(this.root);
                            }
                            if (arguments1Value instanceof Integer && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                                return Round1Node_.create(this.root);
                            }
                        }
                        if (arguments1Value instanceof Integer && arguments2Value instanceof Integer && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                            return Round2Node_.create(this.root);
                        }
                        if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                            return RoundSpecialNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments2_(Frame frameValue) {
                    Object object;
                    Class arguments2Type_ = this.root.arguments2Type_;
                    if (arguments2Type_ == Integer.TYPE) {
                        return this.root.arguments2_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments2Type_ != null) return this.root.arguments2_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments2_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments2Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments2Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments2Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=BigDecimalNodes.AbsNode.class)
    public static final class AbsNodeFactory
    extends NodeFactoryBase<BigDecimalNodes.AbsNode> {
        private static AbsNodeFactory absNodeFactoryInstance;

        private AbsNodeFactory() {
            super(BigDecimalNodes.AbsNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BigDecimalNodes.AbsNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AbsNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BigDecimalNodes.AbsNode> getInstance() {
            if (absNodeFactoryInstance == null) {
                absNodeFactoryInstance = new AbsNodeFactory();
            }
            return absNodeFactoryInstance;
        }

        public static BigDecimalNodes.AbsNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new AbsNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BigDecimalNodes.AbsNode.class)
        public static final class AbsNodeGen
        extends BigDecimalNodes.AbsNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private AbsNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="absSpecial(VirtualFrame, RubyBasicObject)", value=BigDecimalNodes.AbsNode.class)
            private static final class AbsSpecialNode_
            extends BaseNode_ {
                AbsSpecialNode_(AbsNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && !BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.absSpecial(frameValue, arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(AbsNodeGen root) {
                    return new AbsSpecialNode_(root);
                }
            }

            @GeneratedBy(methodName="abs(VirtualFrame, RubyBasicObject)", value=BigDecimalNodes.AbsNode.class)
            private static final class AbsNode_
            extends BaseNode_ {
                AbsNode_(AbsNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.abs(frameValue, arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(AbsNodeGen root) {
                    return new AbsNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.AbsNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(AbsNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(AbsNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.AbsNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(AbsNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(AbsNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.AbsNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final AbsNodeGen root;

                BaseNode_(AbsNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                            return AbsNode_.create(this.root);
                        }
                        return AbsSpecialNode_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=BigDecimalNodes.ExponentNode.class)
    public static final class ExponentNodeFactory
    extends NodeFactoryBase<BigDecimalNodes.ExponentNode> {
        private static ExponentNodeFactory exponentNodeFactoryInstance;

        private ExponentNodeFactory() {
            super(BigDecimalNodes.ExponentNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BigDecimalNodes.ExponentNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ExponentNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BigDecimalNodes.ExponentNode> getInstance() {
            if (exponentNodeFactoryInstance == null) {
                exponentNodeFactoryInstance = new ExponentNodeFactory();
            }
            return exponentNodeFactoryInstance;
        }

        public static BigDecimalNodes.ExponentNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ExponentNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BigDecimalNodes.ExponentNode.class)
        public static final class ExponentNodeGen
        extends BigDecimalNodes.ExponentNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private ExponentNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeLong(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static long expectLong(Object value) throws UnexpectedResultException {
                if (value instanceof Long) {
                    return (Long)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="exponentSpecial(RubyBasicObject)", value=BigDecimalNodes.ExponentNode.class)
            private static final class ExponentSpecialNode_
            extends BaseNode_ {
                ExponentSpecialNode_(ExponentNodeGen root) {
                    super(root, 3);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ExponentNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                        return this.root.exponentSpecial(arguments0Value_);
                    }
                    return ExponentNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && !BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.exponentSpecial(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ExponentNodeGen root) {
                    return new ExponentSpecialNode_(root);
                }
            }

            @GeneratedBy(methodName="exponentZero(RubyBasicObject)", value=BigDecimalNodes.ExponentNode.class)
            private static final class ExponentZeroNode_
            extends BaseNode_ {
                ExponentZeroNode_(ExponentNodeGen root) {
                    super(root, 2);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ExponentNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalZero(arguments0Value_)) {
                        return this.root.exponentZero(arguments0Value_);
                    }
                    return ExponentNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_ = (RubyBasicObject)arguments0Value) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalZero(arguments0Value_)) {
                        return this.root.exponentZero(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ExponentNodeGen root) {
                    return new ExponentZeroNode_(root);
                }
            }

            @GeneratedBy(methodName="exponent(RubyBasicObject)", value=BigDecimalNodes.ExponentNode.class)
            private static final class ExponentNode_
            extends BaseNode_ {
                ExponentNode_(ExponentNodeGen root) {
                    super(root, 1);
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ExponentNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_) && !BigDecimalNodes.BigDecimalCoreMethodNode.isNormalZero(arguments0Value_)) {
                        return this.root.exponent(arguments0Value_);
                    }
                    return ExponentNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_ = (RubyBasicObject)arguments0Value) && !BigDecimalNodes.BigDecimalCoreMethodNode.isNormalZero(arguments0Value_)) {
                        return this.root.exponent(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ExponentNodeGen root) {
                    return new ExponentNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.ExponentNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ExponentNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ExponentNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.ExponentNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ExponentNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ExponentNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.ExponentNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final ExponentNodeGen root;

                BaseNode_(ExponentNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    return ExponentNodeGen.expectInteger(this.execute(frameValue));
                }

                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    return ExponentNodeGen.expectLong(this.execute(frameValue));
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_) && !BigDecimalNodes.BigDecimalCoreMethodNode.isNormalZero(arguments0Value_)) {
                            return ExponentNode_.create(this.root);
                        }
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalZero(arguments0Value_)) {
                            return ExponentZeroNode_.create(this.root);
                        }
                        if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                            return ExponentSpecialNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=BigDecimalNodes.NanNode.class)
    public static final class NanNodeFactory
    extends NodeFactoryBase<BigDecimalNodes.NanNode> {
        private static NanNodeFactory nanNodeFactoryInstance;

        private NanNodeFactory() {
            super(BigDecimalNodes.NanNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BigDecimalNodes.NanNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return NanNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BigDecimalNodes.NanNode> getInstance() {
            if (nanNodeFactoryInstance == null) {
                nanNodeFactoryInstance = new NanNodeFactory();
            }
            return nanNodeFactoryInstance;
        }

        public static BigDecimalNodes.NanNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new NanNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BigDecimalNodes.NanNode.class)
        public static final class NanNodeGen
        extends BigDecimalNodes.NanNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private NanNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.specialization_.executeBoolean(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="nanSpecial(RubyBasicObject)", value=BigDecimalNodes.NanNode.class)
            private static final class NanSpecialNode_
            extends BaseNode_ {
                NanSpecialNode_(NanNodeGen root) {
                    super(root, 2);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, ex.getResult());
                    }
                    if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                        return this.root.nanSpecial(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && !BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.nanSpecial(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(NanNodeGen root) {
                    return new NanSpecialNode_(root);
                }
            }

            @GeneratedBy(methodName="nanNormal(RubyBasicObject)", value=BigDecimalNodes.NanNode.class)
            private static final class NanNormalNode_
            extends BaseNode_ {
                NanNormalNode_(NanNodeGen root) {
                    super(root, 1);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, ex.getResult());
                    }
                    if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                        return this.root.nanNormal(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.nanNormal(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(NanNodeGen root) {
                    return new NanNormalNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.NanNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(NanNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(NanNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.NanNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(NanNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Boolean)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(NanNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.NanNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final NanNodeGen root;

                BaseNode_(NanNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeBoolean_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract boolean executeBoolean_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeBoolean_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) {
                    return (Boolean)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                            return NanNormalNode_.create(this.root);
                        }
                        return NanSpecialNode_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=BigDecimalNodes.SignNode.class)
    public static final class SignNodeFactory
    extends NodeFactoryBase<BigDecimalNodes.SignNode> {
        private static SignNodeFactory signNodeFactoryInstance;

        private SignNodeFactory() {
            super(BigDecimalNodes.SignNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BigDecimalNodes.SignNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SignNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BigDecimalNodes.SignNode> getInstance() {
            if (signNodeFactoryInstance == null) {
                signNodeFactoryInstance = new SignNodeFactory();
            }
            return signNodeFactoryInstance;
        }

        public static BigDecimalNodes.SignNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SignNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BigDecimalNodes.SignNode.class)
        public static final class SignNodeGen
        extends BigDecimalNodes.SignNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private SignNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                return this.specialization_.executeInt(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="signSpecial(VirtualFrame, RubyBasicObject)", value=BigDecimalNodes.SignNode.class)
            private static final class SignSpecialNode_
            extends BaseNode_ {
                SignSpecialNode_(SignNodeGen root) {
                    super(root, 3);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, ex.getResult());
                    }
                    if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                        return this.root.signSpecial(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && !BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.signSpecial(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SignNodeGen root) {
                    return new SignSpecialNode_(root);
                }
            }

            @GeneratedBy(methodName="signNormal(VirtualFrame, RubyBasicObject)", value=BigDecimalNodes.SignNode.class)
            private static final class SignNormalNode_
            extends BaseNode_ {
                SignNormalNode_(SignNodeGen root) {
                    super(root, 2);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, ex.getResult());
                    }
                    if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_) && !BigDecimalNodes.BigDecimalCoreMethodNode.isNormalZero(arguments0Value_)) {
                        return this.root.signNormal(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_ = (RubyBasicObject)arguments0Value) && !BigDecimalNodes.BigDecimalCoreMethodNode.isNormalZero(arguments0Value_)) {
                        return this.root.signNormal(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SignNodeGen root) {
                    return new SignNormalNode_(root);
                }
            }

            @GeneratedBy(methodName="signNormalZero(VirtualFrame, RubyBasicObject)", value=BigDecimalNodes.SignNode.class)
            private static final class SignNormalZeroNode_
            extends BaseNode_ {
                SignNormalZeroNode_(SignNodeGen root) {
                    super(root, 1);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, ex.getResult());
                    }
                    if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalZero(arguments0Value_)) {
                        return this.root.signNormalZero(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_ = (RubyBasicObject)arguments0Value) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalZero(arguments0Value_)) {
                        return this.root.signNormalZero(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SignNodeGen root) {
                    return new SignNormalZeroNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.SignNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SignNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.getNext().executeInt_(frameValue, arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SignNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.SignNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SignNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Integer)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(SignNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.SignNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final SignNodeGen root;

                BaseNode_(SignNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeInt_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract int executeInt_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeInt_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) {
                    return (Integer)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalZero(arguments0Value_)) {
                            return SignNormalZeroNode_.create(this.root);
                        }
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_) && !BigDecimalNodes.BigDecimalCoreMethodNode.isNormalZero(arguments0Value_)) {
                            return SignNormalNode_.create(this.root);
                        }
                        if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                            return SignSpecialNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=BigDecimalNodes.GetIntegerConstantNode.class)
    public static final class GetIntegerConstantNodeGen
    extends BigDecimalNodes.GetIntegerConstantNode {
        @Node.Child
        private RubyNode name_;
        @Node.Child
        private RubyNode module_;
        @Node.Child
        private GetConstantNode getConst_;
        @Node.Child
        private ToIntNode coerce_;
        @Node.Child
        private IntegerCastNode cast_;

        private GetIntegerConstantNodeGen(RubyContext context, SourceSection sourceSection, RubyNode name, RubyNode module, GetConstantNode getConst, ToIntNode coerce, IntegerCastNode cast) {
            super(context, sourceSection);
            this.name_ = name;
            this.module_ = module;
            this.getConst_ = getConst;
            this.coerce_ = coerce;
            this.cast_ = cast;
        }

        @Override
        public IntegerCastNode getCast() {
            return this.cast_;
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public int executeGetIntegerConstant(VirtualFrame frameValue, String nameValue, RubyModule moduleValue) {
            Object getConstValue_ = this.getConst_.executeGetConstant(frameValue, moduleValue, nameValue);
            Object coerceValue_ = this.coerce_.executeIntOrLong(frameValue, getConstValue_);
            int castValue_ = this.cast_.executeInteger(frameValue, coerceValue_);
            return this.doInteger(nameValue, moduleValue, getConstValue_, coerceValue_, castValue_);
        }

        @Override
        public int executeGetIntegerConstant(VirtualFrame frameValue, String nameValue) {
            RubyModule moduleValue_;
            try {
                moduleValue_ = this.module_.executeRubyModule(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object getConstValue = this.getConst_.executeGetConstant(frameValue, ex.getResult(), nameValue);
                Object coerceValue = this.coerce_.executeIntOrLong(frameValue, getConstValue);
                Integer castValue = this.cast_.executeInteger(frameValue, coerceValue);
                throw this.unsupported(nameValue, ex.getResult(), getConstValue, coerceValue, castValue);
            }
            Object getConstValue_ = this.getConst_.executeGetConstant(frameValue, moduleValue_, nameValue);
            Object coerceValue_ = this.coerce_.executeIntOrLong(frameValue, getConstValue_);
            int castValue_ = this.cast_.executeInteger(frameValue, coerceValue_);
            return this.doInteger(nameValue, moduleValue_, getConstValue_, coerceValue_, castValue_);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeInteger(frameValue);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.executeInteger(frameValue);
        }

        @Override
        public int executeInteger(VirtualFrame frameValue) {
            RubyModule moduleValue_;
            String nameValue_;
            try {
                nameValue_ = GetIntegerConstantNodeGen.expectString(this.name_.execute(frameValue));
            }
            catch (UnexpectedResultException ex) {
                Object moduleValue = this.module_.execute(frameValue);
                Object getConstValue = this.getConst_.executeGetConstant(frameValue, moduleValue, (String)ex.getResult());
                Object coerceValue = this.coerce_.executeIntOrLong(frameValue, getConstValue);
                Integer castValue = this.cast_.executeInteger(frameValue, coerceValue);
                throw this.unsupported(ex.getResult(), moduleValue, getConstValue, coerceValue, castValue);
            }
            try {
                moduleValue_ = this.module_.executeRubyModule(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object getConstValue = this.getConst_.executeGetConstant(frameValue, ex.getResult(), nameValue_);
                Object coerceValue = this.coerce_.executeIntOrLong(frameValue, getConstValue);
                Integer castValue = this.cast_.executeInteger(frameValue, coerceValue);
                throw this.unsupported(nameValue_, ex.getResult(), getConstValue, coerceValue, castValue);
            }
            Object getConstValue_ = this.getConst_.executeGetConstant(frameValue, moduleValue_, nameValue_);
            Object coerceValue_ = this.coerce_.executeIntOrLong(frameValue, getConstValue_);
            int castValue_ = this.cast_.executeInteger(frameValue, coerceValue_);
            return this.doInteger(nameValue_, moduleValue_, getConstValue_, coerceValue_, castValue_);
        }

        protected UnsupportedSpecializationException unsupported(Object nameValue, Object moduleValue, Object getConstValue, Object coerceValue, Object castValue) {
            return new UnsupportedSpecializationException((Node)this, new Node[]{this.name_, this.module_, this.getConst_, this.coerce_, this.cast_}, new Object[]{nameValue, moduleValue, getConstValue, coerceValue, castValue});
        }

        private static String expectString(Object value) throws UnexpectedResultException {
            if (value instanceof String) {
                return (String)value;
            }
            throw new UnexpectedResultException(value);
        }

        public static BigDecimalNodes.GetIntegerConstantNode create(RubyContext context, SourceSection sourceSection, RubyNode name, RubyNode module, GetConstantNode getConst, ToIntNode coerce, IntegerCastNode cast) {
            return new GetIntegerConstantNodeGen(context, sourceSection, name, module, getConst, coerce, cast);
        }
    }

    @GeneratedBy(value=BigDecimalNodes.ZeroNode.class)
    public static final class ZeroNodeFactory
    extends NodeFactoryBase<BigDecimalNodes.ZeroNode> {
        private static ZeroNodeFactory zeroNodeFactoryInstance;

        private ZeroNodeFactory() {
            super(BigDecimalNodes.ZeroNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BigDecimalNodes.ZeroNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ZeroNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BigDecimalNodes.ZeroNode> getInstance() {
            if (zeroNodeFactoryInstance == null) {
                zeroNodeFactoryInstance = new ZeroNodeFactory();
            }
            return zeroNodeFactoryInstance;
        }

        public static BigDecimalNodes.ZeroNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ZeroNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BigDecimalNodes.ZeroNode.class)
        public static final class ZeroNodeGen
        extends BigDecimalNodes.ZeroNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private ZeroNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.specialization_.executeBoolean(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="zeroSpecial(RubyBasicObject)", value=BigDecimalNodes.ZeroNode.class)
            private static final class ZeroSpecialNode_
            extends BaseNode_ {
                ZeroSpecialNode_(ZeroNodeGen root) {
                    super(root, 2);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, ex.getResult());
                    }
                    if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                        return this.root.zeroSpecial(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && !BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.zeroSpecial(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ZeroNodeGen root) {
                    return new ZeroSpecialNode_(root);
                }
            }

            @GeneratedBy(methodName="zeroNormal(RubyBasicObject)", value=BigDecimalNodes.ZeroNode.class)
            private static final class ZeroNormalNode_
            extends BaseNode_ {
                ZeroNormalNode_(ZeroNodeGen root) {
                    super(root, 1);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, ex.getResult());
                    }
                    if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                        return this.root.zeroNormal(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.zeroNormal(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ZeroNodeGen root) {
                    return new ZeroNormalNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.ZeroNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ZeroNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ZeroNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.ZeroNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ZeroNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Boolean)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ZeroNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.ZeroNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final ZeroNodeGen root;

                BaseNode_(ZeroNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeBoolean_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract boolean executeBoolean_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeBoolean_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) {
                    return (Boolean)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                            return ZeroNormalNode_.create(this.root);
                        }
                        return ZeroSpecialNode_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=BigDecimalNodes.CompareNode.class)
    public static final class CompareNodeFactory
    extends NodeFactoryBase<BigDecimalNodes.CompareNode> {
        private static CompareNodeFactory compareNodeFactoryInstance;

        private CompareNodeFactory() {
            super(BigDecimalNodes.CompareNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BigDecimalNodes.CompareNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CompareNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BigDecimalNodes.CompareNode> getInstance() {
            if (compareNodeFactoryInstance == null) {
                compareNodeFactoryInstance = new CompareNodeFactory();
            }
            return compareNodeFactoryInstance;
        }

        public static BigDecimalNodes.CompareNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new CompareNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BigDecimalNodes.CompareNode.class)
        public static final class CompareNodeGen
        extends BigDecimalNodes.CompareNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private CompareNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeInt(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="compareCoerced(VirtualFrame, RubyBasicObject, RubyBasicObject)", value=BigDecimalNodes.CompareNode.class)
            private static final class CompareCoercedNode_
            extends BaseNode_ {
                CompareCoercedNode_(CompareNodeGen root) {
                    super(root, 11);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (!RubyGuards.isRubyBigDecimal(arguments1Value_) && !this.root.isNil(arguments1Value_)) {
                            return this.root.compareCoerced(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompareNodeGen root) {
                    return new CompareCoercedNode_(root);
                }
            }

            @GeneratedBy(methodName="compareNil(RubyBasicObject, RubyBasicObject)", value=BigDecimalNodes.CompareNode.class)
            private static final class CompareNilNode_
            extends BaseNode_ {
                CompareNilNode_(CompareNodeGen root) {
                    super(root, 10);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (this.root.isNil(arguments1Value_)) {
                            return this.root.compareNil(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompareNodeGen root) {
                    return new CompareNilNode_(root);
                }
            }

            @GeneratedBy(methodName="compareSpecial(RubyBasicObject, RubyBasicObject)", value=BigDecimalNodes.CompareNode.class)
            private static final class CompareSpecial2Node_
            extends BaseNode_ {
                CompareSpecial2Node_(CompareNodeGen root) {
                    super(root, 9);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (!(!RubyGuards.isRubyBigDecimal(arguments1Value_) || BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments1Value_) || !BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNan(arguments0Value_))) {
                            return this.root.compareSpecial(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompareNodeGen root) {
                    return new CompareSpecial2Node_(root);
                }
            }

            @GeneratedBy(methodName="compareSpecialNan(RubyBasicObject, RubyBasicObject)", value=BigDecimalNodes.CompareNode.class)
            private static final class CompareSpecialNanNode_
            extends BaseNode_ {
                CompareSpecialNanNode_(CompareNodeGen root) {
                    super(root, 8);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNan(arguments0Value_)) {
                            return this.root.compareSpecialNan(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompareNodeGen root) {
                    return new CompareSpecialNanNode_(root);
                }
            }

            @GeneratedBy(methodName="compareSpecialBignum(VirtualFrame, RubyBasicObject, RubyBasicObject)", value=BigDecimalNodes.CompareNode.class)
            private static final class CompareSpecialBignumNode_
            extends BaseNode_ {
                CompareSpecialBignumNode_(CompareNodeGen root) {
                    super(root, 7);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_) && RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.compareSpecialBignum(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompareNodeGen root) {
                    return new CompareSpecialBignumNode_(root);
                }
            }

            @GeneratedBy(methodName="compareSpecial(VirtualFrame, RubyBasicObject, double)", value=BigDecimalNodes.CompareNode.class)
            private static final class CompareSpecial1Node_
            extends BaseNode_ {
                CompareSpecial1Node_(CompareNodeGen root) {
                    super(root, 6);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    double arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                        return this.root.compareSpecial(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof Double) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        double arguments1Value_ = (Double)arguments1Value;
                        if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                            return this.root.compareSpecial(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompareNodeGen root) {
                    return new CompareSpecial1Node_(root);
                }
            }

            @GeneratedBy(methodName="compareSpecial(VirtualFrame, RubyBasicObject, long)", value=BigDecimalNodes.CompareNode.class)
            private static final class CompareSpecial0Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                CompareSpecial0Node_(CompareNodeGen root, Object arguments1Value) {
                    super(root, 5);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((CompareSpecial0Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    long arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                        return this.root.compareSpecial(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                            return this.root.compareSpecial(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompareNodeGen root, Object arguments1Value) {
                    return new CompareSpecial0Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="compareNormal(RubyBasicObject, RubyBasicObject)", value=BigDecimalNodes.CompareNode.class)
            private static final class CompareNormalNode_
            extends BaseNode_ {
                CompareNormalNode_(CompareNodeGen root) {
                    super(root, 4);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    RubyBasicObject arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return CompareNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return CompareNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(arguments1Value_)) {
                        return this.root.compareNormal(arguments0Value_, arguments1Value_);
                    }
                    return CompareNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(arguments1Value_)) {
                            return this.root.compareNormal(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompareNodeGen root) {
                    return new CompareNormalNode_(root);
                }
            }

            @GeneratedBy(methodName="compare(RubyBasicObject, RubyBasicObject)", value=BigDecimalNodes.CompareNode.class)
            private static final class Compare2Node_
            extends BaseNode_ {
                Compare2Node_(CompareNodeGen root) {
                    super(root, 3);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    RubyBasicObject arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return CompareNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return CompareNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_) && RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.compare(arguments0Value_, arguments1Value_);
                    }
                    return CompareNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_) && RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.compare(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompareNodeGen root) {
                    return new Compare2Node_(root);
                }
            }

            @GeneratedBy(methodName="compare(RubyBasicObject, double)", value=BigDecimalNodes.CompareNode.class)
            private static final class Compare1Node_
            extends BaseNode_ {
                Compare1Node_(CompareNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    double arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return CompareNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return CompareNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                        return this.root.compare(arguments0Value_, arguments1Value_);
                    }
                    return CompareNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof Double) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        double arguments1Value_ = (Double)arguments1Value;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                            return this.root.compare(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompareNodeGen root) {
                    return new Compare1Node_(root);
                }
            }

            @GeneratedBy(methodName="compare(RubyBasicObject, long)", value=BigDecimalNodes.CompareNode.class)
            private static final class Compare0Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Compare0Node_(CompareNodeGen root, Object arguments1Value) {
                    super(root, 1);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Compare0Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return CompareNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return CompareNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                        return this.root.compare(arguments0Value_, arguments1Value_);
                    }
                    return CompareNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                            return this.root.compare(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompareNodeGen root, Object arguments1Value) {
                    return new Compare0Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.CompareNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(CompareNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompareNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.CompareNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(CompareNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompareNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.CompareNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final CompareNodeGen root;

                BaseNode_(CompareNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    return CompareNodeGen.expectInteger(this.execute(frameValue));
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments1Value_;
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (RubyTypesGen.isImplicitLong(arguments1Value) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                            return Compare0Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof Double && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                            return Compare1Node_.create(this.root);
                        }
                        if (arguments1Value instanceof RubyBasicObject) {
                            arguments1Value_ = (RubyBasicObject)arguments1Value;
                            if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_) && RubyGuards.isRubyBignum(arguments1Value_)) {
                                return Compare2Node_.create(this.root);
                            }
                            if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(arguments1Value_)) {
                                return CompareNormalNode_.create(this.root);
                            }
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value) && !BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                            return CompareSpecial0Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof Double && !BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                            return CompareSpecial1Node_.create(this.root);
                        }
                        if (arguments1Value instanceof RubyBasicObject) {
                            arguments1Value_ = (RubyBasicObject)arguments1Value;
                            if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_) && RubyGuards.isRubyBignum(arguments1Value_)) {
                                return CompareSpecialBignumNode_.create(this.root);
                            }
                            if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNan(arguments0Value_)) {
                                return CompareSpecialNanNode_.create(this.root);
                            }
                            if (!(!RubyGuards.isRubyBigDecimal(arguments1Value_) || BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments1Value_) || !BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNan(arguments0Value_))) {
                                return CompareSpecial2Node_.create(this.root);
                            }
                            if (this.root.isNil(arguments1Value_)) {
                                return CompareNilNode_.create(this.root);
                            }
                            if (!RubyGuards.isRubyBigDecimal(arguments1Value_) && !this.root.isNil(arguments1Value_)) {
                                return CompareCoercedNode_.create(this.root);
                            }
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Double.TYPE) {
                        return this.root.arguments1_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }

                protected final long executeArguments1Long_(Frame frameValue, Class<?> arguments1ImplicitType) throws UnexpectedResultException {
                    if (arguments1ImplicitType == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1ImplicitType == Integer.TYPE) {
                        return RubyTypes.int2long(this.root.arguments1_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    throw new UnexpectedResultException(arguments1Value_);
                }
            }
        }
    }

    @GeneratedBy(value=BigDecimalNodes.SqrtNode.class)
    public static final class SqrtNodeFactory
    extends NodeFactoryBase<BigDecimalNodes.SqrtNode> {
        private static SqrtNodeFactory sqrtNodeFactoryInstance;

        private SqrtNodeFactory() {
            super(BigDecimalNodes.SqrtNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public BigDecimalNodes.SqrtNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return SqrtNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BigDecimalNodes.SqrtNode> getInstance() {
            if (sqrtNodeFactoryInstance == null) {
                sqrtNodeFactoryInstance = new SqrtNodeFactory();
            }
            return sqrtNodeFactoryInstance;
        }

        public static BigDecimalNodes.SqrtNode create(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode precision) {
            return new SqrtNodeGen(context, sourceSection, self, precision);
        }

        @GeneratedBy(value=BigDecimalNodes.SqrtNode.class)
        public static final class SqrtNodeGen
        extends BigDecimalNodes.SqrtNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode self_;
            @Node.Child
            private RubyNode precision_;
            @CompilerDirectives.CompilationFinal
            private Class<?> precisionType_;
            @Node.Child
            private BaseNode_ specialization_;

            private SqrtNodeGen(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode precision) {
                super(context, sourceSection);
                this.self_ = self;
                this.precision_ = precision;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object executeSqrt(VirtualFrame frameValue, RubyBasicObject selfValue, int precisionValue) {
                return this.specialization_.execute1(frameValue, selfValue, precisionValue);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute0(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="sqrtSpecial(VirtualFrame, RubyBasicObject, int)", value=BigDecimalNodes.SqrtNode.class)
            private static final class SqrtSpecialNode_
            extends BaseNode_ {
                SqrtSpecialNode_(SqrtNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute0(VirtualFrame frameValue) {
                    int precisionValue_;
                    RubyBasicObject selfValue_;
                    try {
                        selfValue_ = this.root.self_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object precisionValue = this.executePrecision_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), precisionValue);
                    }
                    try {
                        precisionValue_ = this.root.precision_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, selfValue_, ex.getResult());
                    }
                    if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(selfValue_) && precisionValue_ > 0) {
                        return this.root.sqrtSpecial(frameValue, selfValue_, precisionValue_);
                    }
                    return this.getNext().execute_(frameValue, selfValue_, precisionValue_);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, RubyBasicObject selfValue, int precisionValue) {
                    if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(selfValue) && precisionValue > 0) {
                        return this.root.sqrtSpecial(frameValue, selfValue, precisionValue);
                    }
                    return this.getNext().execute1(frameValue, selfValue, precisionValue);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object selfValue, Object precisionValue) {
                    if (selfValue instanceof RubyBasicObject && precisionValue instanceof Integer) {
                        RubyBasicObject selfValue_ = (RubyBasicObject)selfValue;
                        int precisionValue_ = (Integer)precisionValue;
                        if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(selfValue_) && precisionValue_ > 0) {
                            return this.root.sqrtSpecial(frameValue, selfValue_, precisionValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, selfValue, precisionValue);
                }

                static BaseNode_ create(SqrtNodeGen root) {
                    return new SqrtSpecialNode_(root);
                }
            }

            @GeneratedBy(methodName="sqrt(VirtualFrame, RubyBasicObject, int)", value=BigDecimalNodes.SqrtNode.class)
            private static final class SqrtNode_
            extends BaseNode_ {
                SqrtNode_(SqrtNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute0(VirtualFrame frameValue) {
                    int precisionValue_;
                    RubyBasicObject selfValue_;
                    try {
                        selfValue_ = this.root.self_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object precisionValue = this.executePrecision_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), precisionValue);
                    }
                    try {
                        precisionValue_ = this.root.precision_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, selfValue_, ex.getResult());
                    }
                    if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(selfValue_) && precisionValue_ > 0) {
                        return this.root.sqrt(frameValue, selfValue_, precisionValue_);
                    }
                    return this.getNext().execute_(frameValue, selfValue_, precisionValue_);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, RubyBasicObject selfValue, int precisionValue) {
                    if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(selfValue) && precisionValue > 0) {
                        return this.root.sqrt(frameValue, selfValue, precisionValue);
                    }
                    return this.getNext().execute1(frameValue, selfValue, precisionValue);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object selfValue, Object precisionValue) {
                    if (selfValue instanceof RubyBasicObject && precisionValue instanceof Integer) {
                        RubyBasicObject selfValue_ = (RubyBasicObject)selfValue;
                        int precisionValue_ = (Integer)precisionValue;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(selfValue_) && precisionValue_ > 0) {
                            return this.root.sqrt(frameValue, selfValue_, precisionValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, selfValue, precisionValue);
                }

                static BaseNode_ create(SqrtNodeGen root) {
                    return new SqrtNode_(root);
                }
            }

            @GeneratedBy(methodName="sqrtZeroPrecision(VirtualFrame, RubyBasicObject, int)", value=BigDecimalNodes.SqrtNode.class)
            private static final class SqrtZeroPrecisionNode_
            extends BaseNode_ {
                SqrtZeroPrecisionNode_(SqrtNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute0(VirtualFrame frameValue) {
                    int precisionValue_;
                    RubyBasicObject selfValue_;
                    try {
                        selfValue_ = this.root.self_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object precisionValue = this.executePrecision_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), precisionValue);
                    }
                    try {
                        precisionValue_ = this.root.precision_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, selfValue_, ex.getResult());
                    }
                    if (precisionValue_ == 0) {
                        return this.root.sqrtZeroPrecision(frameValue, selfValue_, precisionValue_);
                    }
                    return this.getNext().execute_(frameValue, selfValue_, precisionValue_);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, RubyBasicObject selfValue, int precisionValue) {
                    if (precisionValue == 0) {
                        return this.root.sqrtZeroPrecision(frameValue, selfValue, precisionValue);
                    }
                    return this.getNext().execute1(frameValue, selfValue, precisionValue);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object selfValue, Object precisionValue) {
                    if (selfValue instanceof RubyBasicObject && precisionValue instanceof Integer) {
                        RubyBasicObject selfValue_ = (RubyBasicObject)selfValue;
                        int precisionValue_ = (Integer)precisionValue;
                        if (precisionValue_ == 0) {
                            return this.root.sqrtZeroPrecision(frameValue, selfValue_, precisionValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, selfValue, precisionValue);
                }

                static BaseNode_ create(SqrtNodeGen root) {
                    return new SqrtZeroPrecisionNode_(root);
                }
            }

            @GeneratedBy(methodName="sqrtNegativePrecision(VirtualFrame, RubyBasicObject, int)", value=BigDecimalNodes.SqrtNode.class)
            private static final class SqrtNegativePrecisionNode_
            extends BaseNode_ {
                SqrtNegativePrecisionNode_(SqrtNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute0(VirtualFrame frameValue) {
                    int precisionValue_;
                    RubyBasicObject selfValue_;
                    try {
                        selfValue_ = this.root.self_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object precisionValue = this.executePrecision_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), precisionValue);
                    }
                    try {
                        precisionValue_ = this.root.precision_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, selfValue_, ex.getResult());
                    }
                    if (precisionValue_ < 0) {
                        return this.root.sqrtNegativePrecision(frameValue, selfValue_, precisionValue_);
                    }
                    return this.getNext().execute_(frameValue, selfValue_, precisionValue_);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, RubyBasicObject selfValue, int precisionValue) {
                    if (precisionValue < 0) {
                        return this.root.sqrtNegativePrecision(frameValue, selfValue, precisionValue);
                    }
                    return this.getNext().execute1(frameValue, selfValue, precisionValue);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object selfValue, Object precisionValue) {
                    if (selfValue instanceof RubyBasicObject && precisionValue instanceof Integer) {
                        RubyBasicObject selfValue_ = (RubyBasicObject)selfValue;
                        int precisionValue_ = (Integer)precisionValue;
                        if (precisionValue_ < 0) {
                            return this.root.sqrtNegativePrecision(frameValue, selfValue_, precisionValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, selfValue, precisionValue);
                }

                static BaseNode_ create(SqrtNodeGen root) {
                    return new SqrtNegativePrecisionNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.SqrtNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SqrtNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object selfValue, Object precisionValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, selfValue, precisionValue));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object selfValue, Object precisionValue) {
                    return this.getNext().execute_(frameValue, selfValue, precisionValue);
                }

                static BaseNode_ create(SqrtNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.SqrtNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SqrtNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object selfValue, Object precisionValue) {
                    return this.uninitialized((Frame)frameValue, selfValue, precisionValue);
                }

                static BaseNode_ create(SqrtNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.SqrtNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final SqrtNodeGen root;

                BaseNode_(SqrtNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.self_, this.root.precision_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object selfValue, Object precisionValue) {
                    return this.execute_((VirtualFrame)frameValue, selfValue, precisionValue);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute1(VirtualFrame frameValue, RubyBasicObject selfValue, int precisionValue) {
                    return this.execute_(frameValue, selfValue, precisionValue);
                }

                public Object execute0(VirtualFrame frameValue) {
                    Object selfValue_ = this.root.self_.execute(frameValue);
                    Object precisionValue_ = this.executePrecision_((Frame)frameValue);
                    return this.execute_(frameValue, selfValue_, precisionValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute0(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object selfValue, Object precisionValue) {
                    if (selfValue instanceof RubyBasicObject && precisionValue instanceof Integer) {
                        RubyBasicObject selfValue_ = (RubyBasicObject)selfValue;
                        int precisionValue_ = (Integer)precisionValue;
                        if (precisionValue_ < 0) {
                            return SqrtNegativePrecisionNode_.create(this.root);
                        }
                        if (precisionValue_ == 0) {
                            return SqrtZeroPrecisionNode_.create(this.root);
                        }
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(selfValue_) && precisionValue_ > 0) {
                            return SqrtNode_.create(this.root);
                        }
                        if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(selfValue_) && precisionValue_ > 0) {
                            return SqrtSpecialNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executePrecision_(Frame frameValue) {
                    Object object;
                    Class precisionType_ = this.root.precisionType_;
                    if (precisionType_ == Integer.TYPE) {
                        return this.root.precision_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (precisionType_ != null) return this.root.precision_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.precision_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.precisionType_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.precisionType_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.precisionType_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=BigDecimalNodes.PowerNode.class)
    public static final class PowerNodeFactory
    extends NodeFactoryBase<BigDecimalNodes.PowerNode> {
        private static PowerNodeFactory powerNodeFactoryInstance;

        private PowerNodeFactory() {
            super(BigDecimalNodes.PowerNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class, RubyNode.class}});
        }

        public BigDecimalNodes.PowerNode createNode(Object ... arguments) {
            if (!(arguments.length != 5 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode))) {
                return PowerNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]), (RubyNode)((Object)arguments[4]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BigDecimalNodes.PowerNode> getInstance() {
            if (powerNodeFactoryInstance == null) {
                powerNodeFactoryInstance = new PowerNodeFactory();
            }
            return powerNodeFactoryInstance;
        }

        public static BigDecimalNodes.PowerNode create(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode exponent, RubyNode precision) {
            return new PowerNodeGen(context, sourceSection, self, exponent, precision);
        }

        @GeneratedBy(value=BigDecimalNodes.PowerNode.class)
        public static final class PowerNodeGen
        extends BigDecimalNodes.PowerNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode self_;
            @Node.Child
            private RubyNode exponent_;
            @Node.Child
            private RubyNode precision_;
            @CompilerDirectives.CompilationFinal
            private Class<?> exponentType_;
            @CompilerDirectives.CompilationFinal
            private Class<?> precisionType_;
            @Node.Child
            private BaseNode_ specialization_;

            private PowerNodeGen(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode exponent, RubyNode precision) {
                super(context, sourceSection);
                this.self_ = self;
                this.exponent_ = exponent;
                this.precision_ = precision;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="power(VirtualFrame, RubyBasicObject, int, Object)", value=BigDecimalNodes.PowerNode.class)
            private static final class Power2Node_
            extends BaseNode_ {
                Power2Node_(PowerNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int exponentValue_;
                    RubyBasicObject selfValue_;
                    try {
                        selfValue_ = this.root.self_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object exponentValue = this.executeExponent_((Frame)frameValue);
                        Object precisionValue = this.executePrecision_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), exponentValue, precisionValue);
                    }
                    try {
                        exponentValue_ = this.root.exponent_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object precisionValue = this.executePrecision_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, selfValue_, ex.getResult(), precisionValue);
                    }
                    Object precisionValue_ = this.executePrecision_((Frame)frameValue);
                    if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(selfValue_)) {
                        return this.root.power(frameValue, selfValue_, exponentValue_, precisionValue_);
                    }
                    return this.getNext().execute_(frameValue, selfValue_, exponentValue_, precisionValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object selfValue, Object exponentValue, Object precisionValue) {
                    if (selfValue instanceof RubyBasicObject && exponentValue instanceof Integer) {
                        RubyBasicObject selfValue_ = (RubyBasicObject)selfValue;
                        int exponentValue_ = (Integer)exponentValue;
                        if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(selfValue_)) {
                            return this.root.power(frameValue, selfValue_, exponentValue_, precisionValue);
                        }
                    }
                    return this.getNext().execute_(frameValue, selfValue, exponentValue, precisionValue);
                }

                static BaseNode_ create(PowerNodeGen root) {
                    return new Power2Node_(root);
                }
            }

            @GeneratedBy(methodName="power(VirtualFrame, RubyBasicObject, int, int)", value=BigDecimalNodes.PowerNode.class)
            private static final class Power1Node_
            extends BaseNode_ {
                Power1Node_(PowerNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int precisionValue_;
                    int exponentValue_;
                    RubyBasicObject selfValue_;
                    try {
                        selfValue_ = this.root.self_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object exponentValue = this.executeExponent_((Frame)frameValue);
                        Object precisionValue = this.executePrecision_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), exponentValue, precisionValue);
                    }
                    try {
                        exponentValue_ = this.root.exponent_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object precisionValue = this.executePrecision_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, selfValue_, ex.getResult(), precisionValue);
                    }
                    try {
                        precisionValue_ = this.root.precision_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, selfValue_, exponentValue_, ex.getResult());
                    }
                    if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(selfValue_)) {
                        return this.root.power(frameValue, selfValue_, exponentValue_, precisionValue_);
                    }
                    return this.getNext().execute_(frameValue, selfValue_, exponentValue_, precisionValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object selfValue, Object exponentValue, Object precisionValue) {
                    if (selfValue instanceof RubyBasicObject && exponentValue instanceof Integer && precisionValue instanceof Integer) {
                        RubyBasicObject selfValue_ = (RubyBasicObject)selfValue;
                        int exponentValue_ = (Integer)exponentValue;
                        int precisionValue_ = (Integer)precisionValue;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(selfValue_)) {
                            return this.root.power(frameValue, selfValue_, exponentValue_, precisionValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, selfValue, exponentValue, precisionValue);
                }

                static BaseNode_ create(PowerNodeGen root) {
                    return new Power1Node_(root);
                }
            }

            @GeneratedBy(methodName="power(VirtualFrame, RubyBasicObject, int, NotProvided)", value=BigDecimalNodes.PowerNode.class)
            private static final class Power0Node_
            extends BaseNode_ {
                Power0Node_(PowerNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    NotProvided precisionValue_;
                    int exponentValue_;
                    RubyBasicObject selfValue_;
                    try {
                        selfValue_ = this.root.self_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object exponentValue = this.executeExponent_((Frame)frameValue);
                        Object precisionValue = this.executePrecision_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), exponentValue, precisionValue);
                    }
                    try {
                        exponentValue_ = this.root.exponent_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object precisionValue = this.executePrecision_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, selfValue_, ex.getResult(), precisionValue);
                    }
                    try {
                        precisionValue_ = this.root.precision_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, selfValue_, exponentValue_, ex.getResult());
                    }
                    if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(selfValue_)) {
                        return this.root.power(frameValue, selfValue_, exponentValue_, precisionValue_);
                    }
                    return this.getNext().execute_(frameValue, selfValue_, exponentValue_, precisionValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object selfValue, Object exponentValue, Object precisionValue) {
                    if (selfValue instanceof RubyBasicObject && exponentValue instanceof Integer && precisionValue instanceof NotProvided) {
                        RubyBasicObject selfValue_ = (RubyBasicObject)selfValue;
                        int exponentValue_ = (Integer)exponentValue;
                        NotProvided precisionValue_ = (NotProvided)precisionValue;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(selfValue_)) {
                            return this.root.power(frameValue, selfValue_, exponentValue_, precisionValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, selfValue, exponentValue, precisionValue);
                }

                static BaseNode_ create(PowerNodeGen root) {
                    return new Power0Node_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.PowerNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(PowerNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object selfValue, Object exponentValue, Object precisionValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, selfValue, exponentValue, precisionValue));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object selfValue, Object exponentValue, Object precisionValue) {
                    return this.getNext().execute_(frameValue, selfValue, exponentValue, precisionValue);
                }

                static BaseNode_ create(PowerNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.PowerNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(PowerNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object selfValue, Object exponentValue, Object precisionValue) {
                    return this.uninitialized((Frame)frameValue, selfValue, exponentValue, precisionValue);
                }

                static BaseNode_ create(PowerNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.PowerNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final PowerNodeGen root;

                BaseNode_(PowerNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.self_, this.root.exponent_, this.root.precision_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object selfValue, Object exponentValue, Object precisionValue) {
                    return this.execute_((VirtualFrame)frameValue, selfValue, exponentValue, precisionValue);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object selfValue_ = this.root.self_.execute(frameValue);
                    Object exponentValue_ = this.executeExponent_((Frame)frameValue);
                    Object precisionValue_ = this.executePrecision_((Frame)frameValue);
                    return this.execute_(frameValue, selfValue_, exponentValue_, precisionValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object selfValue, Object exponentValue, Object precisionValue) {
                    if (selfValue instanceof RubyBasicObject && exponentValue instanceof Integer) {
                        RubyBasicObject selfValue_ = (RubyBasicObject)selfValue;
                        if (precisionValue instanceof NotProvided && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(selfValue_)) {
                            return Power0Node_.create(this.root);
                        }
                        if (precisionValue instanceof Integer && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(selfValue_)) {
                            return Power1Node_.create(this.root);
                        }
                        if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(selfValue_)) {
                            return Power2Node_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeExponent_(Frame frameValue) {
                    Object object;
                    Class exponentType_ = this.root.exponentType_;
                    if (exponentType_ == Integer.TYPE) {
                        return this.root.exponent_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (exponentType_ != null) return this.root.exponent_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.exponent_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.exponentType_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.exponentType_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.exponentType_ = _type;
                    return object;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executePrecision_(Frame frameValue) {
                    Object object;
                    Class precisionType_ = this.root.precisionType_;
                    if (precisionType_ == Integer.TYPE) {
                        return this.root.precision_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (precisionType_ != null) return this.root.precision_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.precision_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.precisionType_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.precisionType_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.precisionType_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=BigDecimalNodes.ModuloNode.class)
    public static final class ModuloNodeFactory
    extends NodeFactoryBase<BigDecimalNodes.ModuloNode> {
        private static ModuloNodeFactory moduloNodeFactoryInstance;

        private ModuloNodeFactory() {
            super(BigDecimalNodes.ModuloNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public BigDecimalNodes.ModuloNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return ModuloNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BigDecimalNodes.ModuloNode> getInstance() {
            if (moduloNodeFactoryInstance == null) {
                moduloNodeFactoryInstance = new ModuloNodeFactory();
            }
            return moduloNodeFactoryInstance;
        }

        public static BigDecimalNodes.ModuloNode create(RubyContext context, SourceSection sourceSection, RubyNode a, RubyNode b) {
            return new ModuloNodeGen(context, sourceSection, a, b);
        }

        @GeneratedBy(value=BigDecimalNodes.ModuloNode.class)
        public static final class ModuloNodeGen
        extends BigDecimalNodes.ModuloNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode a_;
            @Node.Child
            private RubyNode b_;
            @Node.Child
            private BaseNode_ specialization_;

            private ModuloNodeGen(RubyContext context, SourceSection sourceSection, RubyNode a, RubyNode b) {
                super(context, sourceSection);
                this.a_ = a;
                this.b_ = this.castB(b);
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="moduloSpecial(VirtualFrame, RubyBasicObject, RubyBasicObject)", value=BigDecimalNodes.ModuloNode.class)
            private static final class ModuloSpecialNode_
            extends BaseNode_ {
                ModuloSpecialNode_(ModuloNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        if (!(!RubyGuards.isRubyBigDecimal(bValue_) || BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(bValue_))) {
                            return this.root.moduloSpecial(frameValue, aValue_, bValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(ModuloNodeGen root) {
                    return new ModuloSpecialNode_(root);
                }
            }

            @GeneratedBy(methodName="moduloZero(VirtualFrame, RubyBasicObject, RubyBasicObject)", value=BigDecimalNodes.ModuloNode.class)
            private static final class ModuloZeroNode_
            extends BaseNode_ {
                ModuloZeroNode_(ModuloNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalZero(bValue_)) {
                            return this.root.moduloZero(frameValue, aValue_, bValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(ModuloNodeGen root) {
                    return new ModuloZeroNode_(root);
                }
            }

            @GeneratedBy(methodName="modulo(VirtualFrame, RubyBasicObject, RubyBasicObject)", value=BigDecimalNodes.ModuloNode.class)
            private static final class ModuloNode_
            extends BaseNode_ {
                ModuloNode_(ModuloNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_) && !BigDecimalNodes.BigDecimalCoreMethodNode.isNormalZero(bValue_)) {
                            return this.root.modulo(frameValue, aValue_, bValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(ModuloNodeGen root) {
                    return new ModuloNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.ModuloNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ModuloNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object aValue, Object bValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, aValue, bValue));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    return this.getNext().execute_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(ModuloNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.ModuloNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ModuloNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    return this.uninitialized((Frame)frameValue, aValue, bValue);
                }

                static BaseNode_ create(ModuloNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.ModuloNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final ModuloNodeGen root;

                BaseNode_(ModuloNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.a_, this.root.b_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object aValue, Object bValue) {
                    return this.execute_((VirtualFrame)frameValue, aValue, bValue);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object aValue_ = this.root.a_.execute(frameValue);
                    Object bValue_ = this.root.b_.execute(frameValue);
                    return this.execute_(frameValue, aValue_, bValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_) && !BigDecimalNodes.BigDecimalCoreMethodNode.isNormalZero(bValue_)) {
                            return ModuloNode_.create(this.root);
                        }
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalZero(bValue_)) {
                            return ModuloZeroNode_.create(this.root);
                        }
                        if (!(!RubyGuards.isRubyBigDecimal(bValue_) || BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(bValue_))) {
                            return ModuloSpecialNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=BigDecimalNodes.RemainderNode.class)
    public static final class RemainderNodeFactory
    extends NodeFactoryBase<BigDecimalNodes.RemainderNode> {
        private static RemainderNodeFactory remainderNodeFactoryInstance;

        private RemainderNodeFactory() {
            super(BigDecimalNodes.RemainderNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public BigDecimalNodes.RemainderNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return RemainderNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BigDecimalNodes.RemainderNode> getInstance() {
            if (remainderNodeFactoryInstance == null) {
                remainderNodeFactoryInstance = new RemainderNodeFactory();
            }
            return remainderNodeFactoryInstance;
        }

        public static BigDecimalNodes.RemainderNode create(RubyContext context, SourceSection sourceSection, RubyNode a, RubyNode b) {
            return new RemainderNodeGen(context, sourceSection, a, b);
        }

        @GeneratedBy(value=BigDecimalNodes.RemainderNode.class)
        public static final class RemainderNodeGen
        extends BigDecimalNodes.RemainderNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode a_;
            @Node.Child
            private RubyNode b_;
            @Node.Child
            private BaseNode_ specialization_;

            private RemainderNodeGen(RubyContext context, SourceSection sourceSection, RubyNode a, RubyNode b) {
                super(context, sourceSection);
                this.a_ = a;
                this.b_ = this.castB(b);
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="remainderSpecial(VirtualFrame, RubyBasicObject, RubyBasicObject)", value=BigDecimalNodes.RemainderNode.class)
            private static final class RemainderSpecialNode_
            extends BaseNode_ {
                RemainderSpecialNode_(RemainderNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        if (!(!RubyGuards.isRubyBigDecimal(bValue_) || BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(bValue_))) {
                            return this.root.remainderSpecial(frameValue, aValue_, bValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(RemainderNodeGen root) {
                    return new RemainderSpecialNode_(root);
                }
            }

            @GeneratedBy(methodName="remainderZero(VirtualFrame, RubyBasicObject, RubyBasicObject)", value=BigDecimalNodes.RemainderNode.class)
            private static final class RemainderZeroNode_
            extends BaseNode_ {
                RemainderZeroNode_(RemainderNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalZero(bValue_)) {
                            return this.root.remainderZero(frameValue, aValue_, bValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(RemainderNodeGen root) {
                    return new RemainderZeroNode_(root);
                }
            }

            @GeneratedBy(methodName="remainder(VirtualFrame, RubyBasicObject, RubyBasicObject)", value=BigDecimalNodes.RemainderNode.class)
            private static final class RemainderNode_
            extends BaseNode_ {
                RemainderNode_(RemainderNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_) && !BigDecimalNodes.BigDecimalCoreMethodNode.isNormalZero(bValue_)) {
                            return this.root.remainder(frameValue, aValue_, bValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(RemainderNodeGen root) {
                    return new RemainderNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.RemainderNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(RemainderNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object aValue, Object bValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, aValue, bValue));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    return this.getNext().execute_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(RemainderNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.RemainderNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(RemainderNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    return this.uninitialized((Frame)frameValue, aValue, bValue);
                }

                static BaseNode_ create(RemainderNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.RemainderNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final RemainderNodeGen root;

                BaseNode_(RemainderNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.a_, this.root.b_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object aValue, Object bValue) {
                    return this.execute_((VirtualFrame)frameValue, aValue, bValue);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object aValue_ = this.root.a_.execute(frameValue);
                    Object bValue_ = this.root.b_.execute(frameValue);
                    return this.execute_(frameValue, aValue_, bValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_) && !BigDecimalNodes.BigDecimalCoreMethodNode.isNormalZero(bValue_)) {
                            return RemainderNode_.create(this.root);
                        }
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalZero(bValue_)) {
                            return RemainderZeroNode_.create(this.root);
                        }
                        if (!(!RubyGuards.isRubyBigDecimal(bValue_) || BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(bValue_))) {
                            return RemainderSpecialNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=BigDecimalNodes.DivModNode.class)
    public static final class DivModNodeFactory
    extends NodeFactoryBase<BigDecimalNodes.DivModNode> {
        private static DivModNodeFactory divModNodeFactoryInstance;

        private DivModNodeFactory() {
            super(BigDecimalNodes.DivModNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public BigDecimalNodes.DivModNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return DivModNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BigDecimalNodes.DivModNode> getInstance() {
            if (divModNodeFactoryInstance == null) {
                divModNodeFactoryInstance = new DivModNodeFactory();
            }
            return divModNodeFactoryInstance;
        }

        public static BigDecimalNodes.DivModNode create(RubyContext context, SourceSection sourceSection, RubyNode a, RubyNode b) {
            return new DivModNodeGen(context, sourceSection, a, b);
        }

        @GeneratedBy(value=BigDecimalNodes.DivModNode.class)
        public static final class DivModNodeGen
        extends BigDecimalNodes.DivModNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode a_;
            @Node.Child
            private RubyNode b_;
            @Node.Child
            private BaseNode_ specialization_;

            private DivModNodeGen(RubyContext context, SourceSection sourceSection, RubyNode a, RubyNode b) {
                super(context, sourceSection);
                this.a_ = a;
                this.b_ = this.castB(b);
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="divmodSpecial(VirtualFrame, RubyBasicObject, RubyBasicObject)", value=BigDecimalNodes.DivModNode.class)
            private static final class DivmodSpecialNode_
            extends BaseNode_ {
                DivmodSpecialNode_(DivModNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        if (!(!RubyGuards.isRubyBigDecimal(bValue_) || BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(bValue_))) {
                            return this.root.divmodSpecial(frameValue, aValue_, bValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(DivModNodeGen root) {
                    return new DivmodSpecialNode_(root);
                }
            }

            @GeneratedBy(methodName="divmodZeroDivisor(VirtualFrame, RubyBasicObject, RubyBasicObject)", value=BigDecimalNodes.DivModNode.class)
            private static final class DivmodZeroDivisorNode_
            extends BaseNode_ {
                DivmodZeroDivisorNode_(DivModNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalZero(bValue_)) {
                            return this.root.divmodZeroDivisor(frameValue, aValue_, bValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(DivModNodeGen root) {
                    return new DivmodZeroDivisorNode_(root);
                }
            }

            @GeneratedBy(methodName="divmodZeroDividend(VirtualFrame, RubyBasicObject, RubyBasicObject)", value=BigDecimalNodes.DivModNode.class)
            private static final class DivmodZeroDividendNode_
            extends BaseNode_ {
                DivmodZeroDividendNode_(DivModNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalZero(aValue_) && !BigDecimalNodes.BigDecimalCoreMethodNode.isNormalZero(bValue_)) {
                            return this.root.divmodZeroDividend(frameValue, aValue_, bValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(DivModNodeGen root) {
                    return new DivmodZeroDividendNode_(root);
                }
            }

            @GeneratedBy(methodName="divmod(VirtualFrame, RubyBasicObject, RubyBasicObject)", value=BigDecimalNodes.DivModNode.class)
            private static final class DivmodNode_
            extends BaseNode_ {
                DivmodNode_(DivModNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_) && !BigDecimalNodes.BigDecimalCoreMethodNode.isNormalZero(aValue_) && !BigDecimalNodes.BigDecimalCoreMethodNode.isNormalZero(bValue_)) {
                            return this.root.divmod(frameValue, aValue_, bValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(DivModNodeGen root) {
                    return new DivmodNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.DivModNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(DivModNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object aValue, Object bValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, aValue, bValue));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    return this.getNext().execute_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(DivModNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.DivModNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(DivModNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    return this.uninitialized((Frame)frameValue, aValue, bValue);
                }

                static BaseNode_ create(DivModNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.DivModNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final DivModNodeGen root;

                BaseNode_(DivModNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.a_, this.root.b_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object aValue, Object bValue) {
                    return this.execute_((VirtualFrame)frameValue, aValue, bValue);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object aValue_ = this.root.a_.execute(frameValue);
                    Object bValue_ = this.root.b_.execute(frameValue);
                    return this.execute_(frameValue, aValue_, bValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_) && !BigDecimalNodes.BigDecimalCoreMethodNode.isNormalZero(aValue_) && !BigDecimalNodes.BigDecimalCoreMethodNode.isNormalZero(bValue_)) {
                            return DivmodNode_.create(this.root);
                        }
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalZero(aValue_) && !BigDecimalNodes.BigDecimalCoreMethodNode.isNormalZero(bValue_)) {
                            return DivmodZeroDividendNode_.create(this.root);
                        }
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalZero(bValue_)) {
                            return DivmodZeroDivisorNode_.create(this.root);
                        }
                        if (!(!RubyGuards.isRubyBigDecimal(bValue_) || BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(bValue_))) {
                            return DivmodSpecialNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=BigDecimalNodes.DivNode.class)
    public static final class DivNodeFactory
    extends NodeFactoryBase<BigDecimalNodes.DivNode> {
        private static DivNodeFactory divNodeFactoryInstance;

        private DivNodeFactory() {
            super(BigDecimalNodes.DivNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class, RubyNode.class}});
        }

        public BigDecimalNodes.DivNode createNode(Object ... arguments) {
            if (!(arguments.length != 5 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode))) {
                return DivNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]), (RubyNode)((Object)arguments[4]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BigDecimalNodes.DivNode> getInstance() {
            if (divNodeFactoryInstance == null) {
                divNodeFactoryInstance = new DivNodeFactory();
            }
            return divNodeFactoryInstance;
        }

        public static BigDecimalNodes.DivNode create(RubyContext context, SourceSection sourceSection, RubyNode a, RubyNode b, RubyNode precision) {
            return new DivNodeGen(context, sourceSection, a, b, precision);
        }

        @GeneratedBy(value=BigDecimalNodes.DivNode.class)
        public static final class DivNodeGen
        extends BigDecimalNodes.DivNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode a_;
            @Node.Child
            private RubyNode b_;
            @Node.Child
            private RubyNode precision_;
            @CompilerDirectives.CompilationFinal
            private Class<?> precisionType_;
            @Node.Child
            private BaseNode_ specialization_;

            private DivNodeGen(RubyContext context, SourceSection sourceSection, RubyNode a, RubyNode b, RubyNode precision) {
                super(context, sourceSection);
                this.a_ = a;
                this.b_ = this.castB(b);
                this.precision_ = precision;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="divSpecialSpecial(VirtualFrame, RubyBasicObject, RubyBasicObject, int)", value=BigDecimalNodes.DivNode.class)
            private static final class DivSpecialSpecial1Node_
            extends BaseNode_ {
                DivSpecialSpecial1Node_(DivNodeGen root) {
                    super(root, 8);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int precisionValue_;
                    RubyBasicObject bValue_;
                    RubyBasicObject aValue_;
                    try {
                        aValue_ = this.root.a_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object bValue = this.root.b_.execute(frameValue);
                        Object precisionValue = this.executePrecision_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), bValue, precisionValue);
                    }
                    try {
                        bValue_ = this.root.b_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object precisionValue = this.executePrecision_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, aValue_, ex.getResult(), precisionValue);
                    }
                    try {
                        precisionValue_ = this.root.precision_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, aValue_, bValue_, ex.getResult());
                    }
                    if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isSpecialRubyBigDecimal(bValue_)) {
                        return this.root.divSpecialSpecial(frameValue, aValue_, bValue_, precisionValue_);
                    }
                    return this.getNext().execute_(frameValue, aValue_, bValue_, precisionValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue, Object precisionValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject && precisionValue instanceof Integer) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        int precisionValue_ = (Integer)precisionValue;
                        if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isSpecialRubyBigDecimal(bValue_)) {
                            return this.root.divSpecialSpecial(frameValue, aValue_, bValue_, precisionValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, aValue, bValue, precisionValue);
                }

                static BaseNode_ create(DivNodeGen root) {
                    return new DivSpecialSpecial1Node_(root);
                }
            }

            @GeneratedBy(methodName="divSpecialSpecial(VirtualFrame, RubyBasicObject, RubyBasicObject, NotProvided)", value=BigDecimalNodes.DivNode.class)
            private static final class DivSpecialSpecial0Node_
            extends BaseNode_ {
                DivSpecialSpecial0Node_(DivNodeGen root) {
                    super(root, 7);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue, Object precisionValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject && precisionValue instanceof NotProvided) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        NotProvided precisionValue_ = (NotProvided)precisionValue;
                        if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isSpecialRubyBigDecimal(bValue_)) {
                            return this.root.divSpecialSpecial(frameValue, aValue_, bValue_, precisionValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, aValue, bValue, precisionValue);
                }

                static BaseNode_ create(DivNodeGen root) {
                    return new DivSpecialSpecial0Node_(root);
                }
            }

            @GeneratedBy(methodName="divSpecialNormal(VirtualFrame, RubyBasicObject, RubyBasicObject, int)", value=BigDecimalNodes.DivNode.class)
            private static final class DivSpecialNormal1Node_
            extends BaseNode_ {
                DivSpecialNormal1Node_(DivNodeGen root) {
                    super(root, 6);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int precisionValue_;
                    RubyBasicObject bValue_;
                    RubyBasicObject aValue_;
                    try {
                        aValue_ = this.root.a_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object bValue = this.root.b_.execute(frameValue);
                        Object precisionValue = this.executePrecision_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), bValue, precisionValue);
                    }
                    try {
                        bValue_ = this.root.b_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object precisionValue = this.executePrecision_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, aValue_, ex.getResult(), precisionValue);
                    }
                    try {
                        precisionValue_ = this.root.precision_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, aValue_, bValue_, ex.getResult());
                    }
                    if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_)) {
                        return this.root.divSpecialNormal(frameValue, aValue_, bValue_, precisionValue_);
                    }
                    return this.getNext().execute_(frameValue, aValue_, bValue_, precisionValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue, Object precisionValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject && precisionValue instanceof Integer) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        int precisionValue_ = (Integer)precisionValue;
                        if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_)) {
                            return this.root.divSpecialNormal(frameValue, aValue_, bValue_, precisionValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, aValue, bValue, precisionValue);
                }

                static BaseNode_ create(DivNodeGen root) {
                    return new DivSpecialNormal1Node_(root);
                }
            }

            @GeneratedBy(methodName="divSpecialNormal(VirtualFrame, RubyBasicObject, RubyBasicObject, NotProvided)", value=BigDecimalNodes.DivNode.class)
            private static final class DivSpecialNormal0Node_
            extends BaseNode_ {
                DivSpecialNormal0Node_(DivNodeGen root) {
                    super(root, 5);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue, Object precisionValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject && precisionValue instanceof NotProvided) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        NotProvided precisionValue_ = (NotProvided)precisionValue;
                        if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_)) {
                            return this.root.divSpecialNormal(frameValue, aValue_, bValue_, precisionValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, aValue, bValue, precisionValue);
                }

                static BaseNode_ create(DivNodeGen root) {
                    return new DivSpecialNormal0Node_(root);
                }
            }

            @GeneratedBy(methodName="divNormalSpecial(VirtualFrame, RubyBasicObject, RubyBasicObject, int)", value=BigDecimalNodes.DivNode.class)
            private static final class DivNormalSpecial1Node_
            extends BaseNode_ {
                DivNormalSpecial1Node_(DivNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int precisionValue_;
                    RubyBasicObject bValue_;
                    RubyBasicObject aValue_;
                    try {
                        aValue_ = this.root.a_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object bValue = this.root.b_.execute(frameValue);
                        Object precisionValue = this.executePrecision_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), bValue, precisionValue);
                    }
                    try {
                        bValue_ = this.root.b_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object precisionValue = this.executePrecision_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, aValue_, ex.getResult(), precisionValue);
                    }
                    try {
                        precisionValue_ = this.root.precision_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, aValue_, bValue_, ex.getResult());
                    }
                    if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isSpecialRubyBigDecimal(bValue_)) {
                        return this.root.divNormalSpecial(frameValue, aValue_, bValue_, precisionValue_);
                    }
                    return this.getNext().execute_(frameValue, aValue_, bValue_, precisionValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue, Object precisionValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject && precisionValue instanceof Integer) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        int precisionValue_ = (Integer)precisionValue;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isSpecialRubyBigDecimal(bValue_)) {
                            return this.root.divNormalSpecial(frameValue, aValue_, bValue_, precisionValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, aValue, bValue, precisionValue);
                }

                static BaseNode_ create(DivNodeGen root) {
                    return new DivNormalSpecial1Node_(root);
                }
            }

            @GeneratedBy(methodName="divNormalSpecial(VirtualFrame, RubyBasicObject, RubyBasicObject, NotProvided)", value=BigDecimalNodes.DivNode.class)
            private static final class DivNormalSpecial0Node_
            extends BaseNode_ {
                DivNormalSpecial0Node_(DivNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue, Object precisionValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject && precisionValue instanceof NotProvided) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        NotProvided precisionValue_ = (NotProvided)precisionValue;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isSpecialRubyBigDecimal(bValue_)) {
                            return this.root.divNormalSpecial(frameValue, aValue_, bValue_, precisionValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, aValue, bValue, precisionValue);
                }

                static BaseNode_ create(DivNodeGen root) {
                    return new DivNormalSpecial0Node_(root);
                }
            }

            @GeneratedBy(methodName="div(VirtualFrame, RubyBasicObject, RubyBasicObject, int)", value=BigDecimalNodes.DivNode.class)
            private static final class Div1Node_
            extends BaseNode_ {
                Div1Node_(DivNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int precisionValue_;
                    RubyBasicObject bValue_;
                    RubyBasicObject aValue_;
                    try {
                        aValue_ = this.root.a_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object bValue = this.root.b_.execute(frameValue);
                        Object precisionValue = this.executePrecision_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), bValue, precisionValue);
                    }
                    try {
                        bValue_ = this.root.b_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object precisionValue = this.executePrecision_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, aValue_, ex.getResult(), precisionValue);
                    }
                    try {
                        precisionValue_ = this.root.precision_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, aValue_, bValue_, ex.getResult());
                    }
                    if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_)) {
                        return this.root.div(frameValue, aValue_, bValue_, precisionValue_);
                    }
                    return this.getNext().execute_(frameValue, aValue_, bValue_, precisionValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue, Object precisionValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject && precisionValue instanceof Integer) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        int precisionValue_ = (Integer)precisionValue;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_)) {
                            return this.root.div(frameValue, aValue_, bValue_, precisionValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, aValue, bValue, precisionValue);
                }

                static BaseNode_ create(DivNodeGen root) {
                    return new Div1Node_(root);
                }
            }

            @GeneratedBy(methodName="div(VirtualFrame, RubyBasicObject, RubyBasicObject, NotProvided)", value=BigDecimalNodes.DivNode.class)
            private static final class Div0Node_
            extends BaseNode_ {
                Div0Node_(DivNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue, Object precisionValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject && precisionValue instanceof NotProvided) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        NotProvided precisionValue_ = (NotProvided)precisionValue;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_)) {
                            return this.root.div(frameValue, aValue_, bValue_, precisionValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, aValue, bValue, precisionValue);
                }

                static BaseNode_ create(DivNodeGen root) {
                    return new Div0Node_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.DivNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(DivNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object aValue, Object bValue, Object precisionValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, aValue, bValue, precisionValue));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue, Object precisionValue) {
                    return this.getNext().execute_(frameValue, aValue, bValue, precisionValue);
                }

                static BaseNode_ create(DivNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.DivNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(DivNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue, Object precisionValue) {
                    return this.uninitialized((Frame)frameValue, aValue, bValue, precisionValue);
                }

                static BaseNode_ create(DivNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.DivNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final DivNodeGen root;

                BaseNode_(DivNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.a_, this.root.b_, this.root.precision_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object aValue, Object bValue, Object precisionValue) {
                    return this.execute_((VirtualFrame)frameValue, aValue, bValue, precisionValue);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object aValue_ = this.root.a_.execute(frameValue);
                    Object bValue_ = this.root.b_.execute(frameValue);
                    Object precisionValue_ = this.executePrecision_((Frame)frameValue);
                    return this.execute_(frameValue, aValue_, bValue_, precisionValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object aValue, Object bValue, Object precisionValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        if (precisionValue instanceof NotProvided && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_)) {
                            return Div0Node_.create(this.root);
                        }
                        if (precisionValue instanceof Integer && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_)) {
                            return Div1Node_.create(this.root);
                        }
                        if (precisionValue instanceof NotProvided && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isSpecialRubyBigDecimal(bValue_)) {
                            return DivNormalSpecial0Node_.create(this.root);
                        }
                        if (precisionValue instanceof Integer && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isSpecialRubyBigDecimal(bValue_)) {
                            return DivNormalSpecial1Node_.create(this.root);
                        }
                        if (precisionValue instanceof NotProvided && !BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_)) {
                            return DivSpecialNormal0Node_.create(this.root);
                        }
                        if (precisionValue instanceof Integer && !BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_)) {
                            return DivSpecialNormal1Node_.create(this.root);
                        }
                        if (precisionValue instanceof NotProvided && !BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isSpecialRubyBigDecimal(bValue_)) {
                            return DivSpecialSpecial0Node_.create(this.root);
                        }
                        if (precisionValue instanceof Integer && !BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isSpecialRubyBigDecimal(bValue_)) {
                            return DivSpecialSpecial1Node_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executePrecision_(Frame frameValue) {
                    Object object;
                    Class precisionType_ = this.root.precisionType_;
                    if (precisionType_ == Integer.TYPE) {
                        return this.root.precision_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (precisionType_ != null) return this.root.precision_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.precision_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.precisionType_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.precisionType_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.precisionType_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=BigDecimalNodes.DivOpNode.class)
    public static final class DivOpNodeFactory
    extends NodeFactoryBase<BigDecimalNodes.DivOpNode> {
        private static DivOpNodeFactory divOpNodeFactoryInstance;

        private DivOpNodeFactory() {
            super(BigDecimalNodes.DivOpNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public BigDecimalNodes.DivOpNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return DivOpNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BigDecimalNodes.DivOpNode> getInstance() {
            if (divOpNodeFactoryInstance == null) {
                divOpNodeFactoryInstance = new DivOpNodeFactory();
            }
            return divOpNodeFactoryInstance;
        }

        public static BigDecimalNodes.DivOpNode create(RubyContext context, SourceSection sourceSection, RubyNode a, RubyNode b) {
            return new DivOpNodeGen(context, sourceSection, a, b);
        }

        @GeneratedBy(value=BigDecimalNodes.DivOpNode.class)
        public static final class DivOpNodeGen
        extends BigDecimalNodes.DivOpNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode a_;
            @Node.Child
            private RubyNode b_;
            @Node.Child
            private BaseNode_ specialization_;

            private DivOpNodeGen(RubyContext context, SourceSection sourceSection, RubyNode a, RubyNode b) {
                super(context, sourceSection);
                this.a_ = a;
                this.b_ = this.castB(b);
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="divSpecialSpecial(VirtualFrame, RubyBasicObject, RubyBasicObject)", value=BigDecimalNodes.DivOpNode.class)
            private static final class DivSpecialSpecialNode_
            extends BaseNode_ {
                DivSpecialSpecialNode_(DivOpNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isSpecialRubyBigDecimal(bValue_)) {
                            return this.root.divSpecialSpecial(frameValue, aValue_, bValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(DivOpNodeGen root) {
                    return new DivSpecialSpecialNode_(root);
                }
            }

            @GeneratedBy(methodName="divSpecialNormal(VirtualFrame, RubyBasicObject, RubyBasicObject)", value=BigDecimalNodes.DivOpNode.class)
            private static final class DivSpecialNormalNode_
            extends BaseNode_ {
                DivSpecialNormalNode_(DivOpNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_)) {
                            return this.root.divSpecialNormal(frameValue, aValue_, bValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(DivOpNodeGen root) {
                    return new DivSpecialNormalNode_(root);
                }
            }

            @GeneratedBy(methodName="divNormalSpecial(VirtualFrame, RubyBasicObject, RubyBasicObject)", value=BigDecimalNodes.DivOpNode.class)
            private static final class DivNormalSpecialNode_
            extends BaseNode_ {
                DivNormalSpecialNode_(DivOpNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isSpecialRubyBigDecimal(bValue_)) {
                            return this.root.divNormalSpecial(frameValue, aValue_, bValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(DivOpNodeGen root) {
                    return new DivNormalSpecialNode_(root);
                }
            }

            @GeneratedBy(methodName="div(VirtualFrame, RubyBasicObject, RubyBasicObject)", value=BigDecimalNodes.DivOpNode.class)
            private static final class DivNode_
            extends BaseNode_ {
                DivNode_(DivOpNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_)) {
                            return this.root.div(frameValue, aValue_, bValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(DivOpNodeGen root) {
                    return new DivNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.DivOpNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(DivOpNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object aValue, Object bValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, aValue, bValue));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    return this.getNext().execute_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(DivOpNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.DivOpNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(DivOpNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    return this.uninitialized((Frame)frameValue, aValue, bValue);
                }

                static BaseNode_ create(DivOpNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.DivOpNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final DivOpNodeGen root;

                BaseNode_(DivOpNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.a_, this.root.b_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object aValue, Object bValue) {
                    return this.execute_((VirtualFrame)frameValue, aValue, bValue);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object aValue_ = this.root.a_.execute(frameValue);
                    Object bValue_ = this.root.b_.execute(frameValue);
                    return this.execute_(frameValue, aValue_, bValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_)) {
                            return DivNode_.create(this.root);
                        }
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isSpecialRubyBigDecimal(bValue_)) {
                            return DivNormalSpecialNode_.create(this.root);
                        }
                        if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_)) {
                            return DivSpecialNormalNode_.create(this.root);
                        }
                        if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isSpecialRubyBigDecimal(bValue_)) {
                            return DivSpecialSpecialNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=BigDecimalNodes.MultNode.class)
    public static final class MultNodeFactory
    extends NodeFactoryBase<BigDecimalNodes.MultNode> {
        private static MultNodeFactory multNodeFactoryInstance;

        private MultNodeFactory() {
            super(BigDecimalNodes.MultNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class, RubyNode.class}});
        }

        public BigDecimalNodes.MultNode createNode(Object ... arguments) {
            if (!(arguments.length != 5 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode))) {
                return MultNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]), (RubyNode)((Object)arguments[4]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BigDecimalNodes.MultNode> getInstance() {
            if (multNodeFactoryInstance == null) {
                multNodeFactoryInstance = new MultNodeFactory();
            }
            return multNodeFactoryInstance;
        }

        public static BigDecimalNodes.MultNode create(RubyContext context, SourceSection sourceSection, RubyNode a, RubyNode b, RubyNode precision) {
            return new MultNodeGen(context, sourceSection, a, b, precision);
        }

        @GeneratedBy(value=BigDecimalNodes.MultNode.class)
        public static final class MultNodeGen
        extends BigDecimalNodes.MultNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode a_;
            @Node.Child
            private RubyNode b_;
            @Node.Child
            private RubyNode precision_;
            @CompilerDirectives.CompilationFinal
            private Class<?> precisionType_;
            @Node.Child
            private BaseNode_ specialization_;

            private MultNodeGen(RubyContext context, SourceSection sourceSection, RubyNode a, RubyNode b, RubyNode precision) {
                super(context, sourceSection);
                this.a_ = a;
                this.b_ = this.castB(b);
                this.precision_ = precision;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="multSpecial(VirtualFrame, RubyBasicObject, RubyBasicObject, int)", value=BigDecimalNodes.MultNode.class)
            private static final class MultSpecialNode_
            extends BaseNode_ {
                MultSpecialNode_(MultNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int precisionValue_;
                    RubyBasicObject bValue_;
                    RubyBasicObject aValue_;
                    try {
                        aValue_ = this.root.a_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object bValue = this.root.b_.execute(frameValue);
                        Object precisionValue = this.executePrecision_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), bValue, precisionValue);
                    }
                    try {
                        bValue_ = this.root.b_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object precisionValue = this.executePrecision_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, aValue_, ex.getResult(), precisionValue);
                    }
                    try {
                        precisionValue_ = this.root.precision_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, aValue_, bValue_, ex.getResult());
                    }
                    if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isSpecialRubyBigDecimal(bValue_)) {
                        return this.root.multSpecial(frameValue, aValue_, bValue_, precisionValue_);
                    }
                    return this.getNext().execute_(frameValue, aValue_, bValue_, precisionValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue, Object precisionValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject && precisionValue instanceof Integer) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        int precisionValue_ = (Integer)precisionValue;
                        if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isSpecialRubyBigDecimal(bValue_)) {
                            return this.root.multSpecial(frameValue, aValue_, bValue_, precisionValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, aValue, bValue, precisionValue);
                }

                static BaseNode_ create(MultNodeGen root) {
                    return new MultSpecialNode_(root);
                }
            }

            @GeneratedBy(methodName="multSpecialNormal(VirtualFrame, RubyBasicObject, RubyBasicObject, int)", value=BigDecimalNodes.MultNode.class)
            private static final class MultSpecialNormalNode_
            extends BaseNode_ {
                MultSpecialNormalNode_(MultNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int precisionValue_;
                    RubyBasicObject bValue_;
                    RubyBasicObject aValue_;
                    try {
                        aValue_ = this.root.a_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object bValue = this.root.b_.execute(frameValue);
                        Object precisionValue = this.executePrecision_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), bValue, precisionValue);
                    }
                    try {
                        bValue_ = this.root.b_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object precisionValue = this.executePrecision_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, aValue_, ex.getResult(), precisionValue);
                    }
                    try {
                        precisionValue_ = this.root.precision_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, aValue_, bValue_, ex.getResult());
                    }
                    if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_)) {
                        return this.root.multSpecialNormal(frameValue, aValue_, bValue_, precisionValue_);
                    }
                    return this.getNext().execute_(frameValue, aValue_, bValue_, precisionValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue, Object precisionValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject && precisionValue instanceof Integer) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        int precisionValue_ = (Integer)precisionValue;
                        if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_)) {
                            return this.root.multSpecialNormal(frameValue, aValue_, bValue_, precisionValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, aValue, bValue, precisionValue);
                }

                static BaseNode_ create(MultNodeGen root) {
                    return new MultSpecialNormalNode_(root);
                }
            }

            @GeneratedBy(methodName="multNormalSpecial(VirtualFrame, RubyBasicObject, RubyBasicObject, int)", value=BigDecimalNodes.MultNode.class)
            private static final class MultNormalSpecialNode_
            extends BaseNode_ {
                MultNormalSpecialNode_(MultNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int precisionValue_;
                    RubyBasicObject bValue_;
                    RubyBasicObject aValue_;
                    try {
                        aValue_ = this.root.a_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object bValue = this.root.b_.execute(frameValue);
                        Object precisionValue = this.executePrecision_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), bValue, precisionValue);
                    }
                    try {
                        bValue_ = this.root.b_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object precisionValue = this.executePrecision_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, aValue_, ex.getResult(), precisionValue);
                    }
                    try {
                        precisionValue_ = this.root.precision_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, aValue_, bValue_, ex.getResult());
                    }
                    if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isSpecialRubyBigDecimal(bValue_)) {
                        return this.root.multNormalSpecial(frameValue, aValue_, bValue_, precisionValue_);
                    }
                    return this.getNext().execute_(frameValue, aValue_, bValue_, precisionValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue, Object precisionValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject && precisionValue instanceof Integer) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        int precisionValue_ = (Integer)precisionValue;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isSpecialRubyBigDecimal(bValue_)) {
                            return this.root.multNormalSpecial(frameValue, aValue_, bValue_, precisionValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, aValue, bValue, precisionValue);
                }

                static BaseNode_ create(MultNodeGen root) {
                    return new MultNormalSpecialNode_(root);
                }
            }

            @GeneratedBy(methodName="mult(VirtualFrame, RubyBasicObject, RubyBasicObject, int)", value=BigDecimalNodes.MultNode.class)
            private static final class MultNode_
            extends BaseNode_ {
                MultNode_(MultNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int precisionValue_;
                    RubyBasicObject bValue_;
                    RubyBasicObject aValue_;
                    try {
                        aValue_ = this.root.a_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object bValue = this.root.b_.execute(frameValue);
                        Object precisionValue = this.executePrecision_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), bValue, precisionValue);
                    }
                    try {
                        bValue_ = this.root.b_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object precisionValue = this.executePrecision_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, aValue_, ex.getResult(), precisionValue);
                    }
                    try {
                        precisionValue_ = this.root.precision_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, aValue_, bValue_, ex.getResult());
                    }
                    if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_)) {
                        return this.root.mult(frameValue, aValue_, bValue_, precisionValue_);
                    }
                    return this.getNext().execute_(frameValue, aValue_, bValue_, precisionValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue, Object precisionValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject && precisionValue instanceof Integer) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        int precisionValue_ = (Integer)precisionValue;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_)) {
                            return this.root.mult(frameValue, aValue_, bValue_, precisionValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, aValue, bValue, precisionValue);
                }

                static BaseNode_ create(MultNodeGen root) {
                    return new MultNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.MultNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(MultNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object aValue, Object bValue, Object precisionValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, aValue, bValue, precisionValue));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue, Object precisionValue) {
                    return this.getNext().execute_(frameValue, aValue, bValue, precisionValue);
                }

                static BaseNode_ create(MultNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.MultNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(MultNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue, Object precisionValue) {
                    return this.uninitialized((Frame)frameValue, aValue, bValue, precisionValue);
                }

                static BaseNode_ create(MultNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.MultNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final MultNodeGen root;

                BaseNode_(MultNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.a_, this.root.b_, this.root.precision_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object aValue, Object bValue, Object precisionValue) {
                    return this.execute_((VirtualFrame)frameValue, aValue, bValue, precisionValue);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object aValue_ = this.root.a_.execute(frameValue);
                    Object bValue_ = this.root.b_.execute(frameValue);
                    Object precisionValue_ = this.executePrecision_((Frame)frameValue);
                    return this.execute_(frameValue, aValue_, bValue_, precisionValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object aValue, Object bValue, Object precisionValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject && precisionValue instanceof Integer) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_)) {
                            return MultNode_.create(this.root);
                        }
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isSpecialRubyBigDecimal(bValue_)) {
                            return MultNormalSpecialNode_.create(this.root);
                        }
                        if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_)) {
                            return MultSpecialNormalNode_.create(this.root);
                        }
                        if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isSpecialRubyBigDecimal(bValue_)) {
                            return MultSpecialNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executePrecision_(Frame frameValue) {
                    Object object;
                    Class precisionType_ = this.root.precisionType_;
                    if (precisionType_ == Integer.TYPE) {
                        return this.root.precision_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (precisionType_ != null) return this.root.precision_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.precision_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.precisionType_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.precisionType_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.precisionType_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=BigDecimalNodes.MultOpNode.class)
    public static final class MultOpNodeFactory
    extends NodeFactoryBase<BigDecimalNodes.MultOpNode> {
        private static MultOpNodeFactory multOpNodeFactoryInstance;

        private MultOpNodeFactory() {
            super(BigDecimalNodes.MultOpNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public BigDecimalNodes.MultOpNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return MultOpNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BigDecimalNodes.MultOpNode> getInstance() {
            if (multOpNodeFactoryInstance == null) {
                multOpNodeFactoryInstance = new MultOpNodeFactory();
            }
            return multOpNodeFactoryInstance;
        }

        public static BigDecimalNodes.MultOpNode create(RubyContext context, SourceSection sourceSection, RubyNode a, RubyNode b) {
            return new MultOpNodeGen(context, sourceSection, a, b);
        }

        @GeneratedBy(value=BigDecimalNodes.MultOpNode.class)
        public static final class MultOpNodeGen
        extends BigDecimalNodes.MultOpNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode a_;
            @Node.Child
            private RubyNode b_;
            @Node.Child
            private BaseNode_ specialization_;

            private MultOpNodeGen(RubyContext context, SourceSection sourceSection, RubyNode a, RubyNode b) {
                super(context, sourceSection);
                this.a_ = a;
                this.b_ = this.castB(b);
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="multSpecial(VirtualFrame, RubyBasicObject, RubyBasicObject)", value=BigDecimalNodes.MultOpNode.class)
            private static final class MultSpecialNode_
            extends BaseNode_ {
                MultSpecialNode_(MultOpNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isSpecialRubyBigDecimal(bValue_)) {
                            return this.root.multSpecial(frameValue, aValue_, bValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(MultOpNodeGen root) {
                    return new MultSpecialNode_(root);
                }
            }

            @GeneratedBy(methodName="multSpecialNormal(VirtualFrame, RubyBasicObject, RubyBasicObject)", value=BigDecimalNodes.MultOpNode.class)
            private static final class MultSpecialNormalNode_
            extends BaseNode_ {
                MultSpecialNormalNode_(MultOpNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_)) {
                            return this.root.multSpecialNormal(frameValue, aValue_, bValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(MultOpNodeGen root) {
                    return new MultSpecialNormalNode_(root);
                }
            }

            @GeneratedBy(methodName="multNormalSpecial(VirtualFrame, RubyBasicObject, RubyBasicObject)", value=BigDecimalNodes.MultOpNode.class)
            private static final class MultNormalSpecialNode_
            extends BaseNode_ {
                MultNormalSpecialNode_(MultOpNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isSpecialRubyBigDecimal(bValue_)) {
                            return this.root.multNormalSpecial(frameValue, aValue_, bValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(MultOpNodeGen root) {
                    return new MultNormalSpecialNode_(root);
                }
            }

            @GeneratedBy(methodName="mult(VirtualFrame, RubyBasicObject, RubyBasicObject)", value=BigDecimalNodes.MultOpNode.class)
            private static final class MultNode_
            extends BaseNode_ {
                MultNode_(MultOpNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_)) {
                            return this.root.mult(frameValue, aValue_, bValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(MultOpNodeGen root) {
                    return new MultNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.MultOpNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(MultOpNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object aValue, Object bValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, aValue, bValue));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    return this.getNext().execute_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(MultOpNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.MultOpNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(MultOpNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    return this.uninitialized((Frame)frameValue, aValue, bValue);
                }

                static BaseNode_ create(MultOpNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.MultOpNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final MultOpNodeGen root;

                BaseNode_(MultOpNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.a_, this.root.b_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object aValue, Object bValue) {
                    return this.execute_((VirtualFrame)frameValue, aValue, bValue);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object aValue_ = this.root.a_.execute(frameValue);
                    Object bValue_ = this.root.b_.execute(frameValue);
                    return this.execute_(frameValue, aValue_, bValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_)) {
                            return MultNode_.create(this.root);
                        }
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isSpecialRubyBigDecimal(bValue_)) {
                            return MultNormalSpecialNode_.create(this.root);
                        }
                        if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_)) {
                            return MultSpecialNormalNode_.create(this.root);
                        }
                        if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isSpecialRubyBigDecimal(bValue_)) {
                            return MultSpecialNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=BigDecimalNodes.NegNode.class)
    public static final class NegNodeFactory
    extends NodeFactoryBase<BigDecimalNodes.NegNode> {
        private static NegNodeFactory negNodeFactoryInstance;

        private NegNodeFactory() {
            super(BigDecimalNodes.NegNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BigDecimalNodes.NegNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return NegNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BigDecimalNodes.NegNode> getInstance() {
            if (negNodeFactoryInstance == null) {
                negNodeFactoryInstance = new NegNodeFactory();
            }
            return negNodeFactoryInstance;
        }

        public static BigDecimalNodes.NegNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new NegNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BigDecimalNodes.NegNode.class)
        public static final class NegNodeGen
        extends BigDecimalNodes.NegNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private NegNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="negSpecial(VirtualFrame, RubyBasicObject)", value=BigDecimalNodes.NegNode.class)
            private static final class NegSpecialNode_
            extends BaseNode_ {
                NegSpecialNode_(NegNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && !BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.negSpecial(frameValue, arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(NegNodeGen root) {
                    return new NegSpecialNode_(root);
                }
            }

            @GeneratedBy(methodName="negNormalZero(VirtualFrame, RubyBasicObject)", value=BigDecimalNodes.NegNode.class)
            private static final class NegNormalZeroNode_
            extends BaseNode_ {
                NegNormalZeroNode_(NegNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_ = (RubyBasicObject)arguments0Value) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalZero(arguments0Value_)) {
                        return this.root.negNormalZero(frameValue, arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(NegNodeGen root) {
                    return new NegNormalZeroNode_(root);
                }
            }

            @GeneratedBy(methodName="negNormal(VirtualFrame, RubyBasicObject)", value=BigDecimalNodes.NegNode.class)
            private static final class NegNormalNode_
            extends BaseNode_ {
                NegNormalNode_(NegNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_ = (RubyBasicObject)arguments0Value) && !BigDecimalNodes.BigDecimalCoreMethodNode.isNormalZero(arguments0Value_)) {
                        return this.root.negNormal(frameValue, arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(NegNodeGen root) {
                    return new NegNormalNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.NegNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(NegNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(NegNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.NegNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(NegNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(NegNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.NegNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final NegNodeGen root;

                BaseNode_(NegNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_) && !BigDecimalNodes.BigDecimalCoreMethodNode.isNormalZero(arguments0Value_)) {
                            return NegNormalNode_.create(this.root);
                        }
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalZero(arguments0Value_)) {
                            return NegNormalZeroNode_.create(this.root);
                        }
                        if (!BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(arguments0Value_)) {
                            return NegSpecialNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=BigDecimalNodes.SubNode.class)
    public static final class SubNodeFactory
    extends NodeFactoryBase<BigDecimalNodes.SubNode> {
        private static SubNodeFactory subNodeFactoryInstance;

        private SubNodeFactory() {
            super(BigDecimalNodes.SubNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class, RubyNode.class}});
        }

        public BigDecimalNodes.SubNode createNode(Object ... arguments) {
            if (!(arguments.length != 5 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode))) {
                return SubNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]), (RubyNode)((Object)arguments[4]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BigDecimalNodes.SubNode> getInstance() {
            if (subNodeFactoryInstance == null) {
                subNodeFactoryInstance = new SubNodeFactory();
            }
            return subNodeFactoryInstance;
        }

        public static BigDecimalNodes.SubNode create(RubyContext context, SourceSection sourceSection, RubyNode a, RubyNode b, RubyNode precision) {
            return new SubNodeGen(context, sourceSection, a, b, precision);
        }

        @GeneratedBy(value=BigDecimalNodes.SubNode.class)
        public static final class SubNodeGen
        extends BigDecimalNodes.SubNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode a_;
            @Node.Child
            private RubyNode b_;
            @Node.Child
            private RubyNode precision_;
            @CompilerDirectives.CompilationFinal
            private Class<?> precisionType_;
            @Node.Child
            private BaseNode_ specialization_;

            private SubNodeGen(RubyContext context, SourceSection sourceSection, RubyNode a, RubyNode b, RubyNode precision) {
                super(context, sourceSection);
                this.a_ = a;
                this.b_ = this.castB(b);
                this.precision_ = precision;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="subSpecial(VirtualFrame, RubyBasicObject, RubyBasicObject, int)", value=BigDecimalNodes.SubNode.class)
            private static final class SubSpecialNode_
            extends BaseNode_ {
                SubSpecialNode_(SubNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int precisionValue_;
                    RubyBasicObject bValue_;
                    RubyBasicObject aValue_;
                    try {
                        aValue_ = this.root.a_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object bValue = this.root.b_.execute(frameValue);
                        Object precisionValue = this.executePrecision_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), bValue, precisionValue);
                    }
                    try {
                        bValue_ = this.root.b_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object precisionValue = this.executePrecision_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, aValue_, ex.getResult(), precisionValue);
                    }
                    try {
                        precisionValue_ = this.root.precision_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, aValue_, bValue_, ex.getResult());
                    }
                    if (!(!RubyGuards.isRubyBigDecimal(bValue_) || BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(bValue_))) {
                        return this.root.subSpecial(frameValue, aValue_, bValue_, precisionValue_);
                    }
                    return this.getNext().execute_(frameValue, aValue_, bValue_, precisionValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue, Object precisionValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject && precisionValue instanceof Integer) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        int precisionValue_ = (Integer)precisionValue;
                        if (!(!RubyGuards.isRubyBigDecimal(bValue_) || BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(bValue_))) {
                            return this.root.subSpecial(frameValue, aValue_, bValue_, precisionValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, aValue, bValue, precisionValue);
                }

                static BaseNode_ create(SubNodeGen root) {
                    return new SubSpecialNode_(root);
                }
            }

            @GeneratedBy(methodName="subNormal(VirtualFrame, RubyBasicObject, RubyBasicObject, int)", value=BigDecimalNodes.SubNode.class)
            private static final class SubNormalNode_
            extends BaseNode_ {
                SubNormalNode_(SubNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int precisionValue_;
                    RubyBasicObject bValue_;
                    RubyBasicObject aValue_;
                    try {
                        aValue_ = this.root.a_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object bValue = this.root.b_.execute(frameValue);
                        Object precisionValue = this.executePrecision_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), bValue, precisionValue);
                    }
                    try {
                        bValue_ = this.root.b_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object precisionValue = this.executePrecision_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, aValue_, ex.getResult(), precisionValue);
                    }
                    try {
                        precisionValue_ = this.root.precision_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, aValue_, bValue_, ex.getResult());
                    }
                    if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_)) {
                        return this.root.subNormal(frameValue, aValue_, bValue_, precisionValue_);
                    }
                    return this.getNext().execute_(frameValue, aValue_, bValue_, precisionValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue, Object precisionValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject && precisionValue instanceof Integer) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        int precisionValue_ = (Integer)precisionValue;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_)) {
                            return this.root.subNormal(frameValue, aValue_, bValue_, precisionValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, aValue, bValue, precisionValue);
                }

                static BaseNode_ create(SubNodeGen root) {
                    return new SubNormalNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.SubNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SubNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object aValue, Object bValue, Object precisionValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, aValue, bValue, precisionValue));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue, Object precisionValue) {
                    return this.getNext().execute_(frameValue, aValue, bValue, precisionValue);
                }

                static BaseNode_ create(SubNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.SubNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SubNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue, Object precisionValue) {
                    return this.uninitialized((Frame)frameValue, aValue, bValue, precisionValue);
                }

                static BaseNode_ create(SubNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.SubNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final SubNodeGen root;

                BaseNode_(SubNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.a_, this.root.b_, this.root.precision_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object aValue, Object bValue, Object precisionValue) {
                    return this.execute_((VirtualFrame)frameValue, aValue, bValue, precisionValue);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object aValue_ = this.root.a_.execute(frameValue);
                    Object bValue_ = this.root.b_.execute(frameValue);
                    Object precisionValue_ = this.executePrecision_((Frame)frameValue);
                    return this.execute_(frameValue, aValue_, bValue_, precisionValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object aValue, Object bValue, Object precisionValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject && precisionValue instanceof Integer) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_)) {
                            return SubNormalNode_.create(this.root);
                        }
                        if (!(!RubyGuards.isRubyBigDecimal(bValue_) || BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(bValue_))) {
                            return SubSpecialNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executePrecision_(Frame frameValue) {
                    Object object;
                    Class precisionType_ = this.root.precisionType_;
                    if (precisionType_ == Integer.TYPE) {
                        return this.root.precision_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (precisionType_ != null) return this.root.precision_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.precision_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.precisionType_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.precisionType_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.precisionType_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=BigDecimalNodes.SubOpNode.class)
    public static final class SubOpNodeFactory
    extends NodeFactoryBase<BigDecimalNodes.SubOpNode> {
        private static SubOpNodeFactory subOpNodeFactoryInstance;

        private SubOpNodeFactory() {
            super(BigDecimalNodes.SubOpNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public BigDecimalNodes.SubOpNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return SubOpNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BigDecimalNodes.SubOpNode> getInstance() {
            if (subOpNodeFactoryInstance == null) {
                subOpNodeFactoryInstance = new SubOpNodeFactory();
            }
            return subOpNodeFactoryInstance;
        }

        public static BigDecimalNodes.SubOpNode create(RubyContext context, SourceSection sourceSection, RubyNode a, RubyNode b) {
            return new SubOpNodeGen(context, sourceSection, a, b);
        }

        @GeneratedBy(value=BigDecimalNodes.SubOpNode.class)
        public static final class SubOpNodeGen
        extends BigDecimalNodes.SubOpNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode a_;
            @Node.Child
            private RubyNode b_;
            @Node.Child
            private BaseNode_ specialization_;

            private SubOpNodeGen(RubyContext context, SourceSection sourceSection, RubyNode a, RubyNode b) {
                super(context, sourceSection);
                this.a_ = a;
                this.b_ = this.castB(b);
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="subSpecial(VirtualFrame, RubyBasicObject, RubyBasicObject)", value=BigDecimalNodes.SubOpNode.class)
            private static final class SubSpecialNode_
            extends BaseNode_ {
                SubSpecialNode_(SubOpNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        if (!(!RubyGuards.isRubyBigDecimal(bValue_) || BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(bValue_))) {
                            return this.root.subSpecial(frameValue, aValue_, bValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(SubOpNodeGen root) {
                    return new SubSpecialNode_(root);
                }
            }

            @GeneratedBy(methodName="subNormal(VirtualFrame, RubyBasicObject, RubyBasicObject)", value=BigDecimalNodes.SubOpNode.class)
            private static final class SubNormalNode_
            extends BaseNode_ {
                SubNormalNode_(SubOpNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_)) {
                            return this.root.subNormal(frameValue, aValue_, bValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(SubOpNodeGen root) {
                    return new SubNormalNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.SubOpNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SubOpNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object aValue, Object bValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, aValue, bValue));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    return this.getNext().execute_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(SubOpNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.SubOpNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SubOpNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    return this.uninitialized((Frame)frameValue, aValue, bValue);
                }

                static BaseNode_ create(SubOpNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.SubOpNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final SubOpNodeGen root;

                BaseNode_(SubOpNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.a_, this.root.b_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object aValue, Object bValue) {
                    return this.execute_((VirtualFrame)frameValue, aValue, bValue);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object aValue_ = this.root.a_.execute(frameValue);
                    Object bValue_ = this.root.b_.execute(frameValue);
                    return this.execute_(frameValue, aValue_, bValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_)) {
                            return SubNormalNode_.create(this.root);
                        }
                        if (!(!RubyGuards.isRubyBigDecimal(bValue_) || BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(bValue_))) {
                            return SubSpecialNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=BigDecimalNodes.AddNode.class)
    public static final class AddNodeFactory
    extends NodeFactoryBase<BigDecimalNodes.AddNode> {
        private static AddNodeFactory addNodeFactoryInstance;

        private AddNodeFactory() {
            super(BigDecimalNodes.AddNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class, RubyNode.class}});
        }

        public BigDecimalNodes.AddNode createNode(Object ... arguments) {
            if (!(arguments.length != 5 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode))) {
                return AddNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]), (RubyNode)((Object)arguments[4]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BigDecimalNodes.AddNode> getInstance() {
            if (addNodeFactoryInstance == null) {
                addNodeFactoryInstance = new AddNodeFactory();
            }
            return addNodeFactoryInstance;
        }

        public static BigDecimalNodes.AddNode create(RubyContext context, SourceSection sourceSection, RubyNode a, RubyNode b, RubyNode precision) {
            return new AddNodeGen(context, sourceSection, a, b, precision);
        }

        @GeneratedBy(value=BigDecimalNodes.AddNode.class)
        public static final class AddNodeGen
        extends BigDecimalNodes.AddNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode a_;
            @Node.Child
            private RubyNode b_;
            @Node.Child
            private RubyNode precision_;
            @CompilerDirectives.CompilationFinal
            private Class<?> precisionType_;
            @Node.Child
            private BaseNode_ specialization_;

            private AddNodeGen(RubyContext context, SourceSection sourceSection, RubyNode a, RubyNode b, RubyNode precision) {
                super(context, sourceSection);
                this.a_ = a;
                this.b_ = this.castB(b);
                this.precision_ = precision;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="addSpecial(VirtualFrame, RubyBasicObject, RubyBasicObject, int)", value=BigDecimalNodes.AddNode.class)
            private static final class AddSpecialNode_
            extends BaseNode_ {
                AddSpecialNode_(AddNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int precisionValue_;
                    RubyBasicObject bValue_;
                    RubyBasicObject aValue_;
                    try {
                        aValue_ = this.root.a_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object bValue = this.root.b_.execute(frameValue);
                        Object precisionValue = this.executePrecision_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), bValue, precisionValue);
                    }
                    try {
                        bValue_ = this.root.b_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object precisionValue = this.executePrecision_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, aValue_, ex.getResult(), precisionValue);
                    }
                    try {
                        precisionValue_ = this.root.precision_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, aValue_, bValue_, ex.getResult());
                    }
                    if (!(!RubyGuards.isRubyBigDecimal(bValue_) || BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(bValue_))) {
                        return this.root.addSpecial(frameValue, aValue_, bValue_, precisionValue_);
                    }
                    return this.getNext().execute_(frameValue, aValue_, bValue_, precisionValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue, Object precisionValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject && precisionValue instanceof Integer) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        int precisionValue_ = (Integer)precisionValue;
                        if (!(!RubyGuards.isRubyBigDecimal(bValue_) || BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(bValue_))) {
                            return this.root.addSpecial(frameValue, aValue_, bValue_, precisionValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, aValue, bValue, precisionValue);
                }

                static BaseNode_ create(AddNodeGen root) {
                    return new AddSpecialNode_(root);
                }
            }

            @GeneratedBy(methodName="add(VirtualFrame, RubyBasicObject, RubyBasicObject, int)", value=BigDecimalNodes.AddNode.class)
            private static final class AddNode_
            extends BaseNode_ {
                AddNode_(AddNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int precisionValue_;
                    RubyBasicObject bValue_;
                    RubyBasicObject aValue_;
                    try {
                        aValue_ = this.root.a_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object bValue = this.root.b_.execute(frameValue);
                        Object precisionValue = this.executePrecision_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), bValue, precisionValue);
                    }
                    try {
                        bValue_ = this.root.b_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object precisionValue = this.executePrecision_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, aValue_, ex.getResult(), precisionValue);
                    }
                    try {
                        precisionValue_ = this.root.precision_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, aValue_, bValue_, ex.getResult());
                    }
                    if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_)) {
                        return this.root.add(frameValue, aValue_, bValue_, precisionValue_);
                    }
                    return this.getNext().execute_(frameValue, aValue_, bValue_, precisionValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue, Object precisionValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject && precisionValue instanceof Integer) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        int precisionValue_ = (Integer)precisionValue;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_)) {
                            return this.root.add(frameValue, aValue_, bValue_, precisionValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, aValue, bValue, precisionValue);
                }

                static BaseNode_ create(AddNodeGen root) {
                    return new AddNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.AddNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(AddNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object aValue, Object bValue, Object precisionValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, aValue, bValue, precisionValue));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue, Object precisionValue) {
                    return this.getNext().execute_(frameValue, aValue, bValue, precisionValue);
                }

                static BaseNode_ create(AddNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.AddNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(AddNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue, Object precisionValue) {
                    return this.uninitialized((Frame)frameValue, aValue, bValue, precisionValue);
                }

                static BaseNode_ create(AddNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.AddNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final AddNodeGen root;

                BaseNode_(AddNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.a_, this.root.b_, this.root.precision_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object aValue, Object bValue, Object precisionValue) {
                    return this.execute_((VirtualFrame)frameValue, aValue, bValue, precisionValue);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object aValue_ = this.root.a_.execute(frameValue);
                    Object bValue_ = this.root.b_.execute(frameValue);
                    Object precisionValue_ = this.executePrecision_((Frame)frameValue);
                    return this.execute_(frameValue, aValue_, bValue_, precisionValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object aValue, Object bValue, Object precisionValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject && precisionValue instanceof Integer) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_)) {
                            return AddNode_.create(this.root);
                        }
                        if (!(!RubyGuards.isRubyBigDecimal(bValue_) || BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(bValue_))) {
                            return AddSpecialNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executePrecision_(Frame frameValue) {
                    Object object;
                    Class precisionType_ = this.root.precisionType_;
                    if (precisionType_ == Integer.TYPE) {
                        return this.root.precision_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (precisionType_ != null) return this.root.precision_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.precision_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.precisionType_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.precisionType_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.precisionType_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=BigDecimalNodes.AddOpNode.class)
    public static final class AddOpNodeFactory
    extends NodeFactoryBase<BigDecimalNodes.AddOpNode> {
        private static AddOpNodeFactory addOpNodeFactoryInstance;

        private AddOpNodeFactory() {
            super(BigDecimalNodes.AddOpNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public BigDecimalNodes.AddOpNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return AddOpNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BigDecimalNodes.AddOpNode> getInstance() {
            if (addOpNodeFactoryInstance == null) {
                addOpNodeFactoryInstance = new AddOpNodeFactory();
            }
            return addOpNodeFactoryInstance;
        }

        public static BigDecimalNodes.AddOpNode create(RubyContext context, SourceSection sourceSection, RubyNode a, RubyNode b) {
            return new AddOpNodeGen(context, sourceSection, a, b);
        }

        @GeneratedBy(value=BigDecimalNodes.AddOpNode.class)
        public static final class AddOpNodeGen
        extends BigDecimalNodes.AddOpNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode a_;
            @Node.Child
            private RubyNode b_;
            @Node.Child
            private BaseNode_ specialization_;

            private AddOpNodeGen(RubyContext context, SourceSection sourceSection, RubyNode a, RubyNode b) {
                super(context, sourceSection);
                this.a_ = a;
                this.b_ = this.castB(b);
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="addSpecial(VirtualFrame, RubyBasicObject, RubyBasicObject)", value=BigDecimalNodes.AddOpNode.class)
            private static final class AddSpecialNode_
            extends BaseNode_ {
                AddSpecialNode_(AddOpNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        if (!(!RubyGuards.isRubyBigDecimal(bValue_) || BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(bValue_))) {
                            return this.root.addSpecial(frameValue, aValue_, bValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(AddOpNodeGen root) {
                    return new AddSpecialNode_(root);
                }
            }

            @GeneratedBy(methodName="add(VirtualFrame, RubyBasicObject, RubyBasicObject)", value=BigDecimalNodes.AddOpNode.class)
            private static final class AddNode_
            extends BaseNode_ {
                AddNode_(AddOpNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_)) {
                            return this.root.add(frameValue, aValue_, bValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(AddOpNodeGen root) {
                    return new AddNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.AddOpNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(AddOpNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object aValue, Object bValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, aValue, bValue));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    return this.getNext().execute_(frameValue, aValue, bValue);
                }

                static BaseNode_ create(AddOpNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.AddOpNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(AddOpNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object aValue, Object bValue) {
                    return this.uninitialized((Frame)frameValue, aValue, bValue);
                }

                static BaseNode_ create(AddOpNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.AddOpNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final AddOpNodeGen root;

                BaseNode_(AddOpNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.a_, this.root.b_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object aValue, Object bValue) {
                    return this.execute_((VirtualFrame)frameValue, aValue, bValue);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object aValue_ = this.root.a_.execute(frameValue);
                    Object bValue_ = this.root.b_.execute(frameValue);
                    return this.execute_(frameValue, aValue_, bValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object aValue, Object bValue) {
                    if (aValue instanceof RubyBasicObject && bValue instanceof RubyBasicObject) {
                        RubyBasicObject aValue_ = (RubyBasicObject)aValue;
                        RubyBasicObject bValue_ = (RubyBasicObject)bValue;
                        if (BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormalRubyBigDecimal(bValue_)) {
                            return AddNode_.create(this.root);
                        }
                        if (!(!RubyGuards.isRubyBigDecimal(bValue_) || BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(aValue_) && BigDecimalNodes.BigDecimalCoreMethodNode.isNormal(bValue_))) {
                            return AddSpecialNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=BigDecimalNodes.InitializeNode.class)
    public static final class InitializeNodeFactory
    extends NodeFactoryBase<BigDecimalNodes.InitializeNode> {
        private static InitializeNodeFactory initializeNodeFactoryInstance;

        private InitializeNodeFactory() {
            super(BigDecimalNodes.InitializeNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BigDecimalNodes.InitializeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InitializeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BigDecimalNodes.InitializeNode> getInstance() {
            if (initializeNodeFactoryInstance == null) {
                initializeNodeFactoryInstance = new InitializeNodeFactory();
            }
            return initializeNodeFactoryInstance;
        }

        public static BigDecimalNodes.InitializeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new InitializeNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BigDecimalNodes.InitializeNode.class)
        public static final class InitializeNodeGen
        extends BigDecimalNodes.InitializeNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private InitializeNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="initialize(VirtualFrame, RubyBasicObject, Object, int)", value=BigDecimalNodes.InitializeNode.class)
            private static final class Initialize1Node_
            extends BaseNode_ {
                Initialize1Node_(InitializeNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments2Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.root.arguments1_.execute(frameValue);
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value);
                    }
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    try {
                        arguments2Value_ = this.root.arguments2_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult());
                    }
                    return this.root.initialize(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments2Value instanceof Integer) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        int arguments2Value_ = (Integer)arguments2Value;
                        return this.root.initialize(frameValue, arguments0Value_, arguments1Value, arguments2Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new Initialize1Node_(root);
                }
            }

            @GeneratedBy(methodName="initialize(VirtualFrame, RubyBasicObject, Object, NotProvided)", value=BigDecimalNodes.InitializeNode.class)
            private static final class Initialize0Node_
            extends BaseNode_ {
                Initialize0Node_(InitializeNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments2Value instanceof NotProvided) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        return this.root.initialize(frameValue, arguments0Value_, arguments1Value, arguments2Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new Initialize0Node_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.InitializeNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(InitializeNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.InitializeNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(InitializeNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.InitializeNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final InitializeNodeGen root;

                BaseNode_(InitializeNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.executeArguments2_((Frame)frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        if (arguments2Value instanceof NotProvided) {
                            return Initialize0Node_.create(this.root);
                        }
                        if (arguments2Value instanceof Integer) {
                            return Initialize1Node_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments2_(Frame frameValue) {
                    Object object;
                    Class arguments2Type_ = this.root.arguments2Type_;
                    if (arguments2Type_ == Integer.TYPE) {
                        return this.root.arguments2_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments2Type_ != null) return this.root.arguments2_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments2_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments2Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments2Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments2Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=BigDecimalNodes.CreateBigDecimalNode.class)
    public static final class CreateBigDecimalNodeFactory
    extends NodeFactoryBase<BigDecimalNodes.CreateBigDecimalNode> {
        private static CreateBigDecimalNodeFactory createBigDecimalNodeFactoryInstance;

        private CreateBigDecimalNodeFactory() {
            super(BigDecimalNodes.CreateBigDecimalNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class, RubyNode.class}});
        }

        public BigDecimalNodes.CreateBigDecimalNode createNode(Object ... arguments) {
            if (!(arguments.length != 5 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode))) {
                return CreateBigDecimalNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]), (RubyNode)((Object)arguments[4]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BigDecimalNodes.CreateBigDecimalNode> getInstance() {
            if (createBigDecimalNodeFactoryInstance == null) {
                createBigDecimalNodeFactoryInstance = new CreateBigDecimalNodeFactory();
            }
            return createBigDecimalNodeFactoryInstance;
        }

        public static BigDecimalNodes.CreateBigDecimalNode create(RubyContext context, SourceSection sourceSection, RubyNode value, RubyNode self, RubyNode digits) {
            return new CreateBigDecimalNodeGen(context, sourceSection, value, self, digits);
        }

        @GeneratedBy(value=BigDecimalNodes.CreateBigDecimalNode.class)
        public static final class CreateBigDecimalNodeGen
        extends BigDecimalNodes.CreateBigDecimalNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode value_;
            @Node.Child
            private RubyNode self_;
            @Node.Child
            private RubyNode digits_;
            @CompilerDirectives.CompilationFinal
            private Class<?> valueType_;
            @CompilerDirectives.CompilationFinal
            private Class<?> digitsType_;
            @Node.Child
            private BaseNode_ specialization_;

            private CreateBigDecimalNodeGen(RubyContext context, SourceSection sourceSection, RubyNode value, RubyNode self, RubyNode digits) {
                super(context, sourceSection);
                this.value_ = value;
                this.self_ = self;
                this.digits_ = digits;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public RubyBasicObject executeCreate(VirtualFrame frameValue, Object valueValue, RubyBasicObject selfValue, int digitsValue) {
                return this.specialization_.executeRubyBasicObject1(frameValue, valueValue, selfValue, digitsValue);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                return this.specialization_.executeRubyBasicObject0(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            private static BigDecimal expectBigDecimal(Object value) throws UnexpectedResultException {
                if (value instanceof BigDecimal) {
                    return (BigDecimal)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static BigDecimalNodes.Type expectType(Object value) throws UnexpectedResultException {
                if (value instanceof BigDecimalNodes.Type) {
                    return (BigDecimalNodes.Type)((Object)value);
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="createString(VirtualFrame, RubyBasicObject, RubyBasicObject, int)", value=BigDecimalNodes.CreateBigDecimalNode.class)
            private static final class CreateStringNode_
            extends BaseNode_ {
                CreateStringNode_(CreateBigDecimalNodeGen root) {
                    super(root, 9);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeRubyBasicObject0(frameValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject0(VirtualFrame frameValue) {
                    int digitsValue_;
                    RubyBasicObject selfValue_;
                    RubyBasicObject valueValue_;
                    try {
                        valueValue_ = this.root.value_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object selfValue = this.root.self_.execute(frameValue);
                        Object digitsValue = this.executeDigits_((Frame)frameValue);
                        return this.getNext().executeRubyBasicObject_(frameValue, ex.getResult(), selfValue, digitsValue);
                    }
                    try {
                        selfValue_ = this.root.self_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object digitsValue = this.executeDigits_((Frame)frameValue);
                        return this.getNext().executeRubyBasicObject_(frameValue, valueValue_, ex.getResult(), digitsValue);
                    }
                    try {
                        digitsValue_ = this.root.digits_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeRubyBasicObject_(frameValue, valueValue_, selfValue_, ex.getResult());
                    }
                    if (RubyGuards.isRubyString(valueValue_)) {
                        return this.root.createString(frameValue, valueValue_, selfValue_, digitsValue_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, valueValue_, selfValue_, digitsValue_);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject1(VirtualFrame frameValue, Object valueValue, RubyBasicObject selfValue, int digitsValue) {
                    RubyBasicObject valueValue_;
                    if (valueValue instanceof RubyBasicObject && RubyGuards.isRubyString(valueValue_ = (RubyBasicObject)valueValue)) {
                        return this.root.createString(frameValue, valueValue_, selfValue, digitsValue);
                    }
                    return this.getNext().executeRubyBasicObject1(frameValue, valueValue, selfValue, digitsValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object valueValue, Object selfValue, Object digitsValue) {
                    if (valueValue instanceof RubyBasicObject && selfValue instanceof RubyBasicObject && digitsValue instanceof Integer) {
                        RubyBasicObject valueValue_ = (RubyBasicObject)valueValue;
                        RubyBasicObject selfValue_ = (RubyBasicObject)selfValue;
                        int digitsValue_ = (Integer)digitsValue;
                        if (RubyGuards.isRubyString(valueValue_)) {
                            return this.root.createString(frameValue, valueValue_, selfValue_, digitsValue_);
                        }
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, valueValue, selfValue, digitsValue);
                }

                static BaseNode_ create(CreateBigDecimalNodeGen root) {
                    return new CreateStringNode_(root);
                }
            }

            @GeneratedBy(methodName="createBigDecimal(VirtualFrame, RubyBasicObject, RubyBasicObject, int)", value=BigDecimalNodes.CreateBigDecimalNode.class)
            private static final class CreateBigDecimalNode_
            extends BaseNode_ {
                CreateBigDecimalNode_(CreateBigDecimalNodeGen root) {
                    super(root, 8);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeRubyBasicObject0(frameValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject0(VirtualFrame frameValue) {
                    int digitsValue_;
                    RubyBasicObject selfValue_;
                    RubyBasicObject valueValue_;
                    try {
                        valueValue_ = this.root.value_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object selfValue = this.root.self_.execute(frameValue);
                        Object digitsValue = this.executeDigits_((Frame)frameValue);
                        return this.getNext().executeRubyBasicObject_(frameValue, ex.getResult(), selfValue, digitsValue);
                    }
                    try {
                        selfValue_ = this.root.self_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object digitsValue = this.executeDigits_((Frame)frameValue);
                        return this.getNext().executeRubyBasicObject_(frameValue, valueValue_, ex.getResult(), digitsValue);
                    }
                    try {
                        digitsValue_ = this.root.digits_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeRubyBasicObject_(frameValue, valueValue_, selfValue_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBigDecimal(valueValue_)) {
                        return this.root.createBigDecimal(frameValue, valueValue_, selfValue_, digitsValue_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, valueValue_, selfValue_, digitsValue_);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject1(VirtualFrame frameValue, Object valueValue, RubyBasicObject selfValue, int digitsValue) {
                    RubyBasicObject valueValue_;
                    if (valueValue instanceof RubyBasicObject && RubyGuards.isRubyBigDecimal(valueValue_ = (RubyBasicObject)valueValue)) {
                        return this.root.createBigDecimal(frameValue, valueValue_, selfValue, digitsValue);
                    }
                    return this.getNext().executeRubyBasicObject1(frameValue, valueValue, selfValue, digitsValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object valueValue, Object selfValue, Object digitsValue) {
                    if (valueValue instanceof RubyBasicObject && selfValue instanceof RubyBasicObject && digitsValue instanceof Integer) {
                        RubyBasicObject valueValue_ = (RubyBasicObject)valueValue;
                        RubyBasicObject selfValue_ = (RubyBasicObject)selfValue;
                        int digitsValue_ = (Integer)digitsValue;
                        if (RubyGuards.isRubyBigDecimal(valueValue_)) {
                            return this.root.createBigDecimal(frameValue, valueValue_, selfValue_, digitsValue_);
                        }
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, valueValue, selfValue, digitsValue);
                }

                static BaseNode_ create(CreateBigDecimalNodeGen root) {
                    return new CreateBigDecimalNode_(root);
                }
            }

            @GeneratedBy(methodName="createBignum(VirtualFrame, RubyBasicObject, RubyBasicObject, int)", value=BigDecimalNodes.CreateBigDecimalNode.class)
            private static final class CreateBignumNode_
            extends BaseNode_ {
                CreateBignumNode_(CreateBigDecimalNodeGen root) {
                    super(root, 7);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeRubyBasicObject0(frameValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject0(VirtualFrame frameValue) {
                    int digitsValue_;
                    RubyBasicObject selfValue_;
                    RubyBasicObject valueValue_;
                    try {
                        valueValue_ = this.root.value_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object selfValue = this.root.self_.execute(frameValue);
                        Object digitsValue = this.executeDigits_((Frame)frameValue);
                        return this.getNext().executeRubyBasicObject_(frameValue, ex.getResult(), selfValue, digitsValue);
                    }
                    try {
                        selfValue_ = this.root.self_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object digitsValue = this.executeDigits_((Frame)frameValue);
                        return this.getNext().executeRubyBasicObject_(frameValue, valueValue_, ex.getResult(), digitsValue);
                    }
                    try {
                        digitsValue_ = this.root.digits_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeRubyBasicObject_(frameValue, valueValue_, selfValue_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(valueValue_)) {
                        return this.root.createBignum(frameValue, valueValue_, selfValue_, digitsValue_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, valueValue_, selfValue_, digitsValue_);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject1(VirtualFrame frameValue, Object valueValue, RubyBasicObject selfValue, int digitsValue) {
                    RubyBasicObject valueValue_;
                    if (valueValue instanceof RubyBasicObject && RubyGuards.isRubyBignum(valueValue_ = (RubyBasicObject)valueValue)) {
                        return this.root.createBignum(frameValue, valueValue_, selfValue, digitsValue);
                    }
                    return this.getNext().executeRubyBasicObject1(frameValue, valueValue, selfValue, digitsValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object valueValue, Object selfValue, Object digitsValue) {
                    if (valueValue instanceof RubyBasicObject && selfValue instanceof RubyBasicObject && digitsValue instanceof Integer) {
                        RubyBasicObject valueValue_ = (RubyBasicObject)valueValue;
                        RubyBasicObject selfValue_ = (RubyBasicObject)selfValue;
                        int digitsValue_ = (Integer)digitsValue;
                        if (RubyGuards.isRubyBignum(valueValue_)) {
                            return this.root.createBignum(frameValue, valueValue_, selfValue_, digitsValue_);
                        }
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, valueValue, selfValue, digitsValue);
                }

                static BaseNode_ create(CreateBigDecimalNodeGen root) {
                    return new CreateBignumNode_(root);
                }
            }

            @GeneratedBy(methodName="create(VirtualFrame, BigDecimal, RubyBasicObject, int)", value=BigDecimalNodes.CreateBigDecimalNode.class)
            private static final class Create2Node_
            extends BaseNode_ {
                Create2Node_(CreateBigDecimalNodeGen root) {
                    super(root, 6);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeRubyBasicObject0(frameValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject0(VirtualFrame frameValue) {
                    int digitsValue_;
                    RubyBasicObject selfValue_;
                    BigDecimal valueValue_;
                    try {
                        valueValue_ = CreateBigDecimalNodeGen.expectBigDecimal(this.root.value_.execute(frameValue));
                    }
                    catch (UnexpectedResultException ex) {
                        Object selfValue = this.root.self_.execute(frameValue);
                        Object digitsValue = this.executeDigits_((Frame)frameValue);
                        return this.getNext().executeRubyBasicObject_(frameValue, ex.getResult(), selfValue, digitsValue);
                    }
                    try {
                        selfValue_ = this.root.self_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object digitsValue = this.executeDigits_((Frame)frameValue);
                        return this.getNext().executeRubyBasicObject_(frameValue, valueValue_, ex.getResult(), digitsValue);
                    }
                    try {
                        digitsValue_ = this.root.digits_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeRubyBasicObject_(frameValue, valueValue_, selfValue_, ex.getResult());
                    }
                    return this.root.create(frameValue, valueValue_, selfValue_, digitsValue_);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject1(VirtualFrame frameValue, Object valueValue, RubyBasicObject selfValue, int digitsValue) {
                    if (valueValue instanceof BigDecimal) {
                        BigDecimal valueValue_ = (BigDecimal)valueValue;
                        return this.root.create(frameValue, valueValue_, selfValue, digitsValue);
                    }
                    return this.getNext().executeRubyBasicObject1(frameValue, valueValue, selfValue, digitsValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object valueValue, Object selfValue, Object digitsValue) {
                    if (valueValue instanceof BigDecimal && selfValue instanceof RubyBasicObject && digitsValue instanceof Integer) {
                        BigDecimal valueValue_ = (BigDecimal)valueValue;
                        RubyBasicObject selfValue_ = (RubyBasicObject)selfValue;
                        int digitsValue_ = (Integer)digitsValue;
                        return this.root.create(frameValue, valueValue_, selfValue_, digitsValue_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, valueValue, selfValue, digitsValue);
                }

                static BaseNode_ create(CreateBigDecimalNodeGen root) {
                    return new Create2Node_(root);
                }
            }

            @GeneratedBy(methodName="createNegativeZero(VirtualFrame, Type, RubyBasicObject, int)", value=BigDecimalNodes.CreateBigDecimalNode.class)
            private static final class CreateNegativeZeroNode_
            extends BaseNode_ {
                CreateNegativeZeroNode_(CreateBigDecimalNodeGen root) {
                    super(root, 5);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeRubyBasicObject0(frameValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject0(VirtualFrame frameValue) {
                    int digitsValue_;
                    RubyBasicObject selfValue_;
                    BigDecimalNodes.Type valueValue_;
                    try {
                        valueValue_ = CreateBigDecimalNodeGen.expectType(this.root.value_.execute(frameValue));
                    }
                    catch (UnexpectedResultException ex) {
                        Object selfValue = this.root.self_.execute(frameValue);
                        Object digitsValue = this.executeDigits_((Frame)frameValue);
                        return this.getNext().executeRubyBasicObject_(frameValue, ex.getResult(), selfValue, digitsValue);
                    }
                    try {
                        selfValue_ = this.root.self_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object digitsValue = this.executeDigits_((Frame)frameValue);
                        return this.getNext().executeRubyBasicObject_(frameValue, (Object)valueValue_, ex.getResult(), digitsValue);
                    }
                    try {
                        digitsValue_ = this.root.digits_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeRubyBasicObject_(frameValue, (Object)valueValue_, selfValue_, ex.getResult());
                    }
                    if (valueValue_ == BigDecimalNodes.Type.NEGATIVE_ZERO) {
                        return this.root.createNegativeZero(frameValue, valueValue_, selfValue_, digitsValue_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, (Object)valueValue_, selfValue_, digitsValue_);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject1(VirtualFrame frameValue, Object valueValue, RubyBasicObject selfValue, int digitsValue) {
                    BigDecimalNodes.Type valueValue_;
                    if (valueValue instanceof BigDecimalNodes.Type && (valueValue_ = (BigDecimalNodes.Type)((Object)valueValue)) == BigDecimalNodes.Type.NEGATIVE_ZERO) {
                        return this.root.createNegativeZero(frameValue, valueValue_, selfValue, digitsValue);
                    }
                    return this.getNext().executeRubyBasicObject1(frameValue, valueValue, selfValue, digitsValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object valueValue, Object selfValue, Object digitsValue) {
                    if (valueValue instanceof BigDecimalNodes.Type && selfValue instanceof RubyBasicObject && digitsValue instanceof Integer) {
                        BigDecimalNodes.Type valueValue_ = (BigDecimalNodes.Type)((Object)valueValue);
                        RubyBasicObject selfValue_ = (RubyBasicObject)selfValue;
                        int digitsValue_ = (Integer)digitsValue;
                        if (valueValue_ == BigDecimalNodes.Type.NEGATIVE_ZERO) {
                            return this.root.createNegativeZero(frameValue, valueValue_, selfValue_, digitsValue_);
                        }
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, valueValue, selfValue, digitsValue);
                }

                static BaseNode_ create(CreateBigDecimalNodeGen root) {
                    return new CreateNegativeZeroNode_(root);
                }
            }

            @GeneratedBy(methodName="createNaN(VirtualFrame, Type, RubyBasicObject, int)", value=BigDecimalNodes.CreateBigDecimalNode.class)
            private static final class CreateNaNNode_
            extends BaseNode_ {
                CreateNaNNode_(CreateBigDecimalNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeRubyBasicObject0(frameValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject0(VirtualFrame frameValue) {
                    int digitsValue_;
                    RubyBasicObject selfValue_;
                    BigDecimalNodes.Type valueValue_;
                    try {
                        valueValue_ = CreateBigDecimalNodeGen.expectType(this.root.value_.execute(frameValue));
                    }
                    catch (UnexpectedResultException ex) {
                        Object selfValue = this.root.self_.execute(frameValue);
                        Object digitsValue = this.executeDigits_((Frame)frameValue);
                        return this.getNext().executeRubyBasicObject_(frameValue, ex.getResult(), selfValue, digitsValue);
                    }
                    try {
                        selfValue_ = this.root.self_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object digitsValue = this.executeDigits_((Frame)frameValue);
                        return this.getNext().executeRubyBasicObject_(frameValue, (Object)valueValue_, ex.getResult(), digitsValue);
                    }
                    try {
                        digitsValue_ = this.root.digits_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeRubyBasicObject_(frameValue, (Object)valueValue_, selfValue_, ex.getResult());
                    }
                    if (valueValue_ == BigDecimalNodes.Type.NAN) {
                        return this.root.createNaN(frameValue, valueValue_, selfValue_, digitsValue_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, (Object)valueValue_, selfValue_, digitsValue_);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject1(VirtualFrame frameValue, Object valueValue, RubyBasicObject selfValue, int digitsValue) {
                    BigDecimalNodes.Type valueValue_;
                    if (valueValue instanceof BigDecimalNodes.Type && (valueValue_ = (BigDecimalNodes.Type)((Object)valueValue)) == BigDecimalNodes.Type.NAN) {
                        return this.root.createNaN(frameValue, valueValue_, selfValue, digitsValue);
                    }
                    return this.getNext().executeRubyBasicObject1(frameValue, valueValue, selfValue, digitsValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object valueValue, Object selfValue, Object digitsValue) {
                    if (valueValue instanceof BigDecimalNodes.Type && selfValue instanceof RubyBasicObject && digitsValue instanceof Integer) {
                        BigDecimalNodes.Type valueValue_ = (BigDecimalNodes.Type)((Object)valueValue);
                        RubyBasicObject selfValue_ = (RubyBasicObject)selfValue;
                        int digitsValue_ = (Integer)digitsValue;
                        if (valueValue_ == BigDecimalNodes.Type.NAN) {
                            return this.root.createNaN(frameValue, valueValue_, selfValue_, digitsValue_);
                        }
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, valueValue, selfValue, digitsValue);
                }

                static BaseNode_ create(CreateBigDecimalNodeGen root) {
                    return new CreateNaNNode_(root);
                }
            }

            @GeneratedBy(methodName="createInfinity(VirtualFrame, Type, RubyBasicObject, int)", value=BigDecimalNodes.CreateBigDecimalNode.class)
            private static final class CreateInfinityNode_
            extends BaseNode_ {
                CreateInfinityNode_(CreateBigDecimalNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeRubyBasicObject0(frameValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject0(VirtualFrame frameValue) {
                    int digitsValue_;
                    RubyBasicObject selfValue_;
                    BigDecimalNodes.Type valueValue_;
                    try {
                        valueValue_ = CreateBigDecimalNodeGen.expectType(this.root.value_.execute(frameValue));
                    }
                    catch (UnexpectedResultException ex) {
                        Object selfValue = this.root.self_.execute(frameValue);
                        Object digitsValue = this.executeDigits_((Frame)frameValue);
                        return this.getNext().executeRubyBasicObject_(frameValue, ex.getResult(), selfValue, digitsValue);
                    }
                    try {
                        selfValue_ = this.root.self_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object digitsValue = this.executeDigits_((Frame)frameValue);
                        return this.getNext().executeRubyBasicObject_(frameValue, (Object)valueValue_, ex.getResult(), digitsValue);
                    }
                    try {
                        digitsValue_ = this.root.digits_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeRubyBasicObject_(frameValue, (Object)valueValue_, selfValue_, ex.getResult());
                    }
                    if (valueValue_ == BigDecimalNodes.Type.NEGATIVE_INFINITY || valueValue_ == BigDecimalNodes.Type.POSITIVE_INFINITY) {
                        return this.root.createInfinity(frameValue, valueValue_, selfValue_, digitsValue_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, (Object)valueValue_, selfValue_, digitsValue_);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject1(VirtualFrame frameValue, Object valueValue, RubyBasicObject selfValue, int digitsValue) {
                    BigDecimalNodes.Type valueValue_;
                    if (valueValue instanceof BigDecimalNodes.Type && ((valueValue_ = (BigDecimalNodes.Type)((Object)valueValue)) == BigDecimalNodes.Type.NEGATIVE_INFINITY || valueValue_ == BigDecimalNodes.Type.POSITIVE_INFINITY)) {
                        return this.root.createInfinity(frameValue, valueValue_, selfValue, digitsValue);
                    }
                    return this.getNext().executeRubyBasicObject1(frameValue, valueValue, selfValue, digitsValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object valueValue, Object selfValue, Object digitsValue) {
                    if (valueValue instanceof BigDecimalNodes.Type && selfValue instanceof RubyBasicObject && digitsValue instanceof Integer) {
                        BigDecimalNodes.Type valueValue_ = (BigDecimalNodes.Type)((Object)valueValue);
                        RubyBasicObject selfValue_ = (RubyBasicObject)selfValue;
                        int digitsValue_ = (Integer)digitsValue;
                        if (valueValue_ == BigDecimalNodes.Type.NEGATIVE_INFINITY || valueValue_ == BigDecimalNodes.Type.POSITIVE_INFINITY) {
                            return this.root.createInfinity(frameValue, valueValue_, selfValue_, digitsValue_);
                        }
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, valueValue, selfValue, digitsValue);
                }

                static BaseNode_ create(CreateBigDecimalNodeGen root) {
                    return new CreateInfinityNode_(root);
                }
            }

            @GeneratedBy(methodName="create(VirtualFrame, double, RubyBasicObject, int)", value=BigDecimalNodes.CreateBigDecimalNode.class)
            private static final class Create1Node_
            extends BaseNode_ {
                Create1Node_(CreateBigDecimalNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeRubyBasicObject0(frameValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject0(VirtualFrame frameValue) {
                    int digitsValue_;
                    RubyBasicObject selfValue_;
                    double valueValue_;
                    try {
                        valueValue_ = this.root.value_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object selfValue = this.root.self_.execute(frameValue);
                        Object digitsValue = this.executeDigits_((Frame)frameValue);
                        return this.getNext().executeRubyBasicObject_(frameValue, ex.getResult(), selfValue, digitsValue);
                    }
                    try {
                        selfValue_ = this.root.self_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object digitsValue = this.executeDigits_((Frame)frameValue);
                        return this.getNext().executeRubyBasicObject_(frameValue, valueValue_, ex.getResult(), digitsValue);
                    }
                    try {
                        digitsValue_ = this.root.digits_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeRubyBasicObject_(frameValue, valueValue_, selfValue_, ex.getResult());
                    }
                    return this.root.create(frameValue, valueValue_, selfValue_, digitsValue_);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject1(VirtualFrame frameValue, Object valueValue, RubyBasicObject selfValue, int digitsValue) {
                    if (valueValue instanceof Double) {
                        double valueValue_ = (Double)valueValue;
                        return this.root.create(frameValue, valueValue_, selfValue, digitsValue);
                    }
                    return this.getNext().executeRubyBasicObject1(frameValue, valueValue, selfValue, digitsValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object valueValue, Object selfValue, Object digitsValue) {
                    if (valueValue instanceof Double && selfValue instanceof RubyBasicObject && digitsValue instanceof Integer) {
                        double valueValue_ = (Double)valueValue;
                        RubyBasicObject selfValue_ = (RubyBasicObject)selfValue;
                        int digitsValue_ = (Integer)digitsValue;
                        return this.root.create(frameValue, valueValue_, selfValue_, digitsValue_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, valueValue, selfValue, digitsValue);
                }

                static BaseNode_ create(CreateBigDecimalNodeGen root) {
                    return new Create1Node_(root);
                }
            }

            @GeneratedBy(methodName="create(VirtualFrame, long, RubyBasicObject, int)", value=BigDecimalNodes.CreateBigDecimalNode.class)
            private static final class Create0Node_
            extends BaseNode_ {
                private final Class<?> valueImplicitType;

                Create0Node_(CreateBigDecimalNodeGen root, Object valueValue) {
                    super(root, 1);
                    this.valueImplicitType = RubyTypesGen.getImplicitLongClass(valueValue);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.valueImplicitType == ((Create0Node_)other).valueImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeRubyBasicObject0(frameValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject0(VirtualFrame frameValue) {
                    int digitsValue_;
                    RubyBasicObject selfValue_;
                    long valueValue_;
                    block8: {
                        try {
                            if (this.valueImplicitType == Long.TYPE) {
                                valueValue_ = this.root.value_.executeLong(frameValue);
                                break block8;
                            }
                            if (this.valueImplicitType == Integer.TYPE) {
                                valueValue_ = RubyTypes.int2long(this.root.value_.executeInteger(frameValue));
                                break block8;
                            }
                            Object valueValue__ = this.executeValue_((Frame)frameValue);
                            throw new UnexpectedResultException(valueValue__);
                        }
                        catch (UnexpectedResultException ex) {
                            Object selfValue = this.root.self_.execute(frameValue);
                            Object digitsValue = this.executeDigits_((Frame)frameValue);
                            return this.getNext().executeRubyBasicObject_(frameValue, ex.getResult(), selfValue, digitsValue);
                        }
                    }
                    try {
                        selfValue_ = this.root.self_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object digitsValue = this.executeDigits_((Frame)frameValue);
                        return this.getNext().executeRubyBasicObject_(frameValue, valueValue_, ex.getResult(), digitsValue);
                    }
                    try {
                        digitsValue_ = this.root.digits_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeRubyBasicObject_(frameValue, valueValue_, selfValue_, ex.getResult());
                    }
                    return this.root.create(frameValue, valueValue_, selfValue_, digitsValue_);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject1(VirtualFrame frameValue, Object valueValue, RubyBasicObject selfValue, int digitsValue) {
                    if (RubyTypesGen.isImplicitLong(valueValue, this.valueImplicitType)) {
                        long valueValue_ = RubyTypesGen.asImplicitLong(valueValue, this.valueImplicitType);
                        return this.root.create(frameValue, valueValue_, selfValue, digitsValue);
                    }
                    return this.getNext().executeRubyBasicObject1(frameValue, valueValue, selfValue, digitsValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object valueValue, Object selfValue, Object digitsValue) {
                    if (RubyTypesGen.isImplicitLong(valueValue, this.valueImplicitType) && selfValue instanceof RubyBasicObject && digitsValue instanceof Integer) {
                        long valueValue_ = RubyTypesGen.asImplicitLong(valueValue, this.valueImplicitType);
                        RubyBasicObject selfValue_ = (RubyBasicObject)selfValue;
                        int digitsValue_ = (Integer)digitsValue;
                        return this.root.create(frameValue, valueValue_, selfValue_, digitsValue_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, valueValue, selfValue, digitsValue);
                }

                static BaseNode_ create(CreateBigDecimalNodeGen root, Object valueValue) {
                    return new Create0Node_(root, valueValue);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.CreateBigDecimalNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(CreateBigDecimalNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object valueValue, Object selfValue, Object digitsValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, valueValue, selfValue, digitsValue));
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object valueValue, Object selfValue, Object digitsValue) {
                    return this.getNext().executeRubyBasicObject_(frameValue, valueValue, selfValue, digitsValue);
                }

                static BaseNode_ create(CreateBigDecimalNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.CreateBigDecimalNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(CreateBigDecimalNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object valueValue, Object selfValue, Object digitsValue) {
                    return (RubyBasicObject)this.uninitialized((Frame)frameValue, valueValue, selfValue, digitsValue);
                }

                static BaseNode_ create(CreateBigDecimalNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BigDecimalNodes.CreateBigDecimalNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final CreateBigDecimalNodeGen root;

                BaseNode_(CreateBigDecimalNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.value_, this.root.self_, this.root.digits_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object valueValue, Object selfValue, Object digitsValue) {
                    return this.executeRubyBasicObject_((VirtualFrame)frameValue, valueValue, selfValue, digitsValue);
                }

                public abstract RubyBasicObject executeRubyBasicObject_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public RubyBasicObject executeRubyBasicObject1(VirtualFrame frameValue, Object valueValue, RubyBasicObject selfValue, int digitsValue) {
                    return this.executeRubyBasicObject_(frameValue, valueValue, selfValue, digitsValue);
                }

                public Object execute(VirtualFrame frameValue) {
                    Object valueValue_ = this.executeValue_((Frame)frameValue);
                    Object selfValue_ = this.root.self_.execute(frameValue);
                    Object digitsValue_ = this.executeDigits_((Frame)frameValue);
                    return this.executeRubyBasicObject_(frameValue, valueValue_, selfValue_, digitsValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public RubyBasicObject executeRubyBasicObject0(VirtualFrame frameValue) {
                    return (RubyBasicObject)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object valueValue, Object selfValue, Object digitsValue) {
                    if (selfValue instanceof RubyBasicObject && digitsValue instanceof Integer) {
                        Object valueValue_;
                        if (RubyTypesGen.isImplicitLong(valueValue)) {
                            return Create0Node_.create(this.root, valueValue);
                        }
                        if (valueValue instanceof Double) {
                            return Create1Node_.create(this.root);
                        }
                        if (valueValue instanceof BigDecimalNodes.Type) {
                            valueValue_ = (BigDecimalNodes.Type)((Object)valueValue);
                            if (valueValue_ == BigDecimalNodes.Type.NEGATIVE_INFINITY || valueValue_ == BigDecimalNodes.Type.POSITIVE_INFINITY) {
                                return CreateInfinityNode_.create(this.root);
                            }
                            if (valueValue_ == BigDecimalNodes.Type.NAN) {
                                return CreateNaNNode_.create(this.root);
                            }
                            if (valueValue_ == BigDecimalNodes.Type.NEGATIVE_ZERO) {
                                return CreateNegativeZeroNode_.create(this.root);
                            }
                        }
                        if (valueValue instanceof BigDecimal) {
                            return Create2Node_.create(this.root);
                        }
                        if (valueValue instanceof RubyBasicObject) {
                            valueValue_ = (RubyBasicObject)valueValue;
                            if (RubyGuards.isRubyBignum((RubyBasicObject)valueValue_)) {
                                return CreateBignumNode_.create(this.root);
                            }
                            if (RubyGuards.isRubyBigDecimal((RubyBasicObject)valueValue_)) {
                                return CreateBigDecimalNode_.create(this.root);
                            }
                            if (RubyGuards.isRubyString((RubyBasicObject)valueValue_)) {
                                return CreateStringNode_.create(this.root);
                            }
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeValue_(Frame frameValue) {
                    Object object;
                    Class valueType_ = this.root.valueType_;
                    if (valueType_ == Double.TYPE) {
                        return this.root.value_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (valueType_ == Integer.TYPE) {
                        return this.root.value_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (valueType_ == Long.TYPE) {
                        return this.root.value_.executeLong((VirtualFrame)frameValue);
                    }
                    if (valueType_ != null) return this.root.value_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.value_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.valueType_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.valueType_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.valueType_ = _type;
                    return object;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeDigits_(Frame frameValue) {
                    Object object;
                    Class digitsType_ = this.root.digitsType_;
                    if (digitsType_ == Integer.TYPE) {
                        return this.root.digits_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (digitsType_ != null) return this.root.digits_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.digits_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.digitsType_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.digitsType_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.digitsType_ = _type;
                    return object;
                }
            }
        }
    }
}

