/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.runtime.core.RubyBasicObject;

public class ArrayGuards {
    public static boolean isNullArray(RubyBasicObject array) {
        assert (RubyGuards.isRubyArray(array));
        return ArrayNodes.getStore(array) == null;
    }

    public static boolean isIntArray(RubyBasicObject array) {
        assert (RubyGuards.isRubyArray(array));
        return ArrayNodes.getStore(array) instanceof int[];
    }

    public static boolean isLongArray(RubyBasicObject array) {
        assert (RubyGuards.isRubyArray(array));
        return ArrayNodes.getStore(array) instanceof long[];
    }

    public static boolean isDoubleArray(RubyBasicObject array) {
        assert (RubyGuards.isRubyArray(array));
        return ArrayNodes.getStore(array) instanceof double[];
    }

    public static boolean isObjectArray(RubyBasicObject array) {
        assert (RubyGuards.isRubyArray(array));
        return ArrayNodes.getStore(array) instanceof Object[];
    }

    public static boolean isEmptyArray(RubyBasicObject array) {
        assert (RubyGuards.isRubyArray(array));
        return ArrayNodes.getSize(array) == 0;
    }
}

