/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypes;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.StringGuards;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyRange;

@GeneratedBy(value=StringNodes.class)
public final class StringNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(AddNodeFactory.getInstance(), MulNodeFactory.getInstance(), EqualNodeFactory.getInstance(), CompareNodeFactory.getInstance(), ConcatNodeFactory.getInstance(), GetIndexNodeFactory.getInstance(), ASCIIOnlyNodeFactory.getInstance(), BNodeFactory.getInstance(), BytesNodeFactory.getInstance(), ByteSizeNodeFactory.getInstance(), CaseCmpNodeFactory.getInstance(), ChopBangNodeFactory.getInstance(), CountNodeFactory.getInstance(), CryptNodeFactory.getInstance(), DataNodeFactory.getInstance(), DeleteBangNodeFactory.getInstance(), DowncaseNodeFactory.getInstance(), DowncaseBangNodeFactory.getInstance(), EachByteNodeFactory.getInstance(), EachCharNodeFactory.getInstance(), EmptyNodeFactory.getInstance(), EncodingNodeFactory.getInstance(), ForceEncodingNodeFactory.getInstance(), GetByteNodeFactory.getInstance(), HashNodeFactory.getInstance(), InspectNodeFactory.getInstance(), InitializeNodeFactory.getInstance(), InitializeCopyNodeFactory.getInstance(), InsertNodeFactory.getInstance(), LstripBangNodeFactory.getInstance(), ModifyBangNodeFactory.getInstance(), SetNumBytesNodeFactory.getInstance(), OrdNodeFactory.getInstance(), ReplaceNodeFactory.getInstance(), RstripBangNodeFactory.getInstance(), SwapcaseBangNodeFactory.getInstance(), DumpNodeFactory.getInstance(), SetByteNodeFactory.getInstance(), SizeNodeFactory.getInstance(), SqueezeBangNodeFactory.getInstance(), SuccNodeFactory.getInstance(), SuccBangNodeFactory.getInstance(), SumNodeFactory.getInstance(), ToFNodeFactory.getInstance(), ToSNodeFactory.getInstance(), ToSymNodeFactory.getInstance(), ReverseBangNodeFactory.getInstance(), TrBangNodeFactory.getInstance(), TrSBangNodeFactory.getInstance(), UnpackNodeFactory.getInstance(), UpcaseNodeFactory.getInstance(), UpcaseBangNodeFactory.getInstance(), ValidEncodingQueryNodeFactory.getInstance(), CapitalizeBangNodeFactory.getInstance(), CapitalizeNodeFactory.getInstance(), ClearNodeFactory.getInstance());
    }

    @GeneratedBy(value=StringNodes.ClearNode.class)
    public static final class ClearNodeFactory
    extends NodeFactoryBase<StringNodes.ClearNode> {
        private static ClearNodeFactory clearNodeFactoryInstance;

        private ClearNodeFactory() {
            super(StringNodes.ClearNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.ClearNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ClearNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.ClearNode> getInstance() {
            if (clearNodeFactoryInstance == null) {
                clearNodeFactoryInstance = new ClearNodeFactory();
            }
            return clearNodeFactoryInstance;
        }

        public static StringNodes.ClearNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ClearNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.ClearNode.class)
        public static final class ClearNodeGen
        extends StringNodes.ClearNode {
            @Node.Child
            private RubyNode arguments0_;

            private ClearNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.clear(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=StringNodes.CapitalizeNode.class)
    public static final class CapitalizeNodeFactory
    extends NodeFactoryBase<StringNodes.CapitalizeNode> {
        private static CapitalizeNodeFactory capitalizeNodeFactoryInstance;

        private CapitalizeNodeFactory() {
            super(StringNodes.CapitalizeNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.CapitalizeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CapitalizeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.CapitalizeNode> getInstance() {
            if (capitalizeNodeFactoryInstance == null) {
                capitalizeNodeFactoryInstance = new CapitalizeNodeFactory();
            }
            return capitalizeNodeFactoryInstance;
        }

        public static StringNodes.CapitalizeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new CapitalizeNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.CapitalizeNode.class)
        public static final class CapitalizeNodeGen
        extends StringNodes.CapitalizeNode {
            @Node.Child
            private RubyNode arguments0_;

            private CapitalizeNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.capitalize(frameValue, arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=StringNodes.CapitalizeBangNode.class)
    public static final class CapitalizeBangNodeFactory
    extends NodeFactoryBase<StringNodes.CapitalizeBangNode> {
        private static CapitalizeBangNodeFactory capitalizeBangNodeFactoryInstance;

        private CapitalizeBangNodeFactory() {
            super(StringNodes.CapitalizeBangNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.CapitalizeBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CapitalizeBangNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.CapitalizeBangNode> getInstance() {
            if (capitalizeBangNodeFactoryInstance == null) {
                capitalizeBangNodeFactoryInstance = new CapitalizeBangNodeFactory();
            }
            return capitalizeBangNodeFactoryInstance;
        }

        public static StringNodes.CapitalizeBangNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new CapitalizeBangNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.CapitalizeBangNode.class)
        public static final class CapitalizeBangNodeGen
        extends StringNodes.CapitalizeBangNode {
            @Node.Child
            private RubyNode arguments0_;

            private CapitalizeBangNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.capitalizeBang(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=StringNodes.ValidEncodingQueryNode.class)
    public static final class ValidEncodingQueryNodeFactory
    extends NodeFactoryBase<StringNodes.ValidEncodingQueryNode> {
        private static ValidEncodingQueryNodeFactory validEncodingQueryNodeFactoryInstance;

        private ValidEncodingQueryNodeFactory() {
            super(StringNodes.ValidEncodingQueryNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.ValidEncodingQueryNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ValidEncodingQueryNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.ValidEncodingQueryNode> getInstance() {
            if (validEncodingQueryNodeFactoryInstance == null) {
                validEncodingQueryNodeFactoryInstance = new ValidEncodingQueryNodeFactory();
            }
            return validEncodingQueryNodeFactoryInstance;
        }

        public static StringNodes.ValidEncodingQueryNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ValidEncodingQueryNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.ValidEncodingQueryNode.class)
        public static final class ValidEncodingQueryNodeGen
        extends StringNodes.ValidEncodingQueryNode {
            @Node.Child
            private RubyNode arguments0_;

            private ValidEncodingQueryNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.validEncodingQuery(arguments0Value_);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=StringNodes.UpcaseBangNode.class)
    public static final class UpcaseBangNodeFactory
    extends NodeFactoryBase<StringNodes.UpcaseBangNode> {
        private static UpcaseBangNodeFactory upcaseBangNodeFactoryInstance;

        private UpcaseBangNodeFactory() {
            super(StringNodes.UpcaseBangNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.UpcaseBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return UpcaseBangNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.UpcaseBangNode> getInstance() {
            if (upcaseBangNodeFactoryInstance == null) {
                upcaseBangNodeFactoryInstance = new UpcaseBangNodeFactory();
            }
            return upcaseBangNodeFactoryInstance;
        }

        public static StringNodes.UpcaseBangNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new UpcaseBangNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.UpcaseBangNode.class)
        public static final class UpcaseBangNodeGen
        extends StringNodes.UpcaseBangNode {
            @Node.Child
            private RubyNode arguments0_;

            private UpcaseBangNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.upcaseBang(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=StringNodes.UpcaseNode.class)
    public static final class UpcaseNodeFactory
    extends NodeFactoryBase<StringNodes.UpcaseNode> {
        private static UpcaseNodeFactory upcaseNodeFactoryInstance;

        private UpcaseNodeFactory() {
            super(StringNodes.UpcaseNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.UpcaseNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return UpcaseNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.UpcaseNode> getInstance() {
            if (upcaseNodeFactoryInstance == null) {
                upcaseNodeFactoryInstance = new UpcaseNodeFactory();
            }
            return upcaseNodeFactoryInstance;
        }

        public static StringNodes.UpcaseNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new UpcaseNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.UpcaseNode.class)
        public static final class UpcaseNodeGen
        extends StringNodes.UpcaseNode {
            @Node.Child
            private RubyNode arguments0_;

            private UpcaseNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.upcase(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=StringNodes.UnpackNode.class)
    public static final class UnpackNodeFactory
    extends NodeFactoryBase<StringNodes.UnpackNode> {
        private static UnpackNodeFactory unpackNodeFactoryInstance;

        private UnpackNodeFactory() {
            super(StringNodes.UnpackNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.UnpackNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return UnpackNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.UnpackNode> getInstance() {
            if (unpackNodeFactoryInstance == null) {
                unpackNodeFactoryInstance = new UnpackNodeFactory();
            }
            return unpackNodeFactoryInstance;
        }

        public static StringNodes.UnpackNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new UnpackNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.UnpackNode.class)
        public static final class UnpackNodeGen
        extends StringNodes.UnpackNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;

            private UnpackNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments1Value_;
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                if (RubyGuards.isRubyString(arguments1Value_)) {
                    return this.unpack(arguments0Value_, arguments1Value_);
                }
                throw this.unsupported(arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
        }
    }

    @GeneratedBy(value=StringNodes.TrSBangNode.class)
    public static final class TrSBangNodeFactory
    extends NodeFactoryBase<StringNodes.TrSBangNode> {
        private static TrSBangNodeFactory trSBangNodeFactoryInstance;

        private TrSBangNodeFactory() {
            super(StringNodes.TrSBangNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class, RubyNode.class}});
        }

        public StringNodes.TrSBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 5 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode))) {
                return TrSBangNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]), (RubyNode)((Object)arguments[4]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.TrSBangNode> getInstance() {
            if (trSBangNodeFactoryInstance == null) {
                trSBangNodeFactoryInstance = new TrSBangNodeFactory();
            }
            return trSBangNodeFactoryInstance;
        }

        public static StringNodes.TrSBangNode create(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode fromStr, RubyNode toStrNode) {
            return new TrSBangNodeGen(context, sourceSection, self, fromStr, toStrNode);
        }

        @GeneratedBy(value=StringNodes.TrSBangNode.class)
        public static final class TrSBangNodeGen
        extends StringNodes.TrSBangNode {
            @Node.Child
            private RubyNode self_;
            @Node.Child
            private RubyNode fromStr_;
            @Node.Child
            private RubyNode toStrNode_;

            private TrSBangNodeGen(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode fromStr, RubyNode toStrNode) {
                super(context, sourceSection);
                this.self_ = self;
                this.fromStr_ = this.coerceFromStrToString(fromStr);
                this.toStrNode_ = this.coerceToStrToString(toStrNode);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject toStrNodeValue_;
                RubyBasicObject fromStrValue_;
                RubyBasicObject selfValue_;
                try {
                    selfValue_ = this.self_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object fromStrValue = this.fromStr_.execute(frameValue);
                    Object toStrNodeValue = this.toStrNode_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), fromStrValue, toStrNodeValue);
                }
                try {
                    fromStrValue_ = this.fromStr_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object toStrNodeValue = this.toStrNode_.execute(frameValue);
                    throw this.unsupported(selfValue_, ex.getResult(), toStrNodeValue);
                }
                try {
                    toStrNodeValue_ = this.toStrNode_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(selfValue_, fromStrValue_, ex.getResult());
                }
                if (RubyGuards.isRubyString(fromStrValue_) && RubyGuards.isRubyString(toStrNodeValue_)) {
                    return this.trSBang(frameValue, selfValue_, fromStrValue_, toStrNodeValue_);
                }
                throw this.unsupported(selfValue_, fromStrValue_, toStrNodeValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object selfValue, Object fromStrValue, Object toStrNodeValue) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.self_, this.fromStr_, this.toStrNode_}, new Object[]{selfValue, fromStrValue, toStrNodeValue});
            }
        }
    }

    @GeneratedBy(value=StringNodes.TrBangNode.class)
    public static final class TrBangNodeFactory
    extends NodeFactoryBase<StringNodes.TrBangNode> {
        private static TrBangNodeFactory trBangNodeFactoryInstance;

        private TrBangNodeFactory() {
            super(StringNodes.TrBangNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class, RubyNode.class}});
        }

        public StringNodes.TrBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 5 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode))) {
                return TrBangNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]), (RubyNode)((Object)arguments[4]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.TrBangNode> getInstance() {
            if (trBangNodeFactoryInstance == null) {
                trBangNodeFactoryInstance = new TrBangNodeFactory();
            }
            return trBangNodeFactoryInstance;
        }

        public static StringNodes.TrBangNode create(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode fromStr, RubyNode toStrNode) {
            return new TrBangNodeGen(context, sourceSection, self, fromStr, toStrNode);
        }

        @GeneratedBy(value=StringNodes.TrBangNode.class)
        public static final class TrBangNodeGen
        extends StringNodes.TrBangNode {
            @Node.Child
            private RubyNode self_;
            @Node.Child
            private RubyNode fromStr_;
            @Node.Child
            private RubyNode toStrNode_;

            private TrBangNodeGen(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode fromStr, RubyNode toStrNode) {
                super(context, sourceSection);
                this.self_ = self;
                this.fromStr_ = this.coerceFromStrToString(fromStr);
                this.toStrNode_ = this.coerceToStrToString(toStrNode);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject toStrNodeValue_;
                RubyBasicObject fromStrValue_;
                RubyBasicObject selfValue_;
                try {
                    selfValue_ = this.self_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object fromStrValue = this.fromStr_.execute(frameValue);
                    Object toStrNodeValue = this.toStrNode_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), fromStrValue, toStrNodeValue);
                }
                try {
                    fromStrValue_ = this.fromStr_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object toStrNodeValue = this.toStrNode_.execute(frameValue);
                    throw this.unsupported(selfValue_, ex.getResult(), toStrNodeValue);
                }
                try {
                    toStrNodeValue_ = this.toStrNode_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(selfValue_, fromStrValue_, ex.getResult());
                }
                if (RubyGuards.isRubyString(fromStrValue_) && RubyGuards.isRubyString(toStrNodeValue_)) {
                    return this.trBang(frameValue, selfValue_, fromStrValue_, toStrNodeValue_);
                }
                throw this.unsupported(selfValue_, fromStrValue_, toStrNodeValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object selfValue, Object fromStrValue, Object toStrNodeValue) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.self_, this.fromStr_, this.toStrNode_}, new Object[]{selfValue, fromStrValue, toStrNodeValue});
            }
        }
    }

    @GeneratedBy(value=StringNodes.ReverseBangNode.class)
    public static final class ReverseBangNodeFactory
    extends NodeFactoryBase<StringNodes.ReverseBangNode> {
        private static ReverseBangNodeFactory reverseBangNodeFactoryInstance;

        private ReverseBangNodeFactory() {
            super(StringNodes.ReverseBangNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.ReverseBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ReverseBangNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.ReverseBangNode> getInstance() {
            if (reverseBangNodeFactoryInstance == null) {
                reverseBangNodeFactoryInstance = new ReverseBangNodeFactory();
            }
            return reverseBangNodeFactoryInstance;
        }

        public static StringNodes.ReverseBangNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ReverseBangNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.ReverseBangNode.class)
        public static final class ReverseBangNodeGen
        extends StringNodes.ReverseBangNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private ReverseBangNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="reverse(RubyBasicObject)", value=StringNodes.ReverseBangNode.class)
            private static final class ReverseNode_
            extends BaseNode_ {
                ReverseNode_(ReverseBangNodeGen root) {
                    super(root, 3);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && !StringNodes.ReverseBangNode.reverseIsEqualToSelf(arguments0Value_ = (RubyBasicObject)arguments0Value) && !StringGuards.isSingleByteOptimizable(arguments0Value_)) {
                        return this.root.reverse(arguments0Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ReverseBangNodeGen root) {
                    return new ReverseNode_(root);
                }
            }

            @GeneratedBy(methodName="reverseSingleByteOptimizable(RubyBasicObject)", value=StringNodes.ReverseBangNode.class)
            private static final class ReverseSingleByteOptimizableNode_
            extends BaseNode_ {
                ReverseSingleByteOptimizableNode_(ReverseBangNodeGen root) {
                    super(root, 2);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && !StringNodes.ReverseBangNode.reverseIsEqualToSelf(arguments0Value_ = (RubyBasicObject)arguments0Value) && StringGuards.isSingleByteOptimizable(arguments0Value_)) {
                        return this.root.reverseSingleByteOptimizable(arguments0Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ReverseBangNodeGen root) {
                    return new ReverseSingleByteOptimizableNode_(root);
                }
            }

            @GeneratedBy(methodName="reverseNoOp(RubyBasicObject)", value=StringNodes.ReverseBangNode.class)
            private static final class ReverseNoOpNode_
            extends BaseNode_ {
                ReverseNoOpNode_(ReverseBangNodeGen root) {
                    super(root, 1);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && StringNodes.ReverseBangNode.reverseIsEqualToSelf(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.reverseNoOp(arguments0Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ReverseBangNodeGen root) {
                    return new ReverseNoOpNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.ReverseBangNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ReverseBangNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ReverseBangNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.ReverseBangNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ReverseBangNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return (RubyBasicObject)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ReverseBangNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.ReverseBangNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final ReverseBangNodeGen root;

                BaseNode_(ReverseBangNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeRubyBasicObject_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract RubyBasicObject executeRubyBasicObject_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeRubyBasicObject_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (StringNodes.ReverseBangNode.reverseIsEqualToSelf(arguments0Value_)) {
                            return ReverseNoOpNode_.create(this.root);
                        }
                        if (StringGuards.isSingleByteOptimizable(arguments0Value_)) {
                            return ReverseSingleByteOptimizableNode_.create(this.root);
                        }
                        if (!StringNodes.ReverseBangNode.reverseIsEqualToSelf(arguments0Value_) && !StringGuards.isSingleByteOptimizable(arguments0Value_)) {
                            return ReverseNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.ToSymNode.class)
    public static final class ToSymNodeFactory
    extends NodeFactoryBase<StringNodes.ToSymNode> {
        private static ToSymNodeFactory toSymNodeFactoryInstance;

        private ToSymNodeFactory() {
            super(StringNodes.ToSymNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.ToSymNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToSymNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.ToSymNode> getInstance() {
            if (toSymNodeFactoryInstance == null) {
                toSymNodeFactoryInstance = new ToSymNodeFactory();
            }
            return toSymNodeFactoryInstance;
        }

        public static StringNodes.ToSymNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ToSymNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.ToSymNode.class)
        public static final class ToSymNodeGen
        extends StringNodes.ToSymNode {
            @Node.Child
            private RubyNode arguments0_;

            private ToSymNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.toSym(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=StringNodes.ToSNode.class)
    public static final class ToSNodeFactory
    extends NodeFactoryBase<StringNodes.ToSNode> {
        private static ToSNodeFactory toSNodeFactoryInstance;

        private ToSNodeFactory() {
            super(StringNodes.ToSNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.ToSNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToSNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.ToSNode> getInstance() {
            if (toSNodeFactoryInstance == null) {
                toSNodeFactoryInstance = new ToSNodeFactory();
            }
            return toSNodeFactoryInstance;
        }

        public static StringNodes.ToSNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ToSNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.ToSNode.class)
        public static final class ToSNodeGen
        extends StringNodes.ToSNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private ToSNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="toSOnSubclass(VirtualFrame, RubyBasicObject)", value=StringNodes.ToSNode.class)
            private static final class ToSOnSubclassNode_
            extends BaseNode_ {
                ToSOnSubclassNode_(ToSNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && this.root.isStringSubclass(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.toSOnSubclass(frameValue, arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ToSNodeGen root) {
                    return new ToSOnSubclassNode_(root);
                }
            }

            @GeneratedBy(methodName="toS(RubyBasicObject)", value=StringNodes.ToSNode.class)
            private static final class ToSNode_
            extends BaseNode_ {
                ToSNode_(ToSNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && !this.root.isStringSubclass(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.toS(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ToSNodeGen root) {
                    return new ToSNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.ToSNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ToSNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ToSNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.ToSNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ToSNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ToSNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.ToSNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final ToSNodeGen root;

                BaseNode_(ToSNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (!this.root.isStringSubclass(arguments0Value_)) {
                            return ToSNode_.create(this.root);
                        }
                        return ToSOnSubclassNode_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.ToFNode.class)
    public static final class ToFNodeFactory
    extends NodeFactoryBase<StringNodes.ToFNode> {
        private static ToFNodeFactory toFNodeFactoryInstance;

        private ToFNodeFactory() {
            super(StringNodes.ToFNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.ToFNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToFNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.ToFNode> getInstance() {
            if (toFNodeFactoryInstance == null) {
                toFNodeFactoryInstance = new ToFNodeFactory();
            }
            return toFNodeFactoryInstance;
        }

        public static StringNodes.ToFNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ToFNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.ToFNode.class)
        public static final class ToFNodeGen
        extends StringNodes.ToFNode {
            @Node.Child
            private RubyNode arguments0_;

            private ToFNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeDouble(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeDouble(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.toF(arguments0Value_);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=StringNodes.SumNode.class)
    public static final class SumNodeFactory
    extends NodeFactoryBase<StringNodes.SumNode> {
        private static SumNodeFactory sumNodeFactoryInstance;

        private SumNodeFactory() {
            super(StringNodes.SumNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.SumNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SumNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.SumNode> getInstance() {
            if (sumNodeFactoryInstance == null) {
                sumNodeFactoryInstance = new SumNodeFactory();
            }
            return sumNodeFactoryInstance;
        }

        public static StringNodes.SumNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SumNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.SumNode.class)
        public static final class SumNodeGen
        extends StringNodes.SumNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private SumNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="sum(VirtualFrame, RubyBasicObject, Object)", value=StringNodes.SumNode.class)
            private static final class Sum3Node_
            extends BaseNode_ {
                Sum3Node_(SumNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (!RubyGuards.isInteger(arguments1Value) && !RubyGuards.isLong(arguments1Value) && RubyGuards.wasProvided(arguments1Value)) {
                            return this.root.sum(frameValue, arguments0Value_, arguments1Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SumNodeGen root) {
                    return new Sum3Node_(root);
                }
            }

            @GeneratedBy(methodName="sum(VirtualFrame, RubyBasicObject, NotProvided)", value=StringNodes.SumNode.class)
            private static final class Sum2Node_
            extends BaseNode_ {
                Sum2Node_(SumNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof NotProvided) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        return this.root.sum(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SumNodeGen root) {
                    return new Sum2Node_(root);
                }
            }

            @GeneratedBy(methodName="sum(VirtualFrame, RubyBasicObject, long)", value=StringNodes.SumNode.class)
            private static final class Sum1Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Sum1Node_(SumNodeGen root, Object arguments1Value) {
                    super(root, 2);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Sum1Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    long arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    block6: {
                        try {
                            arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                        }
                        catch (UnexpectedResultException ex) {
                            Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                            return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                        }
                        try {
                            if (this.arguments1ImplicitType == Long.TYPE) {
                                arguments1Value_ = this.root.arguments1_.executeLong(frameValue);
                                break block6;
                            }
                            if (this.arguments1ImplicitType == Integer.TYPE) {
                                arguments1Value_ = RubyTypes.int2long(this.root.arguments1_.executeInteger(frameValue));
                                break block6;
                            }
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            throw new UnexpectedResultException(arguments1Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                        }
                    }
                    return this.root.sum(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.sum(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SumNodeGen root, Object arguments1Value) {
                    return new Sum1Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="sum(VirtualFrame, RubyBasicObject, int)", value=StringNodes.SumNode.class)
            private static final class Sum0Node_
            extends BaseNode_ {
                Sum0Node_(SumNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.sum(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof Integer) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.sum(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SumNodeGen root) {
                    return new Sum0Node_(root);
                }
            }

            @GeneratedBy(value=StringNodes.SumNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SumNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SumNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.SumNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SumNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SumNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.SumNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final SumNodeGen root;

                BaseNode_(SumNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        if (arguments1Value instanceof Integer) {
                            return Sum0Node_.create(this.root);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Sum1Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof NotProvided) {
                            return Sum2Node_.create(this.root);
                        }
                        if (!RubyGuards.isInteger(arguments1Value) && !RubyGuards.isLong(arguments1Value) && RubyGuards.wasProvided(arguments1Value)) {
                            return Sum3Node_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.SuccBangNode.class)
    public static final class SuccBangNodeFactory
    extends NodeFactoryBase<StringNodes.SuccBangNode> {
        private static SuccBangNodeFactory succBangNodeFactoryInstance;

        private SuccBangNodeFactory() {
            super(StringNodes.SuccBangNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.SuccBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SuccBangNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.SuccBangNode> getInstance() {
            if (succBangNodeFactoryInstance == null) {
                succBangNodeFactoryInstance = new SuccBangNodeFactory();
            }
            return succBangNodeFactoryInstance;
        }

        public static StringNodes.SuccBangNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SuccBangNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.SuccBangNode.class)
        public static final class SuccBangNodeGen
        extends StringNodes.SuccBangNode {
            @Node.Child
            private RubyNode arguments0_;

            private SuccBangNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.succBang(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=StringNodes.SuccNode.class)
    public static final class SuccNodeFactory
    extends NodeFactoryBase<StringNodes.SuccNode> {
        private static SuccNodeFactory succNodeFactoryInstance;

        private SuccNodeFactory() {
            super(StringNodes.SuccNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.SuccNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SuccNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.SuccNode> getInstance() {
            if (succNodeFactoryInstance == null) {
                succNodeFactoryInstance = new SuccNodeFactory();
            }
            return succNodeFactoryInstance;
        }

        public static StringNodes.SuccNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SuccNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.SuccNode.class)
        public static final class SuccNodeGen
        extends StringNodes.SuccNode {
            @Node.Child
            private RubyNode arguments0_;

            private SuccNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.succ(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=StringNodes.SqueezeBangNode.class)
    public static final class SqueezeBangNodeFactory
    extends NodeFactoryBase<StringNodes.SqueezeBangNode> {
        private static SqueezeBangNodeFactory squeezeBangNodeFactoryInstance;

        private SqueezeBangNodeFactory() {
            super(StringNodes.SqueezeBangNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.SqueezeBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SqueezeBangNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.SqueezeBangNode> getInstance() {
            if (squeezeBangNodeFactoryInstance == null) {
                squeezeBangNodeFactoryInstance = new SqueezeBangNodeFactory();
            }
            return squeezeBangNodeFactoryInstance;
        }

        public static StringNodes.SqueezeBangNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SqueezeBangNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.SqueezeBangNode.class)
        public static final class SqueezeBangNodeGen
        extends StringNodes.SqueezeBangNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private SqueezeBangNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="squeezeBang(VirtualFrame, RubyBasicObject, Object[])", value=StringNodes.SqueezeBangNode.class)
            private static final class SqueezeBangNode_
            extends BaseNode_ {
                SqueezeBangNode_(SqueezeBangNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof Object[]) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        if (!StringNodes.SqueezeBangNode.zeroArgs(arguments1Value_)) {
                            return this.root.squeezeBang(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SqueezeBangNodeGen root) {
                    return new SqueezeBangNode_(root);
                }
            }

            @GeneratedBy(methodName="squeezeBangZeroArgs(RubyBasicObject, Object[])", value=StringNodes.SqueezeBangNode.class)
            private static final class SqueezeBangZeroArgsNode_
            extends BaseNode_ {
                SqueezeBangZeroArgsNode_(SqueezeBangNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof Object[]) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        if (StringNodes.SqueezeBangNode.zeroArgs(arguments1Value_)) {
                            return this.root.squeezeBangZeroArgs(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SqueezeBangNodeGen root) {
                    return new SqueezeBangZeroArgsNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.SqueezeBangNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SqueezeBangNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SqueezeBangNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.SqueezeBangNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SqueezeBangNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SqueezeBangNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.SqueezeBangNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final SqueezeBangNodeGen root;

                BaseNode_(SqueezeBangNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof Object[]) {
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        if (StringNodes.SqueezeBangNode.zeroArgs(arguments1Value_)) {
                            return SqueezeBangZeroArgsNode_.create(this.root);
                        }
                        return SqueezeBangNode_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.SizeNode.class)
    public static final class SizeNodeFactory
    extends NodeFactoryBase<StringNodes.SizeNode> {
        private static SizeNodeFactory sizeNodeFactoryInstance;

        private SizeNodeFactory() {
            super(StringNodes.SizeNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.SizeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SizeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.SizeNode> getInstance() {
            if (sizeNodeFactoryInstance == null) {
                sizeNodeFactoryInstance = new SizeNodeFactory();
            }
            return sizeNodeFactoryInstance;
        }

        public static StringNodes.SizeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SizeNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.SizeNode.class)
        public static final class SizeNodeGen
        extends StringNodes.SizeNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private SizeNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public int executeInteger(VirtualFrame frameValue, RubyBasicObject arguments0Value) {
                return this.specialization_.executeInt1(frameValue, arguments0Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                return this.specialization_.executeInt0(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="size(RubyBasicObject)", value=StringNodes.SizeNode.class)
            private static final class SizeNode_
            extends BaseNode_ {
                SizeNode_(SizeNodeGen root) {
                    super(root, 2);
                }

                @Override
                public int executeInt0(VirtualFrame frameValue) {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, ex.getResult());
                    }
                    if (!StringGuards.isSingleByteOptimizable(arguments0Value_)) {
                        return this.root.size(arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value_);
                }

                @Override
                public int executeInt1(VirtualFrame frameValue, RubyBasicObject arguments0Value) {
                    if (!StringGuards.isSingleByteOptimizable(arguments0Value)) {
                        return this.root.size(arguments0Value);
                    }
                    return this.getNext().executeInt1(frameValue, arguments0Value);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && !StringGuards.isSingleByteOptimizable(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.size(arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SizeNodeGen root) {
                    return new SizeNode_(root);
                }
            }

            @GeneratedBy(methodName="sizeSingleByte(RubyBasicObject)", value=StringNodes.SizeNode.class)
            private static final class SizeSingleByteNode_
            extends BaseNode_ {
                SizeSingleByteNode_(SizeNodeGen root) {
                    super(root, 1);
                }

                @Override
                public int executeInt0(VirtualFrame frameValue) {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, ex.getResult());
                    }
                    if (StringGuards.isSingleByteOptimizable(arguments0Value_)) {
                        return this.root.sizeSingleByte(arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value_);
                }

                @Override
                public int executeInt1(VirtualFrame frameValue, RubyBasicObject arguments0Value) {
                    if (StringGuards.isSingleByteOptimizable(arguments0Value)) {
                        return this.root.sizeSingleByte(arguments0Value);
                    }
                    return this.getNext().executeInt1(frameValue, arguments0Value);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && StringGuards.isSingleByteOptimizable(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.sizeSingleByte(arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SizeNodeGen root) {
                    return new SizeSingleByteNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.SizeNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SizeNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public int executeInt0(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.getNext().executeInt_(frameValue, arguments0Value_);
                }

                @Override
                public int executeInt1(VirtualFrame frameValue, RubyBasicObject arguments0Value) {
                    return this.getNext().executeInt1(frameValue, arguments0Value);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SizeNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.SizeNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SizeNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Integer)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(SizeNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.SizeNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final SizeNodeGen root;

                BaseNode_(SizeNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeInt_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract int executeInt_(VirtualFrame var1, Object var2);

                public int executeInt1(VirtualFrame frameValue, RubyBasicObject arguments0Value) {
                    return this.executeInt_(frameValue, arguments0Value);
                }

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeInt_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt0(VirtualFrame frameValue) {
                    return (Integer)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (StringGuards.isSingleByteOptimizable(arguments0Value_)) {
                            return SizeSingleByteNode_.create(this.root);
                        }
                        return SizeNode_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.SetByteNode.class)
    public static final class SetByteNodeFactory
    extends NodeFactoryBase<StringNodes.SetByteNode> {
        private static SetByteNodeFactory setByteNodeFactoryInstance;

        private SetByteNodeFactory() {
            super(StringNodes.SetByteNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class, RubyNode.class}});
        }

        public StringNodes.SetByteNode createNode(Object ... arguments) {
            if (!(arguments.length != 5 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode))) {
                return SetByteNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]), (RubyNode)((Object)arguments[4]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.SetByteNode> getInstance() {
            if (setByteNodeFactoryInstance == null) {
                setByteNodeFactoryInstance = new SetByteNodeFactory();
            }
            return setByteNodeFactoryInstance;
        }

        public static StringNodes.SetByteNode create(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode index, RubyNode value) {
            return new SetByteNodeGen(context, sourceSection, string, index, value);
        }

        @GeneratedBy(value=StringNodes.SetByteNode.class)
        public static final class SetByteNodeGen
        extends StringNodes.SetByteNode {
            @Node.Child
            private RubyNode string_;
            @Node.Child
            private RubyNode index_;
            @Node.Child
            private RubyNode value_;

            private SetByteNodeGen(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode index, RubyNode value) {
                super(context, sourceSection);
                this.string_ = string;
                this.index_ = this.coerceIndexToInt(index);
                this.value_ = this.coerceValueToInt(value);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeInteger(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeInteger(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                int valueValue_;
                int indexValue_;
                RubyBasicObject stringValue_;
                try {
                    stringValue_ = this.string_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object indexValue = this.index_.execute(frameValue);
                    Object valueValue = this.value_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), indexValue, valueValue);
                }
                try {
                    indexValue_ = this.index_.executeInteger(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object valueValue = this.value_.execute(frameValue);
                    throw this.unsupported(stringValue_, ex.getResult(), valueValue);
                }
                try {
                    valueValue_ = this.value_.executeInteger(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(stringValue_, indexValue_, ex.getResult());
                }
                return this.setByte(stringValue_, indexValue_, valueValue_);
            }

            protected UnsupportedSpecializationException unsupported(Object stringValue, Object indexValue, Object valueValue) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.string_, this.index_, this.value_}, new Object[]{stringValue, indexValue, valueValue});
            }
        }
    }

    @GeneratedBy(value=StringNodes.DumpNode.class)
    public static final class DumpNodeFactory
    extends NodeFactoryBase<StringNodes.DumpNode> {
        private static DumpNodeFactory dumpNodeFactoryInstance;

        private DumpNodeFactory() {
            super(StringNodes.DumpNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.DumpNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DumpNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.DumpNode> getInstance() {
            if (dumpNodeFactoryInstance == null) {
                dumpNodeFactoryInstance = new DumpNodeFactory();
            }
            return dumpNodeFactoryInstance;
        }

        public static StringNodes.DumpNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new DumpNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.DumpNode.class)
        public static final class DumpNodeGen
        extends StringNodes.DumpNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private DumpNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="dump(RubyBasicObject)", value=StringNodes.DumpNode.class)
            private static final class DumpNode_
            extends BaseNode_ {
                DumpNode_(DumpNodeGen root) {
                    super(root, 2);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && !StringGuards.isAsciiCompatible(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.dump(arguments0Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(DumpNodeGen root) {
                    return new DumpNode_(root);
                }
            }

            @GeneratedBy(methodName="dumpAsciiCompatible(RubyBasicObject)", value=StringNodes.DumpNode.class)
            private static final class DumpAsciiCompatibleNode_
            extends BaseNode_ {
                DumpAsciiCompatibleNode_(DumpNodeGen root) {
                    super(root, 1);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && StringGuards.isAsciiCompatible(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.dumpAsciiCompatible(arguments0Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(DumpNodeGen root) {
                    return new DumpAsciiCompatibleNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.DumpNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(DumpNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(DumpNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.DumpNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(DumpNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return (RubyBasicObject)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(DumpNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.DumpNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final DumpNodeGen root;

                BaseNode_(DumpNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeRubyBasicObject_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract RubyBasicObject executeRubyBasicObject_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeRubyBasicObject_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (StringGuards.isAsciiCompatible(arguments0Value_)) {
                            return DumpAsciiCompatibleNode_.create(this.root);
                        }
                        return DumpNode_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.SwapcaseBangNode.class)
    public static final class SwapcaseBangNodeFactory
    extends NodeFactoryBase<StringNodes.SwapcaseBangNode> {
        private static SwapcaseBangNodeFactory swapcaseBangNodeFactoryInstance;

        private SwapcaseBangNodeFactory() {
            super(StringNodes.SwapcaseBangNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.SwapcaseBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SwapcaseBangNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.SwapcaseBangNode> getInstance() {
            if (swapcaseBangNodeFactoryInstance == null) {
                swapcaseBangNodeFactoryInstance = new SwapcaseBangNodeFactory();
            }
            return swapcaseBangNodeFactoryInstance;
        }

        public static StringNodes.SwapcaseBangNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SwapcaseBangNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.SwapcaseBangNode.class)
        public static final class SwapcaseBangNodeGen
        extends StringNodes.SwapcaseBangNode {
            @Node.Child
            private RubyNode arguments0_;

            private SwapcaseBangNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.swapcaseSingleByte(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=StringNodes.RstripBangNode.class)
    public static final class RstripBangNodeFactory
    extends NodeFactoryBase<StringNodes.RstripBangNode> {
        private static RstripBangNodeFactory rstripBangNodeFactoryInstance;

        private RstripBangNodeFactory() {
            super(StringNodes.RstripBangNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.RstripBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return RstripBangNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.RstripBangNode> getInstance() {
            if (rstripBangNodeFactoryInstance == null) {
                rstripBangNodeFactoryInstance = new RstripBangNodeFactory();
            }
            return rstripBangNodeFactoryInstance;
        }

        public static StringNodes.RstripBangNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new RstripBangNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.RstripBangNode.class)
        public static final class RstripBangNodeGen
        extends StringNodes.RstripBangNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private RstripBangNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="rstripBang(RubyBasicObject)", value=StringNodes.RstripBangNode.class)
            private static final class RstripBangNode_
            extends BaseNode_ {
                RstripBangNode_(RstripBangNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && !StringGuards.isSingleByteOptimizable(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.rstripBang(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(RstripBangNodeGen root) {
                    return new RstripBangNode_(root);
                }
            }

            @GeneratedBy(methodName="rstripBangSingleByte(RubyBasicObject)", value=StringNodes.RstripBangNode.class)
            private static final class RstripBangSingleByteNode_
            extends BaseNode_ {
                RstripBangSingleByteNode_(RstripBangNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && StringGuards.isSingleByteOptimizable(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.rstripBangSingleByte(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(RstripBangNodeGen root) {
                    return new RstripBangSingleByteNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.RstripBangNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(RstripBangNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(RstripBangNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.RstripBangNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(RstripBangNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(RstripBangNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.RstripBangNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final RstripBangNodeGen root;

                BaseNode_(RstripBangNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (StringGuards.isSingleByteOptimizable(arguments0Value_)) {
                            return RstripBangSingleByteNode_.create(this.root);
                        }
                        return RstripBangNode_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.ReplaceNode.class)
    public static final class ReplaceNodeFactory
    extends NodeFactoryBase<StringNodes.ReplaceNode> {
        private static ReplaceNodeFactory replaceNodeFactoryInstance;

        private ReplaceNodeFactory() {
            super(StringNodes.ReplaceNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public StringNodes.ReplaceNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return ReplaceNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.ReplaceNode> getInstance() {
            if (replaceNodeFactoryInstance == null) {
                replaceNodeFactoryInstance = new ReplaceNodeFactory();
            }
            return replaceNodeFactoryInstance;
        }

        public static StringNodes.ReplaceNode create(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode other) {
            return new ReplaceNodeGen(context, sourceSection, string, other);
        }

        @GeneratedBy(value=StringNodes.ReplaceNode.class)
        public static final class ReplaceNodeGen
        extends StringNodes.ReplaceNode {
            @Node.Child
            private RubyNode string_;
            @Node.Child
            private RubyNode other_;

            private ReplaceNodeGen(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode other) {
                super(context, sourceSection);
                this.string_ = string;
                this.other_ = this.coerceOtherToString(other);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject otherValue_;
                RubyBasicObject stringValue_;
                try {
                    stringValue_ = this.string_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object otherValue = this.other_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), otherValue);
                }
                try {
                    otherValue_ = this.other_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(stringValue_, ex.getResult());
                }
                if (RubyGuards.isRubyString(otherValue_)) {
                    return this.replace(stringValue_, otherValue_);
                }
                throw this.unsupported(stringValue_, otherValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object stringValue, Object otherValue) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.string_, this.other_}, new Object[]{stringValue, otherValue});
            }
        }
    }

    @GeneratedBy(value=StringNodes.OrdNode.class)
    public static final class OrdNodeFactory
    extends NodeFactoryBase<StringNodes.OrdNode> {
        private static OrdNodeFactory ordNodeFactoryInstance;

        private OrdNodeFactory() {
            super(StringNodes.OrdNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.OrdNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return OrdNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.OrdNode> getInstance() {
            if (ordNodeFactoryInstance == null) {
                ordNodeFactoryInstance = new OrdNodeFactory();
            }
            return ordNodeFactoryInstance;
        }

        public static StringNodes.OrdNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new OrdNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.OrdNode.class)
        public static final class OrdNodeGen
        extends StringNodes.OrdNode {
            @Node.Child
            private RubyNode arguments0_;

            private OrdNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeInteger(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeInteger(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.ord(arguments0Value_);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=StringNodes.SetNumBytesNode.class)
    public static final class SetNumBytesNodeFactory
    extends NodeFactoryBase<StringNodes.SetNumBytesNode> {
        private static SetNumBytesNodeFactory setNumBytesNodeFactoryInstance;

        private SetNumBytesNodeFactory() {
            super(StringNodes.SetNumBytesNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.SetNumBytesNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SetNumBytesNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.SetNumBytesNode> getInstance() {
            if (setNumBytesNodeFactoryInstance == null) {
                setNumBytesNodeFactoryInstance = new SetNumBytesNodeFactory();
            }
            return setNumBytesNodeFactoryInstance;
        }

        public static StringNodes.SetNumBytesNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SetNumBytesNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.SetNumBytesNode.class)
        public static final class SetNumBytesNodeGen
        extends StringNodes.SetNumBytesNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;

            private SetNumBytesNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeRubyBasicObject(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeRubyBasicObject(frameValue);
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                int arguments1Value_;
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeInteger(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                return this.setNumBytes(arguments0Value_, arguments1Value_);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
        }
    }

    @GeneratedBy(value=StringNodes.ModifyBangNode.class)
    public static final class ModifyBangNodeFactory
    extends NodeFactoryBase<StringNodes.ModifyBangNode> {
        private static ModifyBangNodeFactory modifyBangNodeFactoryInstance;

        private ModifyBangNodeFactory() {
            super(StringNodes.ModifyBangNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.ModifyBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ModifyBangNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.ModifyBangNode> getInstance() {
            if (modifyBangNodeFactoryInstance == null) {
                modifyBangNodeFactoryInstance = new ModifyBangNodeFactory();
            }
            return modifyBangNodeFactoryInstance;
        }

        public static StringNodes.ModifyBangNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ModifyBangNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.ModifyBangNode.class)
        public static final class ModifyBangNodeGen
        extends StringNodes.ModifyBangNode {
            @Node.Child
            private RubyNode arguments0_;

            private ModifyBangNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.modifyBang(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=StringNodes.LstripBangNode.class)
    public static final class LstripBangNodeFactory
    extends NodeFactoryBase<StringNodes.LstripBangNode> {
        private static LstripBangNodeFactory lstripBangNodeFactoryInstance;

        private LstripBangNodeFactory() {
            super(StringNodes.LstripBangNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.LstripBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LstripBangNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.LstripBangNode> getInstance() {
            if (lstripBangNodeFactoryInstance == null) {
                lstripBangNodeFactoryInstance = new LstripBangNodeFactory();
            }
            return lstripBangNodeFactoryInstance;
        }

        public static StringNodes.LstripBangNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new LstripBangNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.LstripBangNode.class)
        public static final class LstripBangNodeGen
        extends StringNodes.LstripBangNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private LstripBangNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="lstripBang(RubyBasicObject)", value=StringNodes.LstripBangNode.class)
            private static final class LstripBangNode_
            extends BaseNode_ {
                LstripBangNode_(LstripBangNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && !StringGuards.isSingleByteOptimizable(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.lstripBang(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(LstripBangNodeGen root) {
                    return new LstripBangNode_(root);
                }
            }

            @GeneratedBy(methodName="lstripBangSingleByte(RubyBasicObject)", value=StringNodes.LstripBangNode.class)
            private static final class LstripBangSingleByteNode_
            extends BaseNode_ {
                LstripBangSingleByteNode_(LstripBangNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && StringGuards.isSingleByteOptimizable(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.lstripBangSingleByte(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(LstripBangNodeGen root) {
                    return new LstripBangSingleByteNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.LstripBangNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(LstripBangNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(LstripBangNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.LstripBangNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(LstripBangNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(LstripBangNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.LstripBangNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final LstripBangNodeGen root;

                BaseNode_(LstripBangNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (StringGuards.isSingleByteOptimizable(arguments0Value_)) {
                            return LstripBangSingleByteNode_.create(this.root);
                        }
                        return LstripBangNode_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.InsertNode.class)
    public static final class InsertNodeFactory
    extends NodeFactoryBase<StringNodes.InsertNode> {
        private static InsertNodeFactory insertNodeFactoryInstance;

        private InsertNodeFactory() {
            super(StringNodes.InsertNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class, RubyNode.class}});
        }

        public StringNodes.InsertNode createNode(Object ... arguments) {
            if (!(arguments.length != 5 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode))) {
                return InsertNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]), (RubyNode)((Object)arguments[4]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.InsertNode> getInstance() {
            if (insertNodeFactoryInstance == null) {
                insertNodeFactoryInstance = new InsertNodeFactory();
            }
            return insertNodeFactoryInstance;
        }

        public static StringNodes.InsertNode create(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode index, RubyNode otherString) {
            return new InsertNodeGen(context, sourceSection, string, index, otherString);
        }

        @GeneratedBy(value=StringNodes.InsertNode.class)
        public static final class InsertNodeGen
        extends StringNodes.InsertNode {
            @Node.Child
            private RubyNode string_;
            @Node.Child
            private RubyNode index_;
            @Node.Child
            private RubyNode otherString_;

            private InsertNodeGen(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode index, RubyNode otherString) {
                super(context, sourceSection);
                this.string_ = string;
                this.index_ = this.coerceIndexToInt(index);
                this.otherString_ = this.coerceOtherToString(otherString);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject otherStringValue_;
                int indexValue_;
                RubyBasicObject stringValue_;
                try {
                    stringValue_ = this.string_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object indexValue = this.index_.execute(frameValue);
                    Object otherStringValue = this.otherString_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), indexValue, otherStringValue);
                }
                try {
                    indexValue_ = this.index_.executeInteger(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object otherStringValue = this.otherString_.execute(frameValue);
                    throw this.unsupported(stringValue_, ex.getResult(), otherStringValue);
                }
                try {
                    otherStringValue_ = this.otherString_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(stringValue_, indexValue_, ex.getResult());
                }
                if (RubyGuards.isRubyString(otherStringValue_)) {
                    return this.insert(frameValue, stringValue_, indexValue_, otherStringValue_);
                }
                throw this.unsupported(stringValue_, indexValue_, otherStringValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object stringValue, Object indexValue, Object otherStringValue) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.string_, this.index_, this.otherString_}, new Object[]{stringValue, indexValue, otherStringValue});
            }
        }
    }

    @GeneratedBy(value=StringNodes.InitializeCopyNode.class)
    public static final class InitializeCopyNodeFactory
    extends NodeFactoryBase<StringNodes.InitializeCopyNode> {
        private static InitializeCopyNodeFactory initializeCopyNodeFactoryInstance;

        private InitializeCopyNodeFactory() {
            super(StringNodes.InitializeCopyNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.InitializeCopyNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InitializeCopyNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.InitializeCopyNode> getInstance() {
            if (initializeCopyNodeFactoryInstance == null) {
                initializeCopyNodeFactoryInstance = new InitializeCopyNodeFactory();
            }
            return initializeCopyNodeFactoryInstance;
        }

        public static StringNodes.InitializeCopyNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new InitializeCopyNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.InitializeCopyNode.class)
        public static final class InitializeCopyNodeGen
        extends StringNodes.InitializeCopyNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;

            private InitializeCopyNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments1Value_;
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                if (RubyGuards.isRubyString(arguments1Value_)) {
                    return this.initializeCopy(arguments0Value_, arguments1Value_);
                }
                throw this.unsupported(arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
        }
    }

    @GeneratedBy(value=StringNodes.InitializeNode.class)
    public static final class InitializeNodeFactory
    extends NodeFactoryBase<StringNodes.InitializeNode> {
        private static InitializeNodeFactory initializeNodeFactoryInstance;

        private InitializeNodeFactory() {
            super(StringNodes.InitializeNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.InitializeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InitializeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.InitializeNode> getInstance() {
            if (initializeNodeFactoryInstance == null) {
                initializeNodeFactoryInstance = new InitializeNodeFactory();
            }
            return initializeNodeFactoryInstance;
        }

        public static StringNodes.InitializeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new InitializeNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.InitializeNode.class)
        public static final class InitializeNodeGen
        extends StringNodes.InitializeNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private InitializeNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="initialize(VirtualFrame, RubyBasicObject, Object)", value=StringNodes.InitializeNode.class)
            private static final class Initialize2Node_
            extends BaseNode_ {
                Initialize2Node_(InitializeNodeGen root) {
                    super(root, 3);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (!RubyGuards.isRubyString(arguments1Value) && RubyGuards.wasProvided(arguments1Value)) {
                            return this.root.initialize(frameValue, arguments0Value_, arguments1Value);
                        }
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new Initialize2Node_(root);
                }
            }

            @GeneratedBy(methodName="initialize(RubyBasicObject, RubyBasicObject)", value=StringNodes.InitializeNode.class)
            private static final class Initialize1Node_
            extends BaseNode_ {
                Initialize1Node_(InitializeNodeGen root) {
                    super(root, 2);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments1Value_)) {
                            return this.root.initialize(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new Initialize1Node_(root);
                }
            }

            @GeneratedBy(methodName="initialize(RubyBasicObject, NotProvided)", value=StringNodes.InitializeNode.class)
            private static final class Initialize0Node_
            extends BaseNode_ {
                Initialize0Node_(InitializeNodeGen root) {
                    super(root, 1);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof NotProvided) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        return this.root.initialize(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new Initialize0Node_(root);
                }
            }

            @GeneratedBy(value=StringNodes.InitializeNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(InitializeNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.InitializeNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(InitializeNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (RubyBasicObject)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.InitializeNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final InitializeNodeGen root;

                BaseNode_(InitializeNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeRubyBasicObject_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract RubyBasicObject executeRubyBasicObject_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.executeRubyBasicObject_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments1Value_;
                        if (arguments1Value instanceof NotProvided) {
                            return Initialize0Node_.create(this.root);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyString(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return Initialize1Node_.create(this.root);
                        }
                        if (!RubyGuards.isRubyString(arguments1Value) && RubyGuards.wasProvided(arguments1Value)) {
                            return Initialize2Node_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.InspectNode.class)
    public static final class InspectNodeFactory
    extends NodeFactoryBase<StringNodes.InspectNode> {
        private static InspectNodeFactory inspectNodeFactoryInstance;

        private InspectNodeFactory() {
            super(StringNodes.InspectNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.InspectNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InspectNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.InspectNode> getInstance() {
            if (inspectNodeFactoryInstance == null) {
                inspectNodeFactoryInstance = new InspectNodeFactory();
            }
            return inspectNodeFactoryInstance;
        }

        public static StringNodes.InspectNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new InspectNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.InspectNode.class)
        public static final class InspectNodeGen
        extends StringNodes.InspectNode {
            @Node.Child
            private RubyNode arguments0_;

            private InspectNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.inspect(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=StringNodes.HashNode.class)
    public static final class HashNodeFactory
    extends NodeFactoryBase<StringNodes.HashNode> {
        private static HashNodeFactory hashNodeFactoryInstance;

        private HashNodeFactory() {
            super(StringNodes.HashNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.HashNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return HashNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.HashNode> getInstance() {
            if (hashNodeFactoryInstance == null) {
                hashNodeFactoryInstance = new HashNodeFactory();
            }
            return hashNodeFactoryInstance;
        }

        public static StringNodes.HashNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new HashNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.HashNode.class)
        public static final class HashNodeGen
        extends StringNodes.HashNode {
            @Node.Child
            private RubyNode arguments0_;

            private HashNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeInteger(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeInteger(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.hash(arguments0Value_);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=StringNodes.GetByteNode.class)
    public static final class GetByteNodeFactory
    extends NodeFactoryBase<StringNodes.GetByteNode> {
        private static GetByteNodeFactory getByteNodeFactoryInstance;

        private GetByteNodeFactory() {
            super(StringNodes.GetByteNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.GetByteNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GetByteNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.GetByteNode> getInstance() {
            if (getByteNodeFactoryInstance == null) {
                getByteNodeFactoryInstance = new GetByteNodeFactory();
            }
            return getByteNodeFactoryInstance;
        }

        public static StringNodes.GetByteNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new GetByteNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.GetByteNode.class)
        public static final class GetByteNodeGen
        extends StringNodes.GetByteNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;

            private GetByteNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value_;
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeInteger(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                return this.getByte(arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
        }
    }

    @GeneratedBy(value=StringNodes.ForceEncodingNode.class)
    public static final class ForceEncodingNodeFactory
    extends NodeFactoryBase<StringNodes.ForceEncodingNode> {
        private static ForceEncodingNodeFactory forceEncodingNodeFactoryInstance;

        private ForceEncodingNodeFactory() {
            super(StringNodes.ForceEncodingNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.ForceEncodingNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ForceEncodingNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.ForceEncodingNode> getInstance() {
            if (forceEncodingNodeFactoryInstance == null) {
                forceEncodingNodeFactoryInstance = new ForceEncodingNodeFactory();
            }
            return forceEncodingNodeFactoryInstance;
        }

        public static StringNodes.ForceEncodingNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ForceEncodingNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.ForceEncodingNode.class)
        public static final class ForceEncodingNodeGen
        extends StringNodes.ForceEncodingNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private ForceEncodingNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="forceEncoding(VirtualFrame, RubyBasicObject, Object)", value=StringNodes.ForceEncodingNode.class)
            private static final class ForceEncodingNode_
            extends BaseNode_ {
                ForceEncodingNode_(ForceEncodingNodeGen root) {
                    super(root, 3);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (!RubyGuards.isRubyString(arguments1Value) && !RubyGuards.isRubyEncoding(arguments1Value)) {
                            return this.root.forceEncoding(frameValue, arguments0Value_, arguments1Value);
                        }
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ForceEncodingNodeGen root) {
                    return new ForceEncodingNode_(root);
                }
            }

            @GeneratedBy(methodName="forceEncodingEncoding(RubyBasicObject, RubyBasicObject)", value=StringNodes.ForceEncodingNode.class)
            private static final class ForceEncodingEncodingNode_
            extends BaseNode_ {
                ForceEncodingEncodingNode_(ForceEncodingNodeGen root) {
                    super(root, 2);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyEncoding(arguments1Value_)) {
                            return this.root.forceEncodingEncoding(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ForceEncodingNodeGen root) {
                    return new ForceEncodingEncodingNode_(root);
                }
            }

            @GeneratedBy(methodName="forceEncodingString(RubyBasicObject, RubyBasicObject)", value=StringNodes.ForceEncodingNode.class)
            private static final class ForceEncodingStringNode_
            extends BaseNode_ {
                ForceEncodingStringNode_(ForceEncodingNodeGen root) {
                    super(root, 1);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments1Value_)) {
                            return this.root.forceEncodingString(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ForceEncodingNodeGen root) {
                    return new ForceEncodingStringNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.ForceEncodingNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ForceEncodingNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ForceEncodingNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.ForceEncodingNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ForceEncodingNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (RubyBasicObject)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ForceEncodingNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.ForceEncodingNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final ForceEncodingNodeGen root;

                BaseNode_(ForceEncodingNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeRubyBasicObject_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract RubyBasicObject executeRubyBasicObject_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.executeRubyBasicObject_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        if (arguments1Value instanceof RubyBasicObject) {
                            RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                            if (RubyGuards.isRubyString(arguments1Value_)) {
                                return ForceEncodingStringNode_.create(this.root);
                            }
                            if (RubyGuards.isRubyEncoding(arguments1Value_)) {
                                return ForceEncodingEncodingNode_.create(this.root);
                            }
                        }
                        if (!RubyGuards.isRubyString(arguments1Value) && !RubyGuards.isRubyEncoding(arguments1Value)) {
                            return ForceEncodingNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.EncodingNode.class)
    public static final class EncodingNodeFactory
    extends NodeFactoryBase<StringNodes.EncodingNode> {
        private static EncodingNodeFactory encodingNodeFactoryInstance;

        private EncodingNodeFactory() {
            super(StringNodes.EncodingNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.EncodingNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EncodingNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.EncodingNode> getInstance() {
            if (encodingNodeFactoryInstance == null) {
                encodingNodeFactoryInstance = new EncodingNodeFactory();
            }
            return encodingNodeFactoryInstance;
        }

        public static StringNodes.EncodingNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new EncodingNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.EncodingNode.class)
        public static final class EncodingNodeGen
        extends StringNodes.EncodingNode {
            @Node.Child
            private RubyNode arguments0_;

            private EncodingNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.encoding(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=StringNodes.EmptyNode.class)
    public static final class EmptyNodeFactory
    extends NodeFactoryBase<StringNodes.EmptyNode> {
        private static EmptyNodeFactory emptyNodeFactoryInstance;

        private EmptyNodeFactory() {
            super(StringNodes.EmptyNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.EmptyNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EmptyNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.EmptyNode> getInstance() {
            if (emptyNodeFactoryInstance == null) {
                emptyNodeFactoryInstance = new EmptyNodeFactory();
            }
            return emptyNodeFactoryInstance;
        }

        public static StringNodes.EmptyNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new EmptyNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.EmptyNode.class)
        public static final class EmptyNodeGen
        extends StringNodes.EmptyNode {
            @Node.Child
            private RubyNode arguments0_;

            private EmptyNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.empty(arguments0Value_);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=StringNodes.EachCharNode.class)
    public static final class EachCharNodeFactory
    extends NodeFactoryBase<StringNodes.EachCharNode> {
        private static EachCharNodeFactory eachCharNodeFactoryInstance;

        private EachCharNodeFactory() {
            super(StringNodes.EachCharNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.EachCharNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EachCharNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.EachCharNode> getInstance() {
            if (eachCharNodeFactoryInstance == null) {
                eachCharNodeFactoryInstance = new EachCharNodeFactory();
            }
            return eachCharNodeFactoryInstance;
        }

        public static StringNodes.EachCharNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new EachCharNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.EachCharNode.class)
        public static final class EachCharNodeGen
        extends StringNodes.EachCharNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private EachCharNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="eachCharMultiByteEncoding(VirtualFrame, RubyBasicObject, RubyBasicObject)", value=StringNodes.EachCharNode.class)
            private static final class EachCharMultiByteEncodingNode_
            extends BaseNode_ {
                EachCharMultiByteEncodingNode_(EachCharNodeGen root) {
                    super(root, 2);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (!StringGuards.isValidOr7BitEncoding(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.eachCharMultiByteEncoding(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachCharNodeGen root) {
                    return new EachCharMultiByteEncodingNode_(root);
                }
            }

            @GeneratedBy(methodName="eachChar(VirtualFrame, RubyBasicObject, RubyBasicObject)", value=StringNodes.EachCharNode.class)
            private static final class EachCharNode_
            extends BaseNode_ {
                EachCharNode_(EachCharNodeGen root) {
                    super(root, 1);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (StringGuards.isValidOr7BitEncoding(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.eachChar(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachCharNodeGen root) {
                    return new EachCharNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.EachCharNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(EachCharNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachCharNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.EachCharNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(EachCharNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (RubyBasicObject)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachCharNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.EachCharNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final EachCharNodeGen root;

                BaseNode_(EachCharNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeRubyBasicObject_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract RubyBasicObject executeRubyBasicObject_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.executeRubyBasicObject_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (StringGuards.isValidOr7BitEncoding(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return EachCharNode_.create(this.root);
                        }
                        if (!StringGuards.isValidOr7BitEncoding(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return EachCharMultiByteEncodingNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.EachByteNode.class)
    public static final class EachByteNodeFactory
    extends NodeFactoryBase<StringNodes.EachByteNode> {
        private static EachByteNodeFactory eachByteNodeFactoryInstance;

        private EachByteNodeFactory() {
            super(StringNodes.EachByteNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.EachByteNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EachByteNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.EachByteNode> getInstance() {
            if (eachByteNodeFactoryInstance == null) {
                eachByteNodeFactoryInstance = new EachByteNodeFactory();
            }
            return eachByteNodeFactoryInstance;
        }

        public static StringNodes.EachByteNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new EachByteNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.EachByteNode.class)
        public static final class EachByteNodeGen
        extends StringNodes.EachByteNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;

            private EachByteNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments1Value_;
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                if (RubyGuards.isRubyProc(arguments1Value_)) {
                    return this.eachByte(frameValue, arguments0Value_, arguments1Value_);
                }
                throw this.unsupported(arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
        }
    }

    @GeneratedBy(value=StringNodes.DowncaseBangNode.class)
    public static final class DowncaseBangNodeFactory
    extends NodeFactoryBase<StringNodes.DowncaseBangNode> {
        private static DowncaseBangNodeFactory downcaseBangNodeFactoryInstance;

        private DowncaseBangNodeFactory() {
            super(StringNodes.DowncaseBangNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.DowncaseBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DowncaseBangNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.DowncaseBangNode> getInstance() {
            if (downcaseBangNodeFactoryInstance == null) {
                downcaseBangNodeFactoryInstance = new DowncaseBangNodeFactory();
            }
            return downcaseBangNodeFactoryInstance;
        }

        public static StringNodes.DowncaseBangNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new DowncaseBangNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.DowncaseBangNode.class)
        public static final class DowncaseBangNodeGen
        extends StringNodes.DowncaseBangNode {
            @Node.Child
            private RubyNode arguments0_;

            private DowncaseBangNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.downcase(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=StringNodes.DowncaseNode.class)
    public static final class DowncaseNodeFactory
    extends NodeFactoryBase<StringNodes.DowncaseNode> {
        private static DowncaseNodeFactory downcaseNodeFactoryInstance;

        private DowncaseNodeFactory() {
            super(StringNodes.DowncaseNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.DowncaseNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DowncaseNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.DowncaseNode> getInstance() {
            if (downcaseNodeFactoryInstance == null) {
                downcaseNodeFactoryInstance = new DowncaseNodeFactory();
            }
            return downcaseNodeFactoryInstance;
        }

        public static StringNodes.DowncaseNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new DowncaseNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.DowncaseNode.class)
        public static final class DowncaseNodeGen
        extends StringNodes.DowncaseNode {
            @Node.Child
            private RubyNode arguments0_;

            private DowncaseNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.downcase(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=StringNodes.DeleteBangNode.class)
    public static final class DeleteBangNodeFactory
    extends NodeFactoryBase<StringNodes.DeleteBangNode> {
        private static DeleteBangNodeFactory deleteBangNodeFactoryInstance;

        private DeleteBangNodeFactory() {
            super(StringNodes.DeleteBangNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.DeleteBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DeleteBangNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.DeleteBangNode> getInstance() {
            if (deleteBangNodeFactoryInstance == null) {
                deleteBangNodeFactoryInstance = new DeleteBangNodeFactory();
            }
            return deleteBangNodeFactoryInstance;
        }

        public static StringNodes.DeleteBangNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new DeleteBangNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.DeleteBangNode.class)
        public static final class DeleteBangNodeGen
        extends StringNodes.DeleteBangNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;

            private DeleteBangNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object[] arguments1Value_;
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                return this.deleteBang(frameValue, arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
        }
    }

    @GeneratedBy(value=StringNodes.DataNode.class)
    public static final class DataNodeFactory
    extends NodeFactoryBase<StringNodes.DataNode> {
        private static DataNodeFactory dataNodeFactoryInstance;

        private DataNodeFactory() {
            super(StringNodes.DataNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.DataNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DataNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.DataNode> getInstance() {
            if (dataNodeFactoryInstance == null) {
                dataNodeFactoryInstance = new DataNodeFactory();
            }
            return dataNodeFactoryInstance;
        }

        public static StringNodes.DataNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new DataNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.DataNode.class)
        public static final class DataNodeGen
        extends StringNodes.DataNode {
            @Node.Child
            private RubyNode arguments0_;

            private DataNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.data(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=StringNodes.CryptNode.class)
    public static final class CryptNodeFactory
    extends NodeFactoryBase<StringNodes.CryptNode> {
        private static CryptNodeFactory cryptNodeFactoryInstance;

        private CryptNodeFactory() {
            super(StringNodes.CryptNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public StringNodes.CryptNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return CryptNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.CryptNode> getInstance() {
            if (cryptNodeFactoryInstance == null) {
                cryptNodeFactoryInstance = new CryptNodeFactory();
            }
            return cryptNodeFactoryInstance;
        }

        public static StringNodes.CryptNode create(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode salt) {
            return new CryptNodeGen(context, sourceSection, string, salt);
        }

        @GeneratedBy(value=StringNodes.CryptNode.class)
        public static final class CryptNodeGen
        extends StringNodes.CryptNode {
            @Node.Child
            private RubyNode string_;
            @Node.Child
            private RubyNode salt_;

            private CryptNodeGen(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode salt) {
                super(context, sourceSection);
                this.string_ = string;
                this.salt_ = this.coerceSaltToString(salt);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject saltValue_;
                RubyBasicObject stringValue_;
                try {
                    stringValue_ = this.string_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object saltValue = this.salt_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), saltValue);
                }
                try {
                    saltValue_ = this.salt_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(stringValue_, ex.getResult());
                }
                if (RubyGuards.isRubyString(saltValue_)) {
                    return this.crypt(stringValue_, saltValue_);
                }
                throw this.unsupported(stringValue_, saltValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object stringValue, Object saltValue) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.string_, this.salt_}, new Object[]{stringValue, saltValue});
            }
        }
    }

    @GeneratedBy(value=StringNodes.CountNode.class)
    public static final class CountNodeFactory
    extends NodeFactoryBase<StringNodes.CountNode> {
        private static CountNodeFactory countNodeFactoryInstance;

        private CountNodeFactory() {
            super(StringNodes.CountNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.CountNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CountNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.CountNode> getInstance() {
            if (countNodeFactoryInstance == null) {
                countNodeFactoryInstance = new CountNodeFactory();
            }
            return countNodeFactoryInstance;
        }

        public static StringNodes.CountNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new CountNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.CountNode.class)
        public static final class CountNodeGen
        extends StringNodes.CountNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;

            private CountNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeInteger(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeInteger(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                Object[] arguments1Value_;
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                return this.count(frameValue, arguments0Value_, arguments1Value_);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
        }
    }

    @GeneratedBy(value=StringNodes.ChopBangNode.class)
    public static final class ChopBangNodeFactory
    extends NodeFactoryBase<StringNodes.ChopBangNode> {
        private static ChopBangNodeFactory chopBangNodeFactoryInstance;

        private ChopBangNodeFactory() {
            super(StringNodes.ChopBangNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.ChopBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ChopBangNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.ChopBangNode> getInstance() {
            if (chopBangNodeFactoryInstance == null) {
                chopBangNodeFactoryInstance = new ChopBangNodeFactory();
            }
            return chopBangNodeFactoryInstance;
        }

        public static StringNodes.ChopBangNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ChopBangNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.ChopBangNode.class)
        public static final class ChopBangNodeGen
        extends StringNodes.ChopBangNode {
            @Node.Child
            private RubyNode arguments0_;

            private ChopBangNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.chopBang(frameValue, arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=StringNodes.CaseCmpNode.class)
    public static final class CaseCmpNodeFactory
    extends NodeFactoryBase<StringNodes.CaseCmpNode> {
        private static CaseCmpNodeFactory caseCmpNodeFactoryInstance;

        private CaseCmpNodeFactory() {
            super(StringNodes.CaseCmpNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public StringNodes.CaseCmpNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return CaseCmpNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.CaseCmpNode> getInstance() {
            if (caseCmpNodeFactoryInstance == null) {
                caseCmpNodeFactoryInstance = new CaseCmpNodeFactory();
            }
            return caseCmpNodeFactoryInstance;
        }

        public static StringNodes.CaseCmpNode create(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode other) {
            return new CaseCmpNodeGen(context, sourceSection, string, other);
        }

        @GeneratedBy(value=StringNodes.CaseCmpNode.class)
        public static final class CaseCmpNodeGen
        extends StringNodes.CaseCmpNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode string_;
            @Node.Child
            private RubyNode other_;
            @Node.Child
            private BaseNode_ specialization_;

            private CaseCmpNodeGen(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode other) {
                super(context, sourceSection);
                this.string_ = string;
                this.other_ = this.coerceOtherToString(other);
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="caseCmp(RubyBasicObject, RubyBasicObject)", value=StringNodes.CaseCmpNode.class)
            private static final class CaseCmpNode_
            extends BaseNode_ {
                CaseCmpNode_(CaseCmpNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                    if (stringValue instanceof RubyBasicObject && otherValue instanceof RubyBasicObject) {
                        RubyBasicObject stringValue_ = (RubyBasicObject)stringValue;
                        RubyBasicObject otherValue_ = (RubyBasicObject)otherValue;
                        if (RubyGuards.isRubyString(otherValue_) && !StringNodes.CaseCmpNode.bothSingleByteOptimizable(stringValue_, otherValue_)) {
                            return this.root.caseCmp(stringValue_, otherValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, stringValue, otherValue);
                }

                static BaseNode_ create(CaseCmpNodeGen root) {
                    return new CaseCmpNode_(root);
                }
            }

            @GeneratedBy(methodName="caseCmpSingleByte(RubyBasicObject, RubyBasicObject)", value=StringNodes.CaseCmpNode.class)
            private static final class CaseCmpSingleByteNode_
            extends BaseNode_ {
                CaseCmpSingleByteNode_(CaseCmpNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                    if (stringValue instanceof RubyBasicObject && otherValue instanceof RubyBasicObject) {
                        RubyBasicObject stringValue_ = (RubyBasicObject)stringValue;
                        RubyBasicObject otherValue_ = (RubyBasicObject)otherValue;
                        if (RubyGuards.isRubyString(otherValue_) && StringNodes.CaseCmpNode.bothSingleByteOptimizable(stringValue_, otherValue_)) {
                            return this.root.caseCmpSingleByte(stringValue_, otherValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, stringValue, otherValue);
                }

                static BaseNode_ create(CaseCmpNodeGen root) {
                    return new CaseCmpSingleByteNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.CaseCmpNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(CaseCmpNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object stringValue, Object otherValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, stringValue, otherValue));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                    return this.getNext().execute_(frameValue, stringValue, otherValue);
                }

                static BaseNode_ create(CaseCmpNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.CaseCmpNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(CaseCmpNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                    return this.uninitialized((Frame)frameValue, stringValue, otherValue);
                }

                static BaseNode_ create(CaseCmpNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.CaseCmpNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final CaseCmpNodeGen root;

                BaseNode_(CaseCmpNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.string_, this.root.other_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object stringValue, Object otherValue) {
                    return this.execute_((VirtualFrame)frameValue, stringValue, otherValue);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object stringValue_ = this.root.string_.execute(frameValue);
                    Object otherValue_ = this.root.other_.execute(frameValue);
                    return this.execute_(frameValue, stringValue_, otherValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object stringValue, Object otherValue) {
                    if (stringValue instanceof RubyBasicObject && otherValue instanceof RubyBasicObject) {
                        RubyBasicObject stringValue_ = (RubyBasicObject)stringValue;
                        RubyBasicObject otherValue_ = (RubyBasicObject)otherValue;
                        if (RubyGuards.isRubyString(otherValue_) && StringNodes.CaseCmpNode.bothSingleByteOptimizable(stringValue_, otherValue_)) {
                            return CaseCmpSingleByteNode_.create(this.root);
                        }
                        if (RubyGuards.isRubyString(otherValue_) && !StringNodes.CaseCmpNode.bothSingleByteOptimizable(stringValue_, otherValue_)) {
                            return CaseCmpNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.ByteSizeNode.class)
    public static final class ByteSizeNodeFactory
    extends NodeFactoryBase<StringNodes.ByteSizeNode> {
        private static ByteSizeNodeFactory byteSizeNodeFactoryInstance;

        private ByteSizeNodeFactory() {
            super(StringNodes.ByteSizeNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.ByteSizeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ByteSizeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.ByteSizeNode> getInstance() {
            if (byteSizeNodeFactoryInstance == null) {
                byteSizeNodeFactoryInstance = new ByteSizeNodeFactory();
            }
            return byteSizeNodeFactoryInstance;
        }

        public static StringNodes.ByteSizeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ByteSizeNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.ByteSizeNode.class)
        public static final class ByteSizeNodeGen
        extends StringNodes.ByteSizeNode {
            @Node.Child
            private RubyNode arguments0_;

            private ByteSizeNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeInteger(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeInteger(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.byteSize(arguments0Value_);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=StringNodes.BytesNode.class)
    public static final class BytesNodeFactory
    extends NodeFactoryBase<StringNodes.BytesNode> {
        private static BytesNodeFactory bytesNodeFactoryInstance;

        private BytesNodeFactory() {
            super(StringNodes.BytesNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.BytesNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return BytesNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.BytesNode> getInstance() {
            if (bytesNodeFactoryInstance == null) {
                bytesNodeFactoryInstance = new BytesNodeFactory();
            }
            return bytesNodeFactoryInstance;
        }

        public static StringNodes.BytesNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new BytesNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.BytesNode.class)
        public static final class BytesNodeGen
        extends StringNodes.BytesNode {
            @Node.Child
            private RubyNode arguments0_;

            private BytesNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.bytes(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=StringNodes.BNode.class)
    public static final class BNodeFactory
    extends NodeFactoryBase<StringNodes.BNode> {
        private static BNodeFactory bNodeFactoryInstance;

        private BNodeFactory() {
            super(StringNodes.BNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.BNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return BNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.BNode> getInstance() {
            if (bNodeFactoryInstance == null) {
                bNodeFactoryInstance = new BNodeFactory();
            }
            return bNodeFactoryInstance;
        }

        public static StringNodes.BNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new BNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.BNode.class)
        public static final class BNodeGen
        extends StringNodes.BNode {
            @Node.Child
            private RubyNode arguments0_;

            private BNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.b(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=StringNodes.ASCIIOnlyNode.class)
    public static final class ASCIIOnlyNodeFactory
    extends NodeFactoryBase<StringNodes.ASCIIOnlyNode> {
        private static ASCIIOnlyNodeFactory aSCIIOnlyNodeFactoryInstance;

        private ASCIIOnlyNodeFactory() {
            super(StringNodes.ASCIIOnlyNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.ASCIIOnlyNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ASCIIOnlyNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.ASCIIOnlyNode> getInstance() {
            if (aSCIIOnlyNodeFactoryInstance == null) {
                aSCIIOnlyNodeFactoryInstance = new ASCIIOnlyNodeFactory();
            }
            return aSCIIOnlyNodeFactoryInstance;
        }

        public static StringNodes.ASCIIOnlyNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ASCIIOnlyNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.ASCIIOnlyNode.class)
        public static final class ASCIIOnlyNodeGen
        extends StringNodes.ASCIIOnlyNode {
            @Node.Child
            private RubyNode arguments0_;

            private ASCIIOnlyNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.asciiOnly(arguments0Value_);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=StringNodes.GetIndexNode.class)
    public static final class GetIndexNodeFactory
    extends NodeFactoryBase<StringNodes.GetIndexNode> {
        private static GetIndexNodeFactory getIndexNodeFactoryInstance;

        private GetIndexNodeFactory() {
            super(StringNodes.GetIndexNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.GetIndexNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GetIndexNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.GetIndexNode> getInstance() {
            if (getIndexNodeFactoryInstance == null) {
                getIndexNodeFactoryInstance = new GetIndexNodeFactory();
            }
            return getIndexNodeFactoryInstance;
        }

        public static StringNodes.GetIndexNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new GetIndexNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.GetIndexNode.class)
        public static final class GetIndexNodeGen
        extends StringNodes.GetIndexNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private GetIndexNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="slice2(VirtualFrame, RubyBasicObject, RubyBasicObject, Object)", value=StringNodes.GetIndexNode.class)
            private static final class Slice21Node_
            extends BaseNode_ {
                Slice21Node_(GetIndexNodeGen root) {
                    super(root, 11);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if ((RubyGuards.wasNotProvided(arguments2Value) || this.root.isRubiniusUndefined(arguments2Value)) && RubyGuards.isRubyString(arguments1Value_)) {
                            return this.root.slice2(frameValue, arguments0Value_, arguments1Value_, arguments2Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(GetIndexNodeGen root) {
                    return new Slice21Node_(root);
                }
            }

            @GeneratedBy(methodName="sliceCapture(VirtualFrame, RubyBasicObject, RubyBasicObject, Object)", value=StringNodes.GetIndexNode.class)
            private static final class SliceCaptureNode_
            extends BaseNode_ {
                SliceCaptureNode_(GetIndexNodeGen root) {
                    super(root, 10);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyRegexp(arguments1Value_) && RubyGuards.wasProvided(arguments2Value)) {
                            return this.root.sliceCapture(frameValue, arguments0Value_, arguments1Value_, arguments2Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(GetIndexNodeGen root) {
                    return new SliceCaptureNode_(root);
                }
            }

            @GeneratedBy(methodName="slice1(VirtualFrame, RubyBasicObject, RubyBasicObject, Object)", value=StringNodes.GetIndexNode.class)
            private static final class Slice11Node_
            extends BaseNode_ {
                Slice11Node_(GetIndexNodeGen root) {
                    super(root, 9);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyRegexp(arguments1Value_) && (RubyGuards.wasNotProvided(arguments2Value) || this.root.isRubiniusUndefined(arguments2Value))) {
                            return this.root.slice1(frameValue, arguments0Value_, arguments1Value_, arguments2Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(GetIndexNodeGen root) {
                    return new Slice11Node_(root);
                }
            }

            @GeneratedBy(methodName="slice(VirtualFrame, RubyBasicObject, Object, Object)", value=StringNodes.GetIndexNode.class)
            private static final class Slice20Node_
            extends BaseNode_ {
                Slice20Node_(GetIndexNodeGen root) {
                    super(root, 8);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (!RubyGuards.isRubyRange(arguments1Value) && !RubyGuards.isRubyRegexp(arguments1Value) && !RubyGuards.isRubyString(arguments1Value) && RubyGuards.wasProvided(arguments2Value)) {
                            return this.root.slice(frameValue, arguments0Value_, arguments1Value, arguments2Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(GetIndexNodeGen root) {
                    return new Slice20Node_(root);
                }
            }

            @GeneratedBy(methodName="slice(VirtualFrame, RubyBasicObject, int, Object)", value=StringNodes.GetIndexNode.class)
            private static final class Slice10Node_
            extends BaseNode_ {
                Slice10Node_(GetIndexNodeGen root) {
                    super(root, 7);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value);
                    }
                    Object arguments2Value_ = this.executeArguments2_((Frame)frameValue);
                    if (RubyGuards.wasProvided(arguments2Value_)) {
                        return this.root.slice(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof Integer) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (RubyGuards.wasProvided(arguments2Value)) {
                            return this.root.slice(frameValue, arguments0Value_, arguments1Value_, arguments2Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(GetIndexNodeGen root) {
                    return new Slice10Node_(root);
                }
            }

            @GeneratedBy(methodName="slice(VirtualFrame, RubyBasicObject, int, int)", value=StringNodes.GetIndexNode.class)
            private static final class Slice0Node_
            extends BaseNode_ {
                Slice0Node_(GetIndexNodeGen root) {
                    super(root, 6);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments2Value_;
                    int arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value);
                    }
                    try {
                        arguments2Value_ = this.root.arguments2_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult());
                    }
                    return this.root.slice(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof Integer && arguments2Value instanceof Integer) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        int arguments2Value_ = (Integer)arguments2Value;
                        return this.root.slice(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(GetIndexNodeGen root) {
                    return new Slice0Node_(root);
                }
            }

            @GeneratedBy(methodName="sliceObjectRange(VirtualFrame, RubyBasicObject, ObjectRange, Object)", value=StringNodes.GetIndexNode.class)
            private static final class SliceObjectRangeNode_
            extends BaseNode_ {
                SliceObjectRangeNode_(GetIndexNodeGen root) {
                    super(root, 5);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyRange.ObjectRange) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyRange.ObjectRange arguments1Value_ = (RubyRange.ObjectRange)arguments1Value;
                        if (RubyGuards.wasNotProvided(arguments2Value) || this.root.isRubiniusUndefined(arguments2Value)) {
                            return this.root.sliceObjectRange(frameValue, arguments0Value_, arguments1Value_, arguments2Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(GetIndexNodeGen root) {
                    return new SliceObjectRangeNode_(root);
                }
            }

            @GeneratedBy(methodName="sliceLongRange(VirtualFrame, RubyBasicObject, LongFixnumRange, Object)", value=StringNodes.GetIndexNode.class)
            private static final class SliceLongRangeNode_
            extends BaseNode_ {
                SliceLongRangeNode_(GetIndexNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyRange.LongFixnumRange) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyRange.LongFixnumRange arguments1Value_ = (RubyRange.LongFixnumRange)arguments1Value;
                        if (RubyGuards.wasNotProvided(arguments2Value) || this.root.isRubiniusUndefined(arguments2Value)) {
                            return this.root.sliceLongRange(frameValue, arguments0Value_, arguments1Value_, arguments2Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(GetIndexNodeGen root) {
                    return new SliceLongRangeNode_(root);
                }
            }

            @GeneratedBy(methodName="sliceIntegerRange(VirtualFrame, RubyBasicObject, IntegerFixnumRange, Object)", value=StringNodes.GetIndexNode.class)
            private static final class SliceIntegerRangeNode_
            extends BaseNode_ {
                SliceIntegerRangeNode_(GetIndexNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyRange.IntegerFixnumRange) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyRange.IntegerFixnumRange arguments1Value_ = (RubyRange.IntegerFixnumRange)arguments1Value;
                        if (RubyGuards.wasNotProvided(arguments2Value) || this.root.isRubiniusUndefined(arguments2Value)) {
                            return this.root.sliceIntegerRange(frameValue, arguments0Value_, arguments1Value_, arguments2Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(GetIndexNodeGen root) {
                    return new SliceIntegerRangeNode_(root);
                }
            }

            @GeneratedBy(methodName="getIndex(VirtualFrame, RubyBasicObject, Object, Object)", value=StringNodes.GetIndexNode.class)
            private static final class GetIndex1Node_
            extends BaseNode_ {
                GetIndex1Node_(GetIndexNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (!(RubyGuards.isRubyRange(arguments1Value) || RubyGuards.isRubyRegexp(arguments1Value) || RubyGuards.isRubyString(arguments1Value) || !RubyGuards.wasNotProvided(arguments2Value) && !this.root.isRubiniusUndefined(arguments2Value))) {
                            return this.root.getIndex(frameValue, arguments0Value_, arguments1Value, arguments2Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(GetIndexNodeGen root) {
                    return new GetIndex1Node_(root);
                }
            }

            @GeneratedBy(methodName="getIndex(VirtualFrame, RubyBasicObject, int, Object)", value=StringNodes.GetIndexNode.class)
            private static final class GetIndex0Node_
            extends BaseNode_ {
                GetIndex0Node_(GetIndexNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value);
                    }
                    Object arguments2Value_ = this.executeArguments2_((Frame)frameValue);
                    if (RubyGuards.wasNotProvided(arguments2Value_) || this.root.isRubiniusUndefined(arguments2Value_)) {
                        return this.root.getIndex(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof Integer) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (RubyGuards.wasNotProvided(arguments2Value) || this.root.isRubiniusUndefined(arguments2Value)) {
                            return this.root.getIndex(frameValue, arguments0Value_, arguments1Value_, arguments2Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(GetIndexNodeGen root) {
                    return new GetIndex0Node_(root);
                }
            }

            @GeneratedBy(value=StringNodes.GetIndexNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(GetIndexNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(GetIndexNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.GetIndexNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(GetIndexNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(GetIndexNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.GetIndexNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final GetIndexNodeGen root;

                BaseNode_(GetIndexNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    Object arguments2Value_ = this.executeArguments2_((Frame)frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        if (arguments1Value instanceof Integer && (RubyGuards.wasNotProvided(arguments2Value) || this.root.isRubiniusUndefined(arguments2Value))) {
                            return GetIndex0Node_.create(this.root);
                        }
                        if (!(RubyGuards.isRubyRange(arguments1Value) || RubyGuards.isRubyRegexp(arguments1Value) || RubyGuards.isRubyString(arguments1Value) || !RubyGuards.wasNotProvided(arguments2Value) && !this.root.isRubiniusUndefined(arguments2Value))) {
                            return GetIndex1Node_.create(this.root);
                        }
                        if (arguments1Value instanceof RubyRange.IntegerFixnumRange && (RubyGuards.wasNotProvided(arguments2Value) || this.root.isRubiniusUndefined(arguments2Value))) {
                            return SliceIntegerRangeNode_.create(this.root);
                        }
                        if (arguments1Value instanceof RubyRange.LongFixnumRange && (RubyGuards.wasNotProvided(arguments2Value) || this.root.isRubiniusUndefined(arguments2Value))) {
                            return SliceLongRangeNode_.create(this.root);
                        }
                        if (arguments1Value instanceof RubyRange.ObjectRange && (RubyGuards.wasNotProvided(arguments2Value) || this.root.isRubiniusUndefined(arguments2Value))) {
                            return SliceObjectRangeNode_.create(this.root);
                        }
                        if (arguments1Value instanceof Integer) {
                            if (arguments2Value instanceof Integer) {
                                return Slice0Node_.create(this.root);
                            }
                            if (RubyGuards.wasProvided(arguments2Value)) {
                                return Slice10Node_.create(this.root);
                            }
                        }
                        if (!RubyGuards.isRubyRange(arguments1Value) && !RubyGuards.isRubyRegexp(arguments1Value) && !RubyGuards.isRubyString(arguments1Value) && RubyGuards.wasProvided(arguments2Value)) {
                            return Slice20Node_.create(this.root);
                        }
                        if (arguments1Value instanceof RubyBasicObject) {
                            RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                            if (RubyGuards.isRubyRegexp(arguments1Value_) && (RubyGuards.wasNotProvided(arguments2Value) || this.root.isRubiniusUndefined(arguments2Value))) {
                                return Slice11Node_.create(this.root);
                            }
                            if (RubyGuards.isRubyRegexp(arguments1Value_) && RubyGuards.wasProvided(arguments2Value)) {
                                return SliceCaptureNode_.create(this.root);
                            }
                            if ((RubyGuards.wasNotProvided(arguments2Value) || this.root.isRubiniusUndefined(arguments2Value)) && RubyGuards.isRubyString(arguments1Value_)) {
                                return Slice21Node_.create(this.root);
                            }
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments2_(Frame frameValue) {
                    Object object;
                    Class arguments2Type_ = this.root.arguments2Type_;
                    if (arguments2Type_ == Integer.TYPE) {
                        return this.root.arguments2_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments2Type_ != null) return this.root.arguments2_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments2_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments2Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments2Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments2Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.ConcatNode.class)
    public static final class ConcatNodeFactory
    extends NodeFactoryBase<StringNodes.ConcatNode> {
        private static ConcatNodeFactory concatNodeFactoryInstance;

        private ConcatNodeFactory() {
            super(StringNodes.ConcatNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public StringNodes.ConcatNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return ConcatNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.ConcatNode> getInstance() {
            if (concatNodeFactoryInstance == null) {
                concatNodeFactoryInstance = new ConcatNodeFactory();
            }
            return concatNodeFactoryInstance;
        }

        public static StringNodes.ConcatNode create(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode other) {
            return new ConcatNodeGen(context, sourceSection, string, other);
        }

        @GeneratedBy(value=StringNodes.ConcatNode.class)
        public static final class ConcatNodeGen
        extends StringNodes.ConcatNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode string_;
            @Node.Child
            private RubyNode other_;
            @CompilerDirectives.CompilationFinal
            private Class<?> otherType_;
            @Node.Child
            private BaseNode_ specialization_;

            private ConcatNodeGen(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode other) {
                super(context, sourceSection);
                this.string_ = string;
                this.other_ = other;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeRubyBasicObject(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            private static RubyBasicObject expectRubyBasicObject(Object value) throws UnexpectedResultException {
                if (value instanceof RubyBasicObject) {
                    return (RubyBasicObject)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="concat(VirtualFrame, RubyBasicObject, Object)", value=StringNodes.ConcatNode.class)
            private static final class Concat2Node_
            extends BaseNode_ {
                Concat2Node_(ConcatNodeGen root) {
                    super(root, 5);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                    if (stringValue instanceof RubyBasicObject) {
                        RubyBasicObject stringValue_ = (RubyBasicObject)stringValue;
                        if (!(RubyGuards.isInteger(otherValue) || RubyGuards.isLong(otherValue) || RubyGuards.isRubyBignum(otherValue) || RubyGuards.isRubyString(otherValue))) {
                            return this.root.concat(frameValue, stringValue_, otherValue);
                        }
                    }
                    return this.getNext().execute_(frameValue, stringValue, otherValue);
                }

                static BaseNode_ create(ConcatNodeGen root) {
                    return new Concat2Node_(root);
                }
            }

            @GeneratedBy(methodName="concatString(RubyBasicObject, RubyBasicObject)", value=StringNodes.ConcatNode.class)
            private static final class ConcatStringNode_
            extends BaseNode_ {
                ConcatStringNode_(ConcatNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                    if (stringValue instanceof RubyBasicObject && otherValue instanceof RubyBasicObject) {
                        RubyBasicObject stringValue_ = (RubyBasicObject)stringValue;
                        RubyBasicObject otherValue_ = (RubyBasicObject)otherValue;
                        if (RubyGuards.isRubyString(otherValue_)) {
                            return this.root.concatString(stringValue_, otherValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, stringValue, otherValue);
                }

                static BaseNode_ create(ConcatNodeGen root) {
                    return new ConcatStringNode_(root);
                }
            }

            @GeneratedBy(methodName="concatBignum(RubyBasicObject, RubyBasicObject)", value=StringNodes.ConcatNode.class)
            private static final class ConcatBignumNode_
            extends BaseNode_ {
                ConcatBignumNode_(ConcatNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                    if (stringValue instanceof RubyBasicObject && otherValue instanceof RubyBasicObject) {
                        RubyBasicObject stringValue_ = (RubyBasicObject)stringValue;
                        RubyBasicObject otherValue_ = (RubyBasicObject)otherValue;
                        if (RubyGuards.isRubyBignum(otherValue_)) {
                            return this.root.concatBignum(stringValue_, otherValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, stringValue, otherValue);
                }

                static BaseNode_ create(ConcatNodeGen root) {
                    return new ConcatBignumNode_(root);
                }
            }

            @GeneratedBy(methodName="concat(RubyBasicObject, long)", value=StringNodes.ConcatNode.class)
            private static final class Concat1Node_
            extends BaseNode_ {
                private final Class<?> otherImplicitType;

                Concat1Node_(ConcatNodeGen root, Object otherValue) {
                    super(root, 2);
                    this.otherImplicitType = RubyTypesGen.getImplicitLongClass(otherValue);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.otherImplicitType == ((Concat1Node_)other).otherImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    long otherValue_;
                    RubyBasicObject stringValue_;
                    block6: {
                        try {
                            stringValue_ = this.root.string_.executeRubyBasicObject(frameValue);
                        }
                        catch (UnexpectedResultException ex) {
                            Object otherValue = this.executeOther_((Frame)frameValue);
                            return ConcatNodeGen.expectRubyBasicObject(this.getNext().execute_(frameValue, ex.getResult(), otherValue));
                        }
                        try {
                            if (this.otherImplicitType == Long.TYPE) {
                                otherValue_ = this.root.other_.executeLong(frameValue);
                                break block6;
                            }
                            if (this.otherImplicitType == Integer.TYPE) {
                                otherValue_ = RubyTypes.int2long(this.root.other_.executeInteger(frameValue));
                                break block6;
                            }
                            Object otherValue__ = this.executeOther_((Frame)frameValue);
                            throw new UnexpectedResultException(otherValue__);
                        }
                        catch (UnexpectedResultException ex) {
                            return ConcatNodeGen.expectRubyBasicObject(this.getNext().execute_(frameValue, stringValue_, ex.getResult()));
                        }
                    }
                    return this.root.concat(stringValue_, otherValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                    if (stringValue instanceof RubyBasicObject && RubyTypesGen.isImplicitLong(otherValue, this.otherImplicitType)) {
                        RubyBasicObject stringValue_ = (RubyBasicObject)stringValue;
                        long otherValue_ = RubyTypesGen.asImplicitLong(otherValue, this.otherImplicitType);
                        return this.root.concat(stringValue_, otherValue_);
                    }
                    return this.getNext().execute_(frameValue, stringValue, otherValue);
                }

                static BaseNode_ create(ConcatNodeGen root, Object otherValue) {
                    return new Concat1Node_(root, otherValue);
                }
            }

            @GeneratedBy(methodName="concat(RubyBasicObject, int)", value=StringNodes.ConcatNode.class)
            private static final class Concat0Node_
            extends BaseNode_ {
                Concat0Node_(ConcatNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    int otherValue_;
                    RubyBasicObject stringValue_;
                    try {
                        stringValue_ = this.root.string_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object otherValue = this.executeOther_((Frame)frameValue);
                        return ConcatNodeGen.expectRubyBasicObject(this.getNext().execute_(frameValue, ex.getResult(), otherValue));
                    }
                    try {
                        otherValue_ = this.root.other_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ConcatNodeGen.expectRubyBasicObject(this.getNext().execute_(frameValue, stringValue_, ex.getResult()));
                    }
                    return this.root.concat(stringValue_, otherValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                    if (stringValue instanceof RubyBasicObject && otherValue instanceof Integer) {
                        RubyBasicObject stringValue_ = (RubyBasicObject)stringValue;
                        int otherValue_ = (Integer)otherValue;
                        return this.root.concat(stringValue_, otherValue_);
                    }
                    return this.getNext().execute_(frameValue, stringValue, otherValue);
                }

                static BaseNode_ create(ConcatNodeGen root) {
                    return new Concat0Node_(root);
                }
            }

            @GeneratedBy(value=StringNodes.ConcatNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ConcatNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object stringValue, Object otherValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, stringValue, otherValue));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                    return this.getNext().execute_(frameValue, stringValue, otherValue);
                }

                static BaseNode_ create(ConcatNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.ConcatNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ConcatNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                    return this.uninitialized((Frame)frameValue, stringValue, otherValue);
                }

                static BaseNode_ create(ConcatNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.ConcatNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final ConcatNodeGen root;

                BaseNode_(ConcatNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.string_, this.root.other_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object stringValue, Object otherValue) {
                    return this.execute_((VirtualFrame)frameValue, stringValue, otherValue);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object stringValue_ = this.root.string_.execute(frameValue);
                    Object otherValue_ = this.executeOther_((Frame)frameValue);
                    return this.execute_(frameValue, stringValue_, otherValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    return ConcatNodeGen.expectRubyBasicObject(this.execute(frameValue));
                }

                protected final SpecializationNode createNext(Frame frameValue, Object stringValue, Object otherValue) {
                    if (stringValue instanceof RubyBasicObject) {
                        if (otherValue instanceof Integer) {
                            return Concat0Node_.create(this.root);
                        }
                        if (RubyTypesGen.isImplicitLong(otherValue)) {
                            return Concat1Node_.create(this.root, otherValue);
                        }
                        if (otherValue instanceof RubyBasicObject) {
                            RubyBasicObject otherValue_ = (RubyBasicObject)otherValue;
                            if (RubyGuards.isRubyBignum(otherValue_)) {
                                return ConcatBignumNode_.create(this.root);
                            }
                            if (RubyGuards.isRubyString(otherValue_)) {
                                return ConcatStringNode_.create(this.root);
                            }
                        }
                        if (!(RubyGuards.isInteger(otherValue) || RubyGuards.isLong(otherValue) || RubyGuards.isRubyBignum(otherValue) || RubyGuards.isRubyString(otherValue))) {
                            return Concat2Node_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeOther_(Frame frameValue) {
                    Object object;
                    Class otherType_ = this.root.otherType_;
                    if (otherType_ == Integer.TYPE) {
                        return this.root.other_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (otherType_ == Long.TYPE) {
                        return this.root.other_.executeLong((VirtualFrame)frameValue);
                    }
                    if (otherType_ != null) return this.root.other_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.other_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.otherType_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.otherType_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.otherType_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.CompareNode.class)
    public static final class CompareNodeFactory
    extends NodeFactoryBase<StringNodes.CompareNode> {
        private static CompareNodeFactory compareNodeFactoryInstance;

        private CompareNodeFactory() {
            super(StringNodes.CompareNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.CompareNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CompareNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.CompareNode> getInstance() {
            if (compareNodeFactoryInstance == null) {
                compareNodeFactoryInstance = new CompareNodeFactory();
            }
            return compareNodeFactoryInstance;
        }

        public static StringNodes.CompareNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new CompareNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.CompareNode.class)
        public static final class CompareNodeGen
        extends StringNodes.CompareNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private CompareNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeInt(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="compare(VirtualFrame, RubyBasicObject, Object)", value=StringNodes.CompareNode.class)
            private static final class Compare1Node_
            extends BaseNode_ {
                Compare1Node_(CompareNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (!RubyGuards.isRubyString(arguments1Value)) {
                            return this.root.compare(frameValue, arguments0Value_, arguments1Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompareNodeGen root) {
                    return new Compare1Node_(root);
                }
            }

            @GeneratedBy(methodName="compare(RubyBasicObject, RubyBasicObject)", value=StringNodes.CompareNode.class)
            private static final class Compare0Node_
            extends BaseNode_ {
                Compare0Node_(CompareNodeGen root) {
                    super(root, 1);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    RubyBasicObject arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.root.arguments1_.execute(frameValue);
                        return CompareNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return CompareNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (RubyGuards.isRubyString(arguments1Value_)) {
                        return this.root.compare(arguments0Value_, arguments1Value_);
                    }
                    return CompareNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments1Value_)) {
                            return this.root.compare(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompareNodeGen root) {
                    return new Compare0Node_(root);
                }
            }

            @GeneratedBy(value=StringNodes.CompareNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(CompareNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompareNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.CompareNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(CompareNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompareNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.CompareNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final CompareNodeGen root;

                BaseNode_(CompareNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    return CompareNodeGen.expectInteger(this.execute(frameValue));
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments1Value_;
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyString(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return Compare0Node_.create(this.root);
                        }
                        if (!RubyGuards.isRubyString(arguments1Value)) {
                            return Compare1Node_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.EqualNode.class)
    public static final class EqualNodeFactory
    extends NodeFactoryBase<StringNodes.EqualNode> {
        private static EqualNodeFactory equalNodeFactoryInstance;

        private EqualNodeFactory() {
            super(StringNodes.EqualNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.EqualNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EqualNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.EqualNode> getInstance() {
            if (equalNodeFactoryInstance == null) {
                equalNodeFactoryInstance = new EqualNodeFactory();
            }
            return equalNodeFactoryInstance;
        }

        public static StringNodes.EqualNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new EqualNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.EqualNode.class)
        public static final class EqualNodeGen
        extends StringNodes.EqualNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private EqualNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.specialization_.executeBoolean(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="equal(VirtualFrame, RubyBasicObject, Object)", value=StringNodes.EqualNode.class)
            private static final class Equal1Node_
            extends BaseNode_ {
                Equal1Node_(EqualNodeGen root) {
                    super(root, 2);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.root.arguments1_.execute(frameValue);
                        return this.getNext().executeBoolean_(frameValue, ex.getResult(), arguments1Value);
                    }
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    if (!RubyGuards.isRubyString(arguments1Value_)) {
                        return this.root.equal(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (!RubyGuards.isRubyString(arguments1Value)) {
                            return this.root.equal(frameValue, arguments0Value_, arguments1Value);
                        }
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EqualNodeGen root) {
                    return new Equal1Node_(root);
                }
            }

            @GeneratedBy(methodName="equal(RubyBasicObject, RubyBasicObject)", value=StringNodes.EqualNode.class)
            private static final class Equal0Node_
            extends BaseNode_ {
                Equal0Node_(EqualNodeGen root) {
                    super(root, 1);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.root.arguments1_.execute(frameValue);
                        return this.getNext().executeBoolean_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyString(arguments1Value_)) {
                        return this.root.equal(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments1Value_)) {
                            return this.root.equal(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EqualNodeGen root) {
                    return new Equal0Node_(root);
                }
            }

            @GeneratedBy(value=StringNodes.EqualNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(EqualNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EqualNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.EqualNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(EqualNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (Boolean)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EqualNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.EqualNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final EqualNodeGen root;

                BaseNode_(EqualNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeBoolean_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract boolean executeBoolean_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) {
                    return (Boolean)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments1Value_;
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyString(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return Equal0Node_.create(this.root);
                        }
                        if (!RubyGuards.isRubyString(arguments1Value)) {
                            return Equal1Node_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.MulNode.class)
    public static final class MulNodeFactory
    extends NodeFactoryBase<StringNodes.MulNode> {
        private static MulNodeFactory mulNodeFactoryInstance;

        private MulNodeFactory() {
            super(StringNodes.MulNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public StringNodes.MulNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MulNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.MulNode> getInstance() {
            if (mulNodeFactoryInstance == null) {
                mulNodeFactoryInstance = new MulNodeFactory();
            }
            return mulNodeFactoryInstance;
        }

        public static StringNodes.MulNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new MulNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.MulNode.class)
        public static final class MulNodeGen
        extends StringNodes.MulNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private MulNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                return this.specialization_.executeRubyBasicObject(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="multiply(VirtualFrame, RubyBasicObject, Object)", value=StringNodes.MulNode.class)
            private static final class Multiply2Node_
            extends BaseNode_ {
                Multiply2Node_(MulNodeGen root) {
                    super(root, 3);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (!RubyGuards.isRubyBignum(arguments1Value) && !RubyGuards.isInteger(arguments1Value)) {
                            return this.root.multiply(frameValue, arguments0Value_, arguments1Value);
                        }
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MulNodeGen root) {
                    return new Multiply2Node_(root);
                }
            }

            @GeneratedBy(methodName="multiply(RubyBasicObject, RubyBasicObject)", value=StringNodes.MulNode.class)
            private static final class Multiply1Node_
            extends BaseNode_ {
                Multiply1Node_(MulNodeGen root) {
                    super(root, 2);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.multiply(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MulNodeGen root) {
                    return new Multiply1Node_(root);
                }
            }

            @GeneratedBy(methodName="multiply(RubyBasicObject, int)", value=StringNodes.MulNode.class)
            private static final class Multiply0Node_
            extends BaseNode_ {
                Multiply0Node_(MulNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeRubyBasicObject(frameValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    int arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeRubyBasicObject_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.multiply(arguments0Value_, arguments1Value_);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof Integer) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.multiply(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MulNodeGen root) {
                    return new Multiply0Node_(root);
                }
            }

            @GeneratedBy(value=StringNodes.MulNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(MulNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MulNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.MulNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(MulNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (RubyBasicObject)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MulNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.MulNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final MulNodeGen root;

                BaseNode_(MulNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeRubyBasicObject_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract RubyBasicObject executeRubyBasicObject_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return this.executeRubyBasicObject_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    return (RubyBasicObject)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments1Value_;
                        if (arguments1Value instanceof Integer) {
                            return Multiply0Node_.create(this.root);
                        }
                        if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                            return Multiply1Node_.create(this.root);
                        }
                        if (!RubyGuards.isRubyBignum(arguments1Value) && !RubyGuards.isInteger(arguments1Value)) {
                            return Multiply2Node_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.AddNode.class)
    public static final class AddNodeFactory
    extends NodeFactoryBase<StringNodes.AddNode> {
        private static AddNodeFactory addNodeFactoryInstance;

        private AddNodeFactory() {
            super(StringNodes.AddNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public StringNodes.AddNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return AddNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.AddNode> getInstance() {
            if (addNodeFactoryInstance == null) {
                addNodeFactoryInstance = new AddNodeFactory();
            }
            return addNodeFactoryInstance;
        }

        public static StringNodes.AddNode create(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode other) {
            return new AddNodeGen(context, sourceSection, string, other);
        }

        @GeneratedBy(value=StringNodes.AddNode.class)
        public static final class AddNodeGen
        extends StringNodes.AddNode {
            @Node.Child
            private RubyNode string_;
            @Node.Child
            private RubyNode other_;

            private AddNodeGen(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode other) {
                super(context, sourceSection);
                this.string_ = string;
                this.other_ = this.coerceOtherToString(other);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject otherValue_;
                RubyBasicObject stringValue_;
                try {
                    stringValue_ = this.string_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object otherValue = this.other_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), otherValue);
                }
                try {
                    otherValue_ = this.other_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(stringValue_, ex.getResult());
                }
                if (RubyGuards.isRubyString(otherValue_)) {
                    return this.add(stringValue_, otherValue_);
                }
                throw this.unsupported(stringValue_, otherValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object stringValue, Object otherValue) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.string_, this.other_}, new Object[]{stringValue, otherValue});
            }
        }
    }
}

