/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Collection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;

public class LoadRequiredLibrariesNode
extends RubyNode {
    @Node.Child
    CallDispatchHeadNode requireNode;

    public LoadRequiredLibrariesNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.requireNode = DispatchHeadNodeFactory.createMethodCallOnSelf(context);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object self = RubyArguments.getSelf(frame.getArguments());
        Collection requiredLibraries = this.getContext().getRuntime().getInstanceConfig().getRequiredLibraries();
        for (String requiredLibrary : requiredLibraries) {
            this.requireNode.call(frame, self, "require", null, this.createString(requiredLibrary));
        }
        return this.nil();
    }
}

