/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.exceptions.MainExitException;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyRootNode;
import org.jruby.truffle.nodes.StringCachingGuards;
import org.jruby.truffle.nodes.cast.BooleanCastWithDefaultNodeGen;
import org.jruby.truffle.nodes.cast.NumericToFloatNode;
import org.jruby.truffle.nodes.cast.NumericToFloatNodeGen;
import org.jruby.truffle.nodes.coerce.NameToJavaStringNodeGen;
import org.jruby.truffle.nodes.coerce.ToPathNodeGen;
import org.jruby.truffle.nodes.coerce.ToStrNodeGen;
import org.jruby.truffle.nodes.core.BasicObjectNodes;
import org.jruby.truffle.nodes.core.BasicObjectNodesFactory;
import org.jruby.truffle.nodes.core.BignumNodes;
import org.jruby.truffle.nodes.core.BindingNodes;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.EncodingNodes;
import org.jruby.truffle.nodes.core.KernelNodesFactory;
import org.jruby.truffle.nodes.core.MethodNodes;
import org.jruby.truffle.nodes.core.ProcNodes;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.nodes.core.SymbolNodes;
import org.jruby.truffle.nodes.core.ThreadBacktraceLocationNodes;
import org.jruby.truffle.nodes.core.UnaryCoreMethodNode;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.nodes.core.hash.HashNodes;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.dispatch.DispatchNode;
import org.jruby.truffle.nodes.dispatch.DoesRespondDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.MissingBehavior;
import org.jruby.truffle.nodes.methods.LookupMethodNode;
import org.jruby.truffle.nodes.methods.LookupMethodNodeGen;
import org.jruby.truffle.nodes.objects.ClassNode;
import org.jruby.truffle.nodes.objects.ClassNodeGen;
import org.jruby.truffle.nodes.objects.FreezeNode;
import org.jruby.truffle.nodes.objects.FreezeNodeGen;
import org.jruby.truffle.nodes.objects.IsFrozenNode;
import org.jruby.truffle.nodes.objects.IsFrozenNodeGen;
import org.jruby.truffle.nodes.objects.IsTaintedNode;
import org.jruby.truffle.nodes.objects.IsTaintedNodeGen;
import org.jruby.truffle.nodes.objects.MetaClassNode;
import org.jruby.truffle.nodes.objects.MetaClassNodeGen;
import org.jruby.truffle.nodes.objects.SingletonClassNode;
import org.jruby.truffle.nodes.objects.SingletonClassNodeGen;
import org.jruby.truffle.nodes.objects.TaintNode;
import org.jruby.truffle.nodes.objects.TaintNodeGen;
import org.jruby.truffle.nodes.objectstorage.WriteHeadObjectFieldNode;
import org.jruby.truffle.nodes.rubinius.ObjectPrimitiveNodes;
import org.jruby.truffle.nodes.rubinius.ObjectPrimitiveNodesFactory;
import org.jruby.truffle.pack.parser.FormatParser;
import org.jruby.truffle.pack.runtime.PackResult;
import org.jruby.truffle.pack.runtime.exceptions.CantCompressNegativeException;
import org.jruby.truffle.pack.runtime.exceptions.CantConvertException;
import org.jruby.truffle.pack.runtime.exceptions.FormatException;
import org.jruby.truffle.pack.runtime.exceptions.NoImplicitConversionException;
import org.jruby.truffle.pack.runtime.exceptions.OutsideOfStringException;
import org.jruby.truffle.pack.runtime.exceptions.PackException;
import org.jruby.truffle.pack.runtime.exceptions.RangeException;
import org.jruby.truffle.pack.runtime.exceptions.TooFewArgumentsException;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyCallStack;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.ThreadLocalObject;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.backtrace.Activation;
import org.jruby.truffle.runtime.backtrace.Backtrace;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.core.RubyThread;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.truffle.runtime.subsystems.FeatureManager;
import org.jruby.truffle.runtime.subsystems.ThreadManager;
import org.jruby.truffle.translator.NodeWrapper;
import org.jruby.truffle.translator.TranslatorDriver;
import org.jruby.util.ByteList;

@CoreClass(name="Kernel")
public abstract class KernelNodes {

    @CoreMethod(names={"untaint"})
    public static abstract class UntaintNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private IsFrozenNode isFrozenNode;
        @Node.Child
        private IsTaintedNode isTaintedNode;
        @Node.Child
        private WriteHeadObjectFieldNode writeTaintNode;

        public UntaintNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.isFrozenNode = IsFrozenNodeGen.create(context, sourceSection, null);
            this.isTaintedNode = IsTaintedNodeGen.create(context, sourceSection, null);
            this.writeTaintNode = new WriteHeadObjectFieldNode(RubyBasicObject.TAINTED_IDENTIFIER);
        }

        @Specialization
        public Object taint(RubyBasicObject object) {
            if (!this.isTaintedNode.executeIsTainted(object)) {
                return object;
            }
            if (this.isFrozenNode.executeIsFrozen(object)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().frozenError(this.getContext().getCoreLibrary().getLogicalClass(object).getName(), this));
            }
            this.writeTaintNode.execute(object, false);
            return object;
        }
    }

    @CoreMethod(names={"to_s", "inspect"})
    public static abstract class ToSNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ClassNode classNode;
        @Node.Child
        private ObjectPrimitiveNodes.ObjectIDPrimitiveNode objectIDNode;
        @Node.Child
        private ToHexStringNode toHexStringNode;

        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.classNode = ClassNodeGen.create(context, sourceSection, null);
            this.objectIDNode = ObjectPrimitiveNodesFactory.ObjectIDPrimitiveNodeFactory.create(context, sourceSection, new RubyNode[]{null});
            this.toHexStringNode = KernelNodesFactory.ToHexStringNodeFactory.create(context, sourceSection, new RubyNode[]{null});
        }

        public abstract RubyBasicObject executeToS(VirtualFrame var1, Object var2);

        @Specialization
        public RubyBasicObject toS(VirtualFrame frame, Object self) {
            CompilerDirectives.transferToInterpreter();
            String className = this.classNode.executeGetClass(frame, self).getName();
            Object id = this.objectIDNode.executeObjectID(frame, self);
            String hexID = this.toHexStringNode.executeToHexString(frame, id);
            return this.createString("#<" + className + ":0x" + hexID + ">");
        }
    }

    public static abstract class ToHexStringNode
    extends CoreMethodArrayArgumentsNode {
        public ToHexStringNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public abstract String executeToHexString(VirtualFrame var1, Object var2);

        @Specialization
        public String toHexString(int value) {
            return this.toHexString((long)value);
        }

        @Specialization
        public String toHexString(long value) {
            return Long.toHexString(value);
        }

        @Specialization(guards={"isRubyBignum(value)"})
        public String toHexString(RubyBasicObject value) {
            return BignumNodes.getBigIntegerValue(value).toString(16);
        }
    }

    @CoreMethod(names={"tainted?"})
    public static abstract class KernelIsTaintedNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private IsTaintedNode isTaintedNode;

        public KernelIsTaintedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean isTainted(Object object) {
            if (this.isTaintedNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.isTaintedNode = (IsTaintedNode)this.insert(IsTaintedNodeGen.create(this.getContext(), this.getEncapsulatingSourceSection(), null));
            }
            return this.isTaintedNode.executeIsTainted(object);
        }
    }

    @CoreMethod(names={"taint"})
    public static abstract class KernelTaintNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TaintNode taintNode;

        public KernelTaintNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object taint(Object object) {
            if (this.taintNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.taintNode = (TaintNode)this.insert(TaintNodeGen.create(this.getContext(), this.getEncapsulatingSourceSection(), null));
            }
            return this.taintNode.executeTaint(object);
        }
    }

    @CoreMethod(names={"system"}, isModuleFunction=true, needsSelf=false, required=1)
    public static abstract class SystemNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode toHashNode;

        public SystemNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(command)"})
        public boolean system(VirtualFrame frame, RubyBasicObject command) {
            if (this.toHashNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toHashNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            CompilerDirectives.transferToInterpreter();
            RubyBasicObject env = this.getContext().getCoreLibrary().getENV();
            RubyBasicObject envAsHash = (RubyBasicObject)this.toHashNode.call(frame, env, "to_hash", null, new Object[0]);
            ArrayList<String> envp = new ArrayList<String>();
            for (Map.Entry<Object, Object> keyValue : HashNodes.iterableKeyValues(envAsHash)) {
                envp.add(keyValue.getKey().toString() + "=" + keyValue.getValue().toString());
            }
            try {
                Runtime.getRuntime().exec(new String[]{"bash", "-c", command.toString()}, envp.toArray(new String[envp.size()]));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return true;
        }
    }

    @CoreMethod(names={"format", "sprintf"}, isModuleFunction=true, argumentsAsArray=true, required=1, taintFromParameter=0)
    @ImportStatic(value={StringCachingGuards.class})
    public static abstract class FormatNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TaintNode taintNode;

        public FormatNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(firstArgument(arguments))", "byteListsEqual(asRubyBasicObject(firstArgument(arguments)), cachedFormat)"})
        public RubyBasicObject formatCached(VirtualFrame frame, Object[] arguments, @Cached(value="privatizeByteList(asRubyBasicObject(firstArgument(arguments)))") ByteList cachedFormat, @Cached(value="create(compileFormat(asRubyBasicObject(firstArgument(arguments))))") DirectCallNode callPackNode) {
            PackResult result;
            Object[] store = ArrayUtils.extractRange(arguments, 1, arguments.length);
            try {
                result = (PackResult)callPackNode.call(frame, new Object[]{store, store.length});
            }
            catch (PackException e) {
                CompilerDirectives.transferToInterpreter();
                throw this.handleException(e);
            }
            return this.finishFormat(cachedFormat, result);
        }

        @Specialization(guards={"isRubyString(firstArgument(arguments))"}, contains={"formatCached"})
        public RubyBasicObject formatUncached(VirtualFrame frame, Object[] arguments, @Cached(value="create()") IndirectCallNode callPackNode) {
            PackResult result;
            RubyBasicObject format = (RubyBasicObject)arguments[0];
            Object[] store = ArrayUtils.extractRange(arguments, 1, arguments.length);
            try {
                result = (PackResult)callPackNode.call(frame, this.compileFormat((RubyBasicObject)arguments[0]), new Object[]{store, store.length});
            }
            catch (PackException e) {
                CompilerDirectives.transferToInterpreter();
                throw this.handleException(e);
            }
            return this.finishFormat(StringNodes.getByteList(format), result);
        }

        private RuntimeException handleException(PackException exception) {
            try {
                throw exception;
            }
            catch (TooFewArgumentsException e) {
                return new RaiseException(this.getContext().getCoreLibrary().argumentError("too few arguments", this));
            }
            catch (NoImplicitConversionException e) {
                return new RaiseException(this.getContext().getCoreLibrary().typeErrorNoImplicitConversion(e.getObject(), e.getTarget(), this));
            }
            catch (OutsideOfStringException e) {
                return new RaiseException(this.getContext().getCoreLibrary().argumentError("X outside of string", this));
            }
            catch (CantCompressNegativeException e) {
                return new RaiseException(this.getContext().getCoreLibrary().argumentError("can't compress negative numbers", this));
            }
            catch (RangeException e) {
                return new RaiseException(this.getContext().getCoreLibrary().rangeError(e.getMessage(), (Node)this));
            }
            catch (CantConvertException e) {
                return new RaiseException(this.getContext().getCoreLibrary().typeError(e.getMessage(), this));
            }
        }

        private RubyBasicObject finishFormat(ByteList format, PackResult result) {
            RubyBasicObject string = this.createString(new ByteList(result.getOutput(), 0, result.getOutputLength()));
            if (format.length() == 0) {
                StringNodes.forceEncoding(string, (Encoding)USASCIIEncoding.INSTANCE);
            } else {
                switch (result.getEncoding()) {
                    case DEFAULT: 
                    case ASCII_8BIT: {
                        break;
                    }
                    case US_ASCII: {
                        StringNodes.forceEncoding(string, (Encoding)USASCIIEncoding.INSTANCE);
                        break;
                    }
                    case UTF_8: {
                        StringNodes.forceEncoding(string, (Encoding)UTF8Encoding.INSTANCE);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            if (result.isTainted()) {
                if (this.taintNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.taintNode = (TaintNode)this.insert(TaintNodeGen.create(this.getContext(), this.getEncapsulatingSourceSection(), null));
                }
                this.taintNode.executeTaint(string);
            }
            return string;
        }

        protected CallTarget compileFormat(RubyBasicObject format) {
            assert (RubyGuards.isRubyString(format));
            try {
                return new FormatParser(this.getContext()).parse(StringNodes.getByteList(format));
            }
            catch (FormatException e) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError(e.getMessage(), this));
            }
        }

        protected Object firstArgument(Object[] args) {
            return args[0];
        }

        protected RubyBasicObject asRubyBasicObject(Object arg) {
            return (RubyBasicObject)arg;
        }
    }

    @CoreMethod(names={"sleep"}, isModuleFunction=true, optional=1)
    public static abstract class SleepNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        NumericToFloatNode floatCastNode;

        public SleepNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public long sleep(NotProvided duration) {
            return this.doSleepMillis(Long.MAX_VALUE);
        }

        @Specialization
        public long sleep(int duration) {
            return this.doSleepMillis((long)duration * 1000L);
        }

        @Specialization
        public long sleep(long duration) {
            return this.doSleepMillis(duration * 1000L);
        }

        @Specialization
        public long sleep(double duration) {
            return this.doSleepMillis((long)(duration * 1000.0));
        }

        @Specialization(guards={"isRubiniusUndefined(duration)"})
        public long sleep(RubyBasicObject duration) {
            return this.sleep(NotProvided.INSTANCE);
        }

        @Specialization(guards={"!isRubiniusUndefined(duration)"})
        public long sleep(VirtualFrame frame, RubyBasicObject duration) {
            if (this.floatCastNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.floatCastNode = (NumericToFloatNode)this.insert(NumericToFloatNodeGen.create(this.getContext(), this.getSourceSection(), "to_f", null));
            }
            return this.sleep(this.floatCastNode.executeDouble(frame, duration));
        }

        @CompilerDirectives.TruffleBoundary
        private long doSleepMillis(long durationInMillis) {
            if (durationInMillis < 0L) {
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("time interval must be positive", this));
            }
            RubyThread thread = this.getContext().getThreadManager().getCurrentThread();
            thread.shouldWakeUp();
            return SleepNode.sleepFor(this.getContext(), durationInMillis);
        }

        public static long sleepFor(RubyContext context, final long durationInMillis) {
            assert (durationInMillis >= 0L);
            final RubyThread thread = context.getThreadManager().getCurrentThread();
            final long start = System.currentTimeMillis();
            long slept = context.getThreadManager().runUntilResult(new ThreadManager.BlockingActionWithoutGlobalLock<Long>(){

                @Override
                public Long block() throws InterruptedException {
                    long now = System.currentTimeMillis();
                    long slept = now - start;
                    if (slept >= durationInMillis || thread.shouldWakeUp()) {
                        return slept;
                    }
                    Thread.sleep(durationInMillis - slept);
                    return System.currentTimeMillis() - start;
                }
            });
            return slept / 1000L;
        }
    }

    @CoreMethod(names={"String"}, isModuleFunction=true, required=1)
    public static abstract class StringNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode toS;

        public StringNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.toS = DispatchHeadNodeFactory.createMethodCall(context);
        }

        @Specialization(guards={"isRubyString(value)"})
        public RubyBasicObject string(RubyBasicObject value) {
            return value;
        }

        @Specialization(guards={"!isRubyString(value)"})
        public Object string(VirtualFrame frame, Object value) {
            return this.toS.call(frame, value, "to_s", null, new Object[0]);
        }
    }

    @CoreMethod(names={"singleton_methods"}, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="object"), @NodeChild(type=RubyNode.class, value="includeAncestors")})
    public static abstract class SingletonMethodsNode
    extends CoreMethodNode {
        @Node.Child
        private MetaClassNode metaClassNode;

        public SingletonMethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.metaClassNode = MetaClassNodeGen.create(context, sourceSection, null);
        }

        public abstract RubyBasicObject executeSingletonMethods(VirtualFrame var1, Object var2, boolean var3);

        @CreateCast(value={"includeAncestors"})
        public RubyNode coerceToBoolean(RubyNode includeAncestors) {
            return BooleanCastWithDefaultNodeGen.create(this.getContext(), this.getSourceSection(), true, includeAncestors);
        }

        @Specialization
        public RubyBasicObject singletonMethods(VirtualFrame frame, Object self, boolean includeAncestors) {
            RubyClass metaClass = this.metaClassNode.executeMetaClass(frame, self);
            if (!metaClass.isSingleton()) {
                return this.createEmptyArray();
            }
            CompilerDirectives.transferToInterpreter();
            return ArrayNodes.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), metaClass.filterSingletonMethods(includeAncestors, RubyModule.MethodFilter.PUBLIC_PROTECTED).toArray());
        }
    }

    @CoreMethod(names={"singleton_class"})
    public static abstract class SingletonClassMethodNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private SingletonClassNode singletonClassNode;

        public SingletonClassMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.singletonClassNode = SingletonClassNodeGen.create(context, sourceSection, null);
        }

        @Specialization
        public RubyClass singletonClass(VirtualFrame frame, Object self) {
            return this.singletonClassNode.executeSingletonClass(frame, self);
        }
    }

    @CoreMethod(names={"set_trace_func"}, isModuleFunction=true, required=1)
    public static abstract class SetTraceFuncNode
    extends CoreMethodArrayArgumentsNode {
        public SetTraceFuncNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNil(nil)"})
        public RubyBasicObject setTraceFunc(Object nil) {
            CompilerDirectives.transferToInterpreter();
            this.getContext().getTraceManager().setTraceFunc(null);
            return this.nil();
        }

        @Specialization(guards={"isRubyProc(traceFunc)"})
        public RubyBasicObject setTraceFunc(RubyBasicObject traceFunc) {
            CompilerDirectives.transferToInterpreter();
            this.getContext().getTraceManager().setTraceFunc(traceFunc);
            return traceFunc;
        }
    }

    @CoreMethod(names={"respond_to_missing?"}, required=1, optional=1)
    public static abstract class RespondToMissingNode
    extends CoreMethodArrayArgumentsNode {
        public RespondToMissingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(name)"})
        public boolean doesRespondToMissingString(Object object, RubyBasicObject name, Object unusedIncludeAll) {
            return false;
        }

        @Specialization(guards={"isRubySymbol(name)"})
        public boolean doesRespondToMissingSymbol(Object object, RubyBasicObject name, Object unusedIncludeAll) {
            return false;
        }
    }

    @CoreMethod(names={"respond_to?"}, required=1, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="object"), @NodeChild(type=RubyNode.class, value="name"), @NodeChild(type=RubyNode.class, value="includeProtectedAndPrivate")})
    public static abstract class RespondToNode
    extends CoreMethodNode {
        @Node.Child
        private DoesRespondDispatchHeadNode dispatch;
        @Node.Child
        private DoesRespondDispatchHeadNode dispatchIgnoreVisibility;

        public RespondToNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.dispatch = new DoesRespondDispatchHeadNode(context, false, false, MissingBehavior.RETURN_MISSING, null);
            this.dispatchIgnoreVisibility = new DoesRespondDispatchHeadNode(context, true, false, MissingBehavior.RETURN_MISSING, null);
            if (DispatchNode.DISPATCH_METAPROGRAMMING_ALWAYS_UNCACHED) {
                this.dispatch.forceUncached();
                this.dispatchIgnoreVisibility.forceUncached();
            }
        }

        public abstract boolean executeDoesRespondTo(VirtualFrame var1, Object var2, Object var3, boolean var4);

        @CreateCast(value={"includeProtectedAndPrivate"})
        public RubyNode coerceToBoolean(RubyNode includeProtectedAndPrivate) {
            return BooleanCastWithDefaultNodeGen.create(this.getContext(), this.getSourceSection(), false, includeProtectedAndPrivate);
        }

        @Specialization(guards={"isRubyString(name)"})
        public boolean doesRespondToString(VirtualFrame frame, Object object, RubyBasicObject name, boolean includeProtectedAndPrivate) {
            if (includeProtectedAndPrivate) {
                return this.dispatchIgnoreVisibility.doesRespondTo(frame, name, object);
            }
            return this.dispatch.doesRespondTo(frame, name, object);
        }

        @Specialization(guards={"isRubySymbol(name)"})
        public boolean doesRespondToSymbol(VirtualFrame frame, Object object, RubyBasicObject name, boolean includeProtectedAndPrivate) {
            if (includeProtectedAndPrivate) {
                return this.dispatchIgnoreVisibility.doesRespondTo(frame, name, object);
            }
            return this.dispatch.doesRespondTo(frame, name, object);
        }
    }

    @CoreMethod(names={"require_relative"}, isModuleFunction=true, required=1)
    public static abstract class RequireRelativeNode
    extends CoreMethodArrayArgumentsNode {
        public RequireRelativeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(feature)"})
        public boolean requireRelative(RubyBasicObject feature) {
            String featurePath;
            String featureString;
            FeatureManager featureManager = this.getContext().getFeatureManager();
            if (featureManager.isAbsolutePath(featureString = feature.toString())) {
                featurePath = featureString;
            } else {
                Source source = RubyCallStack.getCallerFrame(this.getContext()).getCallNode().getEncapsulatingSourceSection().getSource();
                String sourcePath = featureManager.getSourcePath(source);
                if (sourcePath == null) {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.getContext().getCoreLibrary().loadError("cannot infer basepath", this));
                }
                featurePath = this.dirname(sourcePath) + "/" + featureString;
            }
            try {
                featureManager.require(featurePath, this);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return true;
        }

        private String dirname(String path) {
            int lastSlash = path.lastIndexOf(47);
            assert (lastSlash > 0);
            return path.substring(0, lastSlash);
        }
    }

    @CoreMethod(names={"require"}, isModuleFunction=true, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="feature")})
    public static abstract class RequireNode
    extends CoreMethodNode {
        public RequireNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"feature"})
        public RubyNode coerceFeatureToPath(RubyNode feature) {
            return ToPathNodeGen.create(this.getContext(), this.getSourceSection(), feature);
        }

        @Specialization(guards={"isRubyString(feature)"})
        public boolean require(RubyBasicObject feature) {
            CompilerDirectives.transferToInterpreter();
            if (feature.toString().equals("strscan") && RubyCallStack.getCallerFrame(this.getContext()).getCallNode().getEncapsulatingSourceSection().getSource().getName().endsWith("erb.rb")) {
                throw new RaiseException(this.getContext().getCoreLibrary().loadErrorCannotLoad(feature.toString(), this));
            }
            if (feature.toString().equals("openssl") && RubyCallStack.getCallerFrame(this.getContext()).getCallNode().getEncapsulatingSourceSection().getSource().getName().endsWith("securerandom.rb")) {
                this.getContext().getCoreLibrary().getObjectClass().getConstants().remove("OpenSSL");
                throw new RaiseException(this.getContext().getCoreLibrary().loadErrorCannotLoad(feature.toString(), this));
            }
            try {
                this.getContext().getFeatureManager().require(feature.toString(), this);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return true;
        }
    }

    @CoreMethod(names={"rand"}, isModuleFunction=true, optional=1)
    public static abstract class RandNode
    extends CoreMethodArrayArgumentsNode {
        public RandNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public double rand(NotProvided max) {
            return this.getContext().getRandom().nextDouble();
        }

        @Specialization(guards={"isZero(max)"})
        public double randZero(int max) {
            return this.getContext().getRandom().nextDouble();
        }

        @Specialization(guards={"isNonZero(max)"})
        public int randNonZero(int max) {
            return this.getContext().getRandom().nextInt(max);
        }

        @Specialization(guards={"isZero(max)"})
        public double randZero(long max) {
            return this.getContext().getRandom().nextDouble();
        }

        @Specialization(guards={"isNonZero(max)"})
        public long randNonZero(long max) {
            return this.getContext().getRandom().nextLong() % max;
        }

        protected boolean isZero(int max) {
            return max == 0;
        }

        protected boolean isNonZero(int max) {
            return max != 0;
        }

        protected boolean isZero(long max) {
            return max == 0L;
        }

        protected boolean isNonZero(long max) {
            return max != 0L;
        }
    }

    @CoreMethod(names={"public_send"}, needsBlock=true, required=1, argumentsAsArray=true)
    public static abstract class PublicSendNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode dispatchNode;

        public PublicSendNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.dispatchNode = new CallDispatchHeadNode(context, false, DispatchNode.DISPATCH_METAPROGRAMMING_ALWAYS_INDIRECT, MissingBehavior.CALL_METHOD_MISSING);
            if (DispatchNode.DISPATCH_METAPROGRAMMING_ALWAYS_UNCACHED) {
                this.dispatchNode.forceUncached();
            }
        }

        @Specialization
        public Object send(VirtualFrame frame, Object self, Object[] args, NotProvided block) {
            return this.send(frame, self, args, (RubyBasicObject)null);
        }

        @Specialization(guards={"isRubyProc(block)"})
        public Object send(VirtualFrame frame, Object self, Object[] args, RubyBasicObject block) {
            Object name = args[0];
            Object[] sendArgs = ArrayUtils.extractRange(args, 1, args.length);
            return this.dispatchNode.call(frame, self, name, block, sendArgs);
        }
    }

    @CoreMethod(names={"public_methods"}, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="object"), @NodeChild(type=RubyNode.class, value="includeAncestors")})
    public static abstract class PublicMethodsNode
    extends CoreMethodNode {
        @Node.Child
        private MetaClassNode metaClassNode;

        public PublicMethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.metaClassNode = MetaClassNodeGen.create(context, sourceSection, null);
        }

        @CreateCast(value={"includeAncestors"})
        public RubyNode coerceToBoolean(RubyNode includeAncestors) {
            return BooleanCastWithDefaultNodeGen.create(this.getContext(), this.getSourceSection(), true, includeAncestors);
        }

        @Specialization
        public RubyBasicObject publicMethods(VirtualFrame frame, Object self, boolean includeAncestors) {
            RubyClass metaClass = this.metaClassNode.executeMetaClass(frame, self);
            CompilerDirectives.transferToInterpreter();
            return ArrayNodes.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), metaClass.filterMethodsOnObject(includeAncestors, RubyModule.MethodFilter.PUBLIC).toArray());
        }
    }

    @CoreMethod(names={"protected_methods"}, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="object"), @NodeChild(type=RubyNode.class, value="includeAncestors")})
    public static abstract class ProtectedMethodsNode
    extends CoreMethodNode {
        @Node.Child
        private MetaClassNode metaClassNode;

        public ProtectedMethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.metaClassNode = MetaClassNodeGen.create(context, sourceSection, null);
        }

        @CreateCast(value={"includeAncestors"})
        public RubyNode coerceToBoolean(RubyNode includeAncestors) {
            return BooleanCastWithDefaultNodeGen.create(this.getContext(), this.getSourceSection(), true, includeAncestors);
        }

        @Specialization
        public RubyBasicObject protectedMethods(VirtualFrame frame, Object self, boolean includeAncestors) {
            RubyClass metaClass = this.metaClassNode.executeMetaClass(frame, self);
            CompilerDirectives.transferToInterpreter();
            return ArrayNodes.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), metaClass.filterMethodsOnObject(includeAncestors, RubyModule.MethodFilter.PROTECTED).toArray());
        }
    }

    @CoreMethod(names={"proc"}, isModuleFunction=true, needsBlock=true)
    public static abstract class ProcNode
    extends CoreMethodArrayArgumentsNode {
        public ProcNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyProc(block)"})
        public RubyBasicObject proc(RubyBasicObject block) {
            CompilerDirectives.transferToInterpreter();
            return ProcNodes.createRubyProc(this.getContext().getCoreLibrary().getProcClass(), ProcNodes.Type.PROC, ProcNodes.getSharedMethodInfo(block), ProcNodes.getCallTargetForProcs(block), ProcNodes.getCallTargetForProcs(block), ProcNodes.getCallTargetForLambdas(block), ProcNodes.getDeclarationFrame(block), ProcNodes.getMethod(block), ProcNodes.getSelfCapturedInScope(block), ProcNodes.getBlockCapturedInScope(block));
        }
    }

    @CoreMethod(names={"private_methods"}, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="object"), @NodeChild(type=RubyNode.class, value="includeAncestors")})
    public static abstract class PrivateMethodsNode
    extends CoreMethodNode {
        @Node.Child
        private MetaClassNode metaClassNode;

        public PrivateMethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.metaClassNode = MetaClassNodeGen.create(context, sourceSection, null);
        }

        @CreateCast(value={"includeAncestors"})
        public RubyNode coerceToBoolean(RubyNode includeAncestors) {
            return BooleanCastWithDefaultNodeGen.create(this.getContext(), this.getSourceSection(), true, includeAncestors);
        }

        @Specialization
        public RubyBasicObject privateMethods(VirtualFrame frame, Object self, boolean includeAncestors) {
            RubyClass metaClass = this.metaClassNode.executeMetaClass(frame, self);
            CompilerDirectives.transferToInterpreter();
            return ArrayNodes.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), metaClass.filterMethodsOnObject(includeAncestors, RubyModule.MethodFilter.PRIVATE).toArray());
        }
    }

    @CoreMethod(names={"nil?"}, needsSelf=false)
    public static abstract class NilNode
    extends CoreMethodArrayArgumentsNode {
        public NilNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean isNil() {
            return false;
        }
    }

    @CoreMethod(names={"methods"}, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="object"), @NodeChild(type=RubyNode.class, value="regular")})
    public static abstract class MethodsNode
    extends CoreMethodNode {
        public MethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"regular"})
        public RubyNode coerceToBoolean(RubyNode regular) {
            return BooleanCastWithDefaultNodeGen.create(this.getContext(), this.getSourceSection(), true, regular);
        }

        @Specialization(guards={"regular"})
        public RubyBasicObject methodsRegular(VirtualFrame frame, Object self, boolean regular, @Cached(value="createMetaClassNode()") MetaClassNode metaClassNode) {
            RubyClass metaClass = metaClassNode.executeMetaClass(frame, self);
            CompilerDirectives.transferToInterpreter();
            return ArrayNodes.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), metaClass.filterMethodsOnObject(regular, RubyModule.MethodFilter.PUBLIC_PROTECTED).toArray());
        }

        @Specialization(guards={"!regular"})
        public RubyBasicObject methodsSingleton(VirtualFrame frame, Object self, boolean regular, @Cached(value="createSingletonMethodsNode()") SingletonMethodsNode singletonMethodsNode) {
            return singletonMethodsNode.executeSingletonMethods(frame, self, false);
        }

        protected MetaClassNode createMetaClassNode() {
            return MetaClassNodeGen.create(this.getContext(), this.getSourceSection(), null);
        }

        protected SingletonMethodsNode createSingletonMethodsNode() {
            return KernelNodesFactory.SingletonMethodsNodeFactory.create(this.getContext(), this.getSourceSection(), null, null);
        }
    }

    @CoreMethod(names={"method"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="object"), @NodeChild(type=RubyNode.class, value="name")})
    public static abstract class MethodNode
    extends CoreMethodNode {
        @Node.Child
        LookupMethodNode lookupMethodNode;

        public MethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.lookupMethodNode = LookupMethodNodeGen.create(context, sourceSection, null, null);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(this.getContext(), this.getSourceSection(), name);
        }

        @Specialization
        public RubyBasicObject methodCached(VirtualFrame frame, Object self, String name) {
            InternalMethod method = this.lookupMethodNode.executeLookupMethod(frame, self, name);
            if (method == null) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorUndefinedMethod(name, this.getContext().getCoreLibrary().getLogicalClass(self), this));
            }
            return MethodNodes.createMethod(this.getContext().getCoreLibrary().getMethodClass(), self, method);
        }
    }

    @CoreMethod(names={"__method__"}, needsSelf=false)
    public static abstract class MethodNameNode
    extends CoreMethodArrayArgumentsNode {
        public MethodNameNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject methodName() {
            CompilerDirectives.transferToInterpreter();
            return this.getSymbol(RubyCallStack.getCallingMethod(this.getContext()).getSharedMethodInfo().getName());
        }
    }

    @CoreMethod(names={"local_variables"}, needsSelf=false)
    public static abstract class LocalVariablesNode
    extends CoreMethodArrayArgumentsNode {
        public LocalVariablesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject localVariables() {
            CompilerDirectives.transferToInterpreter();
            RubyBasicObject array = this.createEmptyArray();
            for (Object name : RubyCallStack.getCallerFrame(this.getContext()).getFrame(FrameInstance.FrameAccess.READ_ONLY, false).getFrameDescriptor().getIdentifiers()) {
                if (!(name instanceof String)) continue;
                ArrayNodes.slowPush(array, this.getSymbol((String)name));
            }
            return array;
        }
    }

    @CoreMethod(names={"load"}, isModuleFunction=true, required=1, optional=1)
    public static abstract class LoadNode
    extends CoreMethodArrayArgumentsNode {
        public LoadNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(file)"})
        public boolean load(RubyBasicObject file, boolean wrap) {
            if (wrap) {
                throw new UnsupportedOperationException();
            }
            try {
                this.getContext().loadFile(file.toString(), this);
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.getContext().getCoreLibrary().loadErrorCannotLoad(file.toString(), this));
                }
                throw e;
            }
            return true;
        }

        @Specialization(guards={"isRubyString(file)"})
        public boolean load(RubyBasicObject file, NotProvided wrap) {
            return this.load(file, false);
        }
    }

    @CoreMethod(names={"lambda"}, isModuleFunction=true, needsBlock=true)
    public static abstract class LambdaNode
    extends CoreMethodArrayArgumentsNode {
        public LambdaNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject proc(NotProvided block) {
            Frame parentFrame = RubyCallStack.getCallerFrame(this.getContext()).getFrame(FrameInstance.FrameAccess.READ_ONLY, true);
            RubyBasicObject parentBlock = RubyArguments.getBlock(parentFrame.getArguments());
            if (parentBlock == null) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("tried to create Proc object without a block", this));
            }
            return this.proc(parentBlock);
        }

        @Specialization(guards={"isRubyProc(block)"})
        public RubyBasicObject proc(RubyBasicObject block) {
            return ProcNodes.createRubyProc(this.getContext().getCoreLibrary().getProcClass(), ProcNodes.Type.LAMBDA, ProcNodes.getSharedMethodInfo(block), ProcNodes.getCallTargetForLambdas(block), ProcNodes.getCallTargetForLambdas(block), ProcNodes.getCallTargetForLambdas(block), ProcNodes.getDeclarationFrame(block), ProcNodes.getMethod(block), ProcNodes.getSelfCapturedInScope(block), ProcNodes.getBlockCapturedInScope(block));
        }
    }

    @CoreMethod(names={"is_a?", "kind_of?"}, required=1)
    public static abstract class IsANode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        MetaClassNode metaClassNode;

        public IsANode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.metaClassNode = MetaClassNodeGen.create(context, sourceSection, null);
        }

        public abstract boolean executeIsA(VirtualFrame var1, Object var2, RubyModule var3);

        @Specialization(guards={"isNil(nil)", "!isRubyModule(nil)"})
        public boolean isANil(RubyBasicObject self, Object nil) {
            return false;
        }

        @Specialization(limit="getCacheLimit()", guards={"getMetaClass(frame, self) == cachedMetaClass", "module == cachedModule"}, assumptions={"cachedModule.getUnmodifiedAssumption()"})
        public boolean isACached(VirtualFrame frame, Object self, RubyModule module, @Cached(value="getMetaClass(frame, self)") RubyClass cachedMetaClass, @Cached(value="module") RubyModule cachedModule, @Cached(value="isA(cachedMetaClass, cachedModule)") boolean result) {
            return result;
        }

        @Specialization
        public boolean isAUncached(VirtualFrame frame, Object self, RubyModule module) {
            return this.isA(this.getMetaClass(frame, self), module);
        }

        @Specialization(guards={"!isRubyModule(module)"})
        public boolean isATypeError(VirtualFrame frame, Object self, Object module) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().typeError("class or module required", this));
        }

        @CompilerDirectives.TruffleBoundary
        protected boolean isA(RubyClass metaClass, RubyModule module) {
            return ModuleOperations.assignableTo(metaClass, module);
        }

        protected RubyClass getMetaClass(VirtualFrame frame, Object object) {
            return this.metaClassNode.executeMetaClass(frame, object);
        }
    }

    @CoreMethod(names={"instance_variables", "__instance_variables__"})
    public static abstract class InstanceVariablesNode
    extends CoreMethodArrayArgumentsNode {
        public InstanceVariablesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject instanceVariables(RubyBasicObject self) {
            CompilerDirectives.transferToInterpreter();
            Object[] instanceVariableNames = RubyBasicObject.getFieldNames(self);
            Arrays.sort(instanceVariableNames);
            RubyBasicObject array = this.createEmptyArray();
            for (Object name : instanceVariableNames) {
                if (!(name instanceof String)) continue;
                ArrayNodes.slowPush(array, this.getSymbol((String)name));
            }
            return array;
        }
    }

    @CoreMethod(names={"instance_variable_set", "__instance_variable_set__"}, raiseIfFrozenSelf=true, required=2)
    public static abstract class InstanceVariableSetNode
    extends CoreMethodArrayArgumentsNode {
        public InstanceVariableSetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(name)"})
        public Object instanceVariableSetString(RubyBasicObject object, RubyBasicObject name, Object value) {
            RubyBasicObject.setInstanceVariable(object, RubyContext.checkInstanceVariableName(this.getContext(), name.toString(), this), value);
            return value;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubySymbol(name)"})
        public Object instanceVariableSetSymbol(RubyBasicObject object, RubyBasicObject name, Object value) {
            RubyBasicObject.setInstanceVariable(object, RubyContext.checkInstanceVariableName(this.getContext(), SymbolNodes.getString(name), this), value);
            return value;
        }
    }

    @CoreMethod(names={"instance_variable_get"}, required=1)
    public static abstract class InstanceVariableGetNode
    extends CoreMethodArrayArgumentsNode {
        public InstanceVariableGetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(name)"})
        public Object instanceVariableGetString(RubyBasicObject object, RubyBasicObject name) {
            return this.instanceVariableGet(object, name.toString());
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubySymbol(name)"})
        public Object instanceVariableGetSymbol(RubyBasicObject object, RubyBasicObject name) {
            return this.instanceVariableGet(object, SymbolNodes.getString(name));
        }

        private Object instanceVariableGet(RubyBasicObject object, String name) {
            return object.getInstanceVariable(RubyContext.checkInstanceVariableName(this.getContext(), name, this));
        }
    }

    @CoreMethod(names={"instance_variable_defined?"}, required=1)
    public static abstract class InstanceVariableDefinedNode
    extends CoreMethodArrayArgumentsNode {
        public InstanceVariableDefinedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(name)"})
        public boolean isInstanceVariableDefinedString(RubyBasicObject object, RubyBasicObject name) {
            return object.isFieldDefined(RubyContext.checkInstanceVariableName(this.getContext(), name.toString(), this));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubySymbol(name)"})
        public boolean isInstanceVariableDefinedSymbol(RubyBasicObject object, RubyBasicObject name) {
            return object.isFieldDefined(RubyContext.checkInstanceVariableName(this.getContext(), SymbolNodes.getString(name), this));
        }
    }

    @CoreMethod(names={"instance_of?"}, required=1)
    public static abstract class InstanceOfNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ClassNode classNode;

        public InstanceOfNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.classNode = ClassNodeGen.create(context, sourceSection, null);
        }

        @Specialization
        public boolean instanceOf(VirtualFrame frame, Object self, RubyClass rubyClass) {
            return this.classNode.executeGetClass(frame, self) == rubyClass;
        }
    }

    @CoreMethod(names={"initialize_dup", "initialize_clone"}, required=1)
    public static abstract class InitializeDupCloneNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode initializeCopyNode;

        public InitializeDupCloneNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.initializeCopyNode = DispatchHeadNodeFactory.createMethodCallOnSelf(context);
        }

        @Specialization
        public Object initializeDup(VirtualFrame frame, RubyBasicObject self, RubyBasicObject from) {
            return this.initializeCopyNode.call(frame, self, "initialize_copy", null, from);
        }
    }

    @CoreMethod(names={"initialize_copy"}, required=1)
    public static abstract class InitializeCopyNode
    extends CoreMethodArrayArgumentsNode {
        public InitializeCopyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object initializeCopy(RubyBasicObject self, RubyBasicObject from) {
            CompilerDirectives.transferToInterpreter();
            if (self.getLogicalClass() != from.getLogicalClass()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().typeError("initialize_copy should take same class object", this));
            }
            return self;
        }
    }

    @CoreMethod(names={"hash"})
    public static abstract class HashNode
    extends CoreMethodArrayArgumentsNode {
        public HashNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int hash(int value) {
            return value;
        }

        @Specialization
        public int hash(long value) {
            return Long.valueOf(value).hashCode();
        }

        @Specialization
        public int hash(double value) {
            return Double.valueOf(value).hashCode();
        }

        @Specialization
        public int hash(boolean value) {
            return Boolean.valueOf(value).hashCode();
        }

        @Specialization
        public int hash(RubyBasicObject self) {
            return System.identityHashCode(self);
        }
    }

    @CoreMethod(names={"gets"}, isModuleFunction=true)
    public static abstract class GetsNode
    extends CoreMethodArrayArgumentsNode {
        public GetsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject gets(VirtualFrame frame) {
            CompilerDirectives.transferToInterpreter();
            InputStream in = this.getContext().getRuntime().getInstanceConfig().getInput();
            Encoding encoding = this.getContext().getRuntime().getDefaultExternalEncoding();
            final BufferedReader reader = new BufferedReader(new InputStreamReader(in, encoding.getCharset()));
            String line = this.getContext().getThreadManager().runUntilResult(new ThreadManager.BlockingActionWithoutGlobalLock<String>(){

                @Override
                public String block() throws InterruptedException {
                    return GetsNode.gets(reader);
                }
            });
            RubyBasicObject rubyLine = this.createString(line);
            Frame caller = RubyCallStack.getCallerFrame(this.getContext()).getFrame(FrameInstance.FrameAccess.READ_WRITE, false);
            FrameSlot slot = caller.getFrameDescriptor().findFrameSlot((Object)"$_");
            if (slot != null) {
                caller.setObject(slot, (Object)ThreadLocalObject.wrap(this.getContext(), rubyLine));
            }
            return rubyLine;
        }

        @CompilerDirectives.TruffleBoundary
        private static String gets(BufferedReader reader) throws InterruptedException {
            try {
                return reader.readLine() + "\n";
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @CoreMethod(names={"frozen?"})
    public static abstract class KernelFrozenNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private IsFrozenNode isFrozenNode;

        public KernelFrozenNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean isFrozen(Object self) {
            if (this.isFrozenNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.isFrozenNode = (IsFrozenNode)this.insert(IsFrozenNodeGen.create(this.getContext(), this.getEncapsulatingSourceSection(), null));
            }
            return this.isFrozenNode.executeIsFrozen(self);
        }
    }

    @CoreMethod(names={"freeze"})
    public static abstract class KernelFreezeNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private FreezeNode freezeNode;

        public KernelFreezeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object freeze(Object self) {
            if (this.freezeNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.freezeNode = (FreezeNode)this.insert(FreezeNodeGen.create(this.getContext(), this.getEncapsulatingSourceSection(), null));
            }
            return this.freezeNode.executeFreeze(self);
        }
    }

    @CoreMethod(names={"fork"}, isModuleFunction=true, argumentsAsArray=true)
    public static abstract class ForkNode
    extends CoreMethodArrayArgumentsNode {
        public ForkNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object fork(Object[] args) {
            CompilerDirectives.transferToInterpreter();
            this.getContext().getWarnings().warn("Kernel#fork not implemented - defined to satisfy some metaprogramming in RubySpec");
            return this.nil();
        }
    }

    @CoreMethod(names={"exit!"}, isModuleFunction=true, optional=1)
    public static abstract class ExitBangNode
    extends CoreMethodArrayArgumentsNode {
        public ExitBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject exit(NotProvided exitCode) {
            return this.exit(1);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject exit(int exitCode) {
            this.getContext().innerShutdown(false);
            throw new MainExitException(exitCode, true);
        }
    }

    @CoreMethod(names={"exit"}, isModuleFunction=true, optional=1, lowerFixnumParameters={0})
    public static abstract class ExitNode
    extends CoreMethodArrayArgumentsNode {
        public ExitNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object exit(NotProvided exitCode) {
            return this.exit(0);
        }

        @Specialization
        public Object exit(int exitCode) {
            CompilerDirectives.transferToInterpreter();
            this.getContext().shutdown();
            System.exit(exitCode);
            return null;
        }

        @Specialization
        public Object exit(boolean status) {
            CompilerDirectives.transferToInterpreter();
            this.getContext().shutdown();
            System.exit(status ? 0 : -1);
            return null;
        }
    }

    @CoreMethod(names={"exec"}, isModuleFunction=true, required=1, argumentsAsArray=true)
    public static abstract class ExecNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode toHashNode;

        public ExecNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object exec(VirtualFrame frame, Object[] args) {
            if (this.toHashNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toHashNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            CompilerDirectives.transferToInterpreter();
            String[] commandLine = new String[args.length];
            for (int n = 0; n < args.length; ++n) {
                commandLine[n] = args[n].toString();
            }
            RubyBasicObject env = this.getContext().getCoreLibrary().getENV();
            RubyBasicObject envAsHash = (RubyBasicObject)this.toHashNode.call(frame, env, "to_hash", null, new Object[0]);
            ExecNode.exec(this.getContext(), envAsHash, commandLine);
            return null;
        }

        @CompilerDirectives.TruffleBoundary
        private static void exec(RubyContext context, RubyBasicObject envAsHash, String[] commandLine) {
            Process process;
            ProcessBuilder builder = new ProcessBuilder(commandLine);
            builder.inheritIO();
            for (Map.Entry<Object, Object> keyValue : HashNodes.iterableKeyValues(envAsHash)) {
                builder.environment().put(keyValue.getKey().toString(), keyValue.getValue().toString());
            }
            try {
                process = builder.start();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            int exitCode = context.getThreadManager().runUntilResult(new ThreadManager.BlockingActionWithoutGlobalLock<Integer>(){

                @Override
                public Integer block() throws InterruptedException {
                    return process.waitFor();
                }
            });
            System.exit(exitCode);
        }
    }

    @CoreMethod(names={"eval"}, isModuleFunction=true, required=1, optional=3, lowerFixnumParameters={3})
    @ImportStatic(value={StringCachingGuards.class})
    @NodeChildren(value={@NodeChild(value="source", type=RubyNode.class), @NodeChild(value="binding", type=RubyNode.class), @NodeChild(value="filename", type=RubyNode.class), @NodeChild(value="lineNumber", type=RubyNode.class)})
    public static abstract class EvalNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode toStr;
        @Node.Child
        private BindingNode bindingNode;

        public EvalNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"source"})
        public RubyNode coerceSourceToString(RubyNode source) {
            return ToStrNodeGen.create(this.getContext(), this.getSourceSection(), source);
        }

        protected RubyBasicObject getCallerBinding(VirtualFrame frame) {
            if (this.bindingNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.bindingNode = (BindingNode)this.insert(KernelNodesFactory.BindingNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[0]));
            }
            try {
                return this.bindingNode.executeRubyBasicObject(frame);
            }
            catch (UnexpectedResultException e) {
                throw new UnsupportedOperationException(e);
            }
        }

        @Specialization(guards={"isRubyString(source)", "byteListsEqual(source, cachedSource)", "!parseDependsOnDeclarationFrame(cachedRootNode)"})
        public Object evalNoBindingCached(VirtualFrame frame, RubyBasicObject source, NotProvided binding, NotProvided filename, NotProvided lineNumber, @Cached(value="privatizeByteList(source)") ByteList cachedSource, @Cached(value="compileSource(frame, source)") RootNodeWrapper cachedRootNode, @Cached(value="createCallTarget(cachedRootNode)") CallTarget cachedCallTarget, @Cached(value="create(cachedCallTarget)") DirectCallNode callNode) {
            RubyBasicObject callerBinding = this.getCallerBinding(frame);
            Object callerSelf = BindingNodes.getSelf(callerBinding);
            MaterializedFrame parentFrame = BindingNodes.getFrame(callerBinding);
            InternalMethod method = new InternalMethod(cachedRootNode.getRootNode().getSharedMethodInfo(), cachedRootNode.getRootNode().getSharedMethodInfo().getName(), this.getContext().getCoreLibrary().getObjectClass(), Visibility.PUBLIC, false, cachedCallTarget, parentFrame);
            return callNode.call(frame, RubyArguments.pack(method, parentFrame, callerSelf, null, new Object[0]));
        }

        @Specialization(guards={"isRubyString(source)"}, contains={"evalNoBindingCached"})
        public Object evalNoBindingUncached(VirtualFrame frame, RubyBasicObject source, NotProvided binding, NotProvided filename, NotProvided lineNumber) {
            return this.getContext().eval(StringNodes.getByteList(source), this.getCallerBinding(frame), true, this);
        }

        @Specialization(guards={"isRubyString(source)", "isNil(noBinding)", "isRubyString(filename)"})
        public Object evalNilBinding(VirtualFrame frame, RubyBasicObject source, Object noBinding, RubyBasicObject filename, int lineNumber) {
            return this.evalNoBindingUncached(frame, source, NotProvided.INSTANCE, NotProvided.INSTANCE, NotProvided.INSTANCE);
        }

        @Specialization(guards={"isRubyString(source)", "isRubyBinding(binding)"})
        public Object evalBinding(RubyBasicObject source, RubyBasicObject binding, NotProvided filename, NotProvided lineNumber) {
            return this.getContext().eval(StringNodes.getByteList(source), binding, false, this);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(source)", "isRubyBinding(binding)", "isRubyString(filename)"})
        public Object evalBindingFilename(RubyBasicObject source, RubyBasicObject binding, RubyBasicObject filename, NotProvided lineNumber) {
            return this.getContext().eval(StringNodes.getByteList(source), binding, false, filename.toString(), (Node)this);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(source)", "isRubyBinding(binding)", "isRubyString(filename)"})
        public Object evalBindingFilenameLine(RubyBasicObject source, RubyBasicObject binding, RubyBasicObject filename, int lineNumber) {
            return this.getContext().eval(StringNodes.getByteList(source), binding, false, filename.toString(), (Node)this);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(source)", "!isRubyBinding(badBinding)"})
        public Object evalBadBinding(RubyBasicObject source, RubyBasicObject badBinding, NotProvided filename, NotProvided lineNumber) {
            throw new RaiseException(this.getContext().getCoreLibrary().typeErrorWrongArgumentType(badBinding, "binding", this));
        }

        protected RootNodeWrapper compileSource(VirtualFrame frame, RubyBasicObject sourceText) {
            assert (RubyGuards.isRubyString(sourceText));
            RubyBasicObject callerBinding = this.getCallerBinding(frame);
            MaterializedFrame parentFrame = BindingNodes.getFrame(callerBinding);
            Source source = Source.fromText((CharSequence)sourceText.toString(), (String)"(eval)");
            TranslatorDriver translator = new TranslatorDriver(this.getContext());
            return new RootNodeWrapper(translator.parse(this.getContext(), source, (Encoding)UTF8Encoding.INSTANCE, TranslatorDriver.ParserContext.EVAL, parentFrame, true, this, new NodeWrapper(){

                @Override
                public RubyNode wrap(RubyNode node) {
                    return node;
                }
            }));
        }

        protected boolean parseDependsOnDeclarationFrame(RootNodeWrapper rootNode) {
            return rootNode.getRootNode().needsDeclarationFrame();
        }

        protected CallTarget createCallTarget(RootNodeWrapper rootNode) {
            return Truffle.getRuntime().createCallTarget((RootNode)rootNode.rootNode);
        }

        protected static class RootNodeWrapper {
            private final RubyRootNode rootNode;

            public RootNodeWrapper(RubyRootNode rootNode) {
                this.rootNode = rootNode;
            }

            public RubyRootNode getRootNode() {
                return this.rootNode;
            }
        }
    }

    @CoreMethod(names={"dup"}, taintFromSelf=true)
    public static abstract class DupNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CopyNode copyNode;
        @Node.Child
        private CallDispatchHeadNode initializeDupNode;

        public DupNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.copyNode = KernelNodesFactory.CopyNodeFactory.create(context, sourceSection, null);
            this.initializeDupNode = DispatchHeadNodeFactory.createMethodCallOnSelf(context);
        }

        @Specialization
        public RubyBasicObject dup(VirtualFrame frame, RubyBasicObject self) {
            RubyBasicObject newObject = this.copyNode.executeCopy(frame, self);
            this.initializeDupNode.call(frame, newObject, "initialize_dup", null, self);
            return newObject;
        }
    }

    @CoreMethod(names={"clone"}, taintFromSelf=true)
    public static abstract class CloneNode
    extends CoreMethodArrayArgumentsNode {
        private final ConditionProfile frozenProfile = ConditionProfile.createBinaryProfile();
        @Node.Child
        private CopyNode copyNode;
        @Node.Child
        private CallDispatchHeadNode initializeCloneNode;
        @Node.Child
        private IsFrozenNode isFrozenNode;
        @Node.Child
        private FreezeNode freezeNode;
        @Node.Child
        private SingletonClassNode singletonClassNode;

        public CloneNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.copyNode = KernelNodesFactory.CopyNodeFactory.create(context, sourceSection, null);
            this.initializeCloneNode = DispatchHeadNodeFactory.createMethodCallOnSelf(context);
            this.isFrozenNode = IsFrozenNodeGen.create(context, sourceSection, null);
            this.freezeNode = FreezeNodeGen.create(context, sourceSection, null);
            this.singletonClassNode = SingletonClassNodeGen.create(context, sourceSection, null);
        }

        @Specialization
        public RubyBasicObject clone(VirtualFrame frame, RubyBasicObject self) {
            CompilerDirectives.transferToInterpreter();
            RubyBasicObject newObject = this.copyNode.executeCopy(frame, self);
            if (self.getMetaClass().isSingleton()) {
                this.singletonClassNode.executeSingletonClass(frame, newObject).initCopy(self.getMetaClass());
            }
            this.initializeCloneNode.call(frame, newObject, "initialize_clone", null, self);
            if (this.frozenProfile.profile(this.isFrozenNode.executeIsFrozen(self))) {
                this.freezeNode.executeFreeze(newObject);
            }
            return newObject;
        }
    }

    public static abstract class CopyNode
    extends UnaryCoreMethodNode {
        public CopyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public abstract RubyBasicObject executeCopy(VirtualFrame var1, RubyBasicObject var2);

        @Specialization
        public RubyBasicObject copy(VirtualFrame frame, RubyBasicObject self) {
            RubyBasicObject newObject = self.getLogicalClass().allocate(this);
            RubyBasicObject.setInstanceVariables(newObject, RubyBasicObject.getInstanceVariables(self));
            return newObject;
        }
    }

    @CoreMethod(names={"class"})
    public static abstract class KernelClassNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ClassNode classNode;

        public KernelClassNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.classNode = ClassNodeGen.create(context, sourceSection, null);
        }

        @Specialization
        public RubyClass getClass(VirtualFrame frame, Object self) {
            return this.classNode.executeGetClass(frame, self);
        }
    }

    @CoreMethod(names={"caller_locations"}, isModuleFunction=true, optional=2, lowerFixnumParameters={0, 1})
    public static abstract class CallerLocationsNode
    extends CoreMethodArrayArgumentsNode {
        public CallerLocationsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject callerLocations(NotProvided omit, NotProvided length) {
            return this.callerLocations(1, -1);
        }

        @Specialization
        public RubyBasicObject callerLocations(int omit, NotProvided length) {
            return this.callerLocations(omit, -1);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject callerLocations(int omit, int length) {
            RubyClass threadBacktraceLocationClass = this.getContext().getCoreLibrary().getThreadBacktraceLocationClass();
            Backtrace backtrace = RubyCallStack.getBacktrace(this, 1 + omit, true);
            int locationsCount = backtrace.getActivations().size();
            if (length != -1 && locationsCount > length) {
                locationsCount = length;
            }
            Object[] locations = new Object[locationsCount];
            for (int n = 0; n < locationsCount; ++n) {
                Activation activation = backtrace.getActivations().get(n);
                locations[n] = ThreadBacktraceLocationNodes.createRubyThreadBacktraceLocation(threadBacktraceLocationClass, activation);
            }
            return this.createArray(locations, locations.length);
        }
    }

    @CoreMethod(names={"__callee__"}, needsSelf=false)
    public static abstract class CalleeNameNode
    extends CoreMethodArrayArgumentsNode {
        public CalleeNameNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject calleeName() {
            CompilerDirectives.transferToInterpreter();
            return this.getSymbol(RubyCallStack.getCallingMethod(this.getContext()).getName());
        }
    }

    @CoreMethod(names={"block_given?"}, isModuleFunction=true)
    public static abstract class BlockGivenNode
    extends CoreMethodArrayArgumentsNode {
        public BlockGivenNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean blockGiven() {
            return RubyArguments.getBlock(Truffle.getRuntime().getCallerFrame().getFrame(FrameInstance.FrameAccess.READ_ONLY, false).getArguments()) != null;
        }
    }

    @CoreMethod(names={"binding"}, isModuleFunction=true)
    public static abstract class BindingNode
    extends CoreMethodArrayArgumentsNode {
        public BindingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject binding() {
            MaterializedFrame callerFrame = RubyCallStack.getCallerFrame(this.getContext()).getFrame(FrameInstance.FrameAccess.MATERIALIZE, false).materialize();
            return BindingNodes.createRubyBinding(this.getContext().getCoreLibrary().getBindingClass(), RubyArguments.getSelf(callerFrame.getArguments()), callerFrame);
        }
    }

    @CoreMethod(names={"abort"}, isModuleFunction=true, optional=1)
    public static abstract class AbortNode
    extends CoreMethodArrayArgumentsNode {
        public AbortNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(message)"})
        public RubyBasicObject abort(RubyBasicObject message) {
            System.err.println(message.toString());
            return this.abort();
        }

        @Specialization
        public RubyBasicObject abort(NotProvided message) {
            return this.abort();
        }

        @CompilerDirectives.TruffleBoundary
        private RubyBasicObject abort() {
            this.getContext().innerShutdown(false);
            throw new MainExitException(1, true);
        }
    }

    @CoreMethod(names={"<=>"}, required=1)
    public static abstract class CompareNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private SameOrEqualNode equalNode;

        public CompareNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.equalNode = KernelNodesFactory.SameOrEqualNodeFactory.create(context, sourceSection, new RubyNode[]{null, null});
        }

        @Specialization
        public Object compare(VirtualFrame frame, Object self, Object other) {
            if (this.equalNode.executeSameOrEqual(frame, self, other)) {
                return 0;
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"!~"}, required=1)
    public static abstract class NotMatchNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode matchNode;

        public NotMatchNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.matchNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        @Specialization
        public boolean notMatch(VirtualFrame frame, Object self, Object other) {
            return !this.matchNode.callBoolean(frame, self, "=~", null, other);
        }
    }

    @CoreMethod(names={"=~"}, required=1, needsSelf=false)
    public static abstract class MatchNode
    extends CoreMethodArrayArgumentsNode {
        public MatchNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject equal(Object other) {
            return this.nil();
        }
    }

    @CoreMethod(names={"==="}, required=1)
    public static abstract class SameOrEqualNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private BasicObjectNodes.ReferenceEqualNode referenceEqualNode;
        @Node.Child
        private CallDispatchHeadNode equalNode;
        private final ConditionProfile sameProfile = ConditionProfile.createBinaryProfile();

        public SameOrEqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public abstract boolean executeSameOrEqual(VirtualFrame var1, Object var2, Object var3);

        @Specialization
        public boolean sameOrEqual(VirtualFrame frame, Object a, Object b) {
            if (this.sameProfile.profile(this.areSame(frame, a, b))) {
                return true;
            }
            return this.areEqual(frame, a, b);
        }

        private boolean areSame(VirtualFrame frame, Object left, Object right) {
            if (this.referenceEqualNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.referenceEqualNode = (BasicObjectNodes.ReferenceEqualNode)this.insert(BasicObjectNodesFactory.ReferenceEqualNodeFactory.create(this.getContext(), this.getSourceSection(), null, null));
            }
            return this.referenceEqualNode.executeReferenceEqual(frame, left, right);
        }

        private boolean areEqual(VirtualFrame frame, Object left, Object right) {
            if (this.equalNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.equalNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            return this.equalNode.callBoolean(frame, left, "==", null, right);
        }
    }

    @CoreMethod(names={"`"}, isModuleFunction=true, needsSelf=false, required=1)
    public static abstract class BacktickNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode toHashNode;

        public BacktickNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(command)"})
        public RubyBasicObject backtick(VirtualFrame frame, RubyBasicObject command) {
            Process process;
            if (this.toHashNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toHashNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            CompilerDirectives.transferToInterpreter();
            RubyContext context = this.getContext();
            RubyBasicObject env = context.getCoreLibrary().getENV();
            RubyBasicObject envAsHash = (RubyBasicObject)this.toHashNode.call(frame, env, "to_hash", null, new Object[0]);
            ArrayList<String> envp = new ArrayList<String>();
            for (Map.Entry<Object, Object> keyValue : HashNodes.iterableKeyValues(envAsHash)) {
                envp.add(keyValue.getKey().toString() + "=" + keyValue.getValue().toString());
            }
            try {
                process = Runtime.getRuntime().exec(new String[]{"bash", "-c", command.toString()}, envp.toArray(new String[envp.size()]));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            InputStream stdout = process.getInputStream();
            InputStreamReader reader = new InputStreamReader(stdout, StandardCharsets.UTF_8);
            StringBuilder resultBuilder = new StringBuilder();
            try {
                int c;
                while ((c = reader.read()) != -1) {
                    resultBuilder.append((char)c);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this.createString(resultBuilder.toString(), EncodingNodes.getEncoding(EncodingNodes.getEncoding("UTF-8")));
        }
    }
}

