/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import com.oracle.truffle.api.utilities.ConditionProfile;
import java.math.BigInteger;
import java.util.EnumSet;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.cast.BooleanCastNode;
import org.jruby.truffle.nodes.cast.BooleanCastNodeGen;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.FixnumOrBignumNode;
import org.jruby.truffle.nodes.core.GeneralDivModNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.object.BasicObjectType;

@CoreClass(name="Bignum")
public abstract class BignumNodes {
    public static final BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    public static final BigInteger LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    public static final BignumType BIGNUM_TYPE = new BignumType();
    private static final HiddenKey VALUE_IDENTIFIER = new HiddenKey("value");
    public static final Property VALUE_PROPERTY;
    private static final DynamicObjectFactory BIGNUM_FACTORY;

    public static RubyBasicObject createRubyBignum(RubyClass rubyClass, BigInteger value) {
        assert (value.compareTo(LONG_MIN) < 0 || value.compareTo(LONG_MAX) > 0) : String.format("%s not in Bignum range", value);
        return new RubyBasicObject(rubyClass, BIGNUM_FACTORY.newInstance(new Object[]{value}));
    }

    public static BigInteger getBigIntegerValue(RubyBasicObject bignum) {
        assert (RubyGuards.isRubyBignum(bignum));
        assert (bignum.getDynamicObject().getShape().hasProperty((Object)VALUE_IDENTIFIER));
        return (BigInteger)VALUE_PROPERTY.get(bignum.getDynamicObject(), true);
    }

    static {
        Shape.Allocator allocator = RubyBasicObject.LAYOUT.createAllocator();
        VALUE_PROPERTY = Property.create((Object)VALUE_IDENTIFIER, (Location)allocator.locationForType(BigInteger.class, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull)), (int)0);
        Shape shape = RubyBasicObject.LAYOUT.createShape((ObjectType)BIGNUM_TYPE).addProperty(VALUE_PROPERTY);
        BIGNUM_FACTORY = shape.createFactory();
    }

    @CoreMethod(names={"to_s", "inspect"}, optional=1)
    public static abstract class ToSNode
    extends CoreMethodArrayArgumentsNode {
        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject toS(RubyBasicObject value, NotProvided base) {
            return this.createString(BignumNodes.getBigIntegerValue(value).toString(), (Encoding)USASCIIEncoding.INSTANCE);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject toS(RubyBasicObject value, int base) {
            if (base < 2 || base > 36) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentErrorInvalidRadix(base, this));
            }
            return this.createString(BignumNodes.getBigIntegerValue(value).toString(base), (Encoding)USASCIIEncoding.INSTANCE);
        }
    }

    @CoreMethod(names={"to_f"})
    public static abstract class ToFNode
    extends CoreMethodArrayArgumentsNode {
        public ToFNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public double toF(RubyBasicObject value) {
            return BignumNodes.getBigIntegerValue(value).doubleValue();
        }
    }

    @CoreMethod(names={"size"})
    public static abstract class SizeNode
    extends CoreMethodArrayArgumentsNode {
        public SizeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int size(RubyBasicObject value) {
            return (BignumNodes.getBigIntegerValue(value).bitLength() + 7) / 8;
        }
    }

    @CoreMethod(names={"odd?"})
    public static abstract class OddNode
    extends BignumCoreMethodNode {
        public OddNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public boolean odd(RubyBasicObject value) {
            return BignumNodes.getBigIntegerValue(value).testBit(0);
        }
    }

    @CoreMethod(names={"hash"})
    public static abstract class HashNode
    extends CoreMethodArrayArgumentsNode {
        public HashNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int hash(RubyBasicObject value) {
            return BignumNodes.getBigIntegerValue(value).hashCode();
        }
    }

    @CoreMethod(names={"even?"})
    public static abstract class EvenNode
    extends BignumCoreMethodNode {
        public EvenNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public boolean even(RubyBasicObject value) {
            return !BignumNodes.getBigIntegerValue(value).testBit(0);
        }
    }

    @CoreMethod(names={"divmod"}, required=1)
    public static abstract class DivModNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private GeneralDivModNode divModNode;

        public DivModNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.divModNode = new GeneralDivModNode(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject divMod(RubyBasicObject a, long b) {
            return this.divModNode.execute(BignumNodes.getBigIntegerValue(a), b);
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public RubyBasicObject divMod(RubyBasicObject a, RubyBasicObject b) {
            return this.divModNode.execute(BignumNodes.getBigIntegerValue(a), BignumNodes.getBigIntegerValue(b));
        }
    }

    @CoreMethod(names={"coerce"}, required=1)
    public static abstract class CoerceNode
    extends CoreMethodArrayArgumentsNode {
        public CoerceNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject coerce(RubyBasicObject a, int b) {
            CompilerDirectives.transferToInterpreter();
            Object[] store = new Object[]{b, a};
            return this.createArray(store, store.length);
        }

        @Specialization
        public RubyBasicObject coerce(RubyBasicObject a, long b) {
            CompilerDirectives.transferToInterpreter();
            Object[] store = new Object[]{b, a};
            return this.createArray(store, store.length);
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public RubyBasicObject coerce(RubyBasicObject a, RubyBasicObject b) {
            CompilerDirectives.transferToInterpreter();
            Object[] store = new Object[]{b, a};
            return this.createArray(store, store.length);
        }
    }

    @CoreMethod(names={"bit_length"})
    public static abstract class BitLengthNode
    extends CoreMethodArrayArgumentsNode {
        public BitLengthNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int bitLength(RubyBasicObject value) {
            return BignumNodes.getBigIntegerValue(value).bitLength();
        }
    }

    @CoreMethod(names={"abs", "magnitude"})
    public static abstract class AbsNode
    extends BignumCoreMethodNode {
        public AbsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object abs(RubyBasicObject value) {
            return this.fixnumOrBignum(BignumNodes.getBigIntegerValue(value).abs());
        }
    }

    @CoreMethod(names={">>"}, required=1, lowerFixnumParameters={0})
    public static abstract class RightShiftNode
    extends BignumCoreMethodNode {
        private final BranchProfile bLessThanZero = BranchProfile.create();

        public RightShiftNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object leftShift(RubyBasicObject a, int b) {
            if (b >= 0) {
                return this.fixnumOrBignum(BignumNodes.getBigIntegerValue(a).shiftRight(b));
            }
            this.bLessThanZero.enter();
            return this.fixnumOrBignum(BignumNodes.getBigIntegerValue(a).shiftLeft(-b));
        }
    }

    @CoreMethod(names={"<<"}, required=1, lowerFixnumParameters={0})
    public static abstract class LeftShiftNode
    extends BignumCoreMethodNode {
        private final BranchProfile bLessThanZero = BranchProfile.create();

        public LeftShiftNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object leftShift(RubyBasicObject a, int b) {
            if (b >= 0) {
                return this.fixnumOrBignum(BignumNodes.getBigIntegerValue(a).shiftLeft(b));
            }
            this.bLessThanZero.enter();
            return this.fixnumOrBignum(BignumNodes.getBigIntegerValue(a).shiftRight(-b));
        }
    }

    @CoreMethod(names={"^"}, required=1)
    public static abstract class BitXOrNode
    extends BignumCoreMethodNode {
        public BitXOrNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object bitXOr(RubyBasicObject a, long b) {
            return this.fixnumOrBignum(BignumNodes.getBigIntegerValue(a).xor(BigInteger.valueOf(b)));
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public Object bitXOr(RubyBasicObject a, RubyBasicObject b) {
            return this.fixnumOrBignum(BignumNodes.getBigIntegerValue(a).xor(BignumNodes.getBigIntegerValue(b)));
        }
    }

    @CoreMethod(names={"|"}, required=1)
    public static abstract class BitOrNode
    extends BignumCoreMethodNode {
        public BitOrNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object bitOr(RubyBasicObject a, long b) {
            return this.fixnumOrBignum(BignumNodes.getBigIntegerValue(a).or(BigInteger.valueOf(b)));
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public Object bitOr(RubyBasicObject a, RubyBasicObject b) {
            return this.fixnumOrBignum(BignumNodes.getBigIntegerValue(a).or(BignumNodes.getBigIntegerValue(a)));
        }
    }

    @CoreMethod(names={"&"}, required=1)
    public static abstract class BitAndNode
    extends BignumCoreMethodNode {
        public BitAndNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object bitAnd(RubyBasicObject a, long b) {
            return this.fixnumOrBignum(BignumNodes.getBigIntegerValue(a).and(BigInteger.valueOf(b)));
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public Object bitAnd(RubyBasicObject a, RubyBasicObject b) {
            return this.fixnumOrBignum(BignumNodes.getBigIntegerValue(a).and(BignumNodes.getBigIntegerValue(b)));
        }
    }

    @CoreMethod(names={">"}, required=1)
    public static abstract class GreaterNode
    extends CoreMethodArrayArgumentsNode {
        public GreaterNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean greater(RubyBasicObject a, long b) {
            return BignumNodes.getBigIntegerValue(a).compareTo(BigInteger.valueOf(b)) > 0;
        }

        @Specialization
        public boolean greater(RubyBasicObject a, double b) {
            return Double.compare(BignumNodes.getBigIntegerValue(a).doubleValue(), b) > 0;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean greater(RubyBasicObject a, RubyBasicObject b) {
            return BignumNodes.getBigIntegerValue(a).compareTo(BignumNodes.getBigIntegerValue(b)) > 0;
        }

        @Specialization(guards={"!isRubyBignum(b)", "!isInteger(b)", "!isLong(b)", "!isDouble(b)"})
        public Object greaterCoerced(VirtualFrame frame, RubyBasicObject a, Object b) {
            return this.ruby(frame, "b, a = math_coerce other, :compare_error; a > b", "other", b);
        }
    }

    @CoreMethod(names={">="}, required=1)
    public static abstract class GreaterEqualNode
    extends CoreMethodArrayArgumentsNode {
        public GreaterEqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean greaterEqual(RubyBasicObject a, long b) {
            return BignumNodes.getBigIntegerValue(a).compareTo(BigInteger.valueOf(b)) >= 0;
        }

        @Specialization
        public boolean greaterEqual(RubyBasicObject a, double b) {
            return Double.compare(BignumNodes.getBigIntegerValue(a).doubleValue(), b) >= 0;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean greaterEqual(RubyBasicObject a, RubyBasicObject b) {
            return BignumNodes.getBigIntegerValue(a).compareTo(BignumNodes.getBigIntegerValue(b)) >= 0;
        }

        @Specialization(guards={"!isRubyBignum(b)", "!isInteger(b)", "!isLong(b)", "!isDouble(b)"})
        public Object greaterEqualCoerced(VirtualFrame frame, RubyBasicObject a, Object b) {
            return this.ruby(frame, "b, a = math_coerce other, :compare_error; a >= b", "other", b);
        }
    }

    @CoreMethod(names={"<=>"}, required=1)
    public static abstract class CompareNode
    extends CoreMethodArrayArgumentsNode {
        private final ConditionProfile negativeInfinityProfile = ConditionProfile.createBinaryProfile();

        public CompareNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int compare(RubyBasicObject a, long b) {
            return BignumNodes.getBigIntegerValue(a).compareTo(BigInteger.valueOf(b));
        }

        @Specialization
        public int compare(RubyBasicObject a, double b) {
            if (this.negativeInfinityProfile.profile(Double.isInfinite(b) && b < 0.0)) {
                return 1;
            }
            return Double.compare(BignumNodes.getBigIntegerValue(a).doubleValue(), b);
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public int compare(RubyBasicObject a, RubyBasicObject b) {
            return BignumNodes.getBigIntegerValue(a).compareTo(BignumNodes.getBigIntegerValue(b));
        }
    }

    @CoreMethod(names={"==", "eql?"}, required=1)
    public static abstract class EqualNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private BooleanCastNode booleanCastNode;
        @Node.Child
        private CallDispatchHeadNode reverseCallNode;

        public EqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean equal(RubyBasicObject a, int b) {
            return false;
        }

        @Specialization
        public boolean equal(RubyBasicObject a, long b) {
            return false;
        }

        @Specialization
        public boolean equal(RubyBasicObject a, double b) {
            return BignumNodes.getBigIntegerValue(a).doubleValue() == b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean equal(RubyBasicObject a, RubyBasicObject b) {
            return BignumNodes.getBigIntegerValue(a).equals(BignumNodes.getBigIntegerValue(b));
        }

        @Specialization(guards={"!isRubyBignum(b)"})
        public boolean equal(VirtualFrame frame, RubyBasicObject a, RubyBasicObject b) {
            if (this.booleanCastNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.booleanCastNode = (BooleanCastNode)this.insert(BooleanCastNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if (this.reverseCallNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.reverseCallNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            Object reversedResult = this.reverseCallNode.call(frame, b, "==", null, a);
            return this.booleanCastNode.executeBoolean(frame, reversedResult);
        }
    }

    @CoreMethod(names={"<="}, required=1)
    public static abstract class LessEqualNode
    extends CoreMethodArrayArgumentsNode {
        public LessEqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean lessEqual(RubyBasicObject a, long b) {
            return BignumNodes.getBigIntegerValue(a).compareTo(BigInteger.valueOf(b)) <= 0;
        }

        @Specialization
        public boolean lessEqual(RubyBasicObject a, double b) {
            return BignumNodes.getBigIntegerValue(a).compareTo(BigInteger.valueOf((long)b)) <= 0;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean lessEqual(RubyBasicObject a, RubyBasicObject b) {
            return BignumNodes.getBigIntegerValue(a).compareTo(BignumNodes.getBigIntegerValue(b)) <= 0;
        }

        @Specialization(guards={"!isRubyBignum(b)", "!isInteger(b)", "!isLong(b)", "!isDouble(b)"})
        public Object lessEqualCoerced(VirtualFrame frame, RubyBasicObject a, Object b) {
            return this.ruby(frame, "b, a = math_coerce other, :compare_error; a <= b", "other", b);
        }
    }

    @CoreMethod(names={"<"}, required=1)
    public static abstract class LessNode
    extends CoreMethodArrayArgumentsNode {
        public LessNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean less(RubyBasicObject a, long b) {
            return BignumNodes.getBigIntegerValue(a).compareTo(BigInteger.valueOf(b)) < 0;
        }

        @Specialization
        public boolean less(RubyBasicObject a, double b) {
            return Double.compare(BignumNodes.getBigIntegerValue(a).doubleValue(), b) < 0;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean less(RubyBasicObject a, RubyBasicObject b) {
            return BignumNodes.getBigIntegerValue(a).compareTo(BignumNodes.getBigIntegerValue(b)) < 0;
        }

        @Specialization(guards={"!isRubyBignum(b)", "!isInteger(b)", "!isLong(b)", "!isDouble(b)"})
        public Object lessCoerced(VirtualFrame frame, RubyBasicObject a, Object b) {
            return this.ruby(frame, "b, a = math_coerce other, :compare_error; a < b", "other", b);
        }
    }

    @CoreMethod(names={"%", "modulo"}, required=1)
    public static abstract class ModNode
    extends BignumCoreMethodNode {
        public ModNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object mod(RubyBasicObject a, long b) {
            if (b == 0L) {
                throw new ArithmeticException("divide by zero");
            }
            if (b < 0L) {
                BigInteger bigint = BigInteger.valueOf(b);
                BigInteger mod = BignumNodes.getBigIntegerValue(a).mod(bigint.negate());
                return this.fixnumOrBignum(mod.add(bigint));
            }
            return this.fixnumOrBignum(BignumNodes.getBigIntegerValue(a).mod(BigInteger.valueOf(b)));
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public Object mod(RubyBasicObject a, RubyBasicObject b) {
            BigInteger bigint = BignumNodes.getBigIntegerValue(b);
            int compare = bigint.compareTo(BigInteger.ZERO);
            if (compare == 0) {
                throw new ArithmeticException("divide by zero");
            }
            if (compare < 0) {
                BigInteger mod = BignumNodes.getBigIntegerValue(a).mod(bigint.negate());
                return this.fixnumOrBignum(mod.add(bigint));
            }
            return this.fixnumOrBignum(BignumNodes.getBigIntegerValue(a).mod(BignumNodes.getBigIntegerValue(b)));
        }

        @Specialization(guards={"!isInteger(b)", "!isLong(b)", "!isRubyBignum(b)"})
        public Object mod(VirtualFrame frame, RubyBasicObject a, Object b) {
            return this.ruby(frame, "redo_coerced :%, other", "other", b);
        }
    }

    @CoreMethod(names={"/", "__slash__"}, required=1)
    public static abstract class DivNode
    extends BignumCoreMethodNode {
        public DivNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object div(RubyBasicObject a, long b) {
            return this.fixnumOrBignum(BignumNodes.getBigIntegerValue(a).divide(BigInteger.valueOf(b)));
        }

        @Specialization
        public double div(RubyBasicObject a, double b) {
            return BignumNodes.getBigIntegerValue(a).doubleValue() / b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public Object div(RubyBasicObject a, RubyBasicObject b) {
            return this.fixnumOrBignum(BignumNodes.getBigIntegerValue(a).divide(BignumNodes.getBigIntegerValue(b)));
        }
    }

    @CoreMethod(names={"*"}, required=1)
    public static abstract class MulNode
    extends BignumCoreMethodNode {
        public MulNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object mul(RubyBasicObject a, long b) {
            return this.fixnumOrBignum(BignumNodes.getBigIntegerValue(a).multiply(BigInteger.valueOf(b)));
        }

        @Specialization
        public double mul(RubyBasicObject a, double b) {
            return BignumNodes.getBigIntegerValue(a).doubleValue() * b;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyBignum(b)"})
        public Object mul(RubyBasicObject a, RubyBasicObject b) {
            return this.fixnumOrBignum(BignumNodes.getBigIntegerValue(a).multiply(BignumNodes.getBigIntegerValue(b)));
        }
    }

    @CoreMethod(names={"-"}, required=1)
    public static abstract class SubNode
    extends BignumCoreMethodNode {
        public SubNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object sub(RubyBasicObject a, long b) {
            return this.fixnumOrBignum(BignumNodes.getBigIntegerValue(a).subtract(BigInteger.valueOf(b)));
        }

        @Specialization
        public double sub(RubyBasicObject a, double b) {
            return BignumNodes.getBigIntegerValue(a).doubleValue() - b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public Object sub(RubyBasicObject a, RubyBasicObject b) {
            return this.fixnumOrBignum(BignumNodes.getBigIntegerValue(a).subtract(BignumNodes.getBigIntegerValue(b)));
        }
    }

    @CoreMethod(names={"+"}, required=1)
    public static abstract class AddNode
    extends BignumCoreMethodNode {
        public AddNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object add(RubyBasicObject a, long b) {
            return this.fixnumOrBignum(BignumNodes.getBigIntegerValue(a).add(BigInteger.valueOf(b)));
        }

        @Specialization
        public double add(RubyBasicObject a, double b) {
            return BignumNodes.getBigIntegerValue(a).doubleValue() + b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public Object add(RubyBasicObject a, RubyBasicObject b) {
            return this.fixnumOrBignum(BignumNodes.getBigIntegerValue(a).add(BignumNodes.getBigIntegerValue(b)));
        }
    }

    @CoreMethod(names={"-@"})
    public static abstract class NegNode
    extends BignumCoreMethodNode {
        public NegNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object neg(RubyBasicObject value) {
            return this.fixnumOrBignum(BignumNodes.getBigIntegerValue(value).negate());
        }
    }

    public static abstract class BignumCoreMethodNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private FixnumOrBignumNode fixnumOrBignum;

        public BignumCoreMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.fixnumOrBignum = new FixnumOrBignumNode(context, sourceSection);
        }

        public Object fixnumOrBignum(BigInteger value) {
            return this.fixnumOrBignum.fixnumOrBignum(value);
        }
    }

    public static class BignumType
    extends BasicObjectType {
    }
}

