/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.constants;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.constants.GetConstantNode;
import org.jruby.truffle.nodes.constants.GetConstantNodeGen;
import org.jruby.truffle.nodes.constants.LookupConstantNodeGen;
import org.jruby.truffle.nodes.literal.LiteralNode;
import org.jruby.truffle.runtime.ConstantReplacer;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.RubyConstant;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;

public class ReadConstantNode
extends RubyNode {
    private final String name;
    @Node.Child
    private GetConstantNode getConstantNode;

    public ReadConstantNode(RubyContext context, SourceSection sourceSection, String name, RubyNode receiver, LexicalScope lexicalScope) {
        super(context, sourceSection);
        this.name = ConstantReplacer.replacementName(sourceSection, name);
        this.getConstantNode = GetConstantNodeGen.create(context, sourceSection, receiver, new LiteralNode(context, sourceSection, this.name), LookupConstantNodeGen.create(context, sourceSection, lexicalScope, null, null));
    }

    @Override
    public Object execute(VirtualFrame frame) {
        return this.getConstantNode.execute(frame);
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        RubyConstant constant;
        Object receiverObject;
        CompilerDirectives.transferToInterpreter();
        RubyNode receiver = this.getConstantNode.getModule();
        RubyContext context = this.getContext();
        if (this.name.equals("Encoding")) {
            return this.createString("constant");
        }
        try {
            receiverObject = receiver.execute(frame);
        }
        catch (RaiseException e) {
            if (e.getRubyException().getLogicalClass() == context.getCoreLibrary().getNameErrorClass()) {
                return this.nil();
            }
            throw e;
        }
        try {
            constant = this.getConstantNode.getLookupConstantNode().executeLookupConstant(frame, receiverObject, this.name);
        }
        catch (RaiseException e) {
            if (e.getRubyException().getLogicalClass() == context.getCoreLibrary().getTypeErrorClass()) {
                return this.nil();
            }
            if (e.getRubyException().getLogicalClass() == context.getCoreLibrary().getNameErrorClass()) {
                return this.nil();
            }
            throw e;
        }
        if (constant == null) {
            return this.nil();
        }
        return this.createString("constant");
    }

    public String getName() {
        return this.name;
    }
}

