/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypes;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.cast.ArrayCastNode;
import org.jruby.truffle.nodes.cast.SplatCastNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@GeneratedBy(value=ArrayCastNode.class)
public final class ArrayCastNodeGen
extends ArrayCastNode
implements SpecializedNode {
    @Node.Child
    private RubyNode child_;
    @CompilerDirectives.CompilationFinal
    private Class<?> childType_;
    @Node.Child
    private BaseNode_ specialization_;

    private ArrayCastNodeGen(RubyContext context, SourceSection sourceSection, RubyNode child) {
        super(context, sourceSection);
        this.child_ = child;
        this.specialization_ = UninitializedNode_.create(this);
    }

    private ArrayCastNodeGen(RubyContext context, SourceSection sourceSection, SplatCastNode.NilBehavior nilBehavior, RubyNode child) {
        super(context, sourceSection, nilBehavior);
        this.child_ = child;
        this.specialization_ = UninitializedNode_.create(this);
    }

    @Override
    protected RubyNode getChild() {
        return this.child_;
    }

    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
        return this.specialization_.executeRubyBasicObject(frameValue);
    }

    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    public Node deepCopy() {
        return SpecializationNode.updateRoot((Node)super.deepCopy());
    }

    private static RubyBasicObject expectRubyBasicObject(Object value) throws UnexpectedResultException {
        if (value instanceof RubyBasicObject) {
            return (RubyBasicObject)value;
        }
        throw new UnexpectedResultException(value);
    }

    public static ArrayCastNode create(RubyContext context, SourceSection sourceSection, RubyNode child) {
        return new ArrayCastNodeGen(context, sourceSection, child);
    }

    public static ArrayCastNode create(RubyContext context, SourceSection sourceSection, SplatCastNode.NilBehavior nilBehavior, RubyNode child) {
        return new ArrayCastNodeGen(context, sourceSection, nilBehavior, child);
    }

    @GeneratedBy(methodName="cast(VirtualFrame, RubyBasicObject)", value=ArrayCastNode.class)
    private static final class Cast5Node_
    extends BaseNode_ {
        Cast5Node_(ArrayCastNodeGen root) {
            super(root, 8);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object childValue) {
            RubyBasicObject childValue_;
            if (childValue instanceof RubyBasicObject && !this.root.isNil(childValue_ = (RubyBasicObject)childValue) && !RubyGuards.isRubyBignum(childValue_) && !RubyGuards.isRubyArray(childValue_)) {
                return this.root.cast(frameValue, childValue_);
            }
            return this.getNext().execute_(frameValue, childValue);
        }

        static BaseNode_ create(ArrayCastNodeGen root) {
            return new Cast5Node_(root);
        }
    }

    @GeneratedBy(methodName="cast(Object)", value=ArrayCastNode.class)
    private static final class Cast4Node_
    extends BaseNode_ {
        Cast4Node_(ArrayCastNodeGen root) {
            super(root, 7);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object childValue) {
            if (this.root.isNil(childValue)) {
                return this.root.cast(childValue);
            }
            return this.getNext().execute_(frameValue, childValue);
        }

        static BaseNode_ create(ArrayCastNodeGen root) {
            return new Cast4Node_(root);
        }
    }

    @GeneratedBy(methodName="castArray(RubyBasicObject)", value=ArrayCastNode.class)
    private static final class CastArrayNode_
    extends BaseNode_ {
        CastArrayNode_(ArrayCastNodeGen root) {
            super(root, 6);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object childValue) {
            RubyBasicObject childValue_;
            if (childValue instanceof RubyBasicObject && RubyGuards.isRubyArray(childValue_ = (RubyBasicObject)childValue)) {
                return this.root.castArray(childValue_);
            }
            return this.getNext().execute_(frameValue, childValue);
        }

        static BaseNode_ create(ArrayCastNodeGen root) {
            return new CastArrayNode_(root);
        }
    }

    @GeneratedBy(methodName="castBignum(RubyBasicObject)", value=ArrayCastNode.class)
    private static final class CastBignumNode_
    extends BaseNode_ {
        CastBignumNode_(ArrayCastNodeGen root) {
            super(root, 5);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object childValue) {
            RubyBasicObject childValue_;
            if (childValue instanceof RubyBasicObject && RubyGuards.isRubyBignum(childValue_ = (RubyBasicObject)childValue)) {
                return this.root.castBignum(childValue_);
            }
            return this.getNext().execute_(frameValue, childValue);
        }

        static BaseNode_ create(ArrayCastNodeGen root) {
            return new CastBignumNode_(root);
        }
    }

    @GeneratedBy(methodName="cast(double)", value=ArrayCastNode.class)
    private static final class Cast3Node_
    extends BaseNode_ {
        Cast3Node_(ArrayCastNodeGen root) {
            super(root, 4);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            try {
                return this.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
            double childValue_;
            try {
                childValue_ = this.root.child_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ArrayCastNodeGen.expectRubyBasicObject(this.getNext().execute_(frameValue, ex.getResult()));
            }
            return this.root.cast(childValue_);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object childValue) {
            if (childValue instanceof Double) {
                double childValue_ = (Double)childValue;
                return this.root.cast(childValue_);
            }
            return this.getNext().execute_(frameValue, childValue);
        }

        static BaseNode_ create(ArrayCastNodeGen root) {
            return new Cast3Node_(root);
        }
    }

    @GeneratedBy(methodName="cast(long)", value=ArrayCastNode.class)
    private static final class Cast2Node_
    extends BaseNode_ {
        private final Class<?> childImplicitType;

        Cast2Node_(ArrayCastNodeGen root, Object childValue) {
            super(root, 3);
            this.childImplicitType = RubyTypesGen.getImplicitLongClass(childValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.childImplicitType == ((Cast2Node_)other).childImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            try {
                return this.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
            long childValue_;
            block4: {
                try {
                    if (this.childImplicitType == Long.TYPE) {
                        childValue_ = this.root.child_.executeLong(frameValue);
                        break block4;
                    }
                    if (this.childImplicitType == Integer.TYPE) {
                        childValue_ = RubyTypes.int2long(this.root.child_.executeInteger(frameValue));
                        break block4;
                    }
                    Object childValue__ = this.executeChild_((Frame)frameValue);
                    throw new UnexpectedResultException(childValue__);
                }
                catch (UnexpectedResultException ex) {
                    return ArrayCastNodeGen.expectRubyBasicObject(this.getNext().execute_(frameValue, ex.getResult()));
                }
            }
            return this.root.cast(childValue_);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.isImplicitLong(childValue, this.childImplicitType)) {
                long childValue_ = RubyTypesGen.asImplicitLong(childValue, this.childImplicitType);
                return this.root.cast(childValue_);
            }
            return this.getNext().execute_(frameValue, childValue);
        }

        static BaseNode_ create(ArrayCastNodeGen root, Object childValue) {
            return new Cast2Node_(root, childValue);
        }
    }

    @GeneratedBy(methodName="cast(int)", value=ArrayCastNode.class)
    private static final class Cast1Node_
    extends BaseNode_ {
        Cast1Node_(ArrayCastNodeGen root) {
            super(root, 2);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            try {
                return this.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
            int childValue_;
            try {
                childValue_ = this.root.child_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ArrayCastNodeGen.expectRubyBasicObject(this.getNext().execute_(frameValue, ex.getResult()));
            }
            return this.root.cast(childValue_);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object childValue) {
            if (childValue instanceof Integer) {
                int childValue_ = (Integer)childValue;
                return this.root.cast(childValue_);
            }
            return this.getNext().execute_(frameValue, childValue);
        }

        static BaseNode_ create(ArrayCastNodeGen root) {
            return new Cast1Node_(root);
        }
    }

    @GeneratedBy(methodName="cast(boolean)", value=ArrayCastNode.class)
    private static final class Cast0Node_
    extends BaseNode_ {
        Cast0Node_(ArrayCastNodeGen root) {
            super(root, 1);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            try {
                return this.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
            boolean childValue_;
            try {
                childValue_ = this.root.child_.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ArrayCastNodeGen.expectRubyBasicObject(this.getNext().execute_(frameValue, ex.getResult()));
            }
            return this.root.cast(childValue_);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object childValue) {
            if (childValue instanceof Boolean) {
                boolean childValue_ = (Boolean)childValue;
                return this.root.cast(childValue_);
            }
            return this.getNext().execute_(frameValue, childValue);
        }

        static BaseNode_ create(ArrayCastNodeGen root) {
            return new Cast0Node_(root);
        }
    }

    @GeneratedBy(value=ArrayCastNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(ArrayCastNodeGen root) {
            super(root, 0);
        }

        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object childValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, childValue));
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object childValue) {
            return this.getNext().execute_(frameValue, childValue);
        }

        static BaseNode_ create(ArrayCastNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=ArrayCastNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(ArrayCastNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object childValue) {
            return this.uninitialized((Frame)frameValue, childValue);
        }

        static BaseNode_ create(ArrayCastNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=ArrayCastNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        protected final ArrayCastNodeGen root;

        BaseNode_(ArrayCastNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.child_};
        }

        public final Object acceptAndExecute(Frame frameValue, Object childValue) {
            return this.execute_((VirtualFrame)frameValue, childValue);
        }

        public abstract Object execute_(VirtualFrame var1, Object var2);

        public Object execute(VirtualFrame frameValue) {
            Object childValue_ = this.executeChild_((Frame)frameValue);
            return this.execute_(frameValue, childValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
            return ArrayCastNodeGen.expectRubyBasicObject(this.execute(frameValue));
        }

        protected final SpecializationNode createNext(Frame frameValue, Object childValue) {
            RubyBasicObject childValue_;
            if (childValue instanceof Boolean) {
                return Cast0Node_.create(this.root);
            }
            if (childValue instanceof Integer) {
                return Cast1Node_.create(this.root);
            }
            if (RubyTypesGen.isImplicitLong(childValue)) {
                return Cast2Node_.create(this.root, childValue);
            }
            if (childValue instanceof Double) {
                return Cast3Node_.create(this.root);
            }
            if (childValue instanceof RubyBasicObject) {
                childValue_ = (RubyBasicObject)childValue;
                if (RubyGuards.isRubyBignum(childValue_)) {
                    return CastBignumNode_.create(this.root);
                }
                if (RubyGuards.isRubyArray(childValue_)) {
                    return CastArrayNode_.create(this.root);
                }
            }
            if (this.root.isNil(childValue)) {
                return Cast4Node_.create(this.root);
            }
            if (childValue instanceof RubyBasicObject && !this.root.isNil(childValue_ = (RubyBasicObject)childValue) && !RubyGuards.isRubyBignum(childValue_) && !RubyGuards.isRubyArray(childValue_)) {
                return Cast5Node_.create(this.root);
            }
            return null;
        }

        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeChild_(Frame frameValue) {
            Object object;
            Class childType_ = this.root.childType_;
            if (childType_ == Boolean.TYPE) {
                return this.root.child_.executeBoolean((VirtualFrame)frameValue);
            }
            if (childType_ == Double.TYPE) {
                return this.root.child_.executeDouble((VirtualFrame)frameValue);
            }
            if (childType_ == Integer.TYPE) {
                return this.root.child_.executeInteger((VirtualFrame)frameValue);
            }
            if (childType_ == Long.TYPE) {
                return this.root.child_.executeLong((VirtualFrame)frameValue);
            }
            if (childType_ != null) return this.root.child_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.child_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Boolean ? Boolean.TYPE : (_value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class)));
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.childType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.childType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.childType_ = _type;
            return object;
        }
    }
}

