/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.SplatCastNode;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.dispatch.DispatchNode;
import org.jruby.truffle.nodes.dispatch.MissingBehavior;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@NodeChild(value="child")
public abstract class ArrayCastNode
extends RubyNode {
    private final SplatCastNode.NilBehavior nilBehavior;
    @Node.Child
    private CallDispatchHeadNode toArrayNode;

    public ArrayCastNode(RubyContext context, SourceSection sourceSection) {
        this(context, sourceSection, SplatCastNode.NilBehavior.NIL);
    }

    public ArrayCastNode(RubyContext context, SourceSection sourceSection, SplatCastNode.NilBehavior nilBehavior) {
        super(context, sourceSection);
        this.toArrayNode = DispatchHeadNodeFactory.createMethodCall(context, true, MissingBehavior.RETURN_MISSING);
        this.nilBehavior = nilBehavior;
    }

    protected abstract RubyNode getChild();

    @Specialization
    public RubyBasicObject cast(boolean value) {
        return this.nil();
    }

    @Specialization
    public RubyBasicObject cast(int value) {
        return this.nil();
    }

    @Specialization
    public RubyBasicObject cast(long value) {
        return this.nil();
    }

    @Specialization
    public RubyBasicObject cast(double value) {
        return this.nil();
    }

    @Specialization(guards={"isRubyBignum(value)"})
    public RubyBasicObject castBignum(RubyBasicObject value) {
        return this.nil();
    }

    @Specialization(guards={"isRubyArray(array)"})
    public RubyBasicObject castArray(RubyBasicObject array) {
        return array;
    }

    @Specialization(guards={"isNil(nil)"})
    public Object cast(Object nil) {
        switch (this.nilBehavior) {
            case EMPTY_ARRAY: {
                return this.createEmptyArray();
            }
            case ARRAY_WITH_NIL: {
                return ArrayNodes.fromObject(this.getContext().getCoreLibrary().getArrayClass(), this.nil());
            }
            case NIL: {
                return nil;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Specialization(guards={"!isNil(object)", "!isRubyBignum(object)", "!isRubyArray(object)"})
    public Object cast(VirtualFrame frame, RubyBasicObject object) {
        Object result = this.toArrayNode.call(frame, object, "to_ary", null, new Object[0]);
        if (result == DispatchNode.MISSING) {
            return this.nil();
        }
        if (!RubyGuards.isRubyArray(result)) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().typeErrorShouldReturn(object.toString(), "to_ary", "Array", this));
        }
        return result;
    }

    @Override
    public void executeVoid(VirtualFrame frame) {
        this.getChild().executeVoid(frame);
    }
}

