/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.translator;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.OutputStream;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.Node;
import org.jruby.ast.SuperNode;
import org.jruby.ast.UnnamedRestArgNode;
import org.jruby.ast.ZSuperNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyRootNode;
import org.jruby.truffle.nodes.arguments.CheckArityNode;
import org.jruby.truffle.nodes.arguments.MissingArgumentBehaviour;
import org.jruby.truffle.nodes.arguments.ReadPreArgumentNode;
import org.jruby.truffle.nodes.arguments.ShouldDestructureNode;
import org.jruby.truffle.nodes.cast.ArrayCastNode;
import org.jruby.truffle.nodes.cast.ArrayCastNodeGen;
import org.jruby.truffle.nodes.control.IfNode;
import org.jruby.truffle.nodes.control.SequenceNode;
import org.jruby.truffle.nodes.defined.DefinedWrapperNode;
import org.jruby.truffle.nodes.dispatch.RespondToNode;
import org.jruby.truffle.nodes.literal.LiteralNode;
import org.jruby.truffle.nodes.locals.FlipFlopStateNode;
import org.jruby.truffle.nodes.locals.WriteLocalVariableNode;
import org.jruby.truffle.nodes.methods.BlockDefinitionNode;
import org.jruby.truffle.nodes.methods.CatchBreakAsProcErrorNode;
import org.jruby.truffle.nodes.methods.CatchBreakAsReturnNode;
import org.jruby.truffle.nodes.methods.CatchNextNode;
import org.jruby.truffle.nodes.methods.CatchRetryAsErrorNode;
import org.jruby.truffle.nodes.methods.CatchReturnNode;
import org.jruby.truffle.nodes.methods.CatchReturnPlaceholderNode;
import org.jruby.truffle.nodes.methods.ExceptionTranslatingNode;
import org.jruby.truffle.nodes.methods.MethodDefinitionNode;
import org.jruby.truffle.nodes.methods.RedoableNode;
import org.jruby.truffle.nodes.supercall.GeneralSuperCallNode;
import org.jruby.truffle.nodes.supercall.GeneralSuperReCallNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.methods.Arity;
import org.jruby.truffle.runtime.methods.SharedMethodInfo;
import org.jruby.truffle.translator.BehaveAsBlockNode;
import org.jruby.truffle.translator.BehaveAsProcNode;
import org.jruby.truffle.translator.BodyTranslator;
import org.jruby.truffle.translator.LoadArgumentsTranslator;
import org.jruby.truffle.translator.ParameterCollector;
import org.jruby.truffle.translator.ReloadArgumentsTranslator;
import org.jruby.truffle.translator.TranslatorEnvironment;

class MethodTranslator
extends BodyTranslator {
    private final ArgsNode argsNode;
    private boolean isBlock;

    public MethodTranslator(com.oracle.truffle.api.nodes.Node currentNode, RubyContext context, BodyTranslator parent, TranslatorEnvironment environment, boolean isBlock, Source source, ArgsNode argsNode) {
        super(currentNode, context, parent, environment, source, false);
        this.isBlock = isBlock;
        this.argsNode = argsNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyNode compileFunctionNode(SourceSection sourceSection, String methodName, Node bodyNode, SharedMethodInfo sharedMethodInfo) {
        RubyNode prelude;
        RubyNode body;
        if (PRINT_PARSE_TREE_METHOD_NAMES.contains(methodName)) {
            System.err.println(sourceSection + " " + methodName);
            System.err.println(sharedMethodInfo.getParseTree().toString(true, 0));
        }
        ParameterCollector parameterCollector = new ParameterCollector();
        this.argsNode.accept((NodeVisitor)parameterCollector);
        for (String parameter : parameterCollector.getParameters()) {
            this.environment.declareVar(parameter);
        }
        Arity arity = MethodTranslator.getArity(this.argsNode);
        Arity arityForCheck = this.isBlock && this.argsNode.childNodes().size() == 2 && this.argsNode.getRestArgNode() instanceof UnnamedRestArgNode ? new Arity(arity.getRequired(), 0, false, false, false, 0) : arity;
        if (bodyNode != null) {
            this.parentSourceSection.push(sourceSection);
            try {
                body = (RubyNode)((Object)bodyNode.accept((NodeVisitor)this));
            }
            finally {
                this.parentSourceSection.pop();
            }
        } else {
            body = new DefinedWrapperNode(this.context, sourceSection, new LiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject()), "nil");
        }
        LoadArgumentsTranslator loadArgumentsTranslator = new LoadArgumentsTranslator(this.currentNode, this.context, this.source, this.isBlock, this);
        RubyNode loadArguments = (RubyNode)((Object)this.argsNode.accept((NodeVisitor)loadArgumentsTranslator));
        if (this.isBlock) {
            RubyNode preludeBuilder;
            boolean shouldConsiderDestructuringArrayArg = true;
            if (this.argsNode.getPreCount() == 0 && this.argsNode.getOptionalArgsCount() == 0 && this.argsNode.getPostCount() == 0 && this.argsNode.getRestArgNode() == null) {
                shouldConsiderDestructuringArrayArg = false;
            }
            if (this.argsNode.getPreCount() + this.argsNode.getPostCount() == 1 && this.argsNode.getOptionalArgsCount() == 0 && this.argsNode.getRestArgNode() == null) {
                shouldConsiderDestructuringArrayArg = false;
            }
            if (this.argsNode.getPreCount() == 0 && this.argsNode.getRestArgNode() != null) {
                shouldConsiderDestructuringArrayArg = false;
            }
            if (shouldConsiderDestructuringArrayArg) {
                ReadPreArgumentNode readArrayNode = new ReadPreArgumentNode(this.context, sourceSection, 0, MissingArgumentBehaviour.RUNTIME_ERROR);
                ArrayCastNode castArrayNode = ArrayCastNodeGen.create(this.context, sourceSection, readArrayNode);
                FrameSlot arraySlot = this.environment.declareVar(this.environment.allocateLocalTemp("destructure"));
                WriteLocalVariableNode writeArrayNode = new WriteLocalVariableNode(this.context, sourceSection, castArrayNode, arraySlot);
                LoadArgumentsTranslator destructureArgumentsTranslator = new LoadArgumentsTranslator(this.currentNode, this.context, this.source, this.isBlock, this);
                destructureArgumentsTranslator.pushArraySlot(arraySlot);
                RubyNode newDestructureArguments = (RubyNode)((Object)this.argsNode.accept((NodeVisitor)destructureArgumentsTranslator));
                preludeBuilder = new BehaveAsBlockNode(this.context, sourceSection, new IfNode(this.context, sourceSection, new ShouldDestructureNode(this.context, sourceSection, arity, new RespondToNode(this.context, sourceSection, readArrayNode, "to_ary")), SequenceNode.sequence(this.context, sourceSection, writeArrayNode, newDestructureArguments), (RubyNode)NodeUtil.cloneNode((com.oracle.truffle.api.nodes.Node)loadArguments)), (RubyNode)NodeUtil.cloneNode((com.oracle.truffle.api.nodes.Node)loadArguments));
            } else {
                preludeBuilder = loadArguments;
            }
            prelude = SequenceNode.sequence(this.context, sourceSection, new BehaveAsBlockNode(this.context, sourceSection, new DefinedWrapperNode(this.context, sourceSection, new LiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject()), "nil"), new CheckArityNode(this.context, sourceSection, arityForCheck, parameterCollector.getKeywords(), this.argsNode.getKeyRest() != null)), preludeBuilder);
        } else {
            prelude = this.usesRubiniusPrimitive ? loadArguments : SequenceNode.sequence(this.context, sourceSection, new CheckArityNode(this.context, sourceSection, arityForCheck, parameterCollector.getKeywords(), this.argsNode.getKeyRest() != null), loadArguments);
        }
        body = SequenceNode.sequence(this.context, sourceSection, prelude, body);
        if (this.environment.getFlipFlopStates().size() > 0) {
            body = SequenceNode.sequence(this.context, sourceSection, this.initFlipFlopStates(sourceSection), body);
        }
        if (this.isBlock) {
            body = new RedoableNode(this.context, sourceSection, body);
            body = new CatchReturnPlaceholderNode(this.context, sourceSection, body, this.environment.getReturnID());
            body = new BehaveAsProcNode(this.context, sourceSection, new CatchBreakAsProcErrorNode(this.context, sourceSection, body), (RubyNode)NodeUtil.cloneNode((com.oracle.truffle.api.nodes.Node)body));
        } else {
            body = new CatchReturnNode(this.context, sourceSection, body, this.environment.getReturnID());
        }
        body = new CatchNextNode(this.context, sourceSection, body);
        body = new CatchRetryAsErrorNode(this.context, sourceSection, body);
        if (!this.isBlock) {
            body = new ExceptionTranslatingNode(this.context, sourceSection, body);
        }
        RubyRootNode rootNode = new RubyRootNode(this.context, sourceSection, this.environment.getFrameDescriptor(), this.environment.getSharedMethodInfo(), body);
        if (PRINT_AST_METHOD_NAMES.contains(methodName)) {
            System.err.println(sourceSection + " " + methodName);
            NodeUtil.printCompactTree((OutputStream)System.err, (com.oracle.truffle.api.nodes.Node)rootNode);
        }
        if (PRINT_FULL_AST_METHOD_NAMES.contains(methodName)) {
            System.err.println(sourceSection + " " + methodName);
            NodeUtil.printTree((OutputStream)System.err, (com.oracle.truffle.api.nodes.Node)rootNode);
        }
        if (this.isBlock) {
            RubyRootNode newRootNodeForBlocks = rootNode.cloneRubyRootNode();
            for (BehaveAsBlockNode behaveAsBlockNode : NodeUtil.findAllNodeInstances((com.oracle.truffle.api.nodes.Node)newRootNodeForBlocks, BehaveAsBlockNode.class)) {
                behaveAsBlockNode.replace(behaveAsBlockNode.getAsBlock());
            }
            for (BehaveAsProcNode behaveAsProcNode : NodeUtil.findAllNodeInstances((com.oracle.truffle.api.nodes.Node)newRootNodeForBlocks, BehaveAsProcNode.class)) {
                behaveAsProcNode.replace(behaveAsProcNode.getNotAsProc());
            }
            RootCallTarget callTargetAsBlock = Truffle.getRuntime().createCallTarget((RootNode)newRootNodeForBlocks);
            RubyRootNode newRootNodeForProcs = rootNode.cloneRubyRootNode();
            for (BehaveAsBlockNode behaveAsBlockNode : NodeUtil.findAllNodeInstances((com.oracle.truffle.api.nodes.Node)newRootNodeForProcs, BehaveAsBlockNode.class)) {
                behaveAsBlockNode.replace(behaveAsBlockNode.getAsBlock());
            }
            for (BehaveAsProcNode behaveAsProcNode : NodeUtil.findAllNodeInstances((com.oracle.truffle.api.nodes.Node)newRootNodeForProcs, BehaveAsProcNode.class)) {
                behaveAsProcNode.replace(behaveAsProcNode.getAsProc());
            }
            RootCallTarget callTargetAsProc = Truffle.getRuntime().createCallTarget((RootNode)newRootNodeForProcs);
            RubyRootNode newRootNodeForLambdas = rootNode.cloneRubyRootNode();
            for (BehaveAsBlockNode behaveAsBlockNode : NodeUtil.findAllNodeInstances((com.oracle.truffle.api.nodes.Node)newRootNodeForLambdas, BehaveAsBlockNode.class)) {
                behaveAsBlockNode.replace(behaveAsBlockNode.getNotAsBlock());
            }
            for (BehaveAsProcNode behaveAsProcNode : NodeUtil.findAllNodeInstances((com.oracle.truffle.api.nodes.Node)newRootNodeForLambdas, BehaveAsProcNode.class)) {
                behaveAsProcNode.replace(behaveAsProcNode.getNotAsProc());
            }
            RubyRootNode newRootNodeWithCatchReturn = new RubyRootNode(this.context, newRootNodeForLambdas.getSourceSection(), newRootNodeForLambdas.getFrameDescriptor(), newRootNodeForLambdas.getSharedMethodInfo(), new CatchBreakAsReturnNode(this.context, sourceSection, new CatchReturnNode(this.context, newRootNodeForLambdas.getSourceSection(), newRootNodeForLambdas.getBody(), this.getEnvironment().getReturnID())));
            RootCallTarget callTargetAsLambda = Truffle.getRuntime().createCallTarget((RootNode)newRootNodeWithCatchReturn);
            return new BlockDefinitionNode(this.context, sourceSection, this.environment.getSharedMethodInfo(), this.environment.needsDeclarationFrame(), (CallTarget)callTargetAsBlock, (CallTarget)callTargetAsProc, (CallTarget)callTargetAsLambda, this.environment.getBreakID());
        }
        return new MethodDefinitionNode(this.context, sourceSection, methodName, this.environment.getSharedMethodInfo(), this.environment.needsDeclarationFrame(), (CallTarget)Truffle.getRuntime().createCallTarget((RootNode)rootNode));
    }

    public static Arity getArity(ArgsNode argsNode) {
        int minimum = argsNode.getRequiredArgsCount();
        int maximum = argsNode.getMaxArgumentsCount();
        return new Arity(minimum, argsNode.getOptionalArgsCount(), maximum == -1, argsNode.hasKwargs(), argsNode.hasKeyRest(), argsNode.countKeywords(), argsNode);
    }

    public RubyNode visitSuperNode(SuperNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        BodyTranslator.ArgumentsAndBlockTranslation argumentsAndBlock = this.translateArgumentsAndBlock(sourceSection, node.getIterNode(), node.getArgsNode(), null, this.environment.getNamedMethodName());
        return new GeneralSuperCallNode(this.context, sourceSection, argumentsAndBlock.getBlock(), argumentsAndBlock.getArguments(), argumentsAndBlock.isSplatted());
    }

    public RubyNode visitZSuperNode(ZSuperNode node) {
        RubyNode blockNode;
        SourceSection sourceSection = this.translate(node.getPosition());
        if (this.environment.isBlock()) {
            this.environment.setNeedsDeclarationFrame();
        }
        if (node.getIterNode() != null) {
            this.currentCallMethodName = this.environment.getNamedMethodName();
            blockNode = (RubyNode)((Object)node.getIterNode().accept((NodeVisitor)this));
        } else {
            blockNode = null;
        }
        ReloadArgumentsTranslator reloadTranslator = new ReloadArgumentsTranslator(this.currentNode, this.context, this.source, this);
        SequenceNode reloadSequence = (SequenceNode)reloadTranslator.visitArgsNode(this.argsNode);
        return new GeneralSuperReCallNode(this.context, sourceSection, this.environment.isBlock(), reloadTranslator.isSplatted(), reloadSequence.getSequence(), blockNode);
    }

    @Override
    protected FlipFlopStateNode createFlipFlopState(SourceSection sourceSection, int depth) {
        if (this.isBlock) {
            this.environment.setNeedsDeclarationFrame();
            return this.parent.createFlipFlopState(sourceSection, depth + 1);
        }
        return super.createFlipFlopState(sourceSection, depth);
    }
}

