/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.hash;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.ArrayList;
import java.util.List;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.core.hash.HashNodes;
import org.jruby.truffle.runtime.DebugOperations;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.hash.BucketsStrategy;
import org.jruby.truffle.runtime.hash.Entry;
import org.jruby.truffle.runtime.hash.HashLookupResult;
import org.jruby.truffle.runtime.hash.KeyValue;
import org.jruby.truffle.runtime.hash.PackedArrayStrategy;

public class HashOperations {
    public static RubyBasicObject verySlowFromEntries(RubyContext context, List<KeyValue> entries, boolean byIdentity) {
        return HashOperations.verySlowFromEntries(context.getCoreLibrary().getHashClass(), entries, byIdentity);
    }

    @CompilerDirectives.TruffleBoundary
    public static RubyBasicObject verySlowFromEntries(RubyClass hashClass, List<KeyValue> entries, boolean byIdentity) {
        RubyBasicObject hash = HashNodes.createEmptyHash(hashClass);
        HashOperations.verySlowSetKeyValues(hash, entries, byIdentity);
        assert (HashOperations.verifyStore(hash));
        return hash;
    }

    public static void dump(RubyBasicObject hash) {
        Entry entry;
        assert (RubyGuards.isRubyHash(hash));
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(HashNodes.getSize(hash));
        builder.append("](");
        Entry[] arr$ = (Entry[])HashNodes.getStore(hash);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            builder.append("(");
            for (Entry entry2 = arr$[i$]; entry2 != null; entry2 = entry2.getNextInLookup()) {
                builder.append("[");
                builder.append(entry2.getKey());
                builder.append(",");
                builder.append(entry2.getValue());
                builder.append("]");
            }
            builder.append(")");
        }
        builder.append(")~>(");
        for (entry = HashNodes.getFirstInSequence(hash); entry != null; entry = entry.getNextInSequence()) {
            builder.append("[");
            builder.append(entry.getKey());
            builder.append(",");
            builder.append(entry.getValue());
            builder.append("]");
        }
        builder.append(")<~(");
        for (entry = HashNodes.getLastInSequence(hash); entry != null; entry = entry.getPreviousInSequence()) {
            builder.append("[");
            builder.append(entry.getKey());
            builder.append(",");
            builder.append(entry.getValue());
            builder.append("]");
        }
        builder.append(")");
        System.err.println(builder);
    }

    @CompilerDirectives.TruffleBoundary
    public static List<KeyValue> verySlowToKeyValues(RubyBasicObject hash) {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        if (HashNodes.getStore(hash) instanceof Entry[]) {
            for (Entry entry = HashNodes.getFirstInSequence(hash); entry != null; entry = entry.getNextInSequence()) {
                keyValues.add(new KeyValue(entry.getKey(), entry.getValue()));
            }
        } else if (HashNodes.getStore(hash) instanceof Object[]) {
            Object[] store = (Object[])HashNodes.getStore(hash);
            for (int n = 0; n < HashNodes.getSize(hash); ++n) {
                keyValues.add(new KeyValue(PackedArrayStrategy.getKey(store, n), PackedArrayStrategy.getValue(store, n)));
            }
        } else if (HashNodes.getStore(hash) != null) {
            throw new UnsupportedOperationException();
        }
        return keyValues;
    }

    @CompilerDirectives.TruffleBoundary
    public static HashLookupResult verySlowFindBucket(RubyBasicObject hash, Object key, boolean byIdentity) {
        int hashed;
        Object hashValue = DebugOperations.send(hash.getContext(), key, "hash", null, new Object[0]);
        if (hashValue instanceof Integer) {
            hashed = (Integer)hashValue;
        } else if (hashValue instanceof Long) {
            hashed = (int)((Long)hashValue).longValue();
        } else {
            throw new UnsupportedOperationException();
        }
        Entry[] entries = (Entry[])HashNodes.getStore(hash);
        int bucketIndex = (hashed & Integer.MAX_VALUE) % entries.length;
        Entry previousEntry = null;
        for (Entry entry = entries[bucketIndex]; entry != null; entry = entry.getNextInLookup()) {
            String method = byIdentity ? "equal?" : "eql?";
            if (((Boolean)DebugOperations.send(hash.getContext(), key, method, null, entry.getKey())).booleanValue()) {
                return new HashLookupResult(hashed, bucketIndex, previousEntry, entry);
            }
            previousEntry = entry;
        }
        return new HashLookupResult(hashed, bucketIndex, previousEntry, null);
    }

    @CompilerDirectives.TruffleBoundary
    public static void verySlowSetAtBucket(RubyBasicObject hash, HashLookupResult hashLookupResult, Object key, Object value) {
        assert (HashOperations.verifyStore(hash));
        assert (HashNodes.getStore(hash) instanceof Entry[]);
        if (hashLookupResult.getEntry() == null) {
            BucketsStrategy.addNewEntry(hash, hashLookupResult.getHashed(), key, value);
            assert (HashOperations.verifyStore(hash));
        } else {
            Entry entry = hashLookupResult.getEntry();
            entry.setHashed(hashLookupResult.getHashed());
            entry.setKey(key);
            entry.setValue(value);
            assert (HashOperations.verifyStore(hash));
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean verySlowSetInBuckets(RubyBasicObject hash, Object key, Object value, boolean byIdentity) {
        assert (HashOperations.verifyStore(hash));
        if (!byIdentity && key instanceof RubyString) {
            key = DebugOperations.send(hash.getContext(), DebugOperations.send(hash.getContext(), key, "dup", null, new Object[0]), "freeze", null, new Object[0]);
        }
        HashLookupResult hashLookupResult = HashOperations.verySlowFindBucket(hash, key, byIdentity);
        HashOperations.verySlowSetAtBucket(hash, hashLookupResult, key, value);
        assert (HashOperations.verifyStore(hash));
        return hashLookupResult.getEntry() == null;
    }

    @CompilerDirectives.TruffleBoundary
    public static void verySlowSetKeyValues(RubyBasicObject hash, List<KeyValue> keyValues, boolean byIdentity) {
        assert (HashOperations.verifyStore(hash));
        int size = keyValues.size();
        HashNodes.setStore(hash, new Entry[BucketsStrategy.capacityGreaterThan(size)], 0, null, null);
        int actualSize = 0;
        for (KeyValue keyValue : keyValues) {
            if (!HashOperations.verySlowSetInBuckets(hash, keyValue.getKey(), keyValue.getValue(), byIdentity)) continue;
            ++actualSize;
        }
        HashNodes.setSize(hash, actualSize);
        assert (HashOperations.verifyStore(hash));
    }

    public static boolean verifyStore(RubyBasicObject hash) {
        return HashOperations.verifyStore(HashNodes.getStore(hash), HashNodes.getSize(hash), HashNodes.getFirstInSequence(hash), HashNodes.getLastInSequence(hash));
    }

    public static boolean verifyStore(Object store, int size, Entry firstInSequence, Entry lastInSequence) {
        assert (store == null || store instanceof Object[] || store instanceof Entry[]);
        if (store == null) {
            assert (size == 0);
            assert (firstInSequence == null);
            assert (lastInSequence == null);
        }
        if (store instanceof Entry[]) {
            Entry entry;
            assert (lastInSequence == null || lastInSequence.getNextInSequence() == null);
            Entry[] entryStore = (Entry[])store;
            Entry foundFirst = null;
            Entry foundLast = null;
            int foundSizeBuckets = 0;
            for (int n = 0; n < entryStore.length; ++n) {
                for (entry = entryStore[n]; entry != null; entry = entry.getNextInLookup()) {
                    ++foundSizeBuckets;
                    if (entry == firstInSequence) {
                        assert (foundFirst == null);
                        foundFirst = entry;
                    }
                    if (entry != lastInSequence) continue;
                    assert (foundLast == null);
                    foundLast = entry;
                }
            }
            assert (foundSizeBuckets == size);
            assert (firstInSequence == foundFirst);
            assert (lastInSequence == foundLast);
            int foundSizeSequence = 0;
            for (entry = firstInSequence; entry != null; entry = entry.getNextInSequence()) {
                ++foundSizeSequence;
                if (entry.getNextInSequence() == null ? !$assertionsDisabled && entry != lastInSequence : !$assertionsDisabled && entry.getNextInSequence().getPreviousInSequence() != entry) {
                    throw new AssertionError();
                }
            }
            assert (foundSizeSequence == size) : String.format("%d %d", foundSizeSequence, size);
        } else if (store instanceof Object[]) {
            assert (((Object[])store).length == PackedArrayStrategy.MAX_ENTRIES * 3) : ((Object[])store).length;
            Object[] packedStore = (Object[])store;
            for (int n = 0; n < PackedArrayStrategy.MAX_ENTRIES; ++n) {
                if (n >= size) continue;
                assert (packedStore[n * 2] != null);
                assert (packedStore[n * 2 + 1] != null);
            }
            assert (firstInSequence == null);
            assert (lastInSequence == null);
        }
        return true;
    }
}

