/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.nodes.Node;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.backtrace.Backtrace;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;

public class RubyException
extends RubyBasicObject {
    private Object message;
    private Backtrace backtrace;

    public RubyException(RubyClass rubyClass) {
        super(rubyClass);
        this.message = StringNodes.createEmptyString(rubyClass.getContext().getCoreLibrary().getStringClass());
    }

    public RubyException(RubyClass rubyClass, Object message, Backtrace backtrace) {
        this(rubyClass);
        this.initialize(message);
        this.backtrace = backtrace;
    }

    public void initialize(Object message) {
        assert (message != null);
        this.message = message;
    }

    public Object getMessage() {
        return this.message;
    }

    public Backtrace getBacktrace() {
        return this.backtrace;
    }

    public void setBacktrace(Backtrace backtrace) {
        this.backtrace = backtrace;
    }

    public RubyBasicObject asRubyStringArray() {
        assert (this.backtrace != null);
        String[] lines = Backtrace.EXCEPTION_FORMATTER.format(this.getContext(), this, this.backtrace);
        Object[] array = new Object[lines.length];
        for (int n = 0; n < lines.length; ++n) {
            array[n] = StringNodes.createString(this.getContext().getCoreLibrary().getStringClass(), lines[n]);
        }
        return ArrayNodes.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), array);
    }

    public static class ExceptionAllocator
    implements Allocator {
        @Override
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, Node currentNode) {
            return new RubyException(rubyClass);
        }
    }
}

